/****************************************************************************
 * This module is all new
 * by Rob Nation (nation@rocket.sanders.lockheed.com)
 * A little of it is borrowed from ctwm.
 * Copyright 1993 Robert Nation. No restrictions are placed on this code,
 * as long as the copyright notice is preserved
 ****************************************************************************/
/***********************************************************************
 *
 * fvwm menu code
 *
 ***********************************************************************/

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <X11/Xos.h>
#include "fvwm.h"
#include "menus.h"
#include "misc.h"
#include "parse.h"
#include "screen.h"


void do_windowList()
{
#ifndef NO_WINDOWLIST
  MenuRoot *mr;
  MenuItem *mi,*tmp;
  FvwmWindow *t;
  char *tname,*junk;
  char loc[30];
  int dwidth,dheight;

  mr=NewMenuRoot("Window List");
  AddToMenu(mr, "Window List", "Geometry", NULL, F_TITLE,0,0);      

  for (t = Scr.FvwmRoot.next; t != NULL; t = t->next)
    {
      if (!(LookInList(Scr.TheList,t->name, &t->class, &junk)& LISTSKIP_FLAG))
	{
	  tname = safemalloc(30);
	  tname[0]=0;
	  if(t->flags & ICON)
	    strcpy(tname, "(");
	  if(t->frame_x >=0)
	    sprintf(loc,"+%d",t->frame_x);
	  else
	    sprintf(loc,"%d",t->frame_x);
	  strcat(tname, loc);
	  if(t->frame_y >=0)
	    sprintf(loc,"+%d",t->frame_y);
	  else
	    sprintf(loc,"%d",t->frame_y);
	  strcat(tname, loc);
	  dheight = t->frame_height - t->title_height - 2*t->boundary_width;
	  dwidth = t->frame_width - 2*t->boundary_width;
	  
	  if (t->hints.flags&(PMinSize|PBaseSize) 
	      && t->hints.flags & PResizeInc)
	    {
	      if (t->hints.flags & PBaseSize) 
		{
		  dwidth -= t->hints.base_width;
		  dheight -= t->hints.base_height;
		} 
	      else 
		{
		  dwidth -= t->hints.min_width;
		  dheight -= t->hints.min_height;
		}
	    }
	  
	  if (t->hints.flags & PResizeInc)
	    {
	      dwidth /= t->hints.width_inc;
	      dheight /= t->hints.height_inc;
	    }
	  sprintf(loc,"x%d",dwidth);
	  strcat(tname, loc);
	  sprintf(loc,"x%d",dheight);
	  strcat(tname, loc);
	  if(t->flags & ICON)
	    strcat(tname, ")");
	  
	  AddToMenu(mr, t->name,tname, NULL, F_RAISE_IT,(int)t->w,0);      
	}
    }
  MakeMenu(mr);

  do_menu(mr);

  XDestroyWindow(dpy,mr->w);
  
  /* need to free the window list ? */
  mi = mr->first;
  while(mi != NULL)
    {
      tmp = mi->next;
      if((mi->item2 != NULL)&&(mi->func != F_TITLE))
	free(mi->item2);
      free(mi);
      mi = tmp;
    }
  free(mr);
#endif
}

void RaiseThisWindow(int w1)
{
#ifndef NO_WINDOWLIST
  FvwmWindow *t;
  int x,y,mx,my;

  if (XFindContext(dpy, (Window)w1, FvwmContext, (caddr_t *)&t) == XCNOENT)
    return;

  /* De-iconify if its iconified */
  if (t->flags & ICON)
    DeIconify(t);

  /* raise to top */
  RaiseWindow(t);  

  /* If its on the virtual desktop, move to there */
#ifndef NON_VIRTUAL
  mx = t->frame_x + t->frame_width/2;
  my = t->frame_y + t->frame_height/2;

  if(((mx + Scr.Vx) < (Scr.VxMax + Scr.MyDisplayWidth))&&
     ((my + Scr.Vy) < (Scr.VyMax + Scr.MyDisplayHeight))&&
     ((my + Scr.Vy) >= 0)&&((mx + Scr.Vx) >= 0))
    {
      /* don't move the viewport unless the window is currently
       * off the viewport */
      if((mx<0)||(my < 0)||(mx>Scr.MyDisplayWidth)||(my>Scr.MyDisplayHeight))
	{
	  x = (mx /Scr.MyDisplayWidth)*Scr.MyDisplayWidth;
	  y = (my /Scr.MyDisplayHeight)*Scr.MyDisplayHeight;
	  MoveViewport(x,y,True);
	}
    }
  else
#endif
    {
      /* not on the desktop - move the window */
      if((mx < 0)||(my<0)||(mx > Scr.MyDisplayWidth)||(my>Scr.MyDisplayHeight))
	SetupFrame(t,0,0,t->frame_width,t->frame_height,FALSE);
    }

  XWarpPointer(dpy, None, Scr.Root, 0, 0, 0, 0, t->frame_x+2,t->frame_y+2);
  
  if(Scr.flags & ClickToFocus)
    SetBorder (t, True,False,True,None);
  KeepOnTop();    
#ifndef NO_PAGER
  RedrawPager();
#endif
#endif
}
