/*
 * alias.h: header for alias.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#ifndef _ALIAS_H_
#define _ALIAS_H_

#define COMMAND_ALIAS 0
#define VAR_ALIAS 1

#define LEFT_BRACE '{'
#define RIGHT_BRACE '}'
#define LEFT_BRACKET '['
#define RIGHT_BRACKET ']'
#define LEFT_PAREN '('
#define RIGHT_PAREN ')'
#define DOUBLE_QUOTE '"'

extern	void	add_alias();
extern	char	*get_alias();
extern	char	*expand_alias();
extern	void	list_aliases();
extern	int	mark_alias();
extern	void	delete_alias();
extern	char	*inline_aliases();
extern	char	**match_alias();
extern	char	alias_illegals[];
extern	void	alias();
extern	char	*parse_inline();
extern	char	*MatchingBracket();
extern	long	create_irc_number();

extern	char	command_line[];

struct	ArgPosTag
{
	char *ArgStart;
	int ArgLen;
	char *FirstComp;
};

typedef	struct ArgPosTag	ArgPos;

#define MAX_CMD_ARGS 5

#endif /* _ALIAS_H_ */
