/*
 * Here we define how our menus are held
 *
 */

#ifndef _MENU_H_
#define _MENU_H_

#define IRCII_MENU_H

#define	SMF_ERASE	0x0001
#define	SMF_NOCURSOR	0x0002
#define	SMF_CURSONLY	0x0004
#define	SMF_CALCONLY	0x0008

struct	MenuOptionTag
{
	char	*Name;
	char	*Arguments;
	void	(*Func)();
};

typedef	struct	MenuOptionTag	MenuOption;

struct	MenuTag
{
	struct	MenuTag	*next;
	char	*Name;
	int	TotalOptions;
	MenuOption	**Options;
};

typedef struct MenuTag Menu;

/* Below are our known menu functions */
void	menu_previous();	/* Go to previous menu */
void	menu_submenu();		/* Invoke a submenu */
void	menu_exit();		/* Exit the menu */
void	menu_channels();	/* List of channels menu */
void	menu_command();		/* Invoke an IRCII command */

#endif /* _MENU_H_ */
