/* database_read.c */

/*
 * readButtonCB() - called when user clicks "Read from file" button
 *                  on Conference Submission popup
 * databaseDoRead() - called when user clicks "Ok" button on
 *                    filename dialog (child of Conference Submission
 *                    popup)
 */

#include "database.h"

void
readButtonCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg     args[5];
    Widget  popup;
    Position    x, y;
    Dimension   width, height;
    register int n;


    n = 0;
    XtSetArg(args[0], XtNwidth, &width); n++;
    XtSetArg(args[1], XtNheight, &height); n++;
    XtGetValues(w, args, n);
    XtTranslateCoords(w, (Position) (width / 2),
            (Position) (height / 2), &x, &y);


    n = 0;
    XtSetArg(args[n], XtNx, x);             n++;
    XtSetArg(args[n], XtNy, y);             n++;

    popup = XtCreatePopupShell("databaseReadPopup",
        transientShellWidgetClass, w, args, n);

    databaseReadDialog = XtCreateManagedWidget("databaseReadDialog",
        dialogWidgetClass, popup,NULL, 0);

    XawDialogAddButton(databaseReadDialog, "ok", databaseDoRead,
        (XtPointer) databaseReadDialog);
    XawDialogAddButton(databaseReadDialog, "cancel", Destroy_form,
        (XtPointer) databaseReadDialog);

    XtPopup(popup, XtGrabExclusive);
}

void
databaseDoRead(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg args[3];
    char line[MAXLINE], filename[MAXLINE];
    String fname;
    String desc;
    FILE *fp;
    Widget popup;

#ifdef DDEBUG
    printf("in databaseDoRead\n");
#endif
    popup = XtParent(XtParent(XtParent(w)));
    fname = XawDialogGetValueString(databaseReadDialog);


    strcpy(filename, fname);


    replace(filename, "~", Home);

#ifdef DEBUG
    printf("filename: %s\n", filename);
#endif
    if (NULL == (fp = fopen(filename, "r"))) {
        fprintf(stderr, "couldn't open description file \n");
        sprintf(line, "couldn't open description file %s", filename);
        set_status(line, RED);
    }
    else {
        while (fgets(line, MAXLINE-2, fp))
            add_text(descDisplayText, line);

        fclose(fp);
        XtVaSetValues(descDisplayText, XtNeditType, XawtextEdit, NULL);
        XtVaSetValues(descDisplayText, XtNinsertPosition, 0, NULL);
        XtDestroyWidget( XtParent(databaseReadDialog));
        }
}

