/*
 *  Xnetlib developed at The UNIVERSITY of TENNESSEE & ORNL.
 *
 *  Permission to use, copy, modify, and distribute this software
 *  and its documentation for any purpose and without fee is hereby
 *  granted, provided that the above copyright notice appear in all
 *  copies and that both that copyright notice and this permission
 *  notice appear in supporting documentation.
 *
 *  This software is provided "as is" without express or implied
 *  warranty.
 */

/*
 * $Id: main.c,v 1.21 1993/07/01 14:10:59 wade Exp $
 *
 * $Log: main.c,v $
 * Revision 1.21  1993/07/01  14:10:59  wade
 * RT clean compilation
 *
 * Revision 1.20  1993/06/30  20:07:04  wade
 * added resource to turn off bad scrollbars in search popup
 * for conference module
 *
 * Revision 1.19  1993/06/30  17:36:27  wade
 * made menu10 local
 *
 * Revision 1.18  1993/06/30  16:46:22  browne
 * *** empty log message ***
 *
 * Revision 1.17  1993/06/12  11:29:50  browne
 * *** empty log message ***
 *
 * Revision 1.16  1993/05/25  17:40:48  wade
 * added conference switches
 *
 * Revision 1.14  1993/05/14  20:03:09  browne
 * added resource setting for locationText.displayCaret
 *
 * Revision 1.13  1993/04/27  16:28:19  wade
 *
 * Revision 1.12  1993/04/27  15:25:37  wade
 *
 * Revision 1.11  1993/04/27  15:19:57  wade
 *
 * Revision 1.10  1993/04/23  20:12:52  wade
 *
 * Revision 1.9  1993/04/23  20:11:43  wade
 * more database stuff
 *
 * Revision 1.8  1993/04/20  15:27:59  wade
 * added database
 *
 * Revision 1.7  1993/04/19  20:37:34  wade
 *
 * Revision 1.6  1993/02/22  16:04:47  wade
 * added finger demo support
 *
 * Revision 1.5  1993/01/06  20:22:29  wade
 *
 * Revision 1.4  1993/01/05  22:25:11  wade
 * moved toplevel height spec to XtVaAppInitialize call
 *
 * Revision 1.3  1992/12/18  15:10:20  wade
 * added steve's shared index file stuff
 *
 * Revision 1.2  1992/12/05  17:15:51  larose
 * added rcs logging.
 *
 */


#include "xnl.h"
#include "bitmaps/icon.xbm"
#include "bitmaps/menu10.xbm"
#include "bitmaps/subdir.xbm"
#include "bitmaps/check.xbm"
#include "bitmaps/xnetlib.xbm"

Pixmap menuIcon;

void receiveCB(), exitCB(), libraryCB(), classificationCB(), 
        helpCB(), indexCB(), gobackCB(), printCB(), contexthelpCB(),
        newWinCB(), keywordCB(), updateCB(), whoCB(), motdCB();

#ifdef REXEC
void rexecCB();
#endif

#ifdef PERFORMANCE
void performanceCB();
#endif

extern XtResource gas_resources[];
extern XtResource sink_resources[];

void Handle_state();
void whoDoSave();

#ifdef CONFERENCE
void databaseDoSave(), databaseCB();
#endif

/*
void doPrint();
*/
void receiveDoPath();
void acceptNewEntry();

static char default_xnl_path[MAXLINE];
static char default_xnl_download_path[MAXLINE];
static char default_host_file[MAXLINE];

static XtResource col_resources[] = {
    {"okColor", "OkColor", XtRPixel, sizeof(Pixel),
     XtOffset(AppResources *, greenCol), XtRString, "green"},
    {"badColor", "BadColor", XtRPixel, sizeof(Pixel),
     XtOffset(AppResources *, redCol), XtRString, "red"},
    {"cautionColor", "CautionColor", XtRPixel, sizeof(Pixel),
     XtOffset(AppResources *, yellowCol), XtRString, "yellow"},
    {"xnlPath", "XnlPath", XtRString, sizeof(String),
     XtOffset(AppResources *, xnlPath), XtRString,
        default_xnl_path},
    {"xnlDownloadPath", "XnlDownloadPath", XtRString, sizeof(String),
     XtOffset(AppResources *, xnlDownloadPath), XtRString,
        default_xnl_download_path},

    {"entrySep", "EntrySep", XtRString, sizeof(String),
     XtOffset(AppResources *, whoEntrySep), XtRString,
        "-------\n"},
    {"printCommand", "PrintCommand", XtRString, sizeof(String),
     XtOffset(AppResources *, whoPrintCommand), XtRString,
        "lpr %s"},
    {"indexLifetime", "IndexLifetime", XtRInt, sizeof(int),
     XtOffset(AppResources *, indexLifetime), XtRImmediate,
        (XtPointer)7}, /* don't check index unless it's older than 7 days */
    {"hostFile", "HostFile", XtRString, sizeof(String),
     XtOffset(AppResources *, hostFile), XtRString, default_host_file},

    /* email address used to override current host name */
    {"email", "Email", XtRString, sizeof(String),
     XtOffset(AppResources *, email), XtRString, "none"},

    {"fingerDemo", "fingerDemo", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, fingerDemo), XtRImmediate, (XtPointer)False},

    {"depCheck", "DepCheck", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, depCheck), XtRImmediate, (XtPointer)True},
    {"showWhoInfo", "ShowWhoInfo", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, showWhoInfo), XtRImmediate, (XtPointer)True},
    {"showDownloadAnyway", "ShowDownloadAnyway", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources*,showReceiveAnyway),XtRImmediate, (XtPointer)False},
    {"confirmQuit", "ConfirmQuit", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, confirmQuit), XtRImmediate, (XtPointer)False},
    {"publicData", "PublicData", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, publicData), XtRImmediate, (XtPointer)False},
    {"dontWarp", "DontWarp", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, dontWarp), XtRImmediate, (XtPointer)False},
};

static XtResource mono_resources[] = {
    {"okColor", "OkColor", XtRPixel, sizeof(Pixel),
     XtOffset(AppResources *, greenCol), XtRString, "white"},
    {"badColor", "BadColor", XtRPixel, sizeof(Pixel),
     XtOffset(AppResources *, redCol), XtRString, "white"},
    {"cautionColor", "CautionColor", XtRPixel, sizeof(Pixel),
     XtOffset(AppResources *, yellowCol), XtRString, "white"},
    {"xnlPath", "XnlPath", XtRString, sizeof(String),
     XtOffset(AppResources *, xnlPath), XtRString,
        default_xnl_path},
    {"xnlDownloadPath", "XnlDownloadPath", XtRString, sizeof(String),
     XtOffset(AppResources *, xnlDownloadPath), XtRString,
        default_xnl_download_path},

    {"entrySep", "EntrySep", XtRString, sizeof(String),
     XtOffset(AppResources *, whoEntrySep), XtRString,
        "-------\n"},
    {"printCommand", "PrintCommand", XtRString, sizeof(String),
     XtOffset(AppResources *, whoPrintCommand), XtRString,
        "lpr %s"},
    {"indexLifetime", "IndexLifetime", XtRInt, sizeof(int),
     XtOffset(AppResources *, indexLifetime), XtRImmediate,
        (XtPointer)7}, /* don't check index unless it's older than 7 days */
    {"hostFile", "HostFile", XtRString, sizeof(String),
     XtOffset(AppResources *, hostFile), XtRString, default_host_file},

    /* email address used to override current host name */
    {"email", "Email", XtRString, sizeof(String),
     XtOffset(AppResources *, email), XtRString, "none"},

    {"fingerDemo", "fingerDemo", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, fingerDemo), XtRImmediate, (XtPointer)False},

    {"depCheck", "DepCheck", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, depCheck), XtRImmediate, (XtPointer)True},
    {"showWhoInfo", "ShowWhoInfo", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, showWhoInfo), XtRImmediate, (XtPointer)True},
    {"showDownloadAnyway", "ShowDownloadAnyway", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources*,showReceiveAnyway),XtRImmediate, (XtPointer)False},
    {"confirmQuit", "ConfirmQuit", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, confirmQuit), XtRImmediate, (XtPointer)False},
    {"publicData", "PublicData", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, publicData), XtRImmediate, (XtPointer)False},
    {"dontWarp", "DontWarp", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, dontWarp), XtRImmediate, (XtPointer)False},
};   

#ifdef NOWAY
static XtResource resources[] = {
    {"xnlPath", "XnlPath", XtRString, sizeof(String),
     XtOffset(AppResources *, xnlPath), XtRString, 
        default_xnl_path},
    {"xnlDownloadPath", "XnlDownloadPath", XtRString, sizeof(String),
     XtOffset(AppResources *, xnlDownloadPath), XtRString, 
        default_xnl_download_path},

    {"entrySep", "EntrySep", XtRString, sizeof(String),
     XtOffset(AppResources *, whoEntrySep), XtRString, 
        "-------\n"},
    {"printCommand", "PrintCommand", XtRString, sizeof(String),
     XtOffset(AppResources *, whoPrintCommand), XtRString, 
        "lpr %s"},
    {"indexLifetime", "IndexLifetime", XtRInt, sizeof(int),
     XtOffset(AppResources *, indexLifetime), XtRImmediate, 
        (XtPointer)7}, /* don't check index unless it's older than 7 days */
    {"hostFile", "HostFile", XtRString, sizeof(String),
     XtOffset(AppResources *, hostFile), XtRString, default_host_file},

	/* email address used to override current host name */
    {"email", "Email", XtRString, sizeof(String),
     XtOffset(AppResources *, email), XtRString, "none"},

    {"depCheck", "DepCheck", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, depCheck), XtRImmediate, (XtPointer)True},
    {"showWhoInfo", "ShowWhoInfo", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, showWhoInfo), XtRImmediate, (XtPointer)True},
    {"showDownloadAnyway", "ShowDownloadAnyway", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources*,showReceiveAnyway),XtRImmediate, (XtPointer)False},
    {"confirmQuit", "ConfirmQuit", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, confirmQuit), XtRImmediate, (XtPointer)False},
    {"publicData", "PublicData", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, publicData), XtRImmediate, (XtPointer)False},
    {"dontWarp", "DontWarp", XtRBoolean, sizeof(Boolean),
     XtOffset(AppResources *, dontWarp), XtRImmediate, (XtPointer)False},
};
#endif

static XtActionsRec actions[] =
{
    {"do_who",   do_who},
    {"do_keyword",   do_keyword},
#ifdef CONFERENCE
    {"do_database",   do_database},
    {"databaseDoSave",   databaseDoSave},
#endif
#ifdef REXEC
    {"do_rexec",   do_rexec},
#endif
#ifdef PERFORMANCE
    {"do_psearch",   do_psearch},
    {"do_compsearch",   do_compsearch},
#endif
    {"do_receive",   do_receive},
    {"whoDoSave",   whoDoSave},
/*
    {"doPrint",   doPrint},
*/
    {"receiveDoPath",   receiveDoPath},
    {"acceptNewEntry",   acceptNewEntry},
};


String fallback_resources[] = { 

/* uncomment these lines if you want people at your site to use
    	a single set of index files 
    "*publicData: True",
    "*xnlPath: /bone/homes/wade/xnlData",
*/
#ifdef MOULTON
    "*publicData: True",
    "*xnlPath: /white/homes/parallel/xnlData",
#endif

    "*status*Foreground:    black",
    "*useBottom:    True",
    "*displayCaret:    False",
    "*Conference_Submission*displayCaret:    True",
    "*value.displayCaret:    True",
#ifdef REXEC
    "*rexecDisplayText.displayCaret:    True",
#endif
    "*enterText.displayCaret:    True",
    "*fromText.displayCaret:    True",
    "*toText.displayCaret:    True",
    "*enterText.displayCaret:    True",
    "*locationText.displayCaret:    True",
    "*whoEnterText.displayCaret:    True",
    "*insertFile.form.text*scrollVertical:    never",
    "*insertFile.form.text*scrollHorizontal:  never",
	"*description.search.form.Text*scrollVertical:    never",
	"*description.search.form.Text*scrollHorizontal:  never",
    "*value.scrollVertical:    never",
    "*value.scrollHorizontal:  never",
    "*Text*scrollVertical:    Always",
    "*Text*scrollHorizontal:  whenNeeded",
    "*font:    lucidasanstypewriter-bold-12",
    "*Paned.internalBorderWidth:    1",
    "*allowShellResize: True",
    "*showGrip:    False",
    "*resizeToPreferred:    False",
    "*verticalList:        True",
    /*
    "*Command.ShapeStyle: oval",
    */
    "*receiveSaveDialog.label: Save in file",
    "*receiveSaveDialog*value.translations: #override \\n <Key>Return: receiveDoSave()",
    "*databaseSaveDialog.value: conferenceInfo.txt",
    "*descsaveSaveDialog.value: conferenceInfo.txt",
    "*databaseReadDialog.value: conferenceInfo.txt",
    "*databaseSaveDialog.label: Save in file",
    "*descsaveSaveDialog.label: Save in file",
    "*databaseReadDialog.label: Read from file",
    "*databaseSaveDialog*value.translations: #override \\n <Key>Return: databaseDoSave()",
    "*descsaveSaveDialog*value.translations: #override \\n <Key>Return: descsaveDoSave()",
    "*whoSaveDialog.value: whoInfo.txt",
    "*whoSaveDialog.label: Save in file",
    "*whoSaveDialog*value.translations: #override \\n <Key>Return: whoDoSave()",
    "*printDialog.label: Print me?  (%s in command is replaced with file)",
/*
    "*printDialog*value.translations: #override \\n <Key>Return: doPrint()",
*/
    "*Dialog*label.resizable: TRUE",
    "*reportDialog*OK.width: 200",
    "*newEntryDialog*value.translations: #override \\n <Key>Return: acceptNewEntry()",
    NULL,
};

static XrmOptionDescRec options[] = {
    {"-fingerDemo", "*fingerDemo",    XrmoptionNoArg,         "True"},

    {"-hl", "*borderColor",    XrmoptionSepArg,         NULL},
    {"-dw", "*dontWarp",    XrmoptionNoArg,         "True"},

    {"-nocq", "*confirmQuit",    XrmoptionNoArg,         "False"},
    {"-cq", "*confirmQuit",    XrmoptionNoArg,         "True"},

    {"-showdown", "*showDownloadAnyway",    XrmoptionNoArg,         "True"},
    {"-noshowdown", "*showDownloadAnyway",    XrmoptionNoArg,         "False"},

    {"-showwho", "*showWhoInfo",    XrmoptionNoArg,         "True"},
    {"-noshowwho", "*showWhoInfo",    XrmoptionNoArg,         "False"},

    {"-pub", "*publicData",    XrmoptionNoArg,         "True"},
    {"-public", "*publicData",    XrmoptionNoArg,         "True"},
    {"-nopub", "*publicData",    XrmoptionNoArg,         "False"},
    {"-nopublic", "*publicData",    XrmoptionNoArg,         "False"},

    {"-dc", "*depCheck",    XrmoptionNoArg,         "True"},
    {"-nodc", "*depCheck",    XrmoptionNoArg,         "False"},

    {"-path", "*xnlDownloadPath",    XrmoptionSepArg,         NULL},
    {"-dp", "*xnlPath",    XrmoptionSepArg,         NULL},
    {"-es", "*entrySep",    XrmoptionSepArg,         NULL},
    {"-pc", "*printCommand",    XrmoptionSepArg,         NULL},
    {"-life", "*indexLifetime",    XrmoptionSepArg,         NULL},
    {"-email", "*email",    XrmoptionSepArg,         NULL},
    {"-file", "*hostFile",    XrmoptionSepArg,         NULL},
    {"-f", "*hostFile",    XrmoptionSepArg,         NULL},
};

main(argc, argv)
int argc;
char *argv[];
{
    Pixmap icon;
	Widget last;
    register int n;
    Arg args[20];
    Dimension height;
    int screenDepth;
	Boolean RV;

    setHome();

    if (Home) {
        sprintf(default_xnl_path, "%s/xnlData", Home);
        sprintf(default_xnl_download_path, "%s/xnlFiles", Home);
        sprintf(default_host_file, "%s/.xnetlibHosts", Home);
    } else {
        strcpy(default_xnl_path, "./xnlData");
        strcpy(default_xnl_download_path, "./xnlFiles");
        strcpy(default_host_file, "./xnetlibHosts");
    }


    toplevel = XtVaAppInitialize(&app_con, "Xnetlib",
                   options, XtNumber(options),
                   &argc, argv, fallback_resources, 
				   XtNheight, 600, NULL);

    XtSetArg(args[0], XtNdepth, &screenDepth);
    XtSetArg(args[1], XtNreverseVideo, &RV);
    XtGetValues(toplevel, args, 1);

	MONO = (screenDepth < 8) ? True : False;

    XtAppAddActions(app_con, actions, XtNumber(actions));

	if (MONO)  {
      XtGetApplicationResources( toplevel, (XtPointer) &app_resources,
                   mono_resources, XtNumber(mono_resources), NULL, 0 );
	    gas_resources[3].default_addr = (XtPointer)XtDefaultForeground;
	    gas_resources[4].default_addr = (XtPointer)XtDefaultBackground;
	    gas_resources[5].default_addr = (XtPointer)XtDefaultForeground;
	    sink_resources[3].default_addr = (XtPointer)XtDefaultForeground;
	    sink_resources[4].default_addr = (XtPointer)XtDefaultForeground;
	    sink_resources[5].default_addr = (XtPointer)XtDefaultForeground;
	} else {
      XtGetApplicationResources( toplevel, (XtPointer) &app_resources,
                   col_resources, XtNumber(col_resources), NULL, 0 );
	}

	for (n=0; EMAIL_ADDRESS[n]; n++) 
		if (white_char(EMAIL_ADDRESS[n])) {
			fprintf(stderr, "Email address (%s) may not contain whitespace.\n",
				EMAIL_ADDRESS);
			exit(1);
		}
	emailAddress = EMAIL_ADDRESS;

                   
    if (PUBDATA)
	 umask(0);

    if (argc != 1)
        Syntax(app_con, argv[0]);

    init();
    init_colors(toplevel);
    

    n = 0;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH); n++;
    topPane = XtCreateManagedWidget("pane", 
        panedWidgetClass, toplevel, args, n);
    n = 0;
    XtSetArg(args[n], XtNlabel, STATUS_DEFAULT); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNskipAdjust, True); n++;
    last = statusLabel = XtCreateManagedWidget("status", 
        labelWidgetClass, topPane, args, n);

    XtSetArg(args[0], XtNheight, &height);
    XtGetValues(statusLabel, args, 1);
    XawPanedSetMinMax(statusLabel, height, height);

#ifdef NETSTAT
    n = 0;
    XtSetArg(args[n], XtNlabel, INFO_DEFAULT); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNskipAdjust, True); n++;
    last = infoLabel = XtCreateManagedWidget("info",
        labelWidgetClass, topPane, args, n);

    XtSetArg(args[0], XtNheight, &height);
    XtGetValues(infoLabel, args, 1);
    XawPanedSetMinMax(infoLabel, height, height);
#endif


    /* create the main button form    */
    n = 0;
    XtSetArg(args[n], XtNresizeToPreferred, True); n++;
    XtSetArg(args[n], XtNvSpace, 5); n++;
    XtSetArg(args[n], XtNhSpace, 10); n++;
    buttonForm = XtCreateManagedWidget("buttonForm", boxWidgetClass,
            topPane, args, n);

    n = 0;
    XtSetArg(args[n], XtNsensitive, False); n++;
    XtSetArg(args[n], XtNlabel, "Go Up"); n++;
    last = gobackButton = XtCreateManagedWidget("goback", commandWidgetClass,
            buttonForm, args, n);
    XtAddCallback( gobackButton, XtNcallback, gobackCB, (XtPointer) NULL );

    n = 0;
    XtSetArg(args[n], XtNlabel, "Index"); n++;
	XtSetArg(args[n], XtNleftBitmap, menuIcon); n++;
    last = indexButton = XtCreateManagedWidget("index", menuButtonWidgetClass,
            buttonForm, args, n);
    
    indexMenu = XtCreatePopupShell("menu", simpleMenuWidgetClass, indexButton,
    	NULL, 0);


    n = 0;
    XtSetArg(args[n], XtNlabel, "Library"); n++;
    last = libraryButton = XtCreateManagedWidget("library", commandWidgetClass, 
            buttonForm, args, n);
    XtAddCallback( libraryButton, XtNcallback, libraryCB, (XtPointer) NULL );
    XtAddCallback( libraryButton, XtNcallback, Handle_state, (XtPointer) NULL );

    n = 0;
    XtSetArg(args[n], XtNlabel, "Classifications"); n++;
    last = classificationButton = XtCreateManagedWidget("classifications", 
            commandWidgetClass, buttonForm, args, n);
    XtAddCallback( classificationButton, XtNcallback, classificationCB, 
            (XtPointer) NULL );
    XtAddCallback( classificationButton, XtNcallback, Handle_state, 
            (XtPointer) NULL );

    n = 0;
    XtSetArg(args[n], XtNlabel, "Search"); n++;
    last = keywordButton = XtCreateManagedWidget("search", 
            commandWidgetClass, buttonForm, args, n);
    XtAddCallback( keywordButton, XtNcallback, keywordCB, (XtPointer) NULL );
    XtAddCallback( keywordButton, XtNcallback, Handle_state, (XtPointer) NULL );

    n = 0;
    XtSetArg(args[n], XtNlabel, "Who"); n++;
    last = whoButton = XtCreateManagedWidget("who", 
            commandWidgetClass, buttonForm, args, n);
    XtAddCallback( whoButton, XtNcallback, whoCB, (XtPointer) NULL );
    XtAddCallback( whoButton, XtNcallback, Handle_state, (XtPointer) NULL );

/* ZZZ
    n = 0;
    XtSetArg(args[n], XtNlabel, "Remote Services"); n++;
    last = rexecButton = XtCreateManagedWidget("rexec",
            commandWidgetClass, buttonForm, args, n);
    XtAddCallback( rexecButton, XtNcallback, rexecCB, (XtPointer) NULL );
    XtAddCallback( rexecButton, XtNcallback, Handle_state, (XtPointer)NULL );
*/

    n = 0;
    XtSetArg(args[n], XtNlabel, "Download"); n++;
    last = receiveButton = XtCreateManagedWidget("download",
            commandWidgetClass, buttonForm, args, n);
    XtAddCallback( receiveButton, XtNcallback, receiveCB, (XtPointer) NULL );
    XtAddCallback( receiveButton, XtNcallback, Handle_state, (XtPointer) NULL );

    n = 0;
    XtSetArg(args[n], XtNlabel, "Set Up"); n++;
    if (FINGER_DEMO) {
        XtSetArg(args[n], XtNsensitive, False); n++;
    }
    last = updateButton = XtCreateManagedWidget("setup",
            commandWidgetClass, buttonForm, args, n);
	if (FINGER_DEMO == False) {
      XtAddCallback( updateButton, XtNcallback, updateCB, (XtPointer) NULL );
      XtAddCallback( updateButton, XtNcallback, Handle_state, (XtPointer)NULL );
	}

    n = 0;
    XtSetArg(args[n], XtNlabel, "Timely Message"); n++;
	XtSetArg(args[n], XtNleftBitmap, menuIcon); n++;
    last = motdButton = XtCreateManagedWidget("timely",
            menuButtonWidgetClass, buttonForm, args, n);

    motdMenu = XtCreatePopupShell("menu", simpleMenuWidgetClass, 
		motdButton, NULL, 0);

#ifdef CONFERENCE
    n = 0;
    XtSetArg(args[n], XtNlabel, "Conferences"); n++;
    last = databaseButton = XtCreateManagedWidget("database",
            commandWidgetClass, buttonForm, args, n);
    XtAddCallback( databaseButton, XtNcallback, databaseCB, (XtPointer) NULL );
    XtAddCallback( databaseButton, XtNcallback, Handle_state, (XtPointer) NULL );
#endif


#ifdef STUB
    n = 0;
    XtSetArg(args[n], XtNlabel, "Stub"); n++;
    last = stubButton = XtCreateManagedWidget("stub",
            menuButtonWidgetClass, buttonForm, args, n);

    stubMenu = XtCreatePopupShell("menu", simpleMenuWidgetClass,
        stubButton, NULL, 0);
#endif
#ifdef PERFORMANCE
    n = 0;
    XtSetArg(args[n], XtNlabel, "Performance"); n++;
    last = performanceButton = XtCreateManagedWidget("performance",
            commandWidgetClass, buttonForm, args, n);
    XtAddCallback( performanceButton, XtNcallback, performanceCB, (XtPointer) NULL );
    XtAddCallback( performanceButton, XtNcallback, Handle_state, (XtPointer)NULL );
#endif

    n = 0;
    XtSetArg(args[n], XtNlabel, "Show in New Window"); n++;
    last = newWinButton = XtCreateManagedWidget("newwin",
            commandWidgetClass, buttonForm, args, n);
    XtAddCallback( newWinButton, XtNcallback, newWinCB,
        (XtPointer) False );

    n = 0;
    XtSetArg(args[n], XtNstate, False); n++;
    XtSetArg(args[n], XtNlabel, "Contextual Help"); n++;
    last = contextHelpButton = XtCreateManagedWidget("contexthelp",
            toggleWidgetClass, buttonForm, args, n);
    XtAddCallback( contextHelpButton, XtNcallback, contexthelpCB, 
		(XtPointer) False );

    n = 0;
    XtSetArg(args[n], XtNlabel, "Help"); n++;
    last = helpButton = XtCreateManagedWidget("help", commandWidgetClass,
            buttonForm, args, n);
    XtAddCallback( helpButton, XtNcallback, helpCB, (XtPointer) NULL );
    XtAddCallback( helpButton, XtNcallback, Handle_state, (XtPointer) NULL );

    n = 0;
    XtSetArg(args[n], XtNlabel, "Print"); n++;
    if (FINGER_DEMO) {
        XtSetArg(args[n], XtNsensitive, False); n++;
    }
    last = printButton = XtCreateManagedWidget("print",
            commandWidgetClass, buttonForm, args, n);
	if (FINGER_DEMO == False) 
      XtAddCallback( printButton, XtNcallback, printCB, (XtPointer) False );
    currentDisplayText = NULL;

    n = 0;
    XtSetArg(args[n], XtNlabel, "Quit"); n++;
    last = exitButton = XtCreateManagedWidget("quit",
            commandWidgetClass, buttonForm, args, n);
    XtAddCallback( exitButton, XtNcallback, exitCB, (XtPointer) False );

	height *= 2;

    n = 0;
    XtSetArg(args[n], XtNlabel, NORMALHELP); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNskipAdjust, True); n++;
    last = fastHelpLabel = XtCreateManagedWidget("fastHelp",
        labelWidgetClass, topPane, args, n);

    XtSetArg(args[0], XtNheight, &height);
    XtGetValues(fastHelpLabel, args, 1);
    XawPanedSetMinMax(fastHelpLabel, height, height);
    height += 10;

    init_fasthelp(fastHelpLabel , app_con );

    setfasthelpmessage( gobackButton, GOBACKHELP);
    setfasthelpmessage( helpButton, HELPHELP);
    setfasthelpmessage( indexButton, INDEXHELP);
    setfasthelpmessage( libraryButton, LIBRARYHELP);
    setfasthelpmessage( receiveButton, RECVHELP);
    setfasthelpmessage( classificationButton, CLASSHELP);
    setfasthelpmessage( keywordButton, KEYHELP);
#ifdef CONFERENCE
    setfasthelpmessage( databaseButton, DATABASEHELP);
#endif
    setfasthelpmessage( whoButton, WHOHELP);
/* ZZZ
    setfasthelpmessage( rexecButton, REXECHELP);
*/
    setfasthelpmessage( updateButton, UPDATEHELP);
    setfasthelpmessage( motdButton, MOTDHELP);
#ifdef PERFORMANCE
    setfasthelpmessage( performanceButton, PERFORMANCEHELP);
#endif
    setfasthelpmessage( printButton, "print text in window");
    setfasthelpmessage( newWinButton, NEWWINHELP);
    setfasthelpmessage( contextHelpButton, CONTEXTHELPHELP);
    setfasthelpmessage( exitButton, EXITHELP);



    

	make_contexthelp(toplevel);
    make_who(toplevel);
    make_update(toplevel);
    make_help(toplevel);
    make_keyword(toplevel);
#ifdef CONFERENCE
	make_database(toplevel);
#endif
    make_index(toplevel);
    make_motd(toplevel);
#ifdef STUB
    make_stub(toplevel);
#endif
#ifdef PERFORMANCE
    make_performance(toplevel);
#endif
    make_library(toplevel);
    make_libSelect(toplevel);
    make_class(toplevel);
    make_classSelect(toplevel);
    make_receive(toplevel);
#ifdef REXEC
    make_rexec(toplevel);
#endif

    XtUnmanageChild(classPop);
    XtUnmanageChild(classSelPop);
    for (n=0; n < Many_servers; n++) {
		if (indexPop[n])
			XtUnmanageChild(indexPop[n]);
		if (motdPop[n])
			XtUnmanageChild(motdPop[n]);
#ifdef STUB
		if (stubPop[n])
			XtUnmanageChild(stubPop[n]);
#endif
	}
#ifdef PERFORMANCE
	XtUnmanageChild(perfForm);
#endif
    XtUnmanageChild(keywordForm);
#ifdef CONFERENCE
    XtUnmanageChild(databaseForm);
    XtUnmanageChild(databaseDisplayText);
#endif
    XtUnmanageChild(keywordDisplayText);
    XtUnmanageChild(libraryPop);
    XtUnmanageChild(libSelForm);
    XtUnmanageChild(classSelPop);
    XtUnmanageChild(receiveForm);
    XtUnmanageChild(receiveViewport);
    XtUnmanageChild(whoForm);
    XtUnmanageChild(whoDisplayText);
    XtUnmanageChild(updateForm);
#ifdef REXEC
    XtUnmanageChild(rexecForm);
    XtUnmanageChild(rexecDisplayText);
#endif

    Popup_help(toplevel);


    check_download_button();

    XtRealizeWidget(toplevel);

    icon = XCreateBitmapFromData (XtDisplay(toplevel),
                DefaultRootWindow( XtDisplay(toplevel)),
                xnetlib_bits, xnetlib_width,
                xnetlib_height);
    XtSetArg (args[0], XtNiconPixmap, icon);   
    XtSetArg (args[1], XtNiconMask, icon);   
    XtSetValues (toplevel, args, 2);

    XtAppMainLoop(app_con);

/*NOTREACHED*/
}

/*ARGSUSED*/
void
exitCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Boolean from_dialog = (Boolean)call_data;
    Arg     args[5];
    Widget  popup, quitDialog;
    Position    x, y;
    Dimension   width, height;
    register int n;

    if ((CONFIRM_QUIT) && (!from_dialog)) {
        n = 0;
        XtSetArg(args[0], XtNwidth, &width); n++;
        XtSetArg(args[1], XtNheight, &height); n++;
        XtGetValues(w, args, n);
        XtTranslateCoords(w, (Position) (width / 2),
                (Position) (height / 2), &x, &y);

        n = 0;
        XtSetArg(args[n], XtNx, x);             n++;
        XtSetArg(args[n], XtNy, y);             n++;

        popup = XtCreatePopupShell("quitPopup",
            transientShellWidgetClass, w, args, n);

        n = 0;
        XtSetArg(args[n], XtNlabel, "Really quit?");             n++;
        quitDialog = XtCreateManagedWidget("quitDialog",
            dialogWidgetClass, popup, args, n);

        XawDialogAddButton(quitDialog, "yes", exitCB,
            (XtPointer) True);
        XawDialogAddButton(quitDialog, "no", Destroy_form,
            (XtPointer)quitDialog);

        if (!(DONT_WARP))
          XWarpPointer(XtDisplay(toplevel), None, XtWindow(popup),
            0,0,0,0, 20,35);
        
        XtPopup(popup, XtGrabExclusive);

    } else {
    	keywordCleanup();
#ifdef CONFERENCE
    	databaseCleanup();
#endif
        Mode_desired = MODE_QUIT;
        Handle_state(w, NULL, NULL);
    }
}


Syntax(app_con, name)
XtAppContext app_con;
char *name;
{
    XtDestroyApplicationContext(app_con);
    fprintf(stderr,"Usage: %s\n", name);
    fprintf(stderr,"    -fg         foreground color\n");
    fprintf(stderr,"    -bg         background color\n");
    fprintf(stderr,"    -hl         highlight color\n");
    fprintf(stderr,"    -dw         don't warp the cursor, ever\n");
    fprintf(stderr,"    -cq/+cq     set confirmQuit\n");
    fprintf(stderr,"    -showrec/+showrec set showReceiveAnyway\n");
    fprintf(stderr,"    -showwho/+showwho set showWhoInfo\n");
    fprintf(stderr,"    -dc/+dc     set dependency checking in receive mode\n");
    fprintf(stderr,"    -path       set download path\n");
    fprintf(stderr,"    -dp         set data cache path\n");
    fprintf(stderr,"    -pc         set print command in who mode\n");
    fprintf(stderr,"    -es         set entry sep in who mode\n");
    fprintf(stderr,"    -life       set index file lifetime\n");
    fprintf(stderr,"    -server     set server list\n");
    fprintf(stderr,"    -keyserver  set keyword server\n");
    fprintf(stderr,"    -whoserver  set whois server\n");
    fprintf(stderr,"    -help       print this\n");

    exit(1);
}

init()
{
    Num_to_receive = 0;
    Mode = Mode_desired = MODE_HELP;
    Mode_last = MODE_INDEX;

    helpPic = libraryPop = classPop = NULL;

    downloadPath = XtNewString(XNL_DOWNLOAD_PATH);

    /* just in case */
    mkdir(downloadPath, DIR_MODE);
    
	loadHostFile();
    parseServerList();

    whoInit();
    filelist_init();

    setUsername();

    set_cursor(CURSOR_INIT, 0);

    togglePix = XCreateBitmapFromData(XtDisplay(toplevel), 
        DefaultRootWindow( XtDisplay(toplevel)),
        icon_bits, icon_width, icon_height);
    subdirPix = XCreateBitmapFromData(XtDisplay(toplevel), 
        DefaultRootWindow( XtDisplay(toplevel)),
        subdir_bits, subdir_width, subdir_height);
    checkPix = XCreateBitmapFromData(XtDisplay(toplevel), 
        DefaultRootWindow( XtDisplay(toplevel)),
        check_bits, check_width, check_height);
    menuIcon = XCreateBitmapFromData(XtDisplay(toplevel),
        DefaultRootWindow( XtDisplay(toplevel)),
        menu10_bits, menu10_width, menu10_height);
}
