
/*
 *
 * $Log: receive.c,v $
 * Revision 1.9  1993/06/16  20:12:54  wade
 * CONFERENCE was misspelled
 *
 * Revision 1.8  1993/06/12  17:46:03  browne
 * *** empty log message ***
 *
 * Revision 1.7  93/06/12  11:29:59  browne
 * *** empty log message ***
 * 
 * Revision 1.6  1993/05/24  17:37:47  wade
 * misc typecasting cleanup
 *
 * Revision 1.5  1993/02/22  16:04:47  wade
 * added finger demo support
 *
 * Revision 1.4  1993/02/19  16:13:14  wade
 * added finger demo support
 *
 * Revision 1.3  1992/12/15  21:06:05  wade
 * using text instead of bitmaps for contextual help
 *
 * Revision 1.2  1992/12/05  17:01:02  larose
 * added logging.
 *
 *
 */

#include "xnl.h"

extern int *bgColors;

int ConvertColor();

int textSize;

Widget receiveList,
        receiveDownloadButton, receiveCancelButton,
        receiveDepButton, receivePathButton,
		receiveUnsetButton, receiveSetButton,
        receivePathDialog;

int fsize, frecvsize;

int currentFileNum;
char currentFile[MAXLINE];
char currentDir[MAXLINE];

FILE *fp;
char dest[MAXLINE];


Boolean downloadingNow = False;

Boolean recclick = True;
int receiveSocket = (int)NULL;

static void receivePath(), unsetAll(), setAll(), receiveCancel(),
    receiveDownload(), receiveDep();

void receiveDoPath();

static XtInputId inputId = (XtInputId)NULL;

char *commafy();

void receiveCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Mode_desired = MODE_RECEIVE;
}


XtInputCallbackProc receiveIncoming(data, s, inputid)
XtPointer data;
int *s;
XtInputId *inputid;
{
    char buf[1024];
    int retval;
	char file_status[MAXLINE];

	if (receiveSocket == (int)NULL)
		return;

#ifdef TERM
    retval=read(*s, buf, 1022);
#else
    retval=recv(*s, buf, 1022, NULL);
#endif
    fwrite(buf, 1, retval, fp);

    frecvsize += retval;

    setGas(frecvsize, 0);

    if (frecvsize >= fsize) {

        fclose(fp);
        XtRemoveInput(*inputid);
		inputId = (XtInputId)NULL;
		shutdown(receiveSocket, 2);
        close(receiveSocket);
        receiveSocket = (int)NULL;

        sprintf(file_status, "got %s/%s", currentDir, currentFile);
        set_status(file_status, GREEN);

        remove_from_download_list(DownloadList[currentFileNum]);
	    XawTextInvalidate(receiveList, 0, textSize);
        do_receive();

    } 
}


XtInputCallbackProc receiveIncomingInit(data, s, inputid)
XtPointer data;
int *s;
XtInputId *inputid;
{
    char buf[1024];
    char file_status[MAXLINE];
    int retval;
    Arg args[4];


    frecvsize = fsize = 0;

    if ((fp = fopen(dest, "w")) != NULL) {
        get_line(*s, file_status);
        if (0!=strncmp(file_status, "OK ", 3)) {
            fprintf(stderr, "problem getting file: <%s>\n", file_status);
        } else {

            frecvsize = 0;
            sscanf(file_status +3, "%d", &fsize);
	        setGas(0, fsize);

            retval=recv(*s, buf, 1022, NULL);
            
            fwrite(buf, 1, retval, fp);
            frecvsize += retval;

            setGas(frecvsize, 0);

            sprintf(file_status, "getting %s... (%s bytes)", currentFile, 
				commafy(fsize));
            set_status(file_status, YELLOW);

        }
    } else {
        fprintf(stderr, "couldn't open <%s> to write\n", dest);
    }

	setGas(0, fsize);

    XtRemoveInput(*inputid); 
	inputId = (XtInputId)NULL;

    if (frecvsize >= fsize) {
        if (fp) fclose(fp);
		shutdown(receiveSocket, 2);
        close(receiveSocket);
        receiveSocket = (int)NULL;

        sprintf(file_status, "got %s/%s", currentDir, currentFile);
		set_status(file_status, GREEN);

        remove_from_download_list(DownloadList[currentFileNum]);
	    XawTextInvalidate(receiveList, 0, textSize);

        do_receive();

    } else {
        inputId = XtAppAddInput(app_con, receiveSocket,
            (XtPointer)XtInputReadMask, 
			(XtInputCallbackProc)receiveIncoming, (XtPointer)NULL);
    }
}

void
do_receive()
{
    char filename[MAXLINE];
    char file[MAXLINE], dir[MAXLINE];
    char line[MAXLINE];
    char dir_path[MAXLINE];
    register int i, which_server;
	XawTextPosition pt;
	XawTextBlock tblock;

    if (!DownloadList[currentFileNum]) {
        downloadingNow = False;
        grey_the_button(receiveCancelButton, False);
        grey_the_button(receiveDownloadButton, True);
        set_cursor(CURSOR_NORMAL, 0);
        grey_the_bar(True);
    }
    if (!downloadingNow)
        return;

    /* get filename portion of line */
    sscanf(DownloadList[currentFileNum], "file %s", filename);
    i = 0;
    while ( (filename[i] != ' ') && (filename[i] != '\t') &&
                    (filename[i] != '\n') )
        i++;
    filename[i] = '\0';

	/* set insert point so the scrollbar will track current file */
	tblock.format = FMT8BIT;
	tblock.firstPos = 0;
	tblock.length = strlen(DownloadList[currentFileNum]);
	tblock.ptr = DownloadList[currentFileNum];
	if ( (XawTextSearchError != (pt = XawTextSearch(receiveList, 
			XawsdRight, &tblock))) 
	 || (XawTextSearchError != (pt = XawTextSearch(receiveList, 
			XawsdLeft, &tblock))) ) {
		XawTextSetInsertionPoint(receiveList, pt);
	}


    strcpy(dir, filename);
    /* now terminate at the / */
    i=strlen(dir);
    while (dir[i] != '/') i--;
    dir[i] = '\0';
    strcpy(file, filename +strlen(dir) +1);

    strcpy(currentFile, file);
    strcpy(currentDir, dir);

    sprintf(line, "getting %s...", filename);
    set_status(line, YELLOW);

    sprintf(dest, "%s/%s", downloadPath, filename);
    which_server = lib2server(dir);

    sprintf(dir_path, "%s/%s", downloadPath, dir);
    make_dir(dir_path, 0);
    

	receiveSocket = netlib_open(server_list[which_server], 
        (DEP_CHECK) ? "file-get-dep" : "file-get", 
		file, dir, EMAIL_ADDRESS,0);

    /* clear the gas gauge */
    setGas(0, 100);

    if (receiveSocket) {
        inputId = XtAppAddInput(app_con, receiveSocket,
            (XtPointer)XtInputReadMask, 
			(XtInputCallbackProc)receiveIncomingInit, (XtPointer)NULL);
    } else {
		sprintf(line, "had a problem communicating with %s", 
			server_list[which_server]);
        set_status(line, RED);
    }
}

Popup_receive(w)
Widget w;
{
    Arg args[20];
    Dimension label_height;
    register int n, i, size;
	Dimension wide, high;
	String buf;

    XtSetArg(args[0], XtNheight, &label_height);
    XtGetValues(exitButton, args, 1);
    XtSetArg(args[0], XtNmax, 2*label_height +50 + 20); 
    XtSetArg(args[1], XtNmin, 2*label_height +50 + 20); 
    XtSetValues(receiveForm, args, 2);

    XtSetArg(args[0], XtNheight, &high);
    XtSetArg(args[1], XtNwidth, &wide);
    XtGetValues(receiveList, args, 2);

#ifdef CONFERENCE
    if (nextdescButton)
        grey_the_button(nextdescButton, False);
    else if (descrecvButton)
        grey_the_button(descrecvButton, False);
#endif

    /* first destroy the old child */
    XtDestroyWidget(receiveList);

	currentFileNum = 0;

    i = 0;
	size = 10;
    while (DownloadList[i]) {
		size += strlen(DownloadList[i]) +2;
		i++;
	}
	textSize = size;
	buf = (String)malloc(size * sizeof (String));
    i = 0;
	buf[0] = '\0';
    while (DownloadList[i]) {
		strcat(buf, DownloadList[i]);
		strcat(buf, "\n");
		i++;
	}

    n = 0;
    XtSetArg(args[n], XtNheight, high); n++;
    XtSetArg(args[n], XtNwidth, wide); n++;
    XtSetArg(args[n], XtNstring, buf); n++;
	currentDisplayText = 
	receiveList = XtCreateManagedWidget("downloadText",
            utkasciiTextWidgetClass, receiveViewport, args, n);
	free(buf);

    XtManageChild(receiveForm);
    XtManageChild(receiveViewport);

    set_status(RECV_HEADER, GREEN);

    if (!(DONT_WARP))
      XWarpPointer(XtDisplay(toplevel), None, XtWindow(receiveDownloadButton),
        0,0,0,0, 15,5);

	return 1;
}

make_receive(w)
Widget w;
{
    Arg args[20];
    char line[MAXLINE];
    register int n;
    
    downloadingNow = False;

	con_help[MODE_RECEIVE] = "\n\
In Download mode, files you have selected can be downloaded\n\
from their server.\n\
\n\
Click on 'Get Files Now' to begin copying files. Click on 'Cancel'\n\
to stop prematurely.\n\
\n\
To change the location files are copied to, click on 'Download\n\
path:'.\n\
\n\
Click on 'Dependency Checking:' to turn it on or off. If dependency\n\
checking is on, any files required by the file you get are added to\n\
the file before it is copied.\n\
\n\
You may remove files from the download list at this time by selecting\n\
them as in Library Selection mode.\n";


    n = 0;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH); n++;
    XtSetArg(args[n], XtNheight, XNL_HEIGHT); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    receiveForm = XtCreateManagedWidget("downloadForm", formWidgetClass, 
        topPane, args, n);

#undef FIX
#define FIX \
    XtSetArg(args[n], XtNbottom, XtChainTop); n++; \
    XtSetArg(args[n], XtNtop, XtChainTop); n++;    \
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;  \
    XtSetArg(args[n], XtNright, XtChainLeft); n++;


    n = 0;
    XtSetArg(args[n], XtNjustify, XtJustifyLeft); n++;
    sprintf(line, "Download path: %s", downloadPath);
    XtSetArg(args[n], XtNlabel, line); n++;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH -10); n++;
    XtSetArg(args[n], XtNbottom, XtChainTop); n++; 
    XtSetArg(args[n], XtNtop, XtChainTop); n++;    
    receivePathButton = XtCreateManagedWidget("downloadPathButton",
            commandWidgetClass, receiveForm, args, n);
    setfasthelpmessage( receivePathButton, "change where files are donwloaded to");


    n = 0;
    XtSetArg(args[n], XtNlabel, "Get Files Now"); n++;
    XtSetArg(args[n], XtNfromVert, receivePathButton); n++;
	if (FINGER_DEMO) {
		XtSetArg(args[n], XtNsensitive, False); n++;
	}
    FIX
    receiveDownloadButton = XtCreateManagedWidget("downloadGet", 
            commandWidgetClass, receiveForm, args, n);
    setfasthelpmessage( receiveDownloadButton, "begin downloading these files");

    n = 0;
    XtSetArg(args[n], XtNlabel, "Cancel"); n++;
    XtSetArg(args[n], XtNfromVert, receivePathButton); n++;
    XtSetArg(args[n], XtNsensitive, False); n++;
    XtSetArg(args[n], XtNfromHoriz, receiveDownloadButton); n++;
    FIX
    receiveCancelButton = XtCreateManagedWidget("downloadCancel", 
            commandWidgetClass, receiveForm, args, n);
    setfasthelpmessage( receiveCancelButton, "cancel downloading");


    n = 0;
    XtSetArg(args[n], XtNfromHoriz, receiveCancelButton); n++;
    XtSetArg(args[n], XtNfromVert, receivePathButton); n++;
    if (DEP_CHECK) {
        XtSetArg(args[n], XtNlabel, "Dependency Checking: on "); n++;
    } else {
        XtSetArg(args[n], XtNlabel, "Dependency Checking: off"); n++;
    }
    FIX
    receiveDepButton = XtCreateManagedWidget("downloadDep", 
            commandWidgetClass, receiveForm, args, n);
    setfasthelpmessage( receiveDepButton, "get/don't get dependent files also");

    n = 0;
    XtSetArg(args[n], XtNlabel, "Unselect All Files"); n++;
    XtSetArg(args[n], XtNfromVert, receivePathButton); n++;
    XtSetArg(args[n], XtNfromHoriz, receiveDepButton); n++;
    FIX
    receiveUnsetButton = XtCreateManagedWidget("unsetAll",
            commandWidgetClass, receiveForm, args, n);
    setfasthelpmessage( receiveUnsetButton, "unselect all files in the download list");

    n = 0;
    XtSetArg(args[n], XtNlabel, "Select All Files"); n++;
    XtSetArg(args[n], XtNfromVert, receivePathButton); n++;
    XtSetArg(args[n], XtNfromHoriz, receiveUnsetButton); n++;
    FIX
    receiveSetButton = XtCreateManagedWidget("setAll",
            commandWidgetClass, receiveForm, args, n);
    setfasthelpmessage( receiveSetButton, "select all files in the download list");


    n = 0;
/*
	if (MONO) {
	  if (RV) {
		XtSetArg(args[n], XtNef, ConvertColor(w, "white")); n++;
		XtSetArg(args[n], XtNdial, ConvertColor(w, "white")); n++;
		XtSetArg(args[n], XtNneedle, ConvertColor(w, "black")); n++;
	  } else {
		XtSetArg(args[n], XtNneedle, ConvertColor(w, "white")); n++;
		XtSetArg(args[n], XtNdial, ConvertColor(w, "black")); n++;
		XtSetArg(args[n], XtNef, ConvertColor(w, "black")); n++;
	  }
	}
*/
    XtSetArg(args[n], XtNfromVert, receiveDepButton); n++;
    XtSetArg(args[n], XtNgasValue, 0); n++;
    XtSetArg(args[n], XtNmaxValue, 100); n++;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH -10);        n++;
    XtSetArg(args[n], XtNheight, 50);        n++;
    XtSetArg(args[n], XtNbottom, XtChainTop); n++; 
    XtSetArg(args[n], XtNtop, XtChainTop); n++;    
    gasgauge = XtCreateManagedWidget("gasGauge",
            gasGaugeWidgetClass, receiveForm, args, n);

    n = 0;
    FIX
    XtSetArg(args[n], XtNresizable, True); n++;

    receiveViewport = XtCreateManagedWidget("downloadViewport",
            formWidgetClass, topPane, args, n);

    n = 0;
    FIX
    XtSetArg(args[n], XtNwidth, XNL_WIDTH);        n++;
    XtSetArg(args[n], XtNheight, XNL_HEIGHT);        n++;
    XtSetArg(args[n], XtNresizable, True); n++;

    receiveList = XtCreateManagedWidget("receiveList",
        labelWidgetClass, receiveViewport, args, n);


	if (FINGER_DEMO == False) 
      XtAddCallback(receiveDownloadButton, XtNcallback, receiveDownload, 
        (XtPointer)receiveDownloadButton);
    XtAddCallback(receiveCancelButton, XtNcallback, receiveCancel, 
        (XtPointer)receiveCancelButton);
    XtAddCallback(receiveDepButton, XtNcallback, receiveDep, 
        (XtPointer)receiveDepButton);
    XtAddCallback(receivePathButton, XtNcallback, receivePath, 
        (XtPointer)receivePathButton);
    XtAddCallback(receiveUnsetButton, XtNcallback, unsetAll, 
        (XtPointer)receivePathButton);
    XtAddCallback(receiveSetButton, XtNcallback, setAll, 
        (XtPointer)receivePathButton);

    return 1;
}

Popdown_receive(w)
Widget w;
{

    if (downloadingNow)
        return(0);

	currentDisplayText = NULL;

    XtUnmanageChild(receiveForm);
    XtUnmanageChild(receiveViewport);

	if (inputId != (XtInputId)NULL) {
		XtRemoveInput(inputId);
		inputId = (XtInputId)NULL;
	}

    if (receiveSocket)
        netlib_abort(receiveSocket);
    receiveSocket = (int)NULL;
#ifdef CONFERENCE
    if (nextdescButton)
        grey_the_button(nextdescButton, True);
    else if (descrecvButton)
        grey_the_button(descrecvButton, True);
#endif
    return 1;
}


static void
receiveDownload(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{


    if (downloadingNow)
        return;

    grey_the_button(receiveCancelButton, True);
    grey_the_button(receiveDownloadButton, False);
    set_cursor(CURSOR_BUSY, 0);
    grey_the_bar(False);

    downloadingNow = True;

    if (DownloadList[currentFileNum]) {

        do_receive();

    } else {
        set_status("No Files To Download", YELLOW);
        downloadingNow = False;
        grey_the_button(receiveCancelButton, False);
        grey_the_button(receiveDownloadButton, True);
        set_cursor(CURSOR_NORMAL, 0);
        grey_the_bar(True);

    }
}

static void
receiveCancel(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    if (!downloadingNow)
        return;

    grey_the_button(receiveCancelButton, False);
    grey_the_button(receiveDownloadButton, True);
    set_cursor(CURSOR_NORMAL, 0);
    grey_the_bar(True);

    downloadingNow = False;

    if (inputId != (XtInputId)NULL) {
        XtRemoveInput(inputId);
        inputId = (XtInputId)NULL;
    }

    netlib_abort(receiveSocket);
    receiveSocket = (int)NULL;

    set_status("Download Interrupted by You", RED);
}


static void
receiveDep(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg args[3];

    DEP_CHECK = !DEP_CHECK;

    if (DEP_CHECK) {
        XtSetArg(args[0], XtNlabel, "Dependency Checking: on "); 
    } else {
        XtSetArg(args[0], XtNlabel, "Dependency Checking: off"); 
    }
    XtSetValues(receiveDepButton, args, 1);
}


static void
unsetAll(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
	register int i;

	/* remove everything from download_list */
	for (i=0; DownloadList[i]; i++)
		XtFree(DownloadList[i]);
	
	DownloadList[0] = NULL;

	XawTextInvalidate(receiveList, 0, textSize);
}

static void
setAll(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    register int i, j;
	String s;
	char line[2550];
	Arg args[4];

    XtSetArg(args[0], XtNstring, &s);
    XtGetValues(receiveList, args, 1);

	j=0;
	for (i=0; s[i]; i++) {
		if (s[i] == '\n') {
			line[j] = '\0';
			j=0;
			add_to_download_list(line);
		} else { /* add to line */
			line[j] = s[i]; j++;
		}
	}

    XawTextInvalidate(receiveList, 0, textSize);
}


static void
receivePath(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg     args[5];
    Widget  popup;
    Position    x, y;
    Dimension   width, height;
    register int n;


    n = 0;
    XtSetArg(args[0], XtNwidth, &width); n++;
    XtSetArg(args[1], XtNheight, &height); n++;
    XtGetValues(w, args, n);
    XtTranslateCoords(w, (Position) (width / 2),
            (Position) (height / 2), &x, &y);

    n = 0;
    XtSetArg(args[n], XtNx, x);             n++;
    XtSetArg(args[n], XtNy, y);             n++;
    popup = XtCreatePopupShell("receivePathPopup",
        transientShellWidgetClass, w, args, n);

    n = 0;
    XtSetArg(args[n], XtNlabel, "New download path?");             n++;
    XtSetArg(args[n], XtNvalue, downloadPath);             n++;
    receivePathDialog = XtCreateManagedWidget("receivePathDialog",
        dialogWidgetClass, popup, args, n);

    XawDialogAddButton(receivePathDialog, "ok", receiveDoPath,
        (XtPointer) w);
    XawDialogAddButton(receivePathDialog, "cancel", Destroy_form,
        (XtPointer)receivePathDialog);

    XtPopup(popup, XtGrabExclusive);
}



void
receiveDoPath(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg args[3];
    char line[MAXLINE];
    String path;

    path = XawDialogGetValueString(receivePathDialog);

    sprintf(line, "new download path %s", path);
    set_status(line, GREEN);

    sprintf(line, "download path: %s", path);
    XtSetArg(args[0], XtNlabel, line); 
    XtSetValues(receivePathButton, args, 1);

    XtFree(downloadPath);
    downloadPath = XtNewString(path);

    /* just in case */
    mkdir(downloadPath, DIR_MODE);

    XtDestroyWidget( XtParent(receivePathDialog));
}

