#include <stdio.h>		/*					CS.H	*/
#include "sysdep.h"

#define VMSGS 1
#if VMSGS
#define VMSG(x) if (odebug) x
#else
#define VMSG(x)
#endif

#define	INSTR	1
#define	ENDIN	2
#define	LABEL	3

#define MAXINSNO 200
#define	PMAX	 150
#define VARGMAX  201

#define	ORTXT	   h.optext->t
#define	INCOUNT	   ORTXT.inlist->count
#define	OUTCOUNT   ORTXT.outlist->count
#define	INOCOUNT   ORTXT.inoffs->count
#define	OUTOCOUNT  ORTXT.outoffs->count
#define	XINCODE	   ORTXT.xincod
#define	STRARG	   ORTXT.strarg

#define	MAXLEN	   0x1000000L
#define	PMASK	   0x0FFFFFFL
#define	PFRAC(x)   ((x & ftp->lomask) * ftp->lodiv)
#define MAXPOS     0x7FFFFFFFL

#define BYTREVS(n) (n>>8  & 0xFF | n<<8 & 0xFF00)
#define BYTREVL(n) (n>>24 & 0xFF | n>>8 & 0xFF00L | n<<8 & 0xFF0000L | n<<24 & 0xFF000000L)

#define NOCTS      20
#define OCTRES     8192
#define RESMASK    8191L
#define RESHIFT    13
#define CPSOCTL(n) cpsocint[n >> RESHIFT] * cpsocfrc[n & RESMASK]

#define LOBITS     10
#define LOFACT     1024
#define LOMASK     1023

#define SSTRCOD    0xFFFFFL
#define SSTRSIZ    200
#define ALLCHNLS   5
#define DFLT_SR    10000.
#define DFLT_KR    1000.
#define DFLT_KSMPS 10
#define DFLT_NCHNLS 1

typedef	struct {
	int	odebug, initonly;
	int	sfread, sfwrite, sfheader, filetyp;
	int	inbufsamps, outbufsamps;
	int	informat, outformat;
	int	insampsiz, outsampsiz;
	int	displays, graphsoff, msglevel;
	int	Beatmode, cmdTempo, oMaxLag;
	int	usingcscore, Linein, Midiin, FMidiin;
	int	RTevents, ksensing, SusPThresh;
	int	ringbell, termifend, stdoutfd;
	int	rewrt_hdr, heartbeat;
	long	sr_override, kr_override;
	long	instxtcount, optxtsize;
	long	poolcount, gblfixed, gblacount;
	long	argoffsize, strargsize, filnamsize;
	char	*argoffspace, *strargspace, *filnamspace;
	char	*infilename, *outfilename, *playscore;
	char	*Linename, *Midiname, *FMidiname;
} OPARMS;

typedef struct polish {
	char	opcod[12];
	short	incount;
	char	arg[4][12];
} POLISH;

typedef struct arglst {
	short	count;
	char	*arg[1];
} ARGLST;

typedef struct argoffs {
	short	count;
	short	indx[1];
} ARGOFFS;

typedef struct text {
	short	linenum;
	short	opnum;
	char	*opcod;
	char	*strarg;
	ARGLST	*inlist;
	ARGLST	*outlist;
	ARGOFFS	*inoffs;
	ARGOFFS	*outoffs;
	short	xincod;
	char	intype;
	char	pftype;
} TEXT;	
	
typedef struct instr {
	struct op * nxtop;
	TEXT	t;
	short	pmax, pextrab;
	short	lclkcnt, lcldcnt;
	short	lclwcnt, lclacnt;
	short	lclfixed, optxtcount;
	long	localen;
	long	opdstot;
	struct insds * instance;
	struct instr * nxtinstxt;
} INSTRTXT;

typedef struct op {
	struct op * nxtop;
	TEXT	t;
} OPTXT;

typedef struct fdch {
	struct fdch * nxtchp;
        int    fd;
} FDCH;

typedef struct auxch {
	struct auxch * nxtchp;
	long   size;
        char   *auxp, *endp;
} AUXCH;

typedef struct mchnblk {
	short  Omni;
	short  Poly;
        short  bas_chnl;
	short  nchnls;
	short  pgmno;
	short  RegParNo;
	struct insds *kinsptr[128];
	struct insds *ksusptr[128];
	float  katouch[128];
	short  ctl_byt[128];
	float  ctl_val[128];
	short  ksuscnt;
	short  sustaining;
	float  chnpress;
	float  pchbend;
	float  pbensens;
	float  pbendiff;  /* displ in semitones */
	float  finetune;
	float  crsetune;
	float  tuning;    /* displ in semitones */
} MCHNBLK;

typedef struct insds {
	struct opds * nxti;
	struct opds * nxtp;
	struct insds * nxtinstance;
	struct insds * prvinstance;
	struct insds * nxtact;
	struct insds * prvact;
	struct insds * nxtoff;
	FDCH	fdch;
	AUXCH	auxch;
	MCHNBLK *m_chnbp;
	short	m_pitch;
	short	m_veloc;
	short   xtratim;
	short   relesing;
	short	insno;
	short	actflg;
	float	offbet;
	float	offtim;
	float	p0;
	float	p1;
	float	p2;
	float	p3;
} INSDS;

#ifdef __STDC__
typedef	void	(*SUBR)(void *);
#else
typedef	void	(*SUBR)();
#endif

typedef struct opds {
	struct opds * nxti;
	struct opds * nxtp;
	SUBR	iopadr;
	SUBR	opadr;
	OPTXT   *optext;
	INSDS   *insdshead;
} OPDS;
	
typedef struct lblblk {
	OPDS	h;
	OPDS	*prvi;
	OPDS	*prvp;
} LBLBLK;

typedef struct oentry { 
	char	*opname;
	unsigned short	dsblksiz;
	unsigned short	thread;
	char	*outypes;
	char	*intypes;
	SUBR	iopadr;
	SUBR	kopadr;
	SUBR	aopadr;
} OENTRY;

typedef struct {
	float   *begp, *curp, *endp, feedback[6];
	long    scount;
} OCTDAT;

#define MAXOCTS 8

typedef struct {
	long	npts, nocts, nsamps;
	float   lofrq, hifrq, looct, srate;
	OCTDAT  octdata[MAXOCTS];
	AUXCH	auxch;
} DOWNDAT;

typedef struct {
	long	ktimstamp, ktimprd;
	long	npts, nfreqs, dbout;
	DOWNDAT *downsrcp;
	AUXCH	auxch;
} SPECDAT;

typedef struct {
	float	natcps;
	float	gainfac;
	short	loopmode1;
	short	loopmode2;
	long	begin1, end1;
	long	begin2, end2;
} AIFFDAT;

typedef struct {
	long	flen;
	long	lenmask;
	long	lobits;
	long	lomask;
	float	lodiv;
	float	cvtbas, cpscvt;
	float	gainfac;   /* currently used only by gen01 & loscil */
	short	loopmode1;
	short	loopmode2;
	long	begin1, end1;       /* all these in ..  */
	long	begin2, end2;
	long	nframes;            /* .. sample frames */
	long    nchnls;
	float	ftable[1];
} FUNC;

typedef struct {
	char	filename[64];
	char	*beginp;
	char	*endp;
	long	length;
} MEMFIL;

typedef struct event {
	char	*strarg;
	char	opcod;
	short	pcnt;
	float	p2orig;
	float	p3orig;
	float	offtim;
	float	p[PMAX+1];
} EVTBLK;

typedef	struct {
	OPDS	h;
	float	*ktempo, *istartempo;
	float	prvtempo;
} TEMPO;

FUNC   *ftfind();
MEMFIL *ldmemfile();

#include "prototyp.h"

