#! /bin/sh
# expects style files to be just two bars repeated
# expects fills files to be 1 bar - 1 bar - 1 bar - 2 bars
if [ "$2" = "" -o "$3" != "" ]; then
	echo "Usage: $0 file-type style-num"
	echo "recognized file types are: style & fills"
	exit 2
fi
TYPE=$1
STYLE=$2
chmap <$TYPE$STYLE 2=2,16 >x
echo -n "Copy files over from yquem? "; read junk
if [ "$junk" = "y" ]; then
	COPY="rcp yquem:/tmp/$TYPE$STYLE.dp ."
	echo "After the Ready prompt '$COPY' will be executed"
else
	COPY=""
	echo "Okay; no files will be copied from yquem."
fi
if [ "$TYPE" = "style" ]; then
	LIST="-f0~-l2"
elif [ "$TYPE" = "fills" ]; then
	LIST="-f0~-l1 -f1~-l2 -f2~-l3 -f3~-l5"
else
	LIST="-f0"
fi
for ARGS in $LIST; do
	ARGS=`echo $ARGS | tr "~" " "`
	echo "$TYPE$STYLE $ARGS" >x1
	bars -c $ARGS <x >xx
	set HHC A2 CYM D3 TOM C2 SD E2 BD A1
	while [ "$1" != "" ] ; do
	    echo "$1" >>x1
	    shift
	    just -q96 <xx | da | grep "$1 key on" >>x1
	    shift
	done
	more x1
	echo -n "Ready? "; read junk
	$COPY
	mpp -s0-9 <$TYPE$STYLE.dp | dp2mpu | bars $ARGS >z
	play z "|mpuclean <xx"
done
if [ "$TYPE" = "fills" ]; then
	echo "The whole thing"
	mpp -s0-9 <$TYPE$STYLE.dp | dp2mpu >z
	play z x
fi
