#include <stdio.h>
#define u_short unsigned short
#define u_char unsigned char
#include <libmidi.h>
#include <libdx7.h>
#define out(n) if (midi_out(f, n)==EOF) return MidiError("midi_bd"), -1

/*
** Send system exclusive bulk data to dx7.
** Use this to transmit voice/parameter settings, for example.
** Return '-1' on errors (EOF on transmitted command, checksum error)
** '0' otherwise. 
** See also Yamaha dx7 midi data format documentation.
*/
send_dx7_bd(f, fmt, chan, size, data)
int f;			/* where to write output */
u_char	fmt;		/* DX7_SXF_1V or DX7_SXF_32V */
u_char	chan;		/* midi channel */
u_short	size; 		/* size of data array in bytes (156 or 4960) */
u_char	*data;		/* system exclusive voice or function parameter data */
{
	register u_short i, cksum = 0;

	if (fmt == DX7_SXF_1V || fmt == DX7_SXF_32V) {
		out(SX_CMD);
		out(ID_DX7);
		out(DX7_SXSS_BD << 4 | (chan & M_CHAN_MASK));
		out(fmt & M_VAL_MASK);
		out((size >> 7) & M_VAL_MASK);	/* bits 7 - 13 of size */
		out(size & M_VAL_MASK);		/* bits 0 - 6 of size */
		for (i=0; i<size; i++) out(cksum += data[i] & M_VAL_MASK);
		out(-cksum & M_VAL_MASK);
		return 0;
	} else
		return MidiError("midi_bd: invalid format=%x\n", fmt), -1;
}
