/****************************************************************/
/*  dsputil.h							*/
/* DSP utility functions for Csound - dispfft and pvoc		*/
/* Header file - just declarations				*/
/* 20apr90 dpwe							*/
/****************************************************************/

#define     SPTS    (16)    /* SINC TABLE: How many points in each lobe */
#define     SPDS    (6)     /*	 (was 8)   How many sinc lobes to go out */
#define     SBW     0.9     /* To compensate for short sinc, reduce bandw */

#ifndef PI
#ifdef M_PI
#define PI M_PI
#else
#define PI	3.14159265358979323846
#endif
#endif

#ifndef NULL
#define NULL 0L
#endif

/*** yukki ansi bodge ***/
#ifndef FLOATARG
#ifdef __STDC__
#define FLOATARG double		/* you can't have floats in prototypes! */
#else
#define FLOATARG double
#endif /* def __STDC__ */
#endif /* ndef FLOATARG */

/* Predeclare static supporting functions */

#ifdef __STDC__

void CopySamps(float *, float *, long);
float *MakeBuf(long);
void FillHalfWin(float *, long, FLOATARG, int);
float *MakeHalfWin(long, FLOATARG, int);
void UnpackReals(float *, long);
void PackReals(float *, long);
void Rect2Polar(float *, long);
void Polar2Rect(float *, long);
void Lin2DB(float *, long);
void DB2Lin(float *, long);
float maskPhs(FLOATARG);
void UnwrapPhase(float *, long, float *);
void RewrapPhase(float *, long, float *);
void PhaseToFrq(float *, long, FLOATARG, FLOATARG);
void FrqToPhase(float *, long, FLOATARG, FLOATARG, FLOATARG);
void FetchIn(float *, float *, long, FLOATARG);
void FillFFTnConj(float *, long, FLOATARG, int);
void ApplyHalfWin(float *, float *, long);
void addToCircBuf(float *, float *, long, long, long);
void writeClrFromCircBuf(float *, float *, long, long, long);
void FixAndAdd(float *, short *, long);
long NumFrames(long, long, long);
long NumSampls(long, long, long);
void FloatAndCopy(short *, float *, long);
void WriteOut(float *, float **, long);
void UDSample(float *, FLOATARG, float *, long, long, FLOATARG);
void MakeSinc(void);
void DestroySinc(void);	  /* relase the lookup table */
float SincIntp(FLOATARG); /* return interpolated sinc - not used */
void PreWarpSpec(float *, long, FLOATARG);

#else

void CopySamps();
float *MakeBuf();
float *MakeHalfWin();
void FillHalfWin();
void UnpackReals();
void PackReals();
void Rect2Polar();
void Polar2Rect();
float maskPhs();
void UnwrapPhase();
void RewrapPhase();
void PhaseToFrq();
void FrqToPhase();
void FetchIn();
void FillFFTnConj();
void ApplyHalfWin();
void addToCircBuf();
void writeClrFromCircBuf();
void FixAndAdd();
long NumFrames();
long NumSampls();
void FloatAndCopy();
void WriteOut();
void UDSample();
void MakeSinc();
void DestroySinc();	  /* relase the lookup table */
float SincIntp(); /* return interpolated sinc - not used */
void PreWarpSpec();

#endif
