.TH PVANAL 1Csound "7 Feb 1991"
.SH NAME
pvanal - Fourier analysis module for Csound PVOC unit generator
.SH SYNTAX
\fBpvanal 
[flags]
\fIinputSoundFile\fB
\fIoutputFFTFile\fB
\fR
.SH DESCRIPTION
.I pvanal
converts an input audio file (time-domain) into a series of short-time
Fourier transform (STFT) frames at regular points throughout the file
(a frequency-domain representation).  The output file can be used by
.I pvoc
to generate audio fragments based on the original sample, with timescales
and pitches arbitrarily and dynamically modified.
Analysis is conditioned by the flags below.  A space is optional between
the flag and it argument.
.TP 13
-n<frmsiz>
STFT frame size, the number of samples in each fourier analysis frame.
Must be a power of two, in the range 16 to 16384.  For clean results,
a frame must be larger than the longest pitch period of the sample.
However, very long frames result in temporal 'smearing' or reverberation.
The bandwidth of each STFT bin is determined by sampling rate / frame size.
The default framsize is the smallest power of two that corresponds to more 
than 20 milliseconds of the source (e.g. 256 points at 10 kHz sampling,
giving a 25.6 ms frame). 
.TP 13
-w<windfact>
Window overlap factor.  This controls the number of Fourier transform
frames per second.  Csound's PVOC will interpolate between frames, but too 
few frames will generate audible distortion; too many frames will result 
in a huge analysis file.  A good compromise for windfact is 4, meaning that
each input point occurs in 4 output windows, or conversely that the offset
between successive STFT frames is framesize/4.  The default value is 4.
Do not use with 
.B -h.
.TP 13
-h<hopsize>
STFT frame offset.  Converse of above, specifying the increment in samples
between successive frames of analysis (see also lpcanal).  Do not use with 
.B \-w.
.SH EXAMPLE
pvanal asound.irc pvfile
.sp
This will analyze the playable sound 
.I asound.irc
using the default \fIfrmsiz\fR and \fIwindfact\fR to produce the file 
.I pvfile 
suitable for use with
.B pvoc.
.SH FILES
The output file has a special
.B pvoc
header containing details of the source audio file, the analysis frame rate
and overlap.  Frames of analysis data are stored as 
.I float, 
with the magnitude and `frequency' (in Hz) for the first N/2 + 1 Fourier bins
of each frame in turn.  `Frequency' encodes the phase increment in such a way
that for strong harmonics it will give a good indication of the true frequency.  
For low amplitude or rapidly moving harmonics, it is less meaningful.
.SH DIAGNOSTICS
Prints number of frames to process, and total frames completed on every 20th.
See also
.I The Csound Reference Manual
.SH AUTHOR
Dan Ellis, 
.B dpwe@media.mit.edu
