#include	"cs.h"                            /*                WAVE.C   */
#include	"soundio.h"
#include	"wave.h"
#include	"sfheader.h"
#include	<math.h>

#ifndef TRUE
#define TRUE    1
#define FALSE   0
#endif

static struct wav_head formhdr;
static long   framesize;

static short lenshort(sval) /* coerce a natural short into a littlendian short */
  register short sval;
{
    char  benchar[2];
    register char *p = benchar;

    *p++ = 0xFF & sval;
    *p   = 0xFF & (sval >> 8);
    return(*(short *)benchar);
}

static long lenlong(lval)     /* coerce a natural long into a littlendian long */
  register long lval;
{
    char  benchar[4];
    register char *p = benchar;

    *p++ = 0xFF & lval;
    *p++ = 0xFF & (lval >> 8);
    *p++ = 0xFF & (lval >> 16);
    *p   = 0xFF & (lval >> 24);
    return(*(long *)benchar);
}

static short natlshort(sval) /* coerce a littlendian short into a natural short */
  short sval;
{
    unsigned char benchar[2];
    register short natshort;

    *(short *)benchar = sval;
    natshort = benchar[1];
    natshort <<= 8;
    natshort |= benchar[0];
    return(natshort);
}

static long natllong(lval)     /* coerce a littlendian long into a natural long */
  long lval;
{
    unsigned char benchar[4];
    register unsigned char *p = benchar + 3;
    register long natlong;

    *(long *)benchar = lval;
    natlong = *p--;
    natlong <<= 8;
    natlong |= *p--;
    natlong <<= 8;
    natlong |= *p--;
    natlong <<= 8;
    natlong |= *p;
    return(natlong);
}

void wavWriteHdr(fd,sampsize,nchls,sr)/* Write WAV header at start of file.  */
  int fd;               	     /* Called after open, before data writes*/
  int sampsize;			/* sample size in bytes */
  int nchls;
  double sr;			/* sampling rate */
{
	long databytes;
#if DEBUG
	printf("wavWriteHdr: fd %d sampsize %d nchls %d sr %lf\n",
		fd,sampsize,nchls,sr);
#endif
	framesize = sampsize * nchls;
	databytes = 0;		/* reset later by wavReWriteHdr */

	formhdr.magic = *((long *)RIFF_ID);
	formhdr.len0 = lenlong(databytes + WAVHDRSIZ);    /* or 8+16+12 ??? */
	formhdr.magic1 = *((long *)WAVE_ID);
	formhdr.magic2 = *((long *)FMT_ID);
	formhdr.len = lenlong((long)16);        /* ??? what's this ??? */
	formhdr.format = lenshort((short)1);    /* PCM */
	formhdr.nchns = lenshort((short)nchls);
	formhdr.rate = lenlong((long)sr);
	formhdr.aver = lenlong((long)(sr * framesize));
	formhdr.nBlockAlign = lenshort((short)framesize);  /* ??? */
	formhdr.size = lenshort((short)(8 * sampsize));
	formhdr.magic3 = *((long *)DATA_ID);
	formhdr.datasize = lenlong(databytes);

	if (write(fd, (char *)&formhdr, sizeof(formhdr)) != sizeof(formhdr))
	    die("error writing WAV header");
}

void wavReWriteHdr(fd, datasize)  /* Write proper sizes into WAV header  */
  int  fd;                        /*        called before closing file   */
  long datasize;                  /*        & optionally under -R        */
{
	long  endpos = tell(fd);

	if (endpos != datasize + WAVHDRSIZ)
	    die("inconsistent WAV size");
	formhdr.len0 = lenlong(endpos);
	formhdr.datasize = lenlong(datasize);
	if ((lseek(fd, 0L, 0)))
	    die("seek error rewriting WAV header");
	if (write(fd, (char *)&formhdr, sizeof(formhdr)) != sizeof(formhdr))
	    die("error rewriting WAV header");
	lseek(fd, endpos, 0);
}

int is_wav_form(firstlong)    /* test a long for wav form ID                 */
  long firstlong;             /* called by readheader prior to wavReadHeader */
{
        return (firstlong == *(long *)RIFF_ID);
}

void wavReadHeader(fd,fname,hdr,firstlong,p) /* Read WAV header, fill hdr, & */
  int fd;             			    /* postn rd ptr to start of samps*/
  char *fname;
  HEADATA *hdr;	/* datablock for passing data back */
  long firstlong;
  SOUNDIN *p;
{
        struct wav_head form;

	p->filetyp = 0;                 /* ensure no bytrev on sreadin here */
	if (!is_wav_form(firstlong))    /* double check it's a form header */
	    die("bad form for wavReadHeader");         /* & read remainder */
	sreadin(fd,(char *)&form + sizeof(long),sizeof(form) - sizeof(long),p);
	if (form.magic1 != *(long *) WAVE_ID) {
	    fprintf(stderr, "Got form.magic = %lx\n", form.magic);
	    die("form header not type wav");
	}
	hdr->sr = natllong(form.rate);
	hdr->nchnls = natlshort(form.nchns);
	hdr->sampsize = (natlshort(form.size)) / 8;
	hdr->format = (hdr->sampsize == 2 ? AE_SHORT :
		       hdr->sampsize == 1 ? AE_CHAR :
		       AE_LONG);
	hdr->hdrsize = sizeof(form);
	hdr->filetyp = TYP_WAV;
	hdr->aiffdata = NULL;
	hdr->audsize = natllong(form.datasize);
	hdr->readlong = FALSE;
	hdr->firstlong = 0;
}
