;****************************************************************
;**           :
;** Project   : Personal Logic Debugger (PLD)
;** Filename  : RESET.ASM
;** Author    : Don Lekei
;** Status    : Experimental
;** Date      : 08/27/93
;** Purpose   : Reset the system on power-up or failure
;**           :
;****************************************************************
;
;*** Reset Vector ********************************************************
;On a 16C7X / 8X this segment has 4 words

        .seg    RESET           ;
RESVEC::                        ;("::" forces "code" label for simulator)
	btfss	PD		;skip if new battery
	goto	WAKEUP		;good morning! ON/CLR key pressed!
        goto    INIT            ;New power... INIT

;*************************************************************************
; we have a spare byte so this might as well go here:

CALLW:  movwf	PCL		;for call indirect to table. PCH never changes.

;*************************************************************************

	.seg	CODE		;the rest is in regular code area

;*************************************************************************
;** INIT
;** Hardware reset entry point
;**
;*************************************************************************
INIT::                          ;power-on entry
WAKEUP:
        movlw   PAINIT
        movwf   PORTA
        movlw   TAINIT          ;init ports
        tris    PORTA

        movlw   PBINIT
        movwf   PORTB
        movlw   TBINIT
        tris    PORTB

	;REGBASE = FIRST register to clear

REGEND	= $2F		;LAST register to clear (ie. normally $2F)

        movlw   REGBASE+1	;initial register to clear (saves 1 for scratch)
        movwf   FSR             ;point to first reg
	movlw	REGEND-REGBASE	;number to clear (less 1 for regbase)
	movwf	REGBASE		;byte counter
..loop:
        clrf    ind             ;clear next reg
        incf    FSR             ;next address
	decfsz	REGBASE		;exits with REGBASE = 0 too!
        goto ..loop

	movlw	AD0INIT		;default ADCON0 register
	movwf	ADCON0		;A/D Control Register

	movlw	>DATABASE	;PC high for data tables (PC modify instr's)
	movwf	PCLATH		;PC high latch - THIS STAYS A CONSTANT!

	movlw	INTINIT		;default ADCON0 register
	movwf	INTCON   	;interrupt control register

        movlw   OPTINIT		;default OPTION register 
        OPTION			;
	movlw	ADCON1		;get address of ADCON1
	movwf	FSR		;point fsr (work-around simulator bug)

	movlw	AD1INIT		;default ADCON1 register 2 bits
	movwf	(ind)		;A/D Control Register
		     
	SEB	B.RA5ON		;set scale low to start
	call	LCD_RESET	;reset LCD routines

	seb	GIE		;enable interrupts
;	seb	GO		;start A/D
	goto	MAIN_START	;start main idle loop
	

