/*
 * Decompiled with CFR 0.152.
 */
import bsh.TargetError;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Description {
    protected String text;
    protected long comparand;
    protected long mask;
    protected List conditions;

    public Object clone() {
        Description nueva = new Description(this.text, this.comparand, this.mask);
        ArrayList<ObjectCode> nuevasCondiciones = new ArrayList<ObjectCode>();
        if (this.conditions != null) {
            int i = 0;
            while (i < this.conditions.size()) {
                nuevasCondiciones.add(((ObjectCode)this.conditions.get(i)).cloneIfNecessary());
                ++i;
            }
        }
        nueva.conditions = nuevasCondiciones;
        return nueva;
    }

    public Description(String ntext, long ncomparand, long nmask) {
        this.text = ntext;
        this.comparand = ncomparand;
        this.mask = nmask;
    }

    public boolean matches(long state) {
        return (this.mask & (state ^ this.comparand)) == 0L;
    }

    public boolean matchesConditions(Entity context, Entity viewer) {
        if (viewer == null) {
            return this.matchesConditions(context);
        }
        long comparand = (long)((Mobile)viewer).getRelationshipState(context) * (long)Math.pow(2.0, 32.0) + (long)context.getState();
        if (!this.matches(comparand)) {
            return false;
        }
        if (this.conditions == null) {
            return true;
        }
        int i = 0;
        while (i < this.conditions.size()) {
            block7: {
                ReturnValue rv = new ReturnValue(null);
                try {
                    ((ObjectCode)this.conditions.get(i)).run(null, context, null, rv, new Object[][]{{"viewer", viewer}});
                }
                catch (TargetError te) {
                    te.printStackTrace();
                    break block7;
                }
                if (rv.getRetVal() instanceof Boolean && !((Boolean)rv.getRetVal()).booleanValue()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean matchesConditions(Entity context) {
        if (!this.matches(context.getState())) {
            return false;
        }
        if (this.conditions == null) {
            return true;
        }
        int i = 0;
        while (i < this.conditions.size()) {
            block6: {
                ReturnValue rv = new ReturnValue(null);
                try {
                    Object[][] objectArray = new Object[1][];
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "viewer";
                    objectArray[0] = objectArray2;
                    ((ObjectCode)this.conditions.get(i)).run(null, context, null, rv, objectArray);
                }
                catch (TargetError te) {
                    te.printStackTrace();
                    break block6;
                }
                if (rv.getRetVal() instanceof Boolean && !((Boolean)rv.getRetVal()).booleanValue()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public String getText() {
        return this.text;
    }

    public Node getXMLRepresentation(Document doc) {
        Element suElemento = doc.createElement("Description");
        Text t = doc.createTextNode(this.text);
        suElemento.appendChild(t);
        suElemento.setAttribute("stateComparand", String.valueOf(this.comparand));
        suElemento.setAttribute("stateMask", String.valueOf(this.mask));
        if (this.conditions != null) {
            int i = 0;
            while (i < this.conditions.size()) {
                ObjectCode oc = (ObjectCode)this.conditions.get(i);
                Element el = (Element)oc.getXMLRepresentation(doc, "Condition");
                suElemento.appendChild(el);
                ++i;
            }
        }
        return suElemento;
    }

    public Description(World w, Node n) throws XMLtoWorldException {
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Description node not element");
        }
        Element e = (Element)n;
        long comparand = 0L;
        long mask = 0L;
        try {
            if (e.hasAttribute("stateComparand")) {
                comparand = Long.valueOf(e.getAttribute("stateComparand"));
            }
            if (e.hasAttribute("stateMask")) {
                mask = Long.valueOf(e.getAttribute("stateMask"));
            }
        }
        catch (NumberFormatException nfe) {
            throw new XMLtoWorldException("Bad number format at attribute stateComparand or stateMask");
        }
        boolean terminamos = false;
        while (!terminamos) {
            try {
                Node hijo = n.getFirstChild();
                while (!(hijo instanceof Text) || hijo.getNodeValue().trim().length() == 0) {
                    if (hijo == null) break;
                    hijo = hijo.getNextSibling();
                }
                Text t = (Text)hijo;
                if (t == null) {
                    throw new XMLtoWorldException("Description node containing no text node");
                }
                this.comparand = comparand;
                this.mask = mask;
                this.text = t.getData().trim();
                this.text = StringMethods.textualSubstitution(this.text, "\\n", "\n");
                terminamos = true;
            }
            catch (ClassCastException hijo) {
                // empty catch block
            }
        }
        NodeList nl = e.getElementsByTagName("Condition");
        int i = 0;
        while (i < nl.getLength()) {
            ObjectCode oc = new ObjectCode(w, (Element)nl.item(i));
            if (this.conditions == null) {
                this.conditions = new ArrayList();
            }
            this.conditions.add(oc);
            ++i;
        }
    }
}

