/*
 * Decompiled with CFR 0.152.
 */
import bsh.TargetError;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Entity {
    List propertiesList = new ArrayList();
    protected Vector relationships = new Vector();
    protected Vector relationship_properties = new Vector();
    private List pushToFront = new ArrayList();

    public void copyEntityFields(Entity e) {
        this.propertiesList = new ArrayList(e.propertiesList.size());
        int i = 0;
        while (i < e.propertiesList.size()) {
            this.propertiesList.add(((PropertyEntry)e.propertiesList.get(i)).clone());
            ++i;
        }
        this.relationships = new Vector(e.relationships.size());
        i = 0;
        while (i < e.relationships.size()) {
            this.relationships.add((Entity)e.relationships.get(i));
            ++i;
        }
        this.relationship_properties = new Vector(e.relationship_properties.size());
        i = 0;
        while (i < e.relationship_properties.size()) {
            ArrayList<Object> ofProperties = new ArrayList<Object>(((List)e.relationship_properties.get(i)).size());
            this.relationship_properties.add(ofProperties);
            int j = 0;
            while (j < ofProperties.size()) {
                ofProperties.add(((PropertyEntry)((List)e.relationship_properties.get(i)).get(j)).clone());
                ++j;
            }
            ++i;
        }
    }

    public boolean update(World mundo) {
        if (this.pushToFront.size() > 0) {
            this.pushRequestedPropertiesToFront();
        }
        int i = 0;
        while (i < this.propertiesList.size()) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            pe.decreaseTime();
            if (pe.needsUpdate()) {
                this.update(pe, mundo);
            }
            ++i;
        }
        i = 0;
        while (i < this.relationships.size()) {
            Entity ent = (Entity)this.relationships.get(i);
            List propertyEntries = (List)this.relationship_properties.get(i);
            int j = 0;
            while (j < propertyEntries.size()) {
                PropertyEntry entrada = (PropertyEntry)propertyEntries.get(j);
                entrada.decreaseTime();
                if (entrada.needsUpdate()) {
                    this.updateRelationship(ent, entrada, mundo);
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean update(PropertyEntry pe, World mundo) {
        if (pe.getTimeLeft() < -2L) {
            return false;
        }
        boolean ejecutado = false;
        if (this instanceof SupportingCode) {
            SupportingCode esto = (SupportingCode)((Object)this);
            try {
                ejecutado = esto.execCode("update", new Object[]{pe, mundo});
            }
            catch (TargetError bshte) {
                mundo.escribir(mundo.getIO().getColorCode("error"));
                mundo.escribir("bsh.TargetError found at update routine, entity is " + this + ", property entry is " + pe.getName() + "\n");
                mundo.escribir("Target exception: " + bshte.printTargetError(bshte.getTarget()) + "\n");
                mundo.escribir(mundo.getIO().getColorCode("reset"));
                bshte.printStackTrace();
            }
            if (ejecutado) {
                return true;
            }
        }
        try {
            ejecutado = mundo.execCode("update", new Object[]{pe, this});
        }
        catch (TargetError bshte) {
            mundo.escribir("bsh.TargetError found at world's update routine, property entry is " + pe.getName());
            bshte.printStackTrace();
        }
        if (ejecutado) {
            return true;
        }
        if (pe.getName().equalsIgnoreCase("state")) {
            this.changeState(mundo);
        }
        return true;
    }

    public boolean updateRelationship(Entity e, PropertyEntry pe, World mundo) {
        return true;
    }

    public List getProperties() {
        return this.propertiesList;
    }

    public String getPropertyValue(String propertyName) {
        int i = 0;
        while (i < this.propertiesList.size()) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (pe.getName().equalsIgnoreCase(propertyName)) {
                return pe.getValue();
            }
            ++i;
        }
        return null;
    }

    public String getPropertyValueAsString(String propertyName) {
        return this.getPropertyValue(propertyName);
    }

    public void pushPropertyToFront(String propertyName) {
        this.pushToFront.add(propertyName);
    }

    private void pushRequestedPropertiesToFront() {
        int i = 0;
        while (i < this.pushToFront.size()) {
            this.pushPropertyToFrontReally((String)this.pushToFront.get(i));
            ++i;
        }
        this.pushToFront = new ArrayList();
    }

    private void pushPropertyToFrontReally(String propertyName) {
        int i = 0;
        while (i < this.propertiesList.size()) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (pe.getName().equalsIgnoreCase(propertyName)) {
                this.propertiesList.remove(pe);
                this.propertiesList.add(0, pe);
            }
            ++i;
        }
    }

    public Object getPropertyValueAsObject(String propertyName) {
        int i = 0;
        while (i < this.propertiesList.size()) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (pe.getName().equalsIgnoreCase(propertyName)) {
                return pe.getValueAsObject();
            }
            ++i;
        }
        return null;
    }

    public boolean getPropertyValueAsBoolean(String propertyName) {
        int i = 0;
        while (i < this.propertiesList.size()) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (pe.getName().equalsIgnoreCase(propertyName)) {
                return pe.getValueAsBoolean();
            }
            ++i;
        }
        return false;
    }

    public int getPropertyValueAsInteger(String propertyName) {
        int i = 0;
        while (i < this.propertiesList.size()) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (pe.getName().equalsIgnoreCase(propertyName)) {
                return pe.getValueAsInteger();
            }
            ++i;
        }
        return 0;
    }

    public double getPropertyValueAsDouble(String propertyName) {
        int i = 0;
        while (i < this.propertiesList.size()) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (pe.getName().equalsIgnoreCase(propertyName)) {
                return pe.getValueAsDouble();
            }
            ++i;
        }
        return 0.0;
    }

    public float getPropertyValueAsFloat(String propertyName) {
        int i = 0;
        while (i < this.propertiesList.size()) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (pe.getName().equalsIgnoreCase(propertyName)) {
                return pe.getValueAsFloat();
            }
            ++i;
        }
        return 0.0f;
    }

    public long getPropertyTimeLeft(String propertyName) {
        int i = 0;
        while (i < this.propertiesList.size()) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (pe.getName().equalsIgnoreCase(propertyName)) {
                return pe.getTimeLeft();
            }
            ++i;
        }
        return 0L;
    }

    public void setPropertyTimeLeft(String propertyName, long newTime) {
        int i = 0;
        while (i < this.propertiesList.size()) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (pe.getName().equalsIgnoreCase(propertyName)) {
                pe.setTime(newTime);
            }
            ++i;
        }
    }

    public PropertyEntry getPropertyEntry(String propertyName) {
        int i = 0;
        while (i < this.propertiesList.size()) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (pe.getName().equalsIgnoreCase(propertyName)) {
                return pe;
            }
            ++i;
        }
        return null;
    }

    public void setProperty(String propertyName, String propertyValue) {
        int i = 0;
        while (i < this.propertiesList.size()) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (pe.getName().equalsIgnoreCase(propertyName)) {
                pe.setValue(propertyValue);
                return;
            }
            ++i;
        }
        this.propertiesList.add(new PropertyEntry(propertyName, propertyValue, 0L));
    }

    public void setProperty(String propertyName, Object propertyValue) {
        int i = 0;
        while (i < this.propertiesList.size()) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (pe.getName().equalsIgnoreCase(propertyName)) {
                pe.setValue(propertyValue.toString());
                pe.setObjectValue(propertyValue);
                return;
            }
            ++i;
        }
        PropertyEntry pe = new PropertyEntry(propertyName, propertyValue.toString(), 0L);
        pe.setObjectValue(propertyValue);
        this.propertiesList.add(pe);
    }

    public void setProperty(String propertyName, int propertyValue) {
        this.setProperty(propertyName, String.valueOf(propertyValue));
    }

    public void setProperty(String propertyName, double propertyValue) {
        this.setProperty(propertyName, String.valueOf(propertyValue));
    }

    public void setProperty(String propertyName, float propertyValue) {
        this.setProperty(propertyName, String.valueOf(propertyValue));
    }

    public void setProperty(String propertyName, boolean propertyValue) {
        this.setProperty(propertyName, String.valueOf(propertyValue));
    }

    public void setProperty(String propertyName, String propertyValue, long timeLeft) {
        int i = 0;
        while (i < this.propertiesList.size()) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (pe.getName().equalsIgnoreCase(propertyName)) {
                pe.setValueAndTime(propertyValue, timeLeft);
                return;
            }
            ++i;
        }
        this.propertiesList.add(new PropertyEntry(propertyName, propertyValue, timeLeft));
    }

    public void setProperty(String propertyName, int propertyValue, long timeLeft) {
        this.setProperty(propertyName, String.valueOf(propertyValue), timeLeft);
    }

    public void setProperty(String propertyName, boolean propertyValue, long timeLeft) {
        this.setProperty(propertyName, String.valueOf(propertyValue), timeLeft);
    }

    public boolean hasBooleanProperty(String propertyName) {
        return this.getPropertyValueAsBoolean(propertyName);
    }

    public int matchesCommand(String commandArgs, boolean pluralOrSingular) {
        return 0;
    }

    public void setNewTarget(int ntarget) {
        this.setProperty("target", ntarget);
    }

    public int getTarget() {
        return this.getPropertyValueAsInteger("target");
    }

    public void setNewState(int nstate, long TUs) {
        if (this.getPropertyValueAsInteger("state") == 16) {
            System.out.println("setNewState: ");
            new Exception().printStackTrace();
        }
        this.setProperty("state", nstate, TUs);
    }

    protected void setNewState(int nstate) {
        this.setProperty("state", nstate);
    }

    public int getState() {
        return this.getPropertyValueAsInteger("state");
    }

    public abstract void changeState(World var1);

    public boolean stateMatches(int comparand, int mask) {
        return (mask & (this.getPropertyValueAsInteger("state") ^ comparand)) == 0;
    }

    public Node getPropListXMLRepresentation(Document doc) {
        Element e = doc.createElement("PropertyList");
        int i = 0;
        while (i < this.propertiesList.size()) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            Node nodoProp = pe.getXMLRepresentation(doc);
            e.appendChild(nodoProp);
            ++i;
        }
        return e;
    }

    public void readPropListFromXML(World mundo, Node n) throws XMLtoWorldException {
        Element e = null;
        try {
            e = (Element)n;
        }
        catch (ClassCastException cce) {
            throw new XMLtoWorldException("Entity node not Element");
        }
        NodeList nl = e.getElementsByTagName("PropertyList");
        if (nl.getLength() > 0) {
            Element elementoPropertyList = (Element)nl.item(0);
            NodeList listaPropertyEntries = elementoPropertyList.getElementsByTagName("PropertyEntry");
            int i = 0;
            while (i < listaPropertyEntries.getLength()) {
                Node nod = listaPropertyEntries.item(i);
                PropertyEntry pe = new PropertyEntry(mundo, nod);
                String nombre = pe.getName();
                int j = this.propertiesList.size() - 1;
                while (j >= 0) {
                    PropertyEntry actual = (PropertyEntry)this.propertiesList.get(j);
                    if (actual.getName().equals(nombre)) {
                        this.propertiesList.remove(actual);
                    }
                    --j;
                }
                this.propertiesList.add(pe);
                ++i;
            }
        }
    }

    public abstract int getID();

    public Node getRelationshipListXMLRepresentation(Document doc) {
        Element e = doc.createElement("RelationshipList");
        int i = 0;
        while (i < this.relationships.size()) {
            Element eRel = doc.createElement("Relationship");
            Element ePropList = doc.createElement("PropertyList");
            Entity objetivo = (Entity)this.relationships.elementAt(i);
            eRel.setAttribute("id", String.valueOf(objetivo.getID()));
            List propertiesList = (List)this.relationship_properties.elementAt(i);
            int j = 0;
            while (j < propertiesList.size()) {
                PropertyEntry pe = (PropertyEntry)propertiesList.get(j);
                Node nodoProp = pe.getXMLRepresentation(doc);
                ePropList.appendChild(nodoProp);
                ++j;
            }
            eRel.appendChild(ePropList);
            e.appendChild(eRel);
            ++i;
        }
        return e;
    }

    public void readRelationshipListFromXML(World mundo, Node n) throws XMLtoWorldException {
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Mobile node not Element");
        }
        Element e = (Element)n;
        NodeList nl = e.getElementsByTagName("RelationshipList");
        if (nl.getLength() > 0) {
            Element relationshipListNode = (Element)nl.item(0);
            NodeList relaciones = relationshipListNode.getElementsByTagName("Relationship");
            int i = 0;
            while (i < relaciones.getLength()) {
                ArrayList<PropertyEntry> propertiesList;
                Element thisRelationshipNode = (Element)relaciones.item(i);
                if (!thisRelationshipNode.hasAttribute("id")) {
                    throw new XMLtoWorldException("Relationship node lacking attribute id");
                }
                this.relationships.add(mundo.getObject(thisRelationshipNode.getAttribute("id")));
                NodeList pListNodes = thisRelationshipNode.getElementsByTagName("PropertyList");
                if (pListNodes.getLength() < 0) {
                    propertiesList = new ArrayList<PropertyEntry>();
                } else {
                    propertiesList = new ArrayList();
                    Element elementoPropertyList = (Element)pListNodes.item(0);
                    NodeList listaPropertyEntries = elementoPropertyList.getElementsByTagName("PropertyEntry");
                    int k = 0;
                    while (k < listaPropertyEntries.getLength()) {
                        Node nod = listaPropertyEntries.item(k);
                        PropertyEntry pe = new PropertyEntry(mundo, nod);
                        propertiesList.add(pe);
                        ++k;
                    }
                }
                this.relationship_properties.add(propertiesList);
                ++i;
            }
        }
    }

    public int getRelationshipState(Entity e) {
        return this.getRelationshipPropertyValueAsInteger(e, "state");
    }

    public int getRelationshipPropertyValueAsInteger(Entity e, String propertyName) {
        int lim = this.relationships.size();
        int k = 0;
        while (k < lim) {
            if (this.relationships.elementAt(k).equals(e)) {
                List propertiesList = (List)this.relationship_properties.elementAt(k);
                int i = 0;
                while (i < propertiesList.size()) {
                    PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                    if (pe.getName().equalsIgnoreCase(propertyName)) {
                        return pe.getValueAsInteger();
                    }
                    ++i;
                }
            }
            ++k;
        }
        return 0;
    }

    public String getRelationshipPropertyValueAsString(Entity e, String propertyName) {
        System.out.println("Relationships size is " + this.relationships.size());
        int lim = this.relationships.size();
        int k = 0;
        while (k < lim) {
            System.out.println("Checking a relationship. Entity: " + e.getID());
            if (this.relationships.elementAt(k).equals(e)) {
                System.out.println("Entity found.");
                List propertiesList = (List)this.relationship_properties.elementAt(k);
                int i = 0;
                while (i < propertiesList.size()) {
                    System.out.println("Name: " + ((PropertyEntry)propertiesList.get(i)).getName());
                    PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                    if (pe.getName().equalsIgnoreCase(propertyName)) {
                        return pe.getValue();
                    }
                    ++i;
                }
            }
            ++k;
        }
        return null;
    }

    public List getRelatedEntities(String propertyName) {
        int lim = this.relationships.size();
        ArrayList<Entity> result = new ArrayList<Entity>();
        int k = 0;
        while (k < lim) {
            Entity other = (Entity)this.relationships.elementAt(k);
            List propertiesList = (List)this.relationship_properties.elementAt(k);
            int i = 0;
            while (i < propertiesList.size()) {
                PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                if (pe.getName().equalsIgnoreCase(propertyName)) {
                    result.add(other);
                    break;
                }
                ++i;
            }
            ++k;
        }
        return result;
    }

    public List getRelatedEntitiesByValue(String propertyName, boolean boolVal) {
        int lim = this.relationships.size();
        ArrayList<Entity> result = new ArrayList<Entity>();
        int k = 0;
        while (k < lim) {
            Entity other = (Entity)this.relationships.elementAt(k);
            List propertiesList = (List)this.relationship_properties.elementAt(k);
            int i = 0;
            while (i < propertiesList.size()) {
                PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                if (pe.getName().equalsIgnoreCase(propertyName) && pe.getValueAsBoolean() == boolVal) {
                    result.add(other);
                    break;
                }
                ++i;
            }
            ++k;
        }
        return result;
    }

    public List getRelatedEntitiesByValue(String propertyName, int intVal) {
        int lim = this.relationships.size();
        ArrayList<Entity> result = new ArrayList<Entity>();
        int k = 0;
        while (k < lim) {
            Entity other = (Entity)this.relationships.elementAt(k);
            List propertiesList = (List)this.relationship_properties.elementAt(k);
            int i = 0;
            while (i < propertiesList.size()) {
                PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                if (pe.getName().equalsIgnoreCase(propertyName) && pe.getValueAsInteger() == intVal) {
                    result.add(other);
                    break;
                }
                ++i;
            }
            ++k;
        }
        return result;
    }

    public boolean getRelationshipPropertyValueAsBoolean(Entity e, String propertyName) {
        int lim = this.relationships.size();
        int k = 0;
        while (k < lim) {
            if (this.relationships.elementAt(k).equals(e)) {
                List propertiesList = (List)this.relationship_properties.elementAt(k);
                int i = 0;
                while (i < propertiesList.size()) {
                    PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                    if (pe.getName().equalsIgnoreCase(propertyName)) {
                        return pe.getValueAsBoolean();
                    }
                    ++i;
                }
            }
            ++k;
        }
        return false;
    }

    public void setRelationshipProperty(Entity e, String propertyName, String propertyValue) {
        int lim = this.relationships.size();
        int k = 0;
        while (k < lim) {
            if (this.relationships.elementAt(k).equals(e)) {
                List propertiesList = (List)this.relationship_properties.elementAt(k);
                int i = 0;
                while (i < propertiesList.size()) {
                    PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                    if (pe.getName().equalsIgnoreCase(propertyName)) {
                        pe.setValue(propertyValue);
                        return;
                    }
                    ++i;
                }
                propertiesList.add(new PropertyEntry(propertyName, propertyValue, 0L));
                return;
            }
            ++k;
        }
        this.relationships.addElement(e);
        ArrayList<PropertyEntry> nuevaPropEntryList = new ArrayList<PropertyEntry>();
        PropertyEntry pe = new PropertyEntry(propertyName, propertyValue, 0L);
        nuevaPropEntryList.add(pe);
        this.relationship_properties.addElement(nuevaPropEntryList);
    }

    public void setRelationshipProperty(Entity e, String propertyName, int propertyValue) {
        this.setRelationshipProperty(e, propertyName, String.valueOf(propertyValue));
    }

    public void setRelationshipProperty(Entity e, String propertyName, boolean propertyValue) {
        this.setRelationshipProperty(e, propertyName, String.valueOf(propertyValue));
    }

    public void setRelationshipPropertyTimeLeft(Entity e, String propertyName, long newtime) {
        int lim = this.relationships.size();
        int k = 0;
        while (k < lim) {
            if (this.relationships.elementAt(k).equals(e)) {
                List propertiesList = (List)this.relationship_properties.elementAt(k);
                int i = 0;
                while (i < propertiesList.size()) {
                    PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                    if (pe.getName().equalsIgnoreCase(propertyName)) {
                        pe.setTime(newtime);
                        return;
                    }
                    ++i;
                }
                propertiesList.add(new PropertyEntry(propertyName, "false", newtime));
                return;
            }
            ++k;
        }
        this.relationships.addElement(e);
        ArrayList<PropertyEntry> nuevaPropEntryList = new ArrayList<PropertyEntry>();
        PropertyEntry pe = new PropertyEntry(propertyName, "false", newtime);
        nuevaPropEntryList.add(pe);
        this.relationship_properties.addElement(nuevaPropEntryList);
    }

    public void setRelationshipState(Entity e, int newState) {
        this.setRelationshipProperty(e, "state", newState);
    }

    public String toString() {
        String s = "[ " + this.getClass().getName() + ":" + this.getID();
        if (this instanceof Nameable) {
            s = String.valueOf(s) + ":";
            s = String.valueOf(s) + ((Nameable)((Object)this)).constructName2(1, null);
        }
        s = String.valueOf(s) + " ]";
        return s;
    }
}

