// Created with Squiffy 5.1.3
// https://github.com/textadventures/squiffy

(function(){
/* jshint quotmark: single */
/* jshint evil: true */

var squiffy = {};

(function () {
    'use strict';

    squiffy.story = {};

    var initLinkHandler = function () {
        var handleLink = function (link) {
            if (link.hasClass('disabled')) return;
            var passage = link.data('passage');
            var section = link.data('section');
            var rotateAttr = link.attr('data-rotate');
            var sequenceAttr = link.attr('data-sequence');
            if (passage) {
                disableLink(link);
                squiffy.set('_turncount', squiffy.get('_turncount') + 1);
                passage = processLink(passage);
                if (passage) {
                    currentSection.append('<hr/>');
                    squiffy.story.passage(passage);
                }
                var turnPassage = '@' + squiffy.get('_turncount');
                if (turnPassage in squiffy.story.section.passages) {
                    squiffy.story.passage(turnPassage);
                }
                if ('@last' in squiffy.story.section.passages && squiffy.get('_turncount')>= squiffy.story.section.passageCount) {
                    squiffy.story.passage('@last');
                }
            }
            else if (section) {
                currentSection.append('<hr/>');
                disableLink(link);
                section = processLink(section);
                squiffy.story.go(section);
            }
            else if (rotateAttr || sequenceAttr) {
                var result = rotate(rotateAttr || sequenceAttr, rotateAttr ? link.text() : '');
                link.html(result[0].replace(/&quot;/g, '"').replace(/&#39;/g, '\''));
                var dataAttribute = rotateAttr ? 'data-rotate' : 'data-sequence';
                link.attr(dataAttribute, result[1]);
                if (!result[1]) {
                    disableLink(link);
                }
                if (link.attr('data-attribute')) {
                    squiffy.set(link.attr('data-attribute'), result[0]);
                }
                squiffy.story.save();
            }
        };

        squiffy.ui.output.on('click', 'a.squiffy-link', function () {
            handleLink(jQuery(this));
        });

        squiffy.ui.output.on('keypress', 'a.squiffy-link', function (e) {
            if (e.which !== 13) return;
            handleLink(jQuery(this));
        });

        squiffy.ui.output.on('mousedown', 'a.squiffy-link', function (event) {
            event.preventDefault();
        });
    };

    var disableLink = function (link) {
        link.addClass('disabled');
        link.attr('tabindex', -1);
    }
    
    squiffy.story.begin = function () {
        if (!squiffy.story.load()) {
            squiffy.story.go(squiffy.story.start);
        }
    };

    var processLink = function(link) {
		link = String(link);
        var sections = link.split(',');
        var first = true;
        var target = null;
        sections.forEach(function (section) {
            section = section.trim();
            if (startsWith(section, '@replace ')) {
                replaceLabel(section.substring(9));
            }
            else {
                if (first) {
                    target = section;
                }
                else {
                    setAttribute(section);
                }
            }
            first = false;
        });
        return target;
    };

    var setAttribute = function(expr) {
        var lhs, rhs, op, value;
        var setRegex = /^([\w]*)\s*=\s*(.*)$/;
        var setMatch = setRegex.exec(expr);
        if (setMatch) {
            lhs = setMatch[1];
            rhs = setMatch[2];
            if (isNaN(rhs)) {
				if(startsWith(rhs,"@")) rhs=squiffy.get(rhs.substring(1));
                squiffy.set(lhs, rhs);
            }
            else {
                squiffy.set(lhs, parseFloat(rhs));
            }
        }
        else {
			var incDecRegex = /^([\w]*)\s*([\+\-\*\/])=\s*(.*)$/;
            var incDecMatch = incDecRegex.exec(expr);
            if (incDecMatch) {
                lhs = incDecMatch[1];
                op = incDecMatch[2];
				rhs = incDecMatch[3];
				if(startsWith(rhs,"@")) rhs=squiffy.get(rhs.substring(1));
				rhs = parseFloat(rhs);
                value = squiffy.get(lhs);
                if (value === null) value = 0;
                if (op == '+') {
                    value += rhs;
                }
                if (op == '-') {
                    value -= rhs;
                }
				if (op == '*') {
					value *= rhs;
				}
				if (op == '/') {
					value /= rhs;
				}
                squiffy.set(lhs, value);
            }
            else {
                value = true;
                if (startsWith(expr, 'not ')) {
                    expr = expr.substring(4);
                    value = false;
                }
                squiffy.set(expr, value);
            }
        }
    };

    var replaceLabel = function(expr) {
        var regex = /^([\w]*)\s*=\s*(.*)$/;
        var match = regex.exec(expr);
        if (!match) return;
        var label = match[1];
        var text = match[2];
        if (text in squiffy.story.section.passages) {
            text = squiffy.story.section.passages[text].text;
        }
        else if (text in squiffy.story.sections) {
            text = squiffy.story.sections[text].text;
        }
        var stripParags = /^<p>(.*)<\/p>$/;
        var stripParagsMatch = stripParags.exec(text);
        if (stripParagsMatch) {
            text = stripParagsMatch[1];
        }
        var $labels = squiffy.ui.output.find('.squiffy-label-' + label);
        $labels.fadeOut(1000, function() {
            $labels.html(squiffy.ui.processText(text));
            $labels.fadeIn(1000, function() {
                squiffy.story.save();
            });
        });
    };

    squiffy.story.go = function(section) {
        squiffy.set('_transition', null);
        newSection();
        squiffy.story.section = squiffy.story.sections[section];
        if (!squiffy.story.section) return;
        squiffy.set('_section', section);
        setSeen(section);
        var master = squiffy.story.sections[''];
        if (master) {
            squiffy.story.run(master);
            squiffy.ui.write(master.text);
        }
        squiffy.story.run(squiffy.story.section);
        // The JS might have changed which section we're in
        if (squiffy.get('_section') == section) {
            squiffy.set('_turncount', 0);
            squiffy.ui.write(squiffy.story.section.text);
            squiffy.story.save();
        }
    };

    squiffy.story.run = function(section) {
        if (section.clear) {
            squiffy.ui.clearScreen();
        }
        if (section.attributes) {
            processAttributes(section.attributes);
        }
        if (section.js) {
            section.js();
        }
    };

    squiffy.story.passage = function(passageName) {
        var passage = squiffy.story.section.passages[passageName];
        if (!passage) return;
        setSeen(passageName);
        var masterSection = squiffy.story.sections[''];
        if (masterSection) {
            var masterPassage = masterSection.passages[''];
            if (masterPassage) {
                squiffy.story.run(masterPassage);
                squiffy.ui.write(masterPassage.text);
            }
        }
        var master = squiffy.story.section.passages[''];
        if (master) {
            squiffy.story.run(master);
            squiffy.ui.write(master.text);
        }
        squiffy.story.run(passage);
        squiffy.ui.write(passage.text);
        squiffy.story.save();
    };

    var processAttributes = function(attributes) {
        attributes.forEach(function (attribute) {
            if (startsWith(attribute, '@replace ')) {
                replaceLabel(attribute.substring(9));
            }
            else {
                setAttribute(attribute);
            }
        });
    };

    squiffy.story.restart = function() {
        if (squiffy.ui.settings.persist && window.localStorage) {
            var keys = Object.keys(localStorage);
            jQuery.each(keys, function (idx, key) {
                if (startsWith(key, squiffy.story.id)) {
                    localStorage.removeItem(key);
                }
            });
        }
        else {
            squiffy.storageFallback = {};
        }
        if (squiffy.ui.settings.scroll === 'element') {
            squiffy.ui.output.html('');
            squiffy.story.begin();
        }
        else {
            location.reload();
        }
    };

    squiffy.story.save = function() {
        squiffy.set('_output', squiffy.ui.output.html());
    };

    squiffy.story.load = function() {
        var output = squiffy.get('_output');
        if (!output) return false;
        squiffy.ui.output.html(output);
        currentSection = jQuery('#' + squiffy.get('_output-section'));
        squiffy.story.section = squiffy.story.sections[squiffy.get('_section')];
        var transition = squiffy.get('_transition');
        if (transition) {
            eval('(' + transition + ')()');
        }
        return true;
    };

    var setSeen = function(sectionName) {
        var seenSections = squiffy.get('_seen_sections');
        if (!seenSections) seenSections = [];
        if (seenSections.indexOf(sectionName) == -1) {
            seenSections.push(sectionName);
            squiffy.set('_seen_sections', seenSections);
        }
    };

    squiffy.story.seen = function(sectionName) {
        var seenSections = squiffy.get('_seen_sections');
        if (!seenSections) return false;
        return (seenSections.indexOf(sectionName) > -1);
    };
    
    squiffy.ui = {};

    var currentSection = null;
    var screenIsClear = true;
    var scrollPosition = 0;

    var newSection = function() {
        if (currentSection) {
            disableLink(jQuery('.squiffy-link', currentSection));
        }
        var sectionCount = squiffy.get('_section-count') + 1;
        squiffy.set('_section-count', sectionCount);
        var id = 'squiffy-section-' + sectionCount;
        currentSection = jQuery('<div/>', {
            id: id,
        }).appendTo(squiffy.ui.output);
        squiffy.set('_output-section', id);
    };

    squiffy.ui.write = function(text) {
        screenIsClear = false;
        scrollPosition = squiffy.ui.output.height();
        currentSection.append(jQuery('<div/>').html(squiffy.ui.processText(text)));
        squiffy.ui.scrollToEnd();
    };

    squiffy.ui.clearScreen = function() {
        squiffy.ui.output.html('');
        screenIsClear = true;
        newSection();
    };

    squiffy.ui.scrollToEnd = function() {
        var scrollTo, currentScrollTop, distance, duration;
        if (squiffy.ui.settings.scroll === 'element') {
            scrollTo = squiffy.ui.output[0].scrollHeight - squiffy.ui.output.height();
            currentScrollTop = squiffy.ui.output.scrollTop();
            if (scrollTo > currentScrollTop) {
                distance = scrollTo - currentScrollTop;
                duration = distance / 0.4;
                squiffy.ui.output.stop().animate({ scrollTop: scrollTo }, duration);
            }
        }
        else {
            scrollTo = scrollPosition;
            currentScrollTop = Math.max(jQuery('body').scrollTop(), jQuery('html').scrollTop());
            if (scrollTo > currentScrollTop) {
                var maxScrollTop = jQuery(document).height() - jQuery(window).height();
                if (scrollTo > maxScrollTop) scrollTo = maxScrollTop;
                distance = scrollTo - currentScrollTop;
                duration = distance / 0.5;
                jQuery('body,html').stop().animate({ scrollTop: scrollTo }, duration);
            }
        }
    };

    squiffy.ui.processText = function(text) {
        function process(text, data) {
            var containsUnprocessedSection = false;
            var open = text.indexOf('{');
            var close;
            
            if (open > -1) {
                var nestCount = 1;
                var searchStart = open + 1;
                var finished = false;
             
                while (!finished) {
                    var nextOpen = text.indexOf('{', searchStart);
                    var nextClose = text.indexOf('}', searchStart);
         
                    if (nextClose > -1) {
                        if (nextOpen > -1 && nextOpen < nextClose) {
                            nestCount++;
                            searchStart = nextOpen + 1;
                        }
                        else {
                            nestCount--;
                            searchStart = nextClose + 1;
                            if (nestCount === 0) {
                                close = nextClose;
                                containsUnprocessedSection = true;
                                finished = true;
                            }
                        }
                    }
                    else {
                        finished = true;
                    }
                }
            }
            
            if (containsUnprocessedSection) {
                var section = text.substring(open + 1, close);
                var value = processTextCommand(section, data);
                text = text.substring(0, open) + value + process(text.substring(close + 1), data);
            }
            
            return (text);
        }

        function processTextCommand(text, data) {
            if (startsWith(text, 'if ')) {
                return processTextCommand_If(text, data);
            }
            else if (startsWith(text, 'else:')) {
                return processTextCommand_Else(text, data);
            }
            else if (startsWith(text, 'label:')) {
                return processTextCommand_Label(text, data);
            }
            else if (/^rotate[: ]/.test(text)) {
                return processTextCommand_Rotate('rotate', text, data);
            }
            else if (/^sequence[: ]/.test(text)) {
                return processTextCommand_Rotate('sequence', text, data);   
            }
            else if (text in squiffy.story.section.passages) {
                return process(squiffy.story.section.passages[text].text, data);
            }
            else if (text in squiffy.story.sections) {
                return process(squiffy.story.sections[text].text, data);
            }
			else if (startsWith(text,'@') && !startsWith(text,'@replace')) {
				processAttributes(text.substring(1).split(","));
				return "";
			}
            return squiffy.get(text);
        }

        function processTextCommand_If(section, data) {
            var command = section.substring(3);
            var colon = command.indexOf(':');
            if (colon == -1) {
                return ('{if ' + command + '}');
            }

            var text = command.substring(colon + 1);
            var condition = command.substring(0, colon);
			condition = condition.replace("<", "&lt;");
            var operatorRegex = /([\w ]*)(=|&lt;=|&gt;=|&lt;&gt;|&lt;|&gt;)(.*)/;
            var match = operatorRegex.exec(condition);

            var result = false;

            if (match) {
                var lhs = squiffy.get(match[1]);
                var op = match[2];
                var rhs = match[3];

				if(startsWith(rhs,'@')) rhs=squiffy.get(rhs.substring(1));
				
                if (op == '=' && lhs == rhs) result = true;
                if (op == '&lt;&gt;' && lhs != rhs) result = true;
                if (op == '&gt;' && lhs > rhs) result = true;
                if (op == '&lt;' && lhs < rhs) result = true;
                if (op == '&gt;=' && lhs >= rhs) result = true;
                if (op == '&lt;=' && lhs <= rhs) result = true;
            }
            else {
                var checkValue = true;
                if (startsWith(condition, 'not ')) {
                    condition = condition.substring(4);
                    checkValue = false;
                }

                if (startsWith(condition, 'seen ')) {
                    result = (squiffy.story.seen(condition.substring(5)) == checkValue);
                }
                else {
                    var value = squiffy.get(condition);
                    if (value === null) value = false;
                    result = (value == checkValue);
                }
            }

            var textResult = result ? process(text, data) : '';

            data.lastIf = result;
            return textResult;
        }

        function processTextCommand_Else(section, data) {
            if (!('lastIf' in data) || data.lastIf) return '';
            var text = section.substring(5);
            return process(text, data);
        }

        function processTextCommand_Label(section, data) {
            var command = section.substring(6);
            var eq = command.indexOf('=');
            if (eq == -1) {
                return ('{label:' + command + '}');
            }

            var text = command.substring(eq + 1);
            var label = command.substring(0, eq);

            return '<span class="squiffy-label-' + label + '">' + process(text, data) + '</span>';
        }

        function processTextCommand_Rotate(type, section, data) {
            var options;
            var attribute = '';
            if (section.substring(type.length, type.length + 1) == ' ') {
                var colon = section.indexOf(':');
                if (colon == -1) {
                    return '{' + section + '}';
                }
                options = section.substring(colon + 1);
                attribute = section.substring(type.length + 1, colon);
            }
            else {
                options = section.substring(type.length + 1);
            }
            var rotation = rotate(options.replace(/"/g, '&quot;').replace(/'/g, '&#39;'));
            if (attribute) {
                squiffy.set(attribute, rotation[0]);
            }
            return '<a class="squiffy-link" data-' + type + '="' + rotation[1] + '" data-attribute="' + attribute + '" role="link">' + rotation[0] + '</a>';
        }

        var data = {
            fulltext: text
        };
        return process(text, data);
    };

    squiffy.ui.transition = function(f) {
        squiffy.set('_transition', f.toString());
        f();
    };

    squiffy.storageFallback = {};

    squiffy.set = function(attribute, value) {
        if (typeof value === 'undefined') value = true;
        if (squiffy.ui.settings.persist && window.localStorage) {
            localStorage[squiffy.story.id + '-' + attribute] = JSON.stringify(value);
        }
        else {
            squiffy.storageFallback[attribute] = JSON.stringify(value);
        }
        squiffy.ui.settings.onSet(attribute, value);
    };

    squiffy.get = function(attribute) {
        var result;
        if (squiffy.ui.settings.persist && window.localStorage) {
            result = localStorage[squiffy.story.id + '-' + attribute];
        }
        else {
            result = squiffy.storageFallback[attribute];
        }
        if (!result) return null;
        return JSON.parse(result);
    };

    var startsWith = function(string, prefix) {
        return string.substring(0, prefix.length) === prefix;
    };

    var rotate = function(options, current) {
        var colon = options.indexOf(':');
        if (colon == -1) {
            return [options, current];
        }
        var next = options.substring(0, colon);
        var remaining = options.substring(colon + 1);
        if (current) remaining += ':' + current;
        return [next, remaining];
    };

    var methods = {
        init: function (options) {
            var settings = jQuery.extend({
                scroll: 'body',
                persist: true,
                restartPrompt: true,
                onSet: function (attribute, value) {}
            }, options);

            squiffy.ui.output = this;
            squiffy.ui.restart = jQuery(settings.restart);
            squiffy.ui.settings = settings;

            if (settings.scroll === 'element') {
                squiffy.ui.output.css('overflow-y', 'auto');
            }

            initLinkHandler();
            squiffy.story.begin();
            
            return this;
        },
        get: function (attribute) {
            return squiffy.get(attribute);
        },
        set: function (attribute, value) {
            squiffy.set(attribute, value);
        },
        restart: function () {
            if (!squiffy.ui.settings.restartPrompt || confirm('Seguro quieres reiniciar?')) {
                squiffy.story.restart();
            }
        }
    };

    jQuery.fn.squiffy = function (methodOrOptions) {
        if (methods[methodOrOptions]) {
            return methods[methodOrOptions]
                .apply(this, Array.prototype.slice.call(arguments, 1));
        }
        else if (typeof methodOrOptions === 'object' || ! methodOrOptions) {
            return methods.init.apply(this, arguments);
        } else {
            jQuery.error('Method ' +  methodOrOptions + ' does not exist');
        }
    };
})();

var get = squiffy.get;
var set = squiffy.set;


squiffy.story.start = 'Inicio';
squiffy.story.id = 'f1d1e561a5';
squiffy.story.sections = {
	'PUNTAJE': {
		'text': "<p><table style=\"background-color:black;color:white;\" width=\"100%\"></p>\n<p><tr></p>\n<p><td style=\"text-align:left;\" ><FONT face=\"Viner Hand ITC\">&nbsp;{seccion}&nbsp;</FONT></td></p>\n<p><td style=\"text-align:right;\">&nbsp;Puntaje: <b>{puntaje}&nbsp;</b></td>\n</tr>\n</table>\n<br></p>",
		'passages': {
		},
	},
	'Encabezado textadventures': {
		'text': "<!-- Encabezado para textadventures.co.uk -->\n<p><img src=\"ReencuentroTitulo.png\" align=middle alt=\"Quebrada con rio y nave espacial\" height=\"145\" width=\"221\"><BR><BR></p>\n<p><FONT face=\"Viner Hand ITC\" color=\"brown\" size=7>Reencuentro</FONT><BR></p>\n<p><FONT size=4><a href=\"https://incanus.caad.club/reencuentro.html\" target=\"_blank\">Visita su página web</a></FONT><BR><BR></p>\n<!-- Variables del juego -->",
		'passages': {
		},
	},
	'Inicio': {
		'text': "<p>{if textadventures=0:<FONT face=\"Viner Hand ITC\" color=\"brown\" size=7>Reencuentro</FONT><BR><BR>}{else:{Encabezado textadventures}}</p>\n<FONT size=4>versión 01.01.02</FONT><BR><BR>\n<!-- <a class=\"squiffy-link link-section\" data-section=\"llanura mitad\" role=\"link\" tabindex=\"0\">ENLACE DESARROLLO</a><BR><BR> -->\n<FONT face=\"Viner Hand ITC\" color=\"green\" size=5>\nEl camino al reencuentro<BR>\nNo siempre es corto<BR>\nY a veces es difícil<BR>\nPero es un camino hermoso<BR>\nY  merece ser andado<BR>\n<BR>\nComienza, pues, a <a class=\"squiffy-link link-section\" data-section=\"astronave\" role=\"link\" tabindex=\"0\">recorrerlo</a>...</FONT>",
		'attributes': ["mision=0","sistema=0","traje=0","advertencia=0","registro=0","criatura_laguna=0","inteligencia=0","puntaje=0","muerte=0","textadventures=0"],
		'passages': {
		},
	},
	'descripcion mision': {
		'text': "<p>Nos costó un par de desastres el aprenderlo, pero cuando una colonia llega a un cierto número de habitantes se hace obligado buscar nuevos mundos habitables para crear nuevas colonias o de lo contrario las condiciones de vida se vuelven agobiantes en cosa de un par de siglos.</p>",
		'passages': {
		},
	},
	'astronave': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nLa <a class=\"squiffy-link link-passage\" data-passage=\"computadora de a bordo\" role=\"link\" tabindex=\"0\">computadora de a bordo</a> me despertó del <a class=\"squiffy-link link-passage\" data-passage=\"criosueño\" role=\"link\" tabindex=\"0\">criosueño</a> hace algunas horas, sabiendo que me tomo <a class=\"squiffy-link link-passage\" data-passage=\"mi tiempo\" role=\"link\" tabindex=\"0\">mi tiempo</a> para ponerme razonablemente alerta.</p>\n<p>Es la tercera parada de <a class=\"squiffy-link link-passage\" data-passage=\"mi turno\" role=\"link\" tabindex=\"0\">mi turno</a> en <a class=\"squiffy-link link-passage\" data-passage=\"misión de exploración\" role=\"link\" tabindex=\"0\">misión de exploración</a> y espero que sea <I>algo</I> mejor que las dos <a class=\"squiffy-link link-passage\" data-passage=\"anteriores\" role=\"link\" tabindex=\"0\">anteriores</a>.</p>\n<p>Con algo de ansiedad, me aproximo a uno de los visores. Podría comenzar pidiéndole a la computadora una <a class=\"squiffy-link link-section\" data-section=\"vista externa\" role=\"link\" tabindex=\"0\">vista externa</a> o bien ir directamente a la <a class=\"squiffy-link link-section\" data-section=\"promisorio\" role=\"link\" tabindex=\"0\">vista de datos</a>.</p>",
		'attributes': ["seccion=Astronave"],
		'passages': {
			'computadora de a bordo': {
				'text': "<p>Una inteligencia muy considerada y amable, por cierto, pero más bien inflexible a la hora de cumplir con los parámetros de la misión.</p>",
			},
			'criosueño': {
				'text': "<p>Los viajes estelares son demasiado <a class=\"squiffy-link link-passage\" data-passage=\"prolongados\" role=\"link\" tabindex=\"0\">prolongados</a> y las distancias demasiado largas como para que sea práctico o sano hacer la travesía despiertos.</p>",
			},
			'prolongados': {
				'text': "<p>No espero al volver encontrar vivo a nadie que yo recuerde, ni siquiera los <I>niños</I>. A mi regreso estoy cierto que se me acogerá y respetará como un miembro valioso de la comunidad, pero socialmente tendré que partir <I>de cero</I>.</p>",
			},
			'mi tiempo': {
				'text': "<p>No importa si es sueño normal o criosueño, recién despierto no sirvo para nada... haya <a class=\"squiffy-link link-passage\" data-passage=\"ingerido\" role=\"link\" tabindex=\"0\">ingerido</a> algo no.</p>",
			},
			'ingerido': {
				'text': "<p>Acabo de tomar algunos <a class=\"squiffy-link link-passage\" data-passage=\"alimentos\" role=\"link\" tabindex=\"0\">alimentos</a> y como sea que mi estómago no se ha comportado mal, creo que estoy listo para ver dónde nos hemos detenido.</p>",
			},
			'alimentos': {
				'text': "<p>Sólo se recomiendan líquidos los primeros días después del criosueño y la verdad es que nunca me ha gustado demasiado la comida... ejem... <I>sólida</I>.</p>",
			},
			'mi turno': {
				'text': "<p>Aunque se supone que hay algo de azar, la verdad es que los individuos que destacamos en ciertos campos damos por sentado que en algún momento nos ha de tocar participar en una o más misiones de exploración. Si todo sale bien, tendré un buen pasar y algo de tranquilidad volviendo a casa... entre misiones, claro está.</p>",
			},
			'misión de exploración': {
				'text': "<p>{descripcion mision}</p>",
				'attributes': ["mision+=1"],
			},
			'anteriores': {
				'text': "<p>Uno de los mundos resultó tener vida inteligente en estado neolítico y el otro planeta estaba comenzando a desarrollar su agricultura. Nada de eso podía saberlo la computadora y tuve suerte en descubrirlo antes de haber cambiado la mitología o, peor aún, la <I>historia</I> local.</p>",
			},
		},
	},
	'vista externa': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nEl visor se aclara gradualmente y veo que estamos en un sistema con un <a class=\"squiffy-link link-passage\" data-passage=\"sol amarillo\" role=\"link\" tabindex=\"0\">sol amarillo</a>. Resulta algo <a class=\"squiffy-link link-passage\" data-passage=\"chocante\" role=\"link\" tabindex=\"0\">chocante</a> a primera vista, pero no es desagradable de ver, aunque me costaría acostumbrarme a vivir en un lugar así.</p>\n<p>La estrella local es lo de menos, en todo caso, pues el conjunto planetario es sumamente particular: algunos planetas <a class=\"squiffy-link link-passage\" data-passage=\"gaseosos gigantes\" role=\"link\" tabindex=\"0\">gaseosos gigantes</a>, un  nutrido <a class=\"squiffy-link link-passage\" data-passage=\"asteroides\" role=\"link\" tabindex=\"0\">cinturón de asteroides</a> y algunos cuerpos menores en órbita cercana al sol, uno de los cuales debió <a class=\"squiffy-link link-passage\" data-passage=\"interesante\" role=\"link\" tabindex=\"0\">parecerle interesante</a> a la computadora, pues estamos orbitándolo.</p>\n<p>Y la verdad es que, teniendo en cuenta los objetivos de la {if mision=0:<a class=\"squiffy-link link-passage\" data-passage=\"mision\" role=\"link\" tabindex=\"0\">misión</a>}{else:misión}, parece <a class=\"squiffy-link link-section\" data-section=\"promisorio\" role=\"link\" tabindex=\"0\">promisorio</a>.</p>",
		'passages': {
			'sol amarillo': {
				'text': "<p>Vaya. Pensaba que eso de las estrellas amarillas eran puras fábulas, pero se ve que los astrofísicos no bromeaban cuando nos prepararon para la misión.</p>",
			},
			'mision': {
				'text': "<p>{descripcion mision}</p>",
				'attributes': ["mision+=1"],
			},
			'chocante': {
				'text': "<p>Sé que el universo es un lugar muy grande y todos los lugares son diferentes, pero la colonia en que me crié tenía un sol verde y para mi eso es lo normal. En fin...</p>",
			},
			'gaseosos gigantes': {
				'text': "<p>Hay no menos de cuatro, número más bien elevado para un sistema planetario típico. <!--Uno de ellos tiene unos gigantescos anillos.--></p>",
			},
			'asteroides': {
				'text': "<p>Probablemente restos de otro planeta, cosa que he visto en algunas simulaciones de escenarios posibles de la misión. Curioso, en todo caso, que aun subsista en compañía de los gigantes de gas.</p>",
			},
			'interesante': {
				'text': "<p>Los protocolos de selección de mundos de la misión son demasiado complejos para que yo los entienda. La computadora prescinde de la tripulación para esas y otras decisiones... y nos costaron las vidas de <I>muchas</I> tripulaciones el llegar a implementar estas directivas.</p>",
			},
		},
	},
	'promisorio': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nEs un mundo con muchísima <a class=\"squiffy-link link-passage\" data-passage=\"agua\" role=\"link\" tabindex=\"0\">agua</a> y con unos continentes que apenas están <a class=\"squiffy-link link-passage\" data-passage=\"algo separados\" role=\"link\" tabindex=\"0\">algo separados</a>.</p>\n<p>Por los <a class=\"squiffy-link link-passage\" data-passage=\"datos flotantes\" role=\"link\" tabindex=\"0\">datos flotantes</a> en el visor, hay mucha vida animal y vegetal allí abajo, pocos desiertos y, cosa importante, ningún indicio de <a class=\"squiffy-link link-passage\" data-passage=\"tecnología\" role=\"link\" tabindex=\"0\">tecnología</a> de ningún tipo.</p>\n<p>Un mundo candidato para colonizar, entonces: la computadora <a class=\"squiffy-link link-passage\" data-passage=\"no se equivocó\" role=\"link\" tabindex=\"0\">no se equivocó</a> al despertarme, pues será necesario que haga un reconocimiento en terreno.</p>\n<p>Hay un pequeño problema, <I>por supuesto</I>.</p>\n<p>Y es que, por más que <a class=\"squiffy-link link-passage\" data-passage=\"manipulo\" role=\"link\" tabindex=\"0\">manipulo</a> los datos del visor, no parece que haya un sitio idóneo para descender con la nave: la gravedad es más bien intensa y la atmósfera no es especialmente tenue, para no hablar del clima, que lo es todo <a class=\"squiffy-link link-passage\" data-passage=\"menos tranquilo\" role=\"link\" tabindex=\"0\">menos tranquilo</a>.</p>\n<p>No queda otra que bajar en un <a class=\"squiffy-link link-section\" data-section=\"capsula\" role=\"link\" tabindex=\"0\">módulo individual</a></p>",
		'passages': {
			'agua': {
				'text': "<p>Varios océanos cubren más de tres cuartas partes de la superficie. No es muy habitual encontar mundos tan bien provistos de agua.</p>",
			},
			'algo separados': {
				'text': "<p>La deriva continental debe ser muy reciente, así que se trata de un mundo más bien joven.</p>",
			},
			'datos flotantes': {
				'text': "<p>He preferido holografías a implantarme sensores oculares. Es algo más trabajoso para leer los datos, pero al menos así me pican menos los ojos...</p>",
			},
			'tecnología': {
				'text': "<p>Si hay agricultura, está muy hábilmente oculta en la vegetación natural.</p>",
			},
			'no se equivocó': {
				'text': "<p>Rara vez se equivoca, pero cuando lo hace... mejor no pensar en eso.</p>",
			},
			'manipulo': {
				'text': "<p>Los toco, los huelo, los volteo... nada, las lecturas no cambian.</p>",
			},
			'menos tranquilo': {
				'text': "<p>Hay hasta huracanes y tornados aquí y allá.</p>",
			},
		},
	},
	'descripcion traje': {
		'text': "<p>Una sola pieza cubre todo excepto el rostro. Permite sortear toda clase de terrenos y climas extremos, aunque no incluye propulsores para {if seen quebrada:<B>volar</B>}{else:volar} o {if seen laguna:<B>nadar</B>}{else:{if seen cienaga inicio:<B>nadar</B>}{else:nadar}}. Se supone que en caso de tragedia consume al usuario y no deja rastro alguno, pero prefiero no pensar en <I>eso</I>.</p>",
		'passages': {
		},
	},
	'capsula': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nNo se ve particularmente riesgoso, en principio: la atmósfera es respirable, la gravedad no se ve <a class=\"squiffy-link link-passage\" data-passage=\"muy desafiante\" role=\"link\" tabindex=\"0\">muy desafiante</a> y el terreno en que descenderé <a class=\"squiffy-link link-passage\" data-passage=\"no parece malo\" role=\"link\" tabindex=\"0\">no parece malo</a>.</p>\n<p>Con un suspiro, tomo uno de los <a class=\"squiffy-link link-passage\" data-passage=\"traje\" role=\"link\" tabindex=\"0\">trajes de campo</a> y mientras me lo pongo le pido más detalles del itinerario a la computadora.</p>\n<p>Por lo visto, tendré que recorrer una llanura y acercarme a los lindes de un bosque y de un pantano, lo que en principio debiera permitir tomar datos de las distintas formas de vida típicas.</p>\n<p>Si algo de lo que encontremos no resulta <a class=\"squiffy-link link-passage\" data-passage=\"auspicioso\" role=\"link\" tabindex=\"0\">auspicioso</a>, se marcará el mundo como reserva natural y sólo será posible visitarlo bajo estrictas condiciones de preservación. Por el contrario, si todo sale bien, se programará un <a class=\"squiffy-link link-passage\" data-passage=\"misión beta\" role=\"link\" tabindex=\"0\">misión beta</a> para hacer una exploración más profunda de cara a una posible colonización.</p>\n<p>Ya vestido, me tiendo en el suelo y, con un suspiro, la cubierta <a class=\"squiffy-link link-passage\" data-passage=\"materialidad\" role=\"link\" tabindex=\"0\">me envuelve</a> formando una <a class=\"squiffy-link link-section\" data-section=\"aterrizaje\" role=\"link\" tabindex=\"0\">cápsula de aterrizaje</a>.</p>",
		'passages': {
			'muy desafiante': {
				'text': "<p>Al menos podré caminar normalmente: resulta agotador eso de controlar los pasos para no salir <I>volando</I> o tener que arrastrarse casi aplastado por el peso <I>del aire</I>...</p>",
			},
			'no parece malo': {
				'text': "<p>Desde la órbita, por supuesto, nada parece malo. Una vez abajo, las cosas suelen cambiar.</p>",
			},
			'traje': {
				'text': "<p>{descripcion traje}</p>",
				'attributes': ["traje+=1"],
			},
			'auspicioso': {
				'text': "<p>No todas las plantas serán necesariamente inocuas, para no hablar de la fauna local, que ha causado más de algún problema aquí y allá. De hecho, se dice que... pero no, no hagamos caso de <a class=\"squiffy-link link-passage\" data-passage=\"rumores\" role=\"link\" tabindex=\"0\">rumores</a>.</p>",
			},
			'rumores': {
				'text': "<p>El universo es un lugar peligroso <I>de veras</I> y no diré más.</p>",
			},
			'misión beta': {
				'text': "<p>La mía es una de las tantísimas {if mision=0:<a class=\"squiffy-link link-passage\" data-passage=\"mision\" role=\"link\" tabindex=\"0\">misiones alfa</a>}{else:misiones alfa} de exploración inicial, con los recursos justos para observar y notificar. Con un solo tripulante está fuera de discusión el análisis y la investigación que se requieren para llegar a considerar un mundo como posible colonia.</p>",
			},
			'mision': {
				'text': "<p>{descripcion mision}</p>",
				'attributes': ["mision+=1"],
			},
			'materialidad': {
				'text': "<p>La materialidad del interior de la nave es sumamente fluida, lo que permite al explorador y a la computadora <a class=\"squiffy-link link-passage\" data-passage=\"adaptar\" role=\"link\" tabindex=\"0\">adaptar</a> su configuración a múltiples perfiles de funcionamiento.</p>",
			},
			'adaptar': {
				'text': "<p>El desgaste o pérdida de material se repone con prácticamente cualquier cosa, pero no será mala idea recoger más tarde un par de asteroides y reciclarlos.</p>",
			},
		},
	},
	'aterrizaje': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nDespierto algo dolorido: la cápsula hizo su trabajo y sigo entero, pero el color de las luces que <a class=\"squiffy-link link-passage\" data-passage=\"parpadean\" role=\"link\" tabindex=\"0\">parpadean</a> a mi alrededor no parecen augurar nada bueno.</p>\n<p>Al menos estoy en posición horizontal y en contacto con el suelo: podría haber <a class=\"squiffy-link link-passage\" data-passage=\"sido peor\" role=\"link\" tabindex=\"0\">sido peor</a>.</p>\n<p>Me apoyo para levantarme y la cápsula se abre para dejarme salir.</p>\n<p>Doy <a class=\"squiffy-link link-passage\" data-passage=\"mi primer paso\" role=\"link\" tabindex=\"0\">mi primer paso</a> en un mundo nuevo... y noto que el suelo está algo caliente pero, a juzgar por lo que veo al erguirme, es lo de menos.</p>\n<p>Por lo visto, los retrocohetes y el sistema antigravedad no sirvieron de nada, pues la cápsula hizo contacto con el suelo y se arrastró lo suyo antes de detenerse.</p>\n<p>Bueno, no es más que un mal comienzo: más vale empezar la {if mision=0:<a class=\"squiffy-link link-passage\" data-passage=\"mision\" role=\"link\" tabindex=\"0\">misión</a>}{else:misión}, así que me dispongo a salir del <a class=\"squiffy-link link-section\" data-section=\"surco\" role=\"link\" tabindex=\"0\">surco que dejó la cápsula</a>.</p>",
		'attributes': ["seccion=Aterrizaje"],
		'passages': {
			'parpadean': {
				'text': "<p>Son luces de alerta, aunque no parece que haya peligro inmediato.</p>",
			},
			'sido peor': {
				'text': "<p>En la última misión desperté al borde de un barranco. No fue divertido, la verdad.</p>",
			},
			'mi primer paso': {
				'text': "<p>Se supone que debo decir algo <I>memorable</I>, pero francamente no estoy de humor.</p>",
			},
			'mision': {
				'text': "<p>{descripcion mision}</p>",
				'attributes': ["mision+=1"],
			},
		},
	},
	'descripcion sistema': {
		'text': "<p>Mi sistema de información personal es sumamente sencillo pero es funcional y muy robusto, cosa que en este momento es de agradecer.</p>",
		'passages': {
		},
	},
	'surco': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nMientras me alejo, la cápsula comienza a desmoronarse y pronto no queda sino <a class=\"squiffy-link link-passage\" data-passage=\"un polvillo\" role=\"link\" tabindex=\"0\">un polvillo</a> que apenas se distingue del suelo.</p>\n<p>Tras andar un trecho, descubro que efectivamente he aterrizado en una llanura...</p>\n<p>...pero el <a class=\"squiffy-link link-passage\" data-passage=\"módulo de ascenso\" role=\"link\" tabindex=\"0\">módulo de ascenso</a> que debió bajar conmigo no se ve por parte alguna.</p>\n<p>Preocupado, doy un vistazo a <a class=\"squiffy-link link-passage\" data-passage=\"mi muñeca\" role=\"link\" tabindex=\"0\">mi muñeca</a> y, con alivio, veo que hay una señal de advertencia encendida: el módulo está intacto aunque, al igual que la cáspula, tuvo un aterrizaje <I>&quot;fuera de los parámetros de descenso&quot;</I>.</p>\n<p>Según me informo, el vehículo está a una buena distancia de mi posición actual y deberé hacer un viaje <a class=\"squiffy-link link-passage\" data-passage=\"no menor\" role=\"link\" tabindex=\"0\">no menor</a> para reencontrarme con él.</p>\n<p>Bueno, mi objetivo de descenso era precisamente hacer reconocimiento del terreno y recoger información de la flora y fauna, cosa que sin duda deberé hacer si quiero llegar hasta el módulo de ascenso.</p>\n<p>Así pues, me pongo a andar resueltamente y, dejando atrás el surco del aterrizaje, comienzo a avanzar por la llanura.</p>\n<p>Se trata de un enorme pastizal que se extiende en todas direcciones, aunque pareciera que <a class=\"squiffy-link link-passage\" data-passage=\"hay algo\" role=\"link\" tabindex=\"0\">hay algo</a> más adelante.</p>\n<p>Conforme avanzo por la planicie, titubeo entre <a class=\"squiffy-link link-section\" data-section=\"llanura rápido\" role=\"link\" tabindex=\"0\">recorrerla rápidamente</a> o bien ir con calma y <a class=\"squiffy-link link-section\" data-section=\"llanura lento\" role=\"link\" tabindex=\"0\">disfrutar del paisaje</a>.</p>",
		'passages': {
			'un polvillo': {
				'text': "<p>Al igual que el {if traje=0:<a class=\"squiffy-link link-passage\" data-passage=\"traje\" role=\"link\" tabindex=\"0\">traje</a>}{else:traje} que llevo puesto, toda la tecnología usada en las exploraciones planetarias está diseñada para no dejar rastro alguno de nuestro paso.</p>",
			},
			'traje': {
				'text': "<p>{descripcion traje}</p>",
				'attributes': ["traje+=1"],
			},
			'módulo de ascenso': {
				'text': "<p>Las primeras {if mision=0:<a class=\"squiffy-link link-passage\" data-passage=\"mision\" role=\"link\" tabindex=\"0\">misiones de exploración</a>}{else:misiones de exploración} usaron vehículos únicos para aterrizar y despegar. La experiencia demostró que era más seguro separar los componentes del transporte de descenso según la función.</p>",
			},
			'mision': {
				'text': "<p>{descripcion mision}</p>",
				'attributes': ["mision+=1"],
			},
			'mi muñeca': {
				'text': "<p>{descripcion sistema}</p>",
				'attributes': ["sistema+=1"],
			},
			'no menor': {
				'text': "<p>Tengo ante mí por lo menos unas 6 horas de caminata, salvo alguna pausa o demora.</p>",
			},
			'hay algo': {
				'text': "<p>Una masa importante de vegetación, parece. Estoy demasiado lejos aún para distinguir detalles.</p>",
			},
		},
	},
	'descripcion vibracion': {
		'text': "<p>Me ha estremecido de pies a cabeza: la sacudida es muy eficaz, pero algo incómoda.</p>",
		'passages': {
		},
	},
	'llanura rápido': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nMe ha costado muy poco entrar en el régimen mental de exploración profunda: aunque sigo avanzando y <a class=\"squiffy-link link-passage\" data-passage=\"hablando\" role=\"link\" tabindex=\"0\">hablando</a> de manera clara y ordenada, mi mente comienza a divagar y a establecer ideas <a class=\"squiffy-link link-passage\" data-passage=\"muy complejas\" role=\"link\" tabindex=\"0\">muy complejas</a>, casi como si estuviera soñando despierto.</p>\n<p>Tan ensimismado estoy que, sin darme apenas cuenta, ha pasado una hora y el traje me &quot;despierta&quot; con una <a class=\"squiffy-link link-passage\" data-passage=\"vibración seca\" role=\"link\" tabindex=\"0\">vibración seca</a>, llamando mi atención a que hemos llegado al <a class=\"squiffy-link link-section\" data-section=\"llanura mitad\" role=\"link\" tabindex=\"0\">final de la llanura</a>.</p>",
		'attributes': ["seccion=Llanura"],
		'passages': {
			'hablando': {
				'text': "<p>Nuestro entrenamiento tiene mucho de habilidades narrativas, ya que los dispositivos de registro de información del {if traje=0:<a class=\"squiffy-link link-passage\" data-passage=\"traje\" role=\"link\" tabindex=\"0\">traje</a>}{else:traje} siguen tanto la voz como los movimientos del explorador. Menuda tarea sería si, además de sortear el terreno, tuviera que estar <I>tomando notas</I> o capturando imágenes...</p>",
				'attributes': ["registro+=1"],
			},
			'muy complejas': {
				'text': "<p>En el entrenamiento me dieron a entender que esto también queda registrado en el sistema de información del {if traje=0:<a class=\"squiffy-link link-passage\" data-passage=\"traje\" role=\"link\" tabindex=\"0\">traje</a>}{else:traje}, aunque no supieron explicarme como... ni para qué.</p>",
			},
			'traje': {
				'text': "<p>{descripcion traje}</p>",
				'attributes': ["traje+=1"],
			},
			'vibración seca': {
				'text': "<p>{descripcion vibracion}</p>",
				'attributes': ["advertencia+=1"],
			},
		},
	},
	'llanura lento': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nMientras voy caminando, observo atentamente y <a class=\"squiffy-link link-passage\" data-passage=\"hablando\" role=\"link\" tabindex=\"0\">comento en voz alta</a> todo lo que me parece de interés: la forma y colores de las hojas de hierba, textura y apariencia de las piedras, el aspecto de algunos insectos que salen volando o arrastrándose a mi paso... en fin, el paisaje según se despliega a mi alrededor.</p>\n<p>El aire, por cierto, está límpido y es particularmente <a class=\"squiffy-link link-passage\" data-passage=\"estimulante\" role=\"link\" tabindex=\"0\">estimulante</a> el respirarlo; otro tanto ocurre con el cielo, de un <a class=\"squiffy-link link-passage\" data-passage=\"color azul\" role=\"link\" tabindex=\"0\">color azul</a> de intensidad tal que pareciera tener sobre mí una <a class=\"squiffy-link link-passage\" data-passage=\"boveda\" role=\"link\" tabindex=\"0\">bóveda</a> casi sólida.</p>\n<p>Me ha costado muy poco entrar en el régimen mental de exploración profunda: aunque sigo avanzando y hablando de manera clara y ordenada, mi mente comienza a divagar y a establecer ideas <a class=\"squiffy-link link-passage\" data-passage=\"muy complejas\" role=\"link\" tabindex=\"0\">muy complejas</a>, casi como si estuviera soñando despierto.</p>\n<p>Tan ensimismado estoy que, sin darme apenas cuenta, ha pasado una hora y el traje me &quot;despierta&quot; con una <a class=\"squiffy-link link-passage\" data-passage=\"vibración seca\" role=\"link\" tabindex=\"0\">vibración seca</a>, llamando mi atención a que hemos llegado al <a class=\"squiffy-link link-section\" data-section=\"llanura mitad\" role=\"link\" tabindex=\"0\">final de la llanura</a>.</p>",
		'attributes': ["seccion=Llanura"],
		'passages': {
			'hablando': {
				'text': "<p>Nuestro entrenamiento tiene mucho de habilidades narrativas, ya que los dispositivos de registro de información del {if traje=0:<a class=\"squiffy-link link-passage\" data-passage=\"traje\" role=\"link\" tabindex=\"0\">traje</a>}{else:traje} siguen tanto la voz como los movimientos del explorador. Menuda tarea sería si, además de sortear el terreno, tuviera que estar <I>tomando notas</I> o capturando imágenes...</p>",
				'attributes': ["registro+=1"],
			},
			'estimulante': {
				'text': "<p>En nuestras colonias, los ambientes están demasiado cuidados y sanitizados, al punto de resultar algo sosos. Aquí, el ataque olfativo llega a ser casi embriagador.</p>",
			},
			'color azul': {
				'text': "<p>Es una tonalidad muy distinta al violeta anaranjado de mi colonia natal, pero no es repulsivo. Tiene, cosa curiosa, un efecto más bien relajante.</p>",
			},
			'boveda': {
				'text': "<p>Algunas colonias son de hecho abovedadas, pero es que en esto de la higiene se han llegado a veces a extremos rídiculos.</p>",
			},
			'muy complejas': {
				'text': "<p>En el entrenamiento me dieron a entender que esto también queda registrado en el sistema de información del {if traje=0:<a class=\"squiffy-link link-passage\" data-passage=\"traje\" role=\"link\" tabindex=\"0\">traje</a>}{else:traje}, aunque no supieron explicarme cómo... ni para qué.</p>",
			},
			'traje': {
				'text': "<p>{descripcion traje}</p>",
				'attributes': ["traje+=1"],
			},
			'vibración seca': {
				'text': "<p>{descripcion vibracion}</p>",
				'attributes': ["advertencia+=1"],
			},
		},
	},
	'llanura mitad': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nLa llanura me ha llevado hasta el borde exterior de un bosque inmenso y sumamente tupido. Se ve poca luz más allá de los lindes exteriores, así que los árboles han de estar muy apretados y altos. Un terreno <a class=\"squiffy-link link-passage\" data-passage=\"penetrar\" role=\"link\" tabindex=\"0\">difícil de penetrar</a>, sin duda.</p>\n<p>Por el costado exterior de la foresta se ve un extenso pantano al que le llega buena luz, aunque aquí y allá se ven algunos bancos de niebla... o de gas, no hay que descartarlo. Es un camino algo menos accidentado, aunque <a class=\"squiffy-link link-passage\" data-passage=\"riesgos\" role=\"link\" tabindex=\"0\">ha de tener sus riesgos</a>.</p>\n<p>Hay que decidirse, entonces: atravesar el <a class=\"squiffy-link link-section\" data-section=\"bosque inicio\" role=\"link\" tabindex=\"0\">bosque</a> o avanzar por la <a class=\"squiffy-link link-section\" data-section=\"cienaga inicio\" role=\"link\" tabindex=\"0\">ciénaga</a>.</p>",
		'passages': {
			'penetrar': {
				'text': "<p>Se nos adivirtió repetidamente en nuestro entrenamiento que hay que desconfiar de los lugares de vegetación densa, tanto por las plantas en sí mismas como por los animales que suelen esconderse en ellas. Estar alerta todo el tiempo se vuelve vital... y agotador.</p>",
			},
			'riesgos': {
				'text': "<p>Mis instructores decían que una ventaja de avanzar por un pantano es que los peligros están debajo o delante, pero se los ve venir de lejos y rara vez son una sorpresa. No sé porqué, pero eso no me tranquiliza ahora mismo.</p>",
			},
		},
	},
	'bosque inicio': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nAl poco andar por el lugar comienzo a reevaluar mi apreciación inicial: esto, más que bosque, parece una verdadera <a class=\"squiffy-link link-passage\" data-passage=\"selva\" role=\"link\" tabindex=\"0\">selva</a>.</p>\n<p>Los <a class=\"squiffy-link link-passage\" data-passage=\"árboles\" role=\"link\" tabindex=\"0\">árboles</a> son imponentes, hay <a class=\"squiffy-link link-passage\" data-passage=\"arbustos\" role=\"link\" tabindex=\"0\">arbustos</a> por todas partes y <a class=\"squiffy-link link-passage\" data-passage=\"lianas\" role=\"link\" tabindex=\"0\">lianas</a> colgando de las <a class=\"squiffy-link link-passage\" data-passage=\"ramas altas\" role=\"link\" tabindex=\"0\">ramas altas</a>. La luz, por otra parte, es <a class=\"squiffy-link link-passage\" data-passage=\"escasa\" role=\"link\" tabindex=\"0\">escasa</a>, hace bastante calor y hay no poca humedad, pero no llega a ser <a class=\"squiffy-link link-passage\" data-passage=\"desagradable\" role=\"link\" tabindex=\"0\">desagradable</a>.</p>\n<p>Un <a class=\"squiffy-link link-section\" data-section=\"lemures\" role=\"link\" tabindex=\"0\">movimiento</a> en uno de los árboles atrae mi atención, pero por otra parte parece haber algo más de claridad allá adelante y quizás sería mejor seguir <a class=\"squiffy-link link-section\" data-section=\"laguna\" role=\"link\" tabindex=\"0\">avanzando</a>.</p>",
		'attributes': ["seccion=Bosque"],
		'passages': {
			'selva': {
				'text': "<p>He echado mano a mi entrenamiento para identificar este bioma: jamás he estado en un lugar así y muy pocas colonias tienen estos paisajes.</p>",
			},
			'árboles': {
				'text': "<p>Crecen muy altos, con troncos ora gruesos o delgados.</p>",
			},
			'arbustos': {
				'text': "<p>Los llamo así para distinguirlos de los árboles, pero algunos son el doble de altos que yo.</p>",
			},
			'lianas': {
				'text': "<p>Algunas son tan gruesas como ramas, pero cuelgan de maneras más bien antojadizas y se mueven con el aire.<BR><BR>\nO eso parece.</p>",
			},
			'ramas altas': {
				'text': "<p>Las ramas más elevadas apenas se distinguen más arriba y se adivinan por las sombras y poco más.</p>",
			},
			'escasa': {
				'text': "<p>Aunque aquí y allá se ve algún rayo de sol, en general camino en una especie de penumbra.</p>",
			},
			'desagradable': {
				'text': "<p>El {if traje=0:<a class=\"squiffy-link link-passage\" data-passage=\"traje\" role=\"link\" tabindex=\"0\">traje</a>}{else:traje} hace lo que puede con las condiciones del clima, pero no es perfecto. Sin embargo, me encuentro extrañamente a gusto...</p>",
			},
			'traje': {
				'text': "<p>{descripcion traje}</p>",
				'attributes': ["trajeV+=1"],
			},
		},
	},
	'lemures': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nEn las ramas de uno de los árboles distingo un grupo de animales que están comiendo algo que podrían ser <a class=\"squiffy-link link-passage\" data-passage=\"frutas\" role=\"link\" tabindex=\"0\">frutas</a>.</p>\n<p>Son más o menos del porte de mi brazo, con cuerpo, miembros y cola más bien <a class=\"squiffy-link link-passage\" data-passage=\"delgados\" role=\"link\" tabindex=\"0\">delgados</a>, todo cubierto de <a class=\"squiffy-link link-passage\" data-passage=\"pelos\" role=\"link\" tabindex=\"0\">pelos</a>. Sus ojos están hacia el frente y tienen unas bocas y narices algo pequeñas. El efecto del conjunto resulta divertido, pero no se me ocurriría <a class=\"squiffy-link link-passage\" data-passage=\"acercarme demasiado\" role=\"link\" tabindex=\"0\">acercarme demasiado</a> para saber más.</p>\n<p>Mientras he estado relatando esto {if registro=1:en voz alta}{else:<a class=\"squiffy-link link-passage\" data-passage=\"hablando\" role=\"link\" tabindex=\"0\">en voz alta</a>} para el registro, las criaturas se han  quedado muy quietas y me han dedicado unas miradas decididamente <a class=\"squiffy-link link-passage\" data-passage=\"inquisitivas\" role=\"link\" tabindex=\"0\">inquisitivas</a>.</p>\n<p>Contento por mi descubrimiento, decido volver a moverme hacia <a class=\"squiffy-link link-section\" data-section=\"laguna\" role=\"link\" tabindex=\"0\">la claridad más adelante</a>.</p>",
		'attributes': ["puntaje+=1"],
		'passages': {
			'frutas': {
				'text': "<p>O eso parecen.<BR><BR>\nSalvo mi entrenamiento y algún registro documental antiguo, nunca había visto una.</p>",
			},
			'delgados': {
				'text': "<p>Usan sus extremidades con mucha destreza, valiéndose alternativamente de una u otra para coger fruta o aferrarse a las ramas.</p>",
			},
			'pelos': {
				'text': "<p>Aparte de la cara y bajo las manos y pies, no hay epidermis a la vista. El pelaje es de un color uniforme, salvo la cola, que tiene unas curiosas manchas casi como anillos.</p>",
			},
			'acercarme demasiado': {
				'text': "<p>Las instrucciones del entrenamiento son sumamente claras y explícitas: salvo auto preservación, evitar a toda costa el contacto con seres vivos, máxime si están en grupos.</p>",
			},
			'hablando': {
				'text': "<p>Nuestro entrenamiento tiene mucho de habilidades narrativas, ya que los dispositivos de registro de información del {if traje=0:<a class=\"squiffy-link link-passage\" data-passage=\"traje\" role=\"link\" tabindex=\"0\">traje</a>}{else:traje} siguen tanto la voz como los movimientos del explorador. Menuda tarea sería si, además de sortear el terreno, tuviera que estar <I>tomando notas</I> o guardando imágenes...</p>",
				'attributes': ["registro+=1"],
			},
			'traje': {
				'text': "<p>{descripcion traje}</p>",
				'attributes': ["traje+=1"],
			},
			'inquisitivas': {
				'text': "<p>Por lo visto, en este mundo ya hay especies en el camino de la elevación a la inteligencia. Será cosa de algunos millones de años, pero es un fenómeno que una vez iniciado, rara vez <a class=\"squiffy-link link-passage\" data-passage=\"se detiene\" role=\"link\" tabindex=\"0\">se detiene</a>.</p>",
			},
			'se detiene': {
				'text': "<p>Salvo algún evento masivo de extinción, claro está. Nosotros mismos, de hecho, apenas escapamos de una catástrofe sideral y eso fue lo que nos lanzó a las estrellas.</p>",
			},
		},
	},
	'laguna': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nHe llegado a la orilla de una laguna bien ancha.</p>\n<p>Las aguas son más bien <a class=\"squiffy-link link-passage\" data-passage=\"verdosas\" role=\"link\" tabindex=\"0\">verdosas</a> y turbias, pero a la fauna local han de resultarle atractivas, pues nada más entrar he visto movimientos en las plantas colindantes, con ruidos que sólo hacen los animales cuando <a class=\"squiffy-link link-passage\" data-passage=\"huyen asustados\" role=\"link\" tabindex=\"0\">huyen asustados</a>.</p>\n<p>Me he acercado a la orilla más próxima para ver qué tan profunda es el agua, pero una {if advertencia=1:vibración seca}{else:<a class=\"squiffy-link link-passage\" data-passage=\"vibración seca\" role=\"link\" tabindex=\"0\">vibración seca</a>} del {if traje=0:<a class=\"squiffy-link link-passage\" data-passage=\"traje\" role=\"link\" tabindex=\"0\">traje</a>}{else:traje} me detiene oportunamente: bajo la superficie del líquido se adivinan algunos <a class=\"squiffy-link link-passage\" data-passage=\"criatura laguna\" role=\"link\" tabindex=\"0\">movimientos inquietantes</a>... y yo retrocedo rápido unos cuantos pasos.</p>\n<p>Así las cosas, no queda otra opción que rodear la laguna, ya sea por la <a class=\"squiffy-link link-section\" data-section=\"ribera izquierda\" role=\"link\" tabindex=\"0\">espesura izquierda</a>, particularmente a oscuras o bien por <a class=\"squiffy-link link-section\" data-section=\"ribera derecha\" role=\"link\" tabindex=\"0\">unos pastos a la derecha</a>, algo más iluminados pero {label:1=muy tupidos}.</p>",
		'passages': {
			'vibración seca': {
				'text': "<p>{descripcion vibracion}</p>",
				'attributes': ["advertencia+=1"],
			},
			'traje': {
				'text': "<p>{descripcion traje}</p>",
				'attributes': ["traje+=1"],
			},
			'verdosas': {
				'text': "<p>Uno como explorador ya está hecho a estas cosas, pero conozco a varios allá en casa que se habrían puesto del mismo color del agua ante la sola idea de tocarla, para no hablar de <I>beberla</I>...</p>",
			},
			'huyen asustados': {
				'text': "<p>Cuesta creer que algo pueda tenerme miedo pero, bueno, mi apariencia ha de causarles algo de espanto. No es que entre mi gente se me considere un ejemplar muy feo, pero <I>claramente</I> no soy fauna local.</p>",
			},
			'criatura laguna': {
				'text': "<p>Algo parece nadar en la laguna, alejándose a la ribera a mi derecha. Es más grueso que mis dos piernas juntas y casi tan largo como yo soy alto.<BR><BR>\nDe pronto, creo que paso de meterme al agua o incluso de acercarme más a la orilla.</p>",
				'attributes': ["criatura_laguna+=1","@replace 1=<p>no faltos de peligros</p>"],
			},
		},
	},
	'ribera derecha': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nAvanzo con algo de dificultad, pues la hierba es más alta que yo y sumamente húmeda. Intentando abrirme paso, trato de apartar los tallos con un brazo...</p>\n<p>...pero pierdo el equilibrio, resbalo y caigo de espaldas entre la hierba. Trato de ponerme en pie, pero no hago más que mover el pasto a mi alrededor, sin lograr apoyarme lo suficiente para levantarme.</p>\n<p>¡Algo está saliendo de la laguna a mi izquierda!</p>\n<p>Mientras escucho ruidos de un cuerpo pesado que se mueve en la orilla, intento aferrarme desperadamente de los tallos, pero mis manos resbalan inútilmente, pese a que el traje intenta compensar.</p>\n<p>¡Siento que tiran brutalmente de mis pies!</p>\n<p><B>...y tengo una visión fugaz de fauces dentadas...</B>\n{Final Muerte}</p>",
		'attributes': ["muerte+=1"],
		'passages': {
		},
	},
	'ribera izquierda': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nLa espesura de este lado de la laguna es bastante densa, pero el suelo al menos está razonablemente sólido y puedo avanzar sin grandes problemas.</p>\n<p>Estoy a punto de llegar al final de la laguna, cuando del otro lado escucho un <a class=\"squiffy-link link-passage\" data-passage=\"chapoteo violento\" role=\"link\" tabindex=\"0\">chapoteo violento</a> seguido de un chillido que termina bruscamente. {if criatura_laguna=0:Algo parece nadar en la laguna, alejándose despacio de la orilla opuesta. Es más grueso que mis dos piernas juntas y casi tan largo como yo soy alto}{else:Diviso a la criatura que entreví en la orilla, alejándose despacio de la orilla opuesta}. De pronto se hunde... y unas gruesas burbujas revientan en la superficie, dejando unas <a class=\"squiffy-link link-passage\" data-passage=\"manchas oscuras\" role=\"link\" tabindex=\"0\">manchas oscuras</a> flotando en el agua.</p>\n<p>Felicitándome por mi afortunada escogencia de ruta, sigo caminando a paso vivo y en breve dejo atrás la laguna, para continuar <a class=\"squiffy-link link-section\" data-section=\"bosque fin\" role=\"link\" tabindex=\"0\">bosque adentro</a>.</p>",
		'passages': {
			'chapoteo violento': {
				'text': "<p>Algo pesado que se mueve en la otra orilla.</p>",
			},
			'manchas oscuras': {
				'text': "<p>Confieso que he contenido la respiración: no tengo mal olfato y preferiría no saber <I>a qué</I> huelen esas manchas.</p>",
			},
		},
	},
	'bosque fin': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nNo ha pasado mucho rato cuando los árboles comienzan a espaciarse cada vez más y el nivel de luz ambiental va gradualmente en aumento.</p>\n<p>Compruebo, aliviado, que he llegado al final del bosque y que nuevamente tengo frente a mí la llanura.</p>\n<p>Llevo poco menos de la mitad del camino recorrido, así que, con renovados bríos, <a class=\"squiffy-link link-section\" data-section=\"llanura continuacion\" role=\"link\" tabindex=\"0\">sigo adelante</a>.</p>",
		'attributes': ["puntaje+=1"],
		'passages': {
		},
	},
	'cienaga inicio': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nComienzo a avanzar por el pantano, tarea que resulta no demasiado difícil aunque sí algo penosa: el suelo es muy húmedo y en algunas partes se ha <a class=\"squiffy-link link-passage\" data-passage=\"reblandecido\" role=\"link\" tabindex=\"0\">reblandecido</a>. El {if traje=0:<a class=\"squiffy-link link-passage\" data-passage=\"traje\" role=\"link\" tabindex=\"0\">traje</a>}{else:traje} me mantiene seco, en todo caso.</p>\n<p>El lugar está lejos de estar deshabitado: hay múltiples plantas creciendo junto o a veces <I>dentro</I> de <a class=\"squiffy-link link-passage\" data-passage=\"pequeñas pozas\" role=\"link\" tabindex=\"0\">pequeñas pozas</a>, además de una población no menor de <a class=\"squiffy-link link-passage\" data-passage=\"insectos\" role=\"link\" tabindex=\"0\">insectos</a> que vuelan o se arrastran por doquier. He visto también algunos <a class=\"squiffy-link link-passage\" data-passage=\"anfibios\" role=\"link\" tabindex=\"0\">anfibios</a> que se dan un festín con ellos... cuando no es al revés, por cierto.</p>\n<p>Llevo andando una media hora cuando me enfrento a un cambio drástico en el paisaje: la ciénaga se divide en dos zonas muy distintas y no hay manera de seguir adelante si optar por uno u otro camino.</p>\n<p>Debo tratar de sortear un largo trecho de <a class=\"squiffy-link link-section\" data-section=\"fango1\" role=\"link\" tabindex=\"0\">fango</a> o bien aventurarme en una zona muy extensa de <a class=\"squiffy-link link-section\" data-section=\"pastos\" role=\"link\" tabindex=\"0\">pastos largos</a>.... y ninguno de estos &quot;caminos&quot; se ve demasiado seductor, la verdad.</p>",
		'attributes': ["seccion=Ciénaga"],
		'passages': {
			'reblandecido': {
				'text': "<p>Hay sitios en los que mi pie se ha hundido completamente y me ha costado lo suyo sacarlo.</p>",
			},
			'traje': {
				'text': "<p>{descripcion traje}</p>",
				'attributes': ["traje+=1"],
			},
			'pequeñas pozas': {
				'text': "<p>No son más que charcos de agua fétida, fáciles de esquivar pero imposibles de <I>no</I> oler, por desgracia.</p>",
			},
			'insectos': {
				'text': "<p>Algunos son pequeños y forman verdaderos enjambres. Otros son tan grandes como mi brazo aunque se mueven perezosamente.<BR><BR>\nProcuro evitarlos a todos por igual.</p>",
			},
			'anfibios': {
				'text': "<p>Los hay tan pequeños que cabrían de a diez en mi mano y otros más grandes que mi cabeza, con unas tremendas bocotas. Algunos tiene colores muy encendido y brillantes.<BR><BR>\nNinguno es tan bonito que me les quiera acercar ni mucho menos <a class=\"squiffy-link link-passage\" data-passage=\"tocarlos\" role=\"link\" tabindex=\"0\">tocarlos</a>.</p>",
			},
			'tocarlos': {
				'text': "<p>Nuestro entrenamiento hace hincapié en que algunos de estos animales son en extremo tóxicos al tacto, algunos incluso letales.</p>",
			},
		},
	},
	'descripcion fango': {
		'text': "<p>No llevo más que algunos pasos andados por este... me resisto a llamarlo terreno... cuando estoy deseando haberme ido por <I>cualquier</I> otro sitio. Me cuesta mucho moverme y cada paso es una verdadera lucha:</p>\n<p>Doy un paso... y mi pie se hunde.<BR>\nLibero ese pie... y el otro resbala o patina.<BR>\nIntento pisar donde parece estar más seco el suelo... y me hundo <I>también</I>.</p>",
		'passages': {
		},
	},
	'descripcion hojas': {
		'text': "<p>Las hojas, de superficie más bien brillante, son muy grandes y anchas: tanto, que podrían servirme incluso para caminar sobre ellas.</p>\n<p>Curiosamente, de las hojas parece emanar un perfume algo dulzón...</p>",
		'passages': {
		},
	},
	'fango1': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n{descripcion fango}</p>\n<p>Sencillamente, es agotador.</p>\n<p>Llevo &quot;andado&quot; así por espacio de una hora cuando por fin el fango empieza a ceder a un medio más líquido pero, al menos bajo el agua, más sólido para el andar: indescriptiblemente <I><a class=\"squiffy-link link-passage\" data-passage=\"fétido\" role=\"link\" tabindex=\"0\">fétido</a></I>, pero se puede pisar sin daño. Olor aparte, el problema es que conforme avanzo el agua está empezando a subir más y más de nivel...</p>\n<p>...y ya con el agua a la cintura la situación se vuelve <a class=\"squiffy-link link-passage\" data-passage=\"preocupante\" role=\"link\" tabindex=\"0\">preocupante</a>.</p>\n<p>Algo más adelante hay unas piedras sobresaliendo del líquido, aunque se ven algo <a class=\"squiffy-link link-passage\" data-passage=\"peligrosas\" role=\"link\" tabindex=\"0\">peligrosas</a>: entre las piedras hay unas <a class=\"squiffy-link link-passage\" data-passage=\"hojas redondas\" role=\"link\" tabindex=\"0\">hojas redondas</a> que parecen ser más estables.</p>\n<p>En todo caso, no es viable proseguir el avance sin algún apoyo, así que es cuestión de escoger si <a class=\"squiffy-link link-section\" data-section=\"piedras\" role=\"link\" tabindex=\"0\">seguir por las piedras</a>{label:1= o} <a class=\"squiffy-link link-section\" data-section=\"hojas carnivoras\" role=\"link\" tabindex=\"0\">continuar por las hojas</a>{label:2=.}</p>",
		'passages': {
			'fétido': {
				'text': "<p>Una de las cosas para las que se nos entrena es para tener una cierta resistencia sensorial, ya que debemos aprovechar todas las fuentes de informacion cuando estamos en el campo.<BR><BR>\nDicho esto: qué peste horrible...</p>",
			},
			'preocupante': {
				'text': "<p>El {if traje=0:<a class=\"squiffy-link link-passage\" data-passage=\"traje\" role=\"link\" tabindex=\"0\">traje</a>}{else:traje} que llevo puesto, por versátil que sea, no está realmente preparado para buceo.... ni yo tampoco creo que sea buena idea nadar por aquí.</p>",
			},
			'traje': {
				'text': "<p>{descripcion traje}</p>",
				'attributes': ["traje+=1"],
			},
			'peligrosas': {
				'text': "<p>Las piedras están cubiertas de un vegetación muy fina y húmeda: material deslizante, seguro.</p>",
				'attributes': ["@replace 1=<p>, de difícil travesía o</p>"],
			},
			'hojas redondas': {
				'text': "<p>{descripcion hojas}</p>",
				'attributes': ["@replace 2=<p>, de embriagante perfume.</p>"],
			},
		},
	},
	'descripcion frases': {
		'text': "<p>Me da igual si quedan o no registradas en la bitácora. Y si alguien quiere saber más al respecto, se puede <I>comer</I> la transcripción de mi informe.</p>",
		'passages': {
		},
	},
	'piedras': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nMe paro con <I>mucho</I> cuidado en la primera piedra a mi alcance y la piedra parece moverse debajo de mí: trato de quedarme quieto hasta que el movimiento se detiene más o menos por completo.</p>\n<p>Con un suspiro de alivio, doy un paso hasta la piedra más próxima...</p>\n<p>¡Y girando sin control hago la primera <a class=\"squiffy-link link-passage\" data-passage=\"vuelta en el aire\" role=\"link\" tabindex=\"0\">vuelta en el aire</a> desde que salí de mi colonia!</p>\n<p>Hago pie como buenamente puedo y, mientras muevo los brazos en todas direcciones, espero a que la piedra en que aterricé se estabilice de una buena vez, mientras mascullo un <a class=\"squiffy-link link-passage\" data-passage=\"par de frases\" role=\"link\" tabindex=\"0\">par de frases</a>.</p>\n<p>Con mucha desconfianza, considero la <a class=\"squiffy-link link-section\" data-section=\"cienaga fin\" role=\"link\" tabindex=\"0\">siguiente piedra</a> junto a mí y me pregunto si no sería más sencillo optar por <a class=\"squiffy-link link-section\" data-section=\"hojas carnivoras\" role=\"link\" tabindex=\"0\">una de las hojas aquí cerca</a>... </p>",
		'passages': {
			'vuelta en el aire': {
				'text': "<p>El entrenamiento de gravedad cero me ha salvado la vida.</p>",
			},
			'par de frases': {
				'text': "<p>{descripcion frases}</p>",
			},
		},
	},
	'hojas carnivoras': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nMe apoyo con cuidado en la hoja más cercana, pero resiste bien mi peso, así que decido pararme encima con los dos pies.</p>\n<p>Un olor dulzón, que parece emanar de la hoja, me envuelve como un arrullo embriagante. Como en un sueño, intento moverme para caminar hacia otra hoja, pero mis pies están pegados...</p>\n<p>...y la verdad es que ya no quiero moverlos, ni seguir andando: sólo quiero dormir, así que me dejo caer suavemente...</p>\n<p><B>...y la hoja me envuelve por completo.</B>\n{Final Muerte}</p>",
		'attributes': ["muerte+=1"],
		'passages': {
		},
	},
	'pastos': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nAvanzo con algo de dificultad, pues la hierba es más alta que yo y sumamente húmeda. Intentando abrirme paso, trato de apartar los tallos con un brazo...</p>\n<p>...pero pierdo el equilibrio, resbalo y caigo de espaldas entre la hierba. Trato de ponerme en pie, y lo consigo tras un par de intentos fallidos.</p>\n<p>Vuelvo a dar unos pasos y, <I>por supuesto</I>, resbalo nuevamente...</p>\n<p>...y asi unas diez veces más: la última, me voy de bruces hacia adelante, aterrizando en un trecho breve de ciénaga &quot;normal&quot;, pero ya me da igual. Mientras me pongo de pie e intento recuperar el aliento (y mi dignidad) mascullo un <a class=\"squiffy-link link-passage\" data-passage=\"par de frases\" role=\"link\" tabindex=\"0\">par de frases</a>.</p>\n<p>Algo más compuesto, considero el terreno más adelante: en una dirección la ciénaga se vuelve un terreno fangoso mientras que para el otro lado se ve una zona inundada, en la que flotan unas <a class=\"squiffy-link link-passage\" data-passage=\"hojas redondas\" role=\"link\" tabindex=\"0\">hojas redondas</a> que parecen ser estables.</p>\n<p>Con mucha desconfianza, considero si <a class=\"squiffy-link link-section\" data-section=\"fango2\" role=\"link\" tabindex=\"0\">voy a enfrentarme al lodo</a> y me pregunto si no sería más sencillo optar por <a class=\"squiffy-link link-section\" data-section=\"hojas carnivoras\" role=\"link\" tabindex=\"0\">el camino de las hojas</a>{label:1=...} </p>",
		'passages': {
			'par de frases': {
				'text': "<p>{descripcion frases}</p>",
			},
			'hojas redondas': {
				'text': "<p>{descripcion hojas}</p>",
				'attributes': ["@replace 1=<p>, de embriagante perfume...</p>"],
			},
		},
	},
	'fango2': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n{descripcion fango}</p>\n<p>Sencillamente, es agotador.... pero ni pensar en regresar y desperdiciar todo el esfuerzo invertido para llegar aquí...</p>\n<p>...<I>donde sea</I> que esté ahora mismo.</p>\n<p>Tras un breve descanso, miro con más calma hacia adelante y me parece distinguir que el suelo está  <I>algo</I> menos enlodado, así que vuelvo a ponerme (es un decir) <a class=\"squiffy-link link-section\" data-section=\"cienaga fin\" role=\"link\" tabindex=\"0\">en marcha</a>.</p>",
		'passages': {
		},
	},
	'cienaga fin': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n{if seen piedras:Tras un par más de volteretas y aterrizajes en falso, consigo dejar atrás las piedras}{else:Después de aplicar no poco esfuerzo, dejo por fin el fango atrás} y llego a una parte más &quot;normal&quot; de la ciénaga: terreno blando y pozas de agua hedionda.</p>\n<p>Vamos, un alivio comparado con lo que he tenido que atravesar antes.</p>\n<p>No llevo mucho rato andando cuando compruebo ¡con placer! que el suelo está cada vez más seco: he llegado al final de la ciénaga y nuevamente tengo frente a mí la llanura.</p>\n<p>Llevo poco menos de la mitad del camino recorrido, así que, con renovados bríos, <a class=\"squiffy-link link-section\" data-section=\"llanura continuacion\" role=\"link\" tabindex=\"0\">sigo adelante</a>.</p>",
		'attributes': ["puntaje+=1"],
		'passages': {
		},
	},
	'llanura continuacion': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nLa llanura se extiende frente a mi, como un vasto océano de pastos cuyas aguas mansas agita el viento como una <a class=\"squiffy-link link-passage\" data-passage=\"suave caricia\" role=\"link\" tabindex=\"0\">suave caricia</a>.</p>\n<p>Ya no sé si estoy o no en régimen mental de exploración profunda, pues tras andar apenas unos pasos me veo caminando casi como si estuviera <a class=\"squiffy-link link-passage\" data-passage=\"dormido\" role=\"link\" tabindex=\"0\">dormido</a>.</p>\n<p>No estoy comentando nada lo que veo ni estoy fijando la vista en aspecto alguno del paisaje.</p>\n<p>Pierdo la noción del tiempo...</p>\n<p>...y simplemente <a class=\"squiffy-link link-section\" data-section=\"animales\" role=\"link\" tabindex=\"0\">avanzo</a>.</p>",
		'attributes': ["seccion=Llanura"],
		'passages': {
			'suave caricia': {
				'text': "<p>El aire se siente fresco y tibio, casi como si estuviera en un <a class=\"squiffy-link link-passage\" data-passage=\"baño de relajación\" role=\"link\" tabindex=\"0\">baño de relajación</a>.</p>",
			},
			'baño de relajación': {
				'text': "<p>Espero poder tomar uno cuando vuelva a la nave: restauran el equilibrio químico del cuerpo y la mente.</p>",
			},
			'dormido': {
				'text': "<p>Apenas siento el {if traje=0:<a class=\"squiffy-link link-passage\" data-passage=\"traje\" role=\"link\" tabindex=\"0\">traje</a>}{else:traje} que llevo puesto, cosa que sería alarmante en otro caso.<BR><BR>\nAhora podría importarme menos...</p>",
			},
			'traje': {
				'text': "<p>{descripcion traje}</p>",
				'attributes': ["traje+=1"],
			},
		},
	},
	'animales': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nEl sueño no dura demasiado, en todo caso, pues el {if traje=0:<a class=\"squiffy-link link-passage\" data-passage=\"traje\" role=\"link\" tabindex=\"0\">traje</a>}{else:traje} me &quot;despierta&quot; con una {if advertencia=1:vibración seca}{else:<a class=\"squiffy-link link-passage\" data-passage=\"vibración seca\" role=\"link\" tabindex=\"0\">vibración seca</a>}: hay alguna cosa más adelante que requiere mi atención consciente.</p>\n<p>De hecho, son <I>varias</I> cosas.</p>\n<p>A un costado, hay varios <a class=\"squiffy-link link-passage\" data-passage=\"animales grandes\" role=\"link\" tabindex=\"0\">animales grandes</a> ocupados en comer hierba; junto a ellos, a un trecho corto, se ve un grupo de <a class=\"squiffy-link link-passage\" data-passage=\"animales pequeños\" role=\"link\" tabindex=\"0\">animales pequeños</a> que están, aparentemente, descansando.</p>\n<p>No es <a class=\"squiffy-link link-passage\" data-passage=\"buena idea\" role=\"link\" tabindex=\"0\">buena idea</a> pasar entre ambos grupos, así que es cuestión de rodearlos: ya sea por el lado de las <a class=\"squiffy-link link-section\" data-section=\"grandes bestias\" role=\"link\" tabindex=\"0\">grandes bestias</a> que {label:1=ramonean en paz} o bien intentando esquivar a las... <a class=\"squiffy-link link-section\" data-section=\"criaturitas\" role=\"link\" tabindex=\"0\">criaturitas</a> que {label:2=no parecen estar molestando a nadie}.</p>",
		'passages': {
			'vibración seca': {
				'text': "<p>{descripcion vibracion}</p>",
				'attributes': ["advertencia+=1"],
			},
			'traje': {
				'text': "<p>{descripcion traje}</p>",
				'attributes': ["traje+=1"],
			},
			'animales grandes': {
				'text': "<p>Son cuadrúpedos el doble de altos que yo y más bien corpulentos, todos cubiertos de pelos... excepto por unos <a class=\"squiffy-link link-passage\" data-passage=\"enormes dientes\" role=\"link\" tabindex=\"0\">enormes dientes</a>, con los que escarban el suelo para soltar la hierba que devoran.<BR><BR>\nNo parecen interesados en niguna otra cosa, mucho menos en los otros animales aquí junto... ni en mí, de momento.</p>",
			},
			'enormes dientes': {
				'text': "<p>Son gruesos, curvos y se ven más bien afilados.</p>",
				'attributes': ["@replace 1=<p>no están exactamente indefensas</p>"],
			},
			'animales pequeños': {
				'text': "<p>Son... bueno, <I>parecen</I> ser bípedos, pues figuran casi como si estuvieran sentados. Salvo la cara, tienen el cuerpo completamente cubierto de un pelaje con manchas alargadas. En la boca les asoman unos <a class=\"squiffy-link link-passage\" data-passage=\"dientes pequeños\" role=\"link\" tabindex=\"0\">dientes pequeños</a>. Están con la vista fija en los otros animales aquí junto: a mí no me han hecho caso... hasta ahora.</p>",
			},
			'dientes pequeños': {
				'text': "<p>Muy cortos y muy agudos.</p>",
				'attributes': ["@replace 2=<p>pueden ser un gran problema</p>"],
			},
			'buena idea': {
				'text': "<p>No se me ocurre una mejor manera de llamar su atención, vaya.</p>",
			},
		},
	},
	'criaturitas': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nMe alejo un buen trecho antes de comenzar a rodearlos, procurando meter el menor ruido posible.</p>\n<p>Pero algo debo haber pisado en la hierba, pues escucho un fuerte <B>¡CRAK!</B>...</p>\n<p>...y <I>todos</I> los animalitos giran su rostro hacia mí para enseguida ponerse a andar, dando pequeños saltos, con los brazos colgando a los costados.</p>\n<p>¡Vienen hacia mí!</p>\n<p>Alarmado, me pongo a caminar más rápidamente, ante lo cual las bestezuelas comienzan a dar saltos más largos, a la par que abren sus bocas, repletas de dientecillos afilados.</p>\n<p>Francamente asustado, empiezo a correr desesperadamente...</p>\n<p><B>...pero ya siento la respiración de mis cazadores cerca mío.</B>\n{Final Muerte}</p>",
		'attributes': ["muerte+=1"],
		'passages': {
		},
	},
	'grandes bestias': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nMe alejo un buen trecho antes de comenzar a rodearlos, procurando meter el menor ruido posible.</p>\n<p>Los animales me ignoran completamente y siguen tragando plantas.</p>\n<p>Con un suspiro de alivio, continúo andando hasta <a class=\"squiffy-link link-section\" data-section=\"quebrada\" role=\"link\" tabindex=\"0\">perderlos de vista</a>.</p>",
		'passages': {
		},
	},
	'quebrada': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nTras caminar por una media hora o así, el {if traje=0:<a class=\"squiffy-link link-passage\" data-passage=\"traje\" role=\"link\" tabindex=\"0\">traje</a>}{else:traje} me anuncia con una {if advertencia=1:vibración seca}{else:<a class=\"squiffy-link link-passage\" data-passage=\"vibración seca\" role=\"link\" tabindex=\"0\">vibración seca</a>} que he llegado al borde de una quebrada muy ancha y profunda.</p>\n<p>Doy un vistazo a {if sistema=0:<a class=\"squiffy-link link-passage\" data-passage=\"mi muñeca\" role=\"link\" tabindex=\"0\">mi muñeca</a>}{else:mi muñeca} y, con alegría, veo que hay una señal de orientación encendida: el módulo de descenso está justo adelante <I>&quot;en una cota vertical marcadamente inferior a la actual&quot;</I>.</p>\n<p>Habrá que llegar, entonces, <a class=\"squiffy-link link-passage\" data-passage=\"al fondo de la cuestión\" role=\"link\" tabindex=\"0\">al fondo de la cuestión</a>, je.</p>\n<p>Bromas aparte, no se ve que sea trivial bajar hasta el fondo de la quebrada: el traje es bueno, pero no está hecho para resolver <I>esto</I> sin algo de esfuerzo por mi parte.</p>\n<p>Tendría que <a class=\"squiffy-link link-section\" data-section=\"quebrada borde\" role=\"link\" tabindex=\"0\">acercarme al borde de la quebrada</a> y ver si es practicable un escalada de descenso o bien <a class=\"squiffy-link link-section\" data-section=\"quebrada al llano\" role=\"link\" tabindex=\"0\">seguir caminando junto al borde</a> hasta encontrar terreno llano y una vez ahí recorrer la quebrada hasta encontrar el módulo.</p>",
		'attributes': ["seccion=Quebrada"],
		'passages': {
			'traje': {
				'text': "<p>{descripcion traje}</p>",
				'attributes': ["traje+=1"],
			},
			'vibración seca': {
				'text': "<p>{descripcion vibracion}</p>",
				'attributes': ["advertencia+=1"],
			},
			'mi muñeca': {
				'text': "<p>{descripcion sistema}</p>",
				'attributes': ["sistema+=1"],
			},
			'al fondo de la cuestión': {
				'text': "<p>Mis instructores decían que yo tenía un sentido de humor algo fastidioso, pero yo les respondía que, ante problemas de gravedad, había que saber tener un poco de <a class=\"squiffy-link link-passage\" data-passage=\"levedad\" role=\"link\" tabindex=\"0\">levedad</a>...</p>",
			},
			'levedad': {
				'text': "<p>No que a mis instructores les faltara algo de <a class=\"squiffy-link link-passage\" data-passage=\"razón\" role=\"link\" tabindex=\"0\">razón</a>, je...</p>",
			},
			'razón': {
				'text': "<p>Broma esta que les gustaba todavía menos, pues siempre se ha dicho que los exploradores somos gente con tendencia a llevar a cabo <a class=\"squiffy-link link-passage\" data-passage=\"acciones arrojadas\" role=\"link\" tabindex=\"0\">acciones arrojadas</a>...</p>",
			},
			'acciones arrojadas': {
				'text': "<p>Lo que en el caso de esta quebrada...<BR><BR>\nSe entiende ¿no? &quot;arrojadas&quot;...<BR><BR>\nBueno, lo dejo, sin audiencia ya no tiene gracia.</p>",
			},
		},
	},
	'quebrada al llano': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nCamino a buen ritmo durante una hora o así, siempre siguiendo el borde de la quebrada, un límite al que no he querido {if seen quebrada borde:<a class=\"squiffy-link link-passage\" data-passage=\"riesgo\" role=\"link\" tabindex=\"0\">volver a acercarme</a>}{else:<a class=\"squiffy-link link-passage\" data-passage=\"riesgo\" role=\"link\" tabindex=\"0\">acercarme más</a>}: el terreno es muy parecido al de la llanura y no supone mayor esfuerzo... especialmente al compararlo con mi paso por {if seen bosque inicio:el bosque}{else:la ciénaga}.</p>\n<p>Al cabo de un rato, noto que al lado mío el terreno se ensancha a la par que disminuye la profundidad de las paredes que dan forma a la quebrada, a cuyo extremo más llano por fin me estoy acercando.</p>\n<p>De hecho, un afloramiento de agua entre los pastos se ha concentrado en el declive del suelo a la entrada de la quebrada, formando un hilo de agua que, en la distancia, da lugar a un río que corre todo lo largo del fondo de la quebrada y cuyo curso <a class=\"squiffy-link link-section\" data-section=\"rio\" role=\"link\" tabindex=\"0\">ahora empiezo a seguir</a>.</p>",
		'passages': {
			'riesgo': {
				'text': "<p>Bastantes peligros he enfrentado ya como para, justo ahora que estoy llegando al tramo final, empezar a correr riesgos.</p>",
			},
		},
	},
	'quebrada borde': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nAsomándome desde el borde puedo ver que el muro de la quebrada es sumamante escarpado y <I>casi</I> totalmente vertical, pero <a class=\"squiffy-link link-passage\" data-passage=\"no imposible\" role=\"link\" tabindex=\"0\">no imposible</a> para un descenso: simplemente más arriesgado... como ha sido hasta ahora buena parte de mi reconocimiento, por lo demás.</p>\n<p>La pared tienen dos rutas más bien marcadas: podría descender por una <a class=\"squiffy-link link-section\" data-section=\"muro rocas\" role=\"link\" tabindex=\"0\">zona rocosa</a>, donde no hay mayor asidero que algunos trozos de piedra salientes o alternativamente bajar por un sector muy <a class=\"squiffy-link link-section\" data-section=\"muro plantas\" role=\"link\" tabindex=\"0\">abundante en vegetación</a>, aunque sólo se ven plantas pequeñas: nada de árboles.</p>\n<p>Todavía puedo, si lo prefiero, optar por <a class=\"squiffy-link link-section\" data-section=\"quebrada al llano\" role=\"link\" tabindex=\"0\">seguir caminando junto al borde</a> hasta encontrar terreno llano... pero una vez que descienda por el muro ya no habrá vuelta atrás.</p>",
		'passages': {
			'no imposible': {
				'text': "<p>Nuestro entrenamiento ciertamente consideraba esta posibilidad y fuimos preparados arduamente para ello... y entonces no lo aprecié lo suficiente.<BR><BR>\nNo podré agradecerlo a mis instructores, pero si se me da la oportunidad, tendré un par de cosas que decirles a otros candidatos a exploradores.</p>",
			},
		},
	},
	'muro inicio': {
		'text': "<p>Comienzo a bajar por el muro, aferrándome con cuidado a {if seen muro plantas:las plantas}{else: las piedras salientes} y evitando cargar demasiado mi peso.</p>\n<p>Al principio voy lento pero según voy bajando mi entrenamiento se hace presente y mi ritmo de descenso va aumentando.</p>\n<p>Llevo un cuarto de camino recorrido cuando {if seen muro plantas:algo cae sobre mi cabeza}{else: observo algo interesante en la pared}.</p>",
		'passages': {
		},
	},
	'muro plantas': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n{muro inicio}</p>\n<p>Sacudo la cabeza y descubro que lo que me cayó encima <I>era una planta</I>.</p>\n<p>Preocupado, miro hacia arriba...</p>\n<p>...donde se ve que varias plantas que usé recién como apoyo están <I>separándose del muro</I>.</p>\n<p>¡Y desde más arriba, veo una autentica lluvia de plantas que viene hacia mí!</p>\n<p>Asustado, intento acelerar el ritmo de mi bajada...</p>\n<p><B>...pero las plantas a las que me aferro se sueltan ya del muro...</B>\n{Final Muerte}</p>",
		'attributes': ["muerte+=1","seccion=Muro"],
		'passages': {
		},
	},
	'muro rocas': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n{muro inicio}</p>\n<p>Un poco más abajo, se ve la <a class=\"squiffy-link link-passage\" data-passage=\"entrada\" role=\"link\" tabindex=\"0\">entrada de una caverna</a> en la pared del muro.</p>\n<p>No me costaría demasiado desviarme un poco para <a class=\"squiffy-link link-section\" data-section=\"caverna\" role=\"link\" tabindex=\"0\">explorarla</a>, aunque probablemente lo menos arriesgado sería continuar <a class=\"squiffy-link link-section\" data-section=\"rio\" role=\"link\" tabindex=\"0\">el descenso</a> y llegar así al suelo al pie del muro.</p>",
		'attributes': ["seccion=Muro"],
		'passages': {
			'entrada': {
				'text': "<p>No se distingue gran cosa desde aquí, pero estoy seguro de que podré hacer pie en el borde y entrar sin demasiados problemas</p>",
			},
		},
	},
	'nuevos parametros': {
		'text': "<p>Esto cambia <B>completamente</B> los parámetros de la misión, pues es un indicio clarísimo de que hay {if seen lemures:<I>otros</I> seres}{else:seres} inteligentes en este mundo{if seen lemures: con un grado de inteligencia mucho más avanzado que lo que mi encuentro en el bosque me dió a entender}{else:, pese a la falta de evidencia observada hasta aquí en mi reconocimiento}.</p>",
		'passages': {
		},
	},
	'caverna': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nUna vez en la entrada de la cueva, me apoyo en la pared y me tomo unos momentos para que mi vista se acostumbre a la penumbra... y para <a class=\"squiffy-link link-passage\" data-passage=\"descansar un poco\" role=\"link\" tabindex=\"0\">descansar un poco</a>, no lo niego.</p>\n<p>Una vez que percibo mejor las cosas, hago un recorrido visual del lugar, no demasiado distinto a <a class=\"squiffy-link link-passage\" data-passage=\"otras cavernas\" role=\"link\" tabindex=\"0\">otras cavernas</a> que he visitado en mi colonia o en las paradas anteriores de la misión.</p>\n<p>Estoy disponiéndome ya a retomar la escalada cuando veo algo extraño en una esquina al fondo de la cueva: se trata de un pequeño apilamiento de piedras.</p>\n<p>Me acerco a mirarlas en más detalle y constato, perplejo que el apilamiento <I>no es natural</I>: sigue un patrón alargado y angosto sumamente preciso y que ya he visto antes.</p>\n<B>Sin darme cuenta, he entrado a una tumba.</B>\n\n<p>{nuevos parametros}</p>\n<p>Compruebo que no he perturbado nada del lugar y me retiro con cuidado, retomando a continuación <a class=\"squiffy-link link-section\" data-section=\"rio\" role=\"link\" tabindex=\"0\">el descenso</a>.</p>",
		'attributes': ["puntaje+=1","inteligencia+=1","seccion=Caverna"],
		'passages': {
			'descansar un poco': {
				'text': "<p>Mi entrenamiento me preparó en lo técnico, pero nunca jamás había hecho un descenso tan prolongado.</p>",
			},
			'otras cavernas': {
				'text': "<p>Artísticas o naturales, todas suelen parecerse bastante.</p>",
			},
		},
	},
	'rio': {
		'clear': true,
		'text': "<p>{PUNTAJE}\n{if seen muro rocas:Llegando al suelo, me encuentro junto a}{else:Voy ahora avanzando por} la ribera de un río que recorre todo a lo largo el fondo de la quebrada.</p>\n<p>Sus aguas, limpias y brillantes, {if seen caverna:sólo sirven como contraste a la desazón que tengo, pese a estar ya en el}{else:reflejan el entusiasmo con que acometo este} tramo final de mi arduo periplo de reconocimiento. En efecto, pronto estaré de vuelta en mi nave y {if seen caverna:tendré que reportar que este mundo no puede ser}{else:podré reportar que este mundo puede ser} candidato a una nueva colonia.</p>\n<p>Con el ánimo {if seen caverna:apesadumbrado, avanzo lento y cabizbajo}{else:en alto, voy con paso ligero} bordeando la orilla del río, que corre {if seen caverna:indiferente}{else:alegremente} junto a mí.</p>\n<p>Un poco más adelante, me parece {if seen caverna:distinguir}{else:ver unas <a class=\"squiffy-link link-section\" data-section=\"piedras talladas\" role=\"link\" tabindex=\"0\">piedras de formas curiosas</a> en la orilla del río: casi las he pasado por alto pues, a poco andar, se divisa} la silueta redondeada del módulo de ascenso, al que <a class=\"squiffy-link link-section\" data-section=\"modulo ascenso\" role=\"link\" tabindex=\"0\">finalmente he llegado</a>.</p>",
		'attributes': ["seccion=Río"],
		'passages': {
		},
	},
	'piedras talladas': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nMe acerco a mirar las piedras con más detalle y constato, perplejo, que las formas que atrajeron mi atención <I>no son naturales</I>: se trata de piedras talladas a mano, algunas enteras y otras rotas.</p>\n<B>He dado con unas herramientas abandonadas.</B>\n\n<p>{nuevos parametros}</p>\n<p>Compruebo que no he perturbado nada del lugar y me retiro con cuidado, retomando el andar hacia <a class=\"squiffy-link link-section\" data-section=\"modulo ascenso\" role=\"link\" tabindex=\"0\">el módulo de ascenso</a>.</p>",
		'attributes': ["puntaje+=1","inteligencia+=1"],
		'passages': {
		},
	},
	'modulo ascenso': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nPor fin tengo ante mí el módulo para ascenso orbital, del que me ví accidentalmente separado y con el que por fin he logrado reencontrarme.</p>\n<p>Sus formas redondeadas, que <a class=\"squiffy-link link-passage\" data-passage=\"conozco bien\" role=\"link\" tabindex=\"0\">conozco bien</a>, se me antojan ahora muy hermosas, {if inteligencia=1:pese a tener un gusto amargo por}{else:especialmente dado lo fructífero de} mi reconocimiento planetario: en verdad, {if inteligencia=1:no}{else:ya} estoy deseando estar de regreso en la nave para entregar mi reporte.</p>\n<p>Aunque podría <a class=\"squiffy-link link-section\" data-section=\"contacto\" role=\"link\" tabindex=\"0\">abordarlo</a> ya mismo, <a class=\"squiffy-link link-passage\" data-passage=\"la prudencia\" role=\"link\" tabindex=\"0\">la prudencia</a> aconseja realizar una <a class=\"squiffy-link link-section\" data-section=\"inspeccion\" role=\"link\" tabindex=\"0\">revisión general</a> antes del despuegue y evitar así algún problema, <I>justo ahora</I>. </p>",
		'attributes': ["puntaje+=1","seccion=Módulo de ascenso"],
		'passages': {
			'conozco bien': {
				'text': "<p>En el entrenamiento debo haber hecho no menos de diez aterrizajes y despegues en distintas partes de mi colonia.</p>",
			},
			'la prudencia': {
				'text': "<p>En realidad, es más entrenamiento que otra cosa. No guardo buenos recuerdos de lo que me hicieron pasar los instructores en las ocasiones en que, durante el entrenamiento, <I>no</I> he cumplido con este pre chequeo...</p>",
			},
		},
	},
	'inspeccion': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nCamino en torno al módulo, buscando escoraciones o trozos faltantes: el ingreso a la atmósfera es de lejos la parte más dura de la misión y sólo la <a class=\"squiffy-link link-passage\" data-passage=\"robustez y autosuficiencia\" role=\"link\" tabindex=\"0\">robustez y autosuficiencia</a> de estos aparatos me da algo de tranquilidad, después de un recorrido accidentado <a class=\"squiffy-link link-passage\" data-passage=\"como pocos\" role=\"link\" tabindex=\"0\">como pocos</a>.</p>\n<p>Todo parece estar en orden, así que, con {if inteligencia=1:algo de resignación}{else:con la satisfacción del trabajo bien hecho} me dispongo a <a class=\"squiffy-link link-section\" data-section=\"contacto\" role=\"link\" tabindex=\"0\">subir a bordo</a>.</p>",
		'passages': {
			'robustez y autosuficiencia': {
				'text': "<p>Al igual que la astronave, el módulo puede aprovechar casi <I>cualquier</I> material para reparar partes desgastadas o perdidas: agua, arena, tierra, polvo... todo se puede reutilizar para hacer reparaciones o reconstrucciones.</p>",
			},
			'como pocos': {
				'text': "<p>No tengo recuerdo de ningún perfil de misión, histórico o simulado, que incluyera <I>todo</I> lo que me ha pasado en este mundo.</p>",
			},
		},
	},
	'contacto': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nEstoy alargando la mano al fuselaje para generar una compuerta cuando, entre mi mano y el módulo, surge un holograma tenue, como una nubecilla azul.</p>\n<p>Desconcertado, retrocedo un par de pasos pues esto <I>nunca</I> había pasado en ninguna misión, simulación o entrenamiento... y el módulo de ascenso no está programado para nada más sofisticado que, en una emergencia, solicitar un vehículo de reemplazo a la nave, la que ciertamente no puede generar hologramas a esta distancia.</p>\n<p>Es totalmente incomprensible pero, curiosamente, no siento en este momento temor alguno: al contrario, siento una cierta alegría expectante, como si el holograma... cómo decirlo... me estuviera extendiendo una invitación.</p>\n<p>Así que, no sabiendo qué esperar, me acerco al holograma y <a class=\"squiffy-link link-section\" data-section=\"reencuentro\" role=\"link\" tabindex=\"0\">lo toco</a>.</p>",
		'passages': {
		},
	},
	'reencuentro': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nComo en un sueño, el paisaje a mi alrededor se desvanece y en su lugar se materializa bajo mío, como en los cuentos de mi infancia, una hermosa loma de arena, en la que estoy lánguidamente tendido.</p>\n<p>Descubro que ya no tengo el traje puesto y siento en mis escamas el tacto sensual de los gránulos, suaves y tibios, invitándome a extender y a hundir bajo la arena cada uno de mis cuatro dedos, como cuando era un niño y volvía al nido comunal al final del día.</p>\n<p>Giro la cabeza para acomodarme y descubro que no estoy solo, pues junto a mi está tendido uno de mis antiguos preceptores, cosa imposible pues todos ellos habían muerto mucho antes de que yo saliera en misión.</p>\n<p>Lo miro desconcertado, pero mi antiguo maestro se limita a mirarme y entonces escucho su voz, aunque no parezca <a class=\"squiffy-link link-section\" data-section=\"desde el pasado\" role=\"link\" tabindex=\"0\">estar hablando</a>.</p>",
		'attributes': ["seccion=Reencuentro"],
		'passages': {
		},
	},
	'desde el pasado': {
		'clear': true,
		'text': "<p>{PUNTAJE}</p>\n<I><P>Te saludo desde tu futuro, viajero de nuestro pasado.</P>\n<P>Me presento ante ti usando la forma de alguien por ti conocido: he tomado prestada esta imagen pues no quiero alarmarte o atemorizarte con mi verdadera apariencia. Mucho ha cambiado nuestra corporalidad; tanto así que incluso a ti, que conoces otros mundos, te resultaría algo chocante.</P>\n<P>El mundo en que te encuentras no es un mundo nuevo, sino más bien uno que, en nuestra huida a las estrellas, olvidamos y perdimos en la memoria y la distancia.</P>\n<P>Estás en el <B>Nido Original</B>, nuestro planeta nativo, un planeta hermoso que incluso nosotros, gentes de los tiempos por venir, jamás hemos querido volver a visitar.</P>\n<P>Supimos reencontrarlo en nuestros largos viajes, pero decidimos apartarnos, pues una vez más había sido fuente de vida y dado lugar a otras criaturas inteligentes: gentes diferentes a nosotros, pero que también estaban iniciando su propio <a class=\"squiffy-link link-section\" data-section=\"hacia el futuro\" role=\"link\" tabindex=\"0\">camino a las estrellas</a>.</P></I>",
		'passages': {
		},
	},
	'hacia el futuro': {
		'clear': true,
		'text': "<p>{PUNTAJE}</p>\n<I><P>Cuando reencontramos el Nido, habían pasado océanos de tiempo desde el tuyo al nuestro.</P>\n<P>Y navegando esos mares descubrimos que el tiempo y las realidades que crea son como un río.</P>\n<P>Un río cuyo curso a veces se bifurca y se vuelve a encontrar, pero no siempre del mismo modo.</P>\n<P>Remontándolo en viaje de memoria y recuerdo, no queríamos cambiar nuestra propia historia, pero tampoco deseábamos que, por algún accidente o error, se trastocara el devenir de este mundo, que fue nuestra cuna y lo será de muchas otras gentes por venir.</P>\n<P>Gentes distintas a nosotros, con otros cuerpos y otras mentes: con su propia sabiduría, que no necesariamente compartimos y <a class=\"squiffy-link link-section\" data-section=\"despedida\" role=\"link\" tabindex=\"0\">no deseábamos influenciar</a>.</P></I>",
		'passages': {
		},
	},
	'despedida': {
		'clear': true,
		'text': "<p>{PUNTAJE}</p>\n<I><P>Este mensaje quedará en tu mente y podrás comunicarlo a tus hermanos y hermanas, quienes no dudamos sabrán cuidar este planeta, alejándose cuando sea necesario, para dar lugar a los muchos pueblos que de aquí surgirán y que lo llamarán con muchos nombres: Oceánica, Nido, Jardín, Tierra, Acqua...</P>\n<P>...muchos nombres para muchos pueblos que desde aquí, con mejor o peor fortuna, dieron y darán sus primeros pasos a la inteligencia, en el tiempo y en las estrellas.</P>\n<P>Nosotros deseamos que este planeta sea preservado y esperamos que sea también vuestro deseo y el de todos quienes lleguen a habitarlo.</P>\n<P>Lo que esas gentes decidan hacer con este mundo, según el brazo del río del tiempo que decidan navegar... eso no es nuestro para cambiarlo.</P>\n<P>Desde tu futuro a nuestro pasado, nos despedimos con un <a class=\"squiffy-link link-section\" data-section=\"Final\" role=\"link\" tabindex=\"0\">abrazo de paz</a>.</P></I>",
		'passages': {
		},
	},
	'Final Muerte': {
		'text': "<p><BR></p>\n<FONT face=\"Viner Hand ITC\" color=\"red\" size=5><B>Aquí terminan mi misión y mi vida&nbsp;</B></FONT><BR><BR>\n<FONT size=4>Puedes revisar tu <a class=\"squiffy-link link-section\" data-section=\"Puntuacion\" role=\"link\" tabindex=\"0\">puntuación</a> o {label:1=<a class=\"squiffy-link link-section\" data-section=\"Reiniciar\" role=\"link\" tabindex=\"0\">reiniciar</a>} el relato.</FONT>",
		'passages': {
		},
	},
	'Puntuacion': {
		'text': "<B>Puntuación:</B>\n\n<p>Has conseguido {puntaje} punto{if puntaje=1: }{else:s }de 4 así que calificas como \n{if puntaje=0: <b>pisaverde</b></p>\n<p>Te limitaste a pasear por el lugar...}\n{if puntaje=1: <b>explorador novato</b>.}\n{if puntaje=2: <b>explorador avanzado</b>.}\n{if puntaje=3: <b>explorador experto</b>.}\n{if puntaje=4: <b>instructor de exploradores</b>.}</p>\n<p>{if seen lemures:+1 Descubriste primates camino a la inteligencia<br>}\n{if seen bosque fin:+1 Atravesaste el bosque<br>}\n{if seen cienaga fin:+1 Atravesaste la ciénaga<br>}\n{if seen caverna:+1 Encontraste evidencia de vida inteligente nativa<br>}\n{if seen piedras talladas:+1 Encontraste evidencia de vida inteligente nativa<br>}\n{if seen modulo ascenso:+1 Llegaste al módulo de ascenso<br>}</p>",
		'attributes': ["@replace 1=<p><a class=\"squiffy-link link-section\" data-section=\"Reiniciar\" role=\"link\" tabindex=\"0\">reiniciar</a></p>"],
		'passages': {
		},
	},
	'Final': {
		'clear': true,
		'text': "<p>{PUNTAJE}\nMe encuentro de vuelta frente al módulo de ascenso, mirando este mundo como si hubiera salido nuevamente del huevo y estuviera abriendo los ojos por vez primera.</p>\n<p>Todo está como antes pero es a la vez distinto, pues aunque me he reencontrado con el Nido, ya no puedo quedarme en él.</p>\n<p>Otros {if inteligencia=1:han venido ya}{else:han de venir} a desovar aquí y criarán sus propios polluelos.</p>\n<p>Y como nosotros, querrán tener un lugar limpio para crecer en paz.</p>\n<p>Con un suspiro, el módulo se abre a mi contacto y me recibe, cerrándose suavemente en torno a mí.</p>\n<p>Y mientras me adormezco para el despegue, pienso en el río del tiempo y en los océanos a los que nos llevará...</p>\n<FONT face=\"Viner Hand ITC\" color=\"green\" size=10>F&nbsp;I&nbsp;N&nbsp;</B></FONT><BR><BR>\n<FONT size=4>Puedes revisar tu <a class=\"squiffy-link link-passage\" data-passage=\"Puntuacion\" role=\"link\" tabindex=\"0\">puntuación</a>, leer los <a class=\"squiffy-link link-passage\" data-passage=\"Agradecimientos\" role=\"link\" tabindex=\"0\">agradecimientos</a>, mirar las <a class=\"squiffy-link link-passage\" data-passage=\"Curiosidades\" role=\"link\" tabindex=\"0\">curiosidades</a>, saber más <a class=\"squiffy-link link-passage\" data-passage=\"Acerca de\" role=\"link\" tabindex=\"0\">acerca de la creación de &quot;Reencuentro&quot;</a> o <a class=\"squiffy-link link-section\" data-section=\"Reiniciar\" role=\"link\" tabindex=\"0\">reiniciar</a> el relato.</FONT>",
		'attributes': ["seccion=Despegue"],
		'passages': {
			'Puntuacion': {
				'text': "<B>Puntuación:</B>\n\n<p>Has conseguido {puntaje} punto{if puntaje=1: }{else:s }de 4 así que calificas como \n{if puntaje=0: <b>pisaverde</b></p>\n<p>Te limitaste a pasear por el lugar...}\n{if puntaje=1: <b>explorador novato</b>.}\n{if puntaje=2: <b>explorador avanzado</b>.}\n{if puntaje=3: <b>explorador experto</b>.}\n{if puntaje=4: <b>instructor de exploradores</b>.}</p>\n<p>{if seen lemures:+1 Descubriste primates camino a la inteligencia<br>}\n{if seen bosque fin:+1 Atravesaste el bosque<br>}\n{if seen cienaga fin:+1 Atravesaste la ciénaga<br>}\n{if seen caverna:+1 Encontraste evidencia de vida inteligente nativa<br>}\n{if seen piedras talladas:+1 Encontraste evidencia de vida inteligente nativa<br>}\n{if seen modulo ascenso:+1 Llegaste al módulo de ascenso<br>}</p>",
			},
			'Agradecimientos': {
				'text': "<B>Agradecimientos:</B>\n\n<p>El autor quiere agradecer a:</p>\n<ul>\n<li>A Comely por su testing.</li>\n<li>A Jade, por los consejos que me llevaron de vuelta a la autoría.</li>\n<li>A Alex Warren, por crear Squiffy, con el que pude construir este hiperrelato.</li>\n<li>A los exploradores de todos los mundos, en todos los tiempos.</li>\n</ul>",
			},
			'Curiosidades': {
				'text': "<B>Curiosidades:</B>\n\n<ul>\n<li>Has llegado a un sistema solar muy particular, obsérvalo con cuidado usando la vista externa.</li>\n<li>Tu traje es muy especial, estate atento a sus particularidades.</li>\n<li>El bosque esconde secretos que dan pistas sobre el destino de este mundo, no te apures y los descubrirás.</li>\n<li>El protagonista tiene un sentido de humor... particular: explóralo.</li>\n<li>Cuando estés en el acceso a la quebrada, independiente del camino que tomes, no dejes de observar todo cuanto te rodea.</li>\n</ul>",
			},
			'Acerca de': {
				'text': "<B>Acerca de &quot;Reencuentro&quot;</B>\n<BR>\n<BR>\n<B>Sobre la creación de la obra</B>\n\n<p>Este trabajo se creó originalmente para participar en la competencia &quot;Rayuela de Arena&quot;, durante Mayo del 2023.</p>\n<p>Tenía entonces entre manos un proyecto sumamente desarrollado para crear una aventura conversacional, pero no había avanzado hacia la programación por cuestiones creativas y de tiempo libre.</p>\n<p>Cuando se abrió el periodo creativo de la &quot;Rayuela&quot; terminó de cuajar en mi mente (y en una libreta de apuntes: ¡Gracias, Jade!) una idea para un relato que <I>podía</I> alcanzar a desarrollar, probar y publicar en el plazo de la jam.</p>\n<p>Me lancé a escribir y programar, que en <a href=\"https://www.ifwiki.org/Squiffy\" target=\"_blank\">Squiffy</a> es todo casi la misma cosa...</p>\n<p>...y el resultado es lo que tiene el lector en sus manos.</p>\n<B>Sobre el tema de la obra</B>\n\n<p>Uno de los tópicos favoritos de la ciencia ficción es la exploración del espacio en búsqueda de nuevos mundos y el encuentro con especies inteligentes extraterrestres.</p>\n<p>Esos relatos suelen enfocarse desde la perspectiva de los seres humanos como exploradores, por lo que la inteligencia hallada y el contacto, amén de la cooperación o competencia por recursos extra planetarios, son posibles (o no) desde un punto de vista narrativo que suele ser, también, estrictamente humano.</p>\n<p>En cuanto a la búsqueda de inteligencia no humana en nuestro propio mundo, visitas extraterrestres aparte, poco y nada hay que no se cirscunscriba a mamíferos percibidos como algo más que hábiles... siempre bajo la óptica humana, claro está.</p>\n<p>Que otras especies hayan llegado a la inteligencia en nuestro mundo <I>antes</I> que nosotros rara vez suele plantearse, en la ficción o fuera de ella, argumentando la falta de evidencia arqueológica, evidencia que, lo habrá adivinado el lector, suele buscarse con nuestros criterios humanos.</p>\n<p>¿Hay espacio en los millones de años de historia de nuestro planeta para otras inteligencias, con otros desarrollos tecnológicos que no hayan dejado huella alguna de su paso en nuestro planeta?</p>\n<p>¿Y si nos aventuramos a comparar los cientos de millones de años de los reptiles en nuestro mundo con la escasa carrera evolutiva de los primates que dieron origen a nuestra humanidad?</p>\n<p>Los moluscos, mucho antes de los dinosaurios y durante mucho más tiempo que ellos ¿fueron también <I>necesariamente</I> un callejón sin salida?</p>\n<p>Quiera el lector reflexionar sobre estas y otras supuestamente irrefutables &quot;verdades&quot; que hemos construido en nuestro ¡tan comparativamente breve! paso por este mundo.</p>\n<p>Pues el tiempo y las realidades que crea son como un río, cuyo curso a veces se bifurca y se vuelve a encontrar.</p>\n<p>Pero no siempre del mismo modo.</p>\n<p>Santiago de Chile, 26 de Mayo, 2023</p>",
			},
		},
	},
	'Reiniciar': {
		'text': "",
		'js': function() {
			squiffy.story.restart();
		},
		'passages': {
		},
	},
}
})();