/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import java.util.HashMap;
import java.util.Map;
import org.zmpp.base.MemoryReadAccess;
import org.zmpp.encoding.ZCharDecoder;
import org.zmpp.encoding.ZsciiString;
import org.zmpp.vm.AbstractDictionary;
import org.zmpp.vm.DictionarySizes;

public class DefaultDictionary
extends AbstractDictionary {
    private Map<ZsciiString, Integer> lookupMap;
    private int maxEntrySize;

    public DefaultDictionary(MemoryReadAccess memoryReadAccess, int n, ZCharDecoder zCharDecoder, DictionarySizes dictionarySizes) {
        super(memoryReadAccess, n, zCharDecoder, dictionarySizes);
        this.createLookupMap();
    }

    public int lookup(ZsciiString zsciiString) {
        ZsciiString zsciiString2 = this.truncateToken(zsciiString);
        if (this.lookupMap.containsKey(zsciiString2)) {
            return this.lookupMap.get(zsciiString2);
        }
        return 0;
    }

    protected int getMaxEntrySize() {
        return this.maxEntrySize;
    }

    private void createLookupMap() {
        this.lookupMap = new HashMap<ZsciiString, Integer>();
        int n = this.getNumberOfEntries();
        for (int i = 0; i < n; ++i) {
            int n2 = this.getEntryAddress(i);
            ZsciiString zsciiString = this.getDecoder().decode2Zscii(this.getMemoryAccess(), n2, this.getSizes().getNumEntryBytes());
            this.maxEntrySize = Math.max(zsciiString.length(), this.maxEntrySize);
            this.lookupMap.put(zsciiString, n2);
        }
    }
}

