#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>
#include "AHA.h"

/* The in-game hints for All Hope Abandon */

topHintMenu : TopHintMenu 'Give Me a Hint'
;

+ Goal 'What am I meant to be doing in the lecture room?'
    [
        'First, listen to Wortschlachter\'s lecture; although he\'s talking a
        good deal of tosh, some of it may turn out to be more relevant than you
        realize. ',
        'Take the opportunity to examine your surroundings, and, more
        particularly, yourself and your inventory. ',
        'You could also try thinking about a few things too. ', 
        'You don\'t have to worry about having to make anything happen at this
        stage; things will pretty soon start happening of their own accors, and
        it\'ll be quite obvious when they do. '
    ]
    openWhenSeen = lectureRoom
    closeWhenSeen = limbo
;

+ Goal 'Am I meant to be doing anything in particular in the breakfast queue?'
    [
        'Only the obvious. ',
        'Just keep talking to the blonde woman. '
    ]
    openWhenSeen = blondeWoman
    closeWhenTrue = !gPlayerChar.canSee(blondeWoman)
;


+ Goal 'Well, I\'ve arrived in the grey limbo, so what do I do now?'
    [
        'Explore as widely as you can. ',
        'You could also try talking to the demon. '
    ]
    openWhenSeen = limbo
    closeWhenSeen = ropeBridge
;

+ Goal 'I\'ve run out of places to explore; now what do I do?'
    [
        'Is there anywhere you\'ve tried to go that might be worth trying again
        now you\'ve explored more widely?',
        'You have explored the area to the east of Hell\'s Gate, haven\'t you?',
        'What did you find there?',
        'Is there something you could try getting into?',
        'What\'s sticking out of the rocks?',
        'How big is the pipe?',
        'Might it lead somewhere?',
        'ENTER THE PIPE'    
    ]
    openWhenSeen = ropeBridge
    closeWhenSeen = insideBoiler
;

+ Goal 'I can\'t crawl into the pipe. '
    [
        'Something seems to be blocking it. ',
        'You need to remove that cable somehow. ',
        'But it seems unwilling to budge. ',
        'Maybe you need to cut it. ',
        'You need something sharp. ',
        'If you haven\'t already done so, maybe you should explore 
        elsewhere. ',
        'Try going west from Hell\'s Gate, and then explore as
        thoroughly as you can. ',
        'You should soon come across a knife. ',   
        'Use the knife to cut the cable. '   
    ]
    openWhenRevealed = 'pipe-cable'
    closeWhenTrue = pipeCable.hasBeenCut
;

+ Goal 'How do I get out of the boiler?'
    [
        'How closely have you examined your surroundings? ',
        'The only door out is locked. What might unlock it? ',
        'What\'s left inside the boiler?',
        'How closely have you searched your surroundings?',
        'SEARCH THE ASH',
        'What did this search reveal?',
        'What might you do with it?',
        'PULL THE HANDLE',
        'The door is now unlocked; you should be able to open it and go OUT'   
    ]
    openWhenSeen = insideBoiler
    closeWhenSeen = boilerRoom
;

+ Goal 'A door snaps shut when I try to leave the Long Hall to the northeast. '
    [
        'How carefully have you examined the arch? ',
        'And, more particularly, what\'s above the arch. ',
        'Namely the brass sign. ',
        'Does the brass sign contain anything that looks like an instruction? ',
        'How might you go about leaving the past behind?',
        'Are you carrying anything from the past?',
        'Perhaps everything you\'re carrying is from the past in some sense --
        from <i>your</i> past at least. ',
        'Drop everything you\'re carrying, then you can simply walk on through. '
    ]
    openWhenRevealed = 'snap-shut'
    closeWhenTrue = bunker.seen || maze1.seen
;

+ Goal 'What am I meant to be doing in the examination hall? '
    [
        'You have examined everything there carefully? ',
        'Including the slot in the north wall? ',
        'And what\'s on the desk? '
    ]
    openWhenSeen = examHall
    closeWhenDescribed = examPaper
    closeWhenSeen = maze1
    closeWhenTrue = (slotDoor.isOpen || viaModernaCorridor.seen)
;

+ Goal 'Am I meant to be answering the exam paper?'
    [
        'Yes, you are; but you can rely on the player character\'s knowledge to
        do so. ',
        'All you need to do to answer a question on the paper is to use the
        command ANSWER QUESTION <i>N</i>, where <i>N</i> is the number of the
        question (you can also abbreviate QUESTION to Q, e.g. ANSWER Q 1). ',
        penHint,
        'When you\'ve completed the exam paper you\'ll need to do something
        with it. '    
    ]
    openWhenDescribed = examPaper
    closeWhenTrue = (examBooklet.questionsAnswered.length >2 )
    closeWhenSeen = maze1
;

++ penHint : Hint 
    'But when you try you\'ll find you need something to write with. '
    [penGoal]
;

+ penGoal : Goal 'Where can I find something to write with? '
    [
        'How thoroughly have you searched the areas near the examination room? ',
        'You won\'t find anything of much use in the bunker -- what\'s outside? ',
        'What can you see from the battlefield apart from the bunker? ',
        'In particular, what other building? ',
        'How thoroughly have you searched the ruined church? ',
        'Where has the roof of the church ended up? ',
        'Have you searched the rubble? '    
    ]
    closeWhenTrue = pen.seen || maze1.seen
;

+ Goal 'I can\'t get the pen to write. Where can I find some ink?'
    [
        'Where might ink be used?',
        'What furniture was in the long hall? ',
        'Which bit of that furniture might you associate with writing? ',
        'The bureau opens into a desk. ',
        bureauHint
    ]
    openWhenRevealed = 'need-ink'
    closeWhenTrue = inkBottle.seen || maze1.seen
;  

++ bureauHint : Hint 'You need to open the bureau. '
    [bureauGoal]  
;

+ bureauGoal: Goal 'I can\'t get the bureau open. '
    [
        'How thoroughly have you searched the bureau? ',
        'What does it have besides an opening top?',
        'Have you looked in the drawers? ',
        'How carefully have you looked in the drawers? ',
        'What did you find there? ',
        'Could the lining paper be concealing anything? ',
        'Have you tried taking it or looking under it?',
        'If you open the top drawer and look under the lining paper
        you\'ll find a key that unlocks the bureau. '
    ]
    closeWhenTrue = inkBottle.seen
    closeWhenSeen = maze1 // at this point it's no longer relevant
    openWhenRevealed = 'bureau-locked'
;


+ Goal 'Is there any way to get objects from the Long Hall into the Bunker?'
    [
        'Yes there is -- but not through the snapping doors. ',
        'So you\'ll have to find another way. ',
        'You have investigated the Via Antiqua, haven\'t you? ',
        'In particular, you need to take a look round the ancient city. ',
        'Especially its buildings. ',
        'Try investigating the basilica. '
    ]
    openWhenTrue = (inkBottle.seen && gRevealed('need-ink'))
    closeWhenTrue = narthex.seen || maze1.seen
;

+ Goal 'Is there any way to get objects from the Long Hall into the Bunker?'
    [
        'Yes there is -- but not the most obvious way. ',
        'You\'ve been down the Via Antiqua; what did you find there? ',
        'In particular, in the ancient city. ',
        'What in the ancient city resembles something you\'ve seen
        elsewhere? ',
        'Something out on the battlefield near the Bunker? ',
        movieHint,
        'Could there be a relation between the ruined basilica on the
        battlefield and the basilica in the old city? ',
        'They\'re the same building at different times. ',
        'There are two ways to exploit that to get objects from the city church
        to the ruined church. ',
        'The simplest is simply to leave objects in the nave. ',
        cryptHint,
        'If you leave something in the nave of the intact basilica in the city
        you can pick it up in the ruined basilica on the battlefield by looking
        under the rubble in the nave. '
    ]
    openWhenTrue = (inkBottle.seen && gRevealed('need-ink') && narthex.seen)
    closedWhenTrue = pen.full
    closedWhenSeen = maze1 // at this point it's no longer relevant
;

++ movieHint : Hint 'Have you seen both of the motion pictures on display in
    the long hall?'
    [contraptionGoal]
;

++ cryptHint : Hint 'The other involves exploring the crypt more thoroughly. '
    [cryptGoal]
; 

+ contraptionGoal : Goal 'How do I get the strange contraption in the long hall
    to work?'
    [
        'What\'s attached to the contraption? ',
        'What might you do with the handle? ',
        'What might you do with the eyepiece? ',
        'Try looking through the eyepiece and then turning the handle. ',
        'Have you tried opening the flap? ',
        'What\'s inside the compartment? ',
        'Have you seen something else like the disk you found in the
        compartment? ',
        'Presumably you have looked in the red box. ',
        'There\'s another disk in there. ',
        'Try removing the black disk from the compartment and putting the grey
        one in instead. ',
        'Then look through the eyepiece and turn the handle. '
    ]
    closeWhenRevealed = 'movie-seen'
    closeWhenTrue = (maze1.seen || deconstruction.seen) // by then it's too late
;

+ cryptGoal : Goal 'What am I meant to be doing in the crypt (under the
    basilica in the ancient city) '
    [
        'How thoroughly have you searched it? ',
        'Is there anything about it that strikes you as a bit strange? ',
        'Could there be more than one way out? ',
        'Is there anything that looks like another way out? ',
        'Might there be a way of finding out if it actually is another way out? ',
        'Try giving it a push. ',
        'The painting, that is. '
    ]
    openWhenSeen = crypt
    closeWhenTrue = (gardenPainting.isOpen || maze1.seen)
    closeWhenSeen = deconstruction // there's no way back to the crypt from there
;

+ Goal 'What can I do in the dank cave next to the crypt? '
    [
        'How closely have you examined everything? ',
        'Perhaps there\'s another way out. ',
        'Where should you be in relation to the church? ',
        'Which way would you expect another way out to be? ',
        'Is there anything you could climb? ',
        'Is there anything that looks like it might be supporting something? ',
        'Is there anything that might be blocking your path if you did try to
        climb? ',
        'What would happen if you gave a prop a little push? ',
        'And then tried climbing it. '
        #ifdef __MULTIROUTE
        , skullStatueHint
        #endif
    ]
    openWhenSeen = gardenCave
    closeWhenTrue = flagstone.isOpen
;


+ Goal 'Okay, I\'ve answered three questions on the exam paper -- what now?'
    [
        'You did examine everything in the examination hall thoroughly, didn\'t
        you? ',
        'So you presumably found an obvious place to put the finished exam
        script. ',
        'Surely you\'ve found something in the room that tells you where to put
        it. ',
        'PUT SCRIPT IN SLOT. '
    ]
    openWhenTrue = (examBooklet.questionsAnswered.length >2 )
    closeWhenTrue = (slotDoor.isOpen || maze1.seen)
    closeWhenSeen = viaModernaCorridor
;

+ Goal 'How do I unlock the grey door?'
    [
        'You can\'t; whoever left the note in the control room took the key and
        went off with it after locking the door. '
    ]
    openWhenRevealed = 'greydoor-locked'
    closeWhenSeen = deconstruction
    closeWhenTrue = (maze1.seen)
;


+ Goal 'How do I escape from the Deconstruction Chamber?'
    [
        'Presumably you\'ve tried leaving using a movement command; what
        did that tell you?',
        'Well, there don\'t seem to be any obvious exits from the chamber, so
        you\'ll have to think of something else. ',    
        'Have you given it enough thought?',
        'You really should try thinking about it. ',
        'Have you noticed what happens on the screen when you think about
        things?',
        'Okay, so what might you want to think about in order to get out of
        this situation?',
        'A way out, presumably. ',
        'So try thinking about a way out. ',
        'Still haven\'t got it? THINK ABOUT A WAY OUT. '
    ]
    openWhenSeen = deconstruction
    closeWhenSeen = tombGarden
;

+ Goal 'How do I unlock the black door in the garden wall?'
    [
        'If it isn\'t obvious it probably isn\'t possible. ',
        'You should have brought the key with you. ',
        'The key you need is the large bronze one you should have found under
        the rubble in the nave. ',
        'If you\'ve left it behind, there\'s no way of retrieving it now, and
        no way of getting that door open. But since you don\'t actually need to
        go through it, there\'s no need to worry -- just go and explore
        somewhere else. '  
    ]
    openWhenRevealed = 'black-door-locked'
    closeWhenSeen = tomb
    closeWhenTrue = hinnomValley.seen || !smallBlackDoor.isLocked
;


+ Goal 'How do I go about selecting the right bead to give to the man in white?'
    [
        'Presumably you have tried asking that man in white. ',
        'For example, you have tried asking him about authenticity. ',
        'And then about the criteria. ',
        'Have you found the scroll yet? ',
        'If not, have you tried asking the bloke in white about it? ',
        'What he replies does contain a clue. ',
        'He said something about bones. ',
        'An ossuary is a bone box (try THINK ABOUT OSSUARY). ',
        'Look in the ossuary (you\'ll have to remove it from its niche first. '
    ]
    openWhenRevealed = 'bead-task'
    closeWhenSeen = criteria
;

+ Goal 'How do I go about selecting the right bead to give to the man in white?'
    [
        'Presumably, you have read the scroll. ',
        'Can you figure out from the scroll which bead or
        beads might meet the criteria? ',
        'What properties might the beads have that could make them resemble one
        another? ',
        'What properties might the beads have that make them different from one
        another? ',
        'There\'s no reason to suppose that there\'s only one correct solution. ',
        'In fact, any bead will do. ',
        'Pick whichever bead you like and give it to the young man in white. ',
        'And then answer YES to both his questions. '
    ]
    openWhenSeen = criteria
    closeWhenTrue = whiteYouth.isIn(nil)
;

+ Goal 'How do I unlock the ossuary?'
    [
        'How closely have you examined the ossuary? ',
        'What\'s on it?',
        'Is what\'s on it purely decorative, or is there something that could
        be manipulated in some way?',
        'You need to perform more than one manipulation. ',
        'And the order is important. ',
        'First, try pressing the menorah. ',
        'Then turn the rosette. '
    ]
    openWhenRevealed = 'ossuary-lock'
    closeWhenTrue = (!ossuary.subContainer.isLocked)
;


//+ Goal 'Can the blue door be unlocked?'
//  [
//    'Yes - but only by achieving other tasks first. ',
//    'Try the other two doors first, and then come back to the blue door. '
//  ]
//  openWhenSeen = lakeDoor
//  closeWhenTrue = (!lakeDoor.isLocked)
//;

//+ Goal 'Where do I go now?'
//  [
//    'Have you tried the blue door again? '
//  ]
//  openWhenTrue = (!lakeDoor.isLocked)
//  closeWhenSeen = lake
//;


+ Goal 'Where do I go from the lakeside?'
    [
        'There\'s a vast barren plain to the south. ',
        'But if you\'ve explored it you\'ll have found there\'s not much there. ',
        'So that just leaves the lake. ',
        'Does examining the shore remind you of anything Wortschlachter said in
        his lecture? ',
        'How did the professor say the binary opposition of land and sea was
        overcome in Mark\'s narrative? ',
        'What would happen if the lake was treated like dry land?',
        'WALK ON THE LAKE',
        'But perhaps that didn\'t work -- so what might be wrong? ',
        'Apparently you\'re too weighed down by worldly cares -- perhaps not so
        much like Peter who doubted (in Matthew 14.28-31) as the rich man who
        was unable to follow Jesus (in Mark 10.17-22). ',
        'Well, what\'s one obvious reason people can\'t walk on water? ',
        'Perhaps they\'re too heavy? ',
        'What could you do to make yourself lighter? ',
        'Perhaps you\'re carrying too much? ',
        'Given the extraordinary nature of what you\'re trying to do, perhaps 
        <i>anything</i> you\'re carrying is too much. ',
        'DROP ALL and then WALK ON THE LAKE. ' 
    ]
    openWhenSeen = lake
    closeWhenSeen = valley
;

+ Goal 'I can\'t get back up the slope from the Sleepy Glade'
    [
        'Is there some way you could make it seem less of an effort? ',
        'Is it only yourself that you\'re trying to drag back up? ',
        'Are you overburdened, perhaps? ',
        'Try dropping everything before you make the ascent -- there\'s nothing
        you need to take with you. '
    ]
    openWhenRevealed = 'drag-slope'
    closeWhenRevealed = 'slope-climbed'
;

+ Goal 'I can\'t open the rusty gate'
    [
        'How closely have you examined the gate? ',
        'What looks like it might be preventing the gate from opening? ',
        'Particularly near the lower end of the gate? ',
        'How might you dispose of this obstruction? ',
        'How do you normally get rid of weeds? ',
        'Try pulling the thorns and briars. '
    ]
    openWhenRevealed = 'rusty-gate'
    closeWhenTrue = !narrowGate.isLocked
;

+ Goal 'What am I meant to be doing on Skull Mountain?'
    [
        'You have examined everything there, haven\'t you? ',
        'The crow might give you a clue. ',
        'What is the crow doing? ',
        'Have you tried taking the bones? ',
        'Well, the crow won\'t let you take them, but he might let you search
        them. '
    ]
    openWhenSeen = skullMountain
    closeWhenSeen = wordPile
;

+ Goal 'What am I meant to do with the pile of words?'
    [
        'Is there anyone around that might tell you?',
        'Have you tried throwing the stone at the crow?'   
    ]
    openWhenSeen = wordPile
    closeWhenTrue = (titulus.attachedWord != nil)
    closeWhenRevealed = 'talking-crow'
;

++ titulusHint : Hint 
    'You need to attach a word to the titulus of the central cross'
    [whichWord]
;

+ Goal 'What am I meant to do with the pile of words?'
    [
        'You\'ll have discovered that the crow can talk. ',
        'So you could try asking the crow. ',
        'What did the crow tell you when you asked him about the words? ',
        'What objects already have words? ',
        'So what object is missing a word? ',
        'How carefully have you examined the central cross?',
        'What about its titulus?',
        titulusHint      
    ]
    openWhenTrue = gRevealed('talking-crow') && wordPile.described
    closeWhenTrue = (titulus.attachedWord != nil)
;


+ whichWord: Goal 'Which word do I need to attach to the titulus?'
    [
        'What does the crow have to say on the subject?',
        'You\'ll just have to make your own choice',
        'It really doesn\'t matter -- use whichever you like. '
    ]
    closeWhenTrue = (titulus.attachedWord != nil) 
;

+ reachTitulus: Goal 'The titulus seems to be out of reach'
    [
        'That means it\'s a bit too high, because it\'s fixed near the top of
        the cross',
        'What do you normally do when something\'s a bit too high to reach?',
        'It might be a good idea to stand on something. ',
        'What\'s available to be stood on? ',
        'What has a suitably flat surface? ',
        'Try standing on the stone.'
    ]
    openWhenRevealed= ('titulus-reach')
    closeWhenTrue = (titulus.attachedWord != nil)
;

+ Goal 'What should I be doing now?'
    [
        'Just watch the chess game and see how Caiaphas does. ',
        'You could examine a few things in the Chess Room while the game goes
        on. ',
        'But you\'ll find the players are too wrapped up in the game to talk
        with you. ',
        'So wait until one or other of the players is defeated, and see what
        happens then. '
    ]
    openWhenSeen = chessBoard
    closeWhenTrue = (emperor.curState is in (emperorPlaying, emperorStone))
; 


+ Goal 'How do I beat the Emperor at chess?'
    [
        'The commands used for playing chess are MOVE {your piece}, e.g. MOVE
        WHITE KNIGHT, and TAKE {enemy piece} WITH {your piece} e.g., TAKE RED
        PAWN WITH WHITE KNIGHT',
        'In order to play chess, you need to be seated at the board, i.e. in
        the white chair. ',
        'How did the Emperor defeat Caiaphas?',
        'What did the Emperor do to cause Caiaphas to protest? ',
        'Where did the Emperor get his most effective piece from? ',
        'Have you tried doing the same?',
        'Look under the chess board.',
        'What did you find there?',
        'Take it and examine it. ',
        'Put it on the chess board. ',
        'Use it to take the Whore. ',
        'I.e. PUT {piece} ON BOARD and then TAKE WHORE WITH {piece} where
        {piece} is the name of the piece you find under the chess board, e.g.
        HOPE or JUSTICE (note that you can also refer to the piece as your
        QUEEN). '     
    ]
    
    openWhenTrue = (emperor.curState == emperorPlaying)
    closeWhenTrue = (emperor.curState == emperorStone)
;

+ Goal 'How do I rescue Felicity from the marsh?'
    [
        'You can\'t reach her from the shore. ',
        'And there\'s no point trying to enter the marsh. ',
        'So you\'ll need something to pull her out with. ',
        ropeHint,
        'When you\'ve found a rope you\'ll obviously need to get it to Felicity
        somehow. ',
        'How would you get a rope to someone a short distance away but out of
        reach? ',
        'THROW ROPE TO FELICITY should do the trick. ',
        'Then you still need to get Felicity out of the marsh; what would help
        her ashore?',
        'You have tried pulling the rope, haven\'t you? ',
        'PULL THE ROPE. '
    ]
    openWhenSeen = swamp
    closeWhenTrue = (!felicity.isIn(swamp))
;

++ ropeHint: Hint 'A rope would be a good idea. '
    [ropeGoal]
;

+ ropeGoal : Goal 'Where can I find a rope?'
    [
        'You\'ll have to hunt around a bit. ',
        'Have you taken a good look round the garden nearby? ',
        'Is there anything there that\'s at all rope-like, even though it
        may not exactly be a rope?',
        'Something coiled up perhaps? ',
        'If you have a bible to hand, perhaps Moses\' rod (Exodus 4:1-5)
        might provide a hint of sorts. ',
        snakeHint     
    ]
    closeWhenSeen = rope
;

++ snakeHint: Hint 'Perhaps the snake could double as a rope? '
    [snakeGoal]
;

+ snakeGoal : Goal 'What do I need to do with the snake? '
    [
        'Before you can do anything with it, you need to find out more about
        it. ',
        'So you need to find some way of attracting its attention. ',
        'What else is in the garden? ',
        'Where is the snake lying?',
        'Have you examined the tree?',
        'What\'s on the tree?',
        'Do you recall a story involving a garden, a serpent, a tree, a piece
        of fruit, and someone who shares a name with the author of this
        game? ',
        'Try taking the apple. ',
        'Now you\'ve got the snake\'s attention, you can try talking to it. ',
        'If you tell the snake what you need, you may find it makes a helpful
        suggestion. ',
        'Have you told the snake about Felicity?',
        'Did you tell it you need a rope? ',
        'You can simply pick the snake up. '     
    ]
    closeWhenSeen = rope
;

+ Goal 'Is there another way out of the end of the tunnel?'
    [
        'Yes, there is. ',
        'How thoroughly have you searched that location? ',
        'Have you seen an ossuary (bone box)?',
        'What happens if you take it from its niche? '
    ]
    openWhenSeen = mountainTunnel
    closeWhenSeen = smallLever
;

+ Goal 'What good is the lever in the niche?'
    [
        'Presumably, you have tried pulling it. What happens then?',
        'What happens when you try to turn the wheel? ',
        'The problem is, the wheel\'s only accessible while the handle\'s being
        pulled, and you can\'t do both jobs at once. ',
        'What\'s the normal solution when two jobs have to be done at once that
        can\'t both be done simultaneously by one person? ',
        'Obviously, you need to get someone to help you. ',
        'Specifically, you need to get Felicity to help you. ',
        'By asking her to do the other job. ',
        'Either pull the lever, then ask Felicity to turn the wheel, or ask
        Felicity to pull the lever, then turn the wheel yourself. '
    ]
    openWhenSeen = smallLever
    closeWhenTrue = mountainDoor.isOpen
;


+ Goal 'Felicity wants me to cross the bridge without her; what should I do?'
    [
        'That\'s a decision you must make. ',
        'But it will affect the outcome of the game. ',
        crossHint,
        'The decision is yours. '
    ]
    openWhenTrue = (ropeBridge.isHeld == felicity)
    closeWhenSeen = farSide
;

++ crossHint : Hint
    'And you do have a choice. '
    [crossGoal, stayGoal]
;

+ crossGoal : Goal 'What do I do to cross the rope bridge?'
    [
        'Just cross it. ',
        'The command CROSS BRIDGE should do the trick; or just W. ',
        'You can cross at any time after Felicity starts holding the rope. '
    ]
    closeWhenSeen = farSide
;

+ stayGoal : Goal 'How do I make Felicity cross the bridge?'
    [
        'You\'ve tried persuading her? ',
        'But the discussion seems to be going round in circles, right? ',
        'So maybe actions would speak louder than words? ',
        'What did Felicity actually <i>do</i> to try to get you to cross? ',
        'What is Felicity actually doing to ensure that you can cross? ',
        'What would happen if you tried to do the same thing? ',
        'Take the rope. '  
    ]
;

// Hints pertinent to the alternative path through Hell

#ifdef __MULTIROUTE

+ Goal 'What else can I do in the dank cave next to the crypt? '
    [
        'How closely have you examined everything? ',
        'Perhaps there\'s yet another way out. ',    
        skullStatueHint   
    ]  
    openWhenTrue = flagstone.isOpen
    closeWhenTrue = statueDoor.isOpen
    closeWhenSeen = deconstruction
;

++ skullStatueHint: Hint 'You could try taking a closer look at the statue. '
    [skullStatueGoal]
;

+ skullStatueGoal: Goal 'What use can I make of the skull-faced statue in the
    dank cave?'
    [
        'Yes, try examining it more closely. ',
        'What strikes you as odd about it? ',
        'It has the face of a skull -- so what\'s with the hair?',
        'Have you tried feeling the statue\'s hair?',
        'Have you tried pulling it? '
    ]  
    closeWhenSeen = deconstruction // at this point the PC is committed to the Via Moderna
    closeWhenTrue = statueDoor.isOpen
;

+ Goal 'How do I get out of the very strange place?'
    [
        'What is described as being the nearest to fixed features of this place? ',
        'What might the coloured patches be good for? ',
        'In particular, ther green and brown patches? ',
        'How might you go about going through one of these patches? ',
        'Try entering one of them. '
    ]
    openWhenSeen = veryStrangePlace
    closeWhenRevealed = 'colour-patch'
;

+ Goal 'Where is the key to the gold casket?'
    [
        'It\'s not in any obvious place you might expect to find a key. ',
        'So you may be all at sea trying to find it. ',
        'Talking of the sea, what did the sign on the beach say? ',
        'What action might that suggest? ',
        'If you\'re not meant to walk on the water...',
        '... you could try taking a swim. '
    ]
    openWhenRevealed = 'casket-lock'
    closeWhenSeen = goldKey
;

+ Goal 'How do I open the gold casket?'
    [
        'You\'ve already found the key you need. ',
        'What colour is the casket? ',
        'What key might match it? ',
        'Use the small gold key. '
    ]
    openWhenSeen = goldKey
    closeWhenSeen = ornateScroll
;

+ Goal 'I can\'t open the door to the shed. '
    [
        'The key is not far away. ',
        'Have a good look round the neighbouring locations. ',
        'In particular, take a good look at the orchard. ',
        'What\'s in the orchard? ',
        'What\'s in the orchard apart from apples and trees?',
        'Where is the path to the west described as going? ',
        'How closely have you examined the bushes? ',
        'If there\'s nothing in the bushes, where else could you look
        in relation to them?',
        'Look under the bushes. '
    ]
    openWhenRevealed = 'shed-locked'
    closeWhenSeen = shedKey
    
;

+ Goal 'The statue won\'t let me into the shrine. '
    [
        'You need to find a way to placate the statue. ',
        'You\'ll have to hunt around for instructions how to do so. ',    
        'When you find them they\'ll shed some light on it. ',
        'That was a punning clue. ',
        'When you find it, the scroll will prove the key. ',
        'But you\'ll need some other keys first to find it. '
    ]
    openWhenRevealed = 'shrine-barrier'
    closeWhenSeen = ornateScroll
;

+ Goal 'What does the poem on the scroll mean?'
    [
        'It contains instructions for getting into the shrine. ',
        statueHint,    
        fruitHint,   
        cashHint,
        'The final part of the hint is telling you that if the statue
        is getting annoyed with your pulling its hair too often, you
        can make amends by giving it a kiss. ' ,
        'You need to carry both the apple and the coin with you into the shrine. '  
    ]
    openWhenSeen = ornateScroll
    closeWhenSeen = insideShrine
;

++ statueHint: Hint
    'The first part means that the statue outside the shrine must be
    completely stone before you can pass '
    [statueGoal]
;


++ fruitHint: Hint
    'The second part of the poem refers to Adam, Eve and fruit -- what
    might that suggest? '
    [fruitGoal]
;


++ cashHint : Hint 
    'The third part of the poem is telling you to find some cash to offer. '
    [cashGoal]   
;

+ statueGoal : Goal 'How do I ensure that the statue is completely stone?'
    [
        'What part of the statue is not stone? ',
        'What might you do to it? ',
        'If you pull the hair on the statue it turns to stone. '
    ]
    closeWhenSeen = insideShrine
;


+ fruitGoal : Goal 'Where can I find the fruit referred to in the poem? '
    [
        'Where might you find some fruit round here? ',
        'How about the orchard? ',
        'Go to the orchard and take an apple. '
    ]
    closeWhenTrue = greenApple.moved
;

+ cashGoal: Goal 'Where can I find some cash? '
    [
        'The poem refers to yellow ground -- where might you find that? ',
        'Sand, perhaps? ',
        'The beach? ',
        'Take the spade and dig in the beach. '    
    ]
    closeWhenSeen = goldCoin
;

+ Goal 'What am I meant to do once I\'m inside the shrine? '
    [
        'What did you have to bring into the shrine? ',
        'Where might you make an offering in this shrine? ',
        'How might you offer it? ',
        'Where would you put something to offer it here? ',
        'What is the altar for?',
        'Put the apple and the coin on the shrine. '
    ]
    openWhenSeen = insideShrine  
    closeWhenTrue = altarHole.isOpen
;


#endif

+ Goal 'Doesn\'t the author of this game know better than to include a maze!'
    [
        'Don\'t be too quick to type QUIT in disgust -- it may not be quite
        what you think. ',
        'But do read the signs. ',
        'Have a go at getting through the labyrinth by yourself. ',
        'It could be easier than you think. ',
        'In fact is doesn\'t matter which direction you take at each junction
        in the labyrinth -- they all end up at the same place. '
    ]
    openWhenSeen = maze1
    closeWhenSeen = lair
;

+ Goal 'Where can I find the key to the faded blue door?'
    [
        'It\'s not all that far from the door. ',
        'In fact it\'s just upstairs. ',
        'How carefully have you searched the temple? ',
        'What\'s in the temple? ',
        'What\'s the most prominent object in the temple? ',
        'What did you have to manipulate in order to be able to reach the crypt
        with the faded blue door in the first place? ',
        'How carefully have you examined the carving on the altar? ',
        'Is there anything at all key-like there? ',
        'Have you examined that key closely? ',
        'Have you tried taking it? ' 
    ]
    openWhenSeen = paganCrypt
    closeWhenTrue = paganKey.moved 
;

+ Goal 'Is there anything special about the foot on the altar carving? '
    [
        'Yes',
        'What might you do with that foot? ',
        'How might you manipulate it? ',
        'Have you tried pushing it? '
    ]
    closeWhenRevealed = 'push-foot'
    openWhenDescribed = carvingLeftFoot
;

+ Goal 'I can push the foot of the carving on the altar, but nothing much happens. '
    [
        'Maybe there\'s something else you need to do first. ',
        'Take a closer look at the carving. ',
        'Is there anything else you notice -- at the opposite end of the carved
        woman, for instance?',
        'I spy with my little --- ',
        'Have you spied her little eye adequately? ',
        'What might be suggested by hole or hollow? ',
        'Could something be inserted in it, perhaps? ', 
        'What have you spotted in the vicinity that might fit the hole? ',
        'You won\'t find it in the temple. ',
        'But it\'s not too far away. ',
        'In another building used for worship. ',
        'The cathedral in fact. ',
        'Put the short metal rod (from the cathedral) in the eye of the carving
        on the altar and then push the foot. '
    ]
    openWhenRevealed = 'push-foot'
    closeWhenTrue = altarLid.isOpen
    closeWhenSeen = deconstruction // at this point the PC is committed to the Via Moderna
;

+ Goal 'How should I respond to Agrath\'s attempts to tempt me?'
    [
        'You <i>have</i> to ask for something she can tempt you with;
        she\'ll insist on it. ',
        
        'The trick, of course, is to ask for the right thing. Actually,
        there are a number of possibilities that will do equally well, so
        it shouldn\'t be beyond you to hit on one of them. ',
        
        'For example, why did you think it worth trying to get into Hell
        in the first place? What are you ultimately trying to find? ',
        
        'Alternatively, what is your immediate goal now?',
        
        'Presumably your immediate goal is to get out of there; so why
        not ask Agrath for that? ',
        
        'e.g. ASK FOR A WAY OUT or ASK FOR AN EXIT or ASK FOR ESCAPE. ',
        
        'You could also ASK FOR HOPE or ASK FOR FELICITY or ASK FOR GOLDEN
        GLOW (among other things). ',
        
        'Oh, if you\'re still reading these hints, once you\'ve asked her for
        one of these things, you simply need to go through the opening Agrath
        creates for you to the north. '
    ]
    openWhenRevealed = 'temptation'
    closeWhenSeen = fireLedge
;

+ Goal 'How do I get across the fiery ravine?'
    [
        'Presumably you\'ve tried going north or walking on the rope? ',
        'That didn\'t work, of course, but might the rope have another use? ',
        'What happens if you pull it? ',
        'That didn\'t help too much either -- but it might suggest something
        that does. ',
        'Try examining the area a bit more thoroughly. ',
        'You should also explore the surrounding area - i.e. go west. ',
        'What did you find in the cave? ',
        'What use might it have? ',
        'Look closely at the south wall of the cave -- what do you see? ',
        'Try putting the hand crank in the hole. ',
        'And then turning it. ',
        'And then explore further. '    
    ]
    openWhenSeen = fireLedge
    closeWhenSeen = deadEndPassage2
    closeWhenTrue = farSideRavine.seen
;

+ Goal 'I found the hand crank and opened the concealed passage from the cave,
    but when I explored the passage it led only to a dead end, and
    I still don\'t know how to get across the fiery ravine! '
    [
        'But by now you should have learned something that will help you to
        get across the ravine. ',     
        'Could the hand crank have more than one use?',
        'Go back to the rope across the ravine and take a closer look. ',
        'What\'s beneath you? ',
        'Try looking at the ground. ',
        'Does that hole suggest anything? ',
        'The hand crank will fit the hole in the ground by the rope. ',
        'Turning the hand crank will wind in the rope and draw a plank across. ',
        'And, perilous though it may look, you can walk across the plank. '     
    ]
    openWhenSeen = deadEndPassage2
    closeWhenSeen = farSideRavine
;

+ Goal 'How can I take the large white crystal? '
    [
        'It seems fairly firmly embedded in the wall. ',
        'Perhaps you could dislodge it somehow. ',
        'A sharp blow should do the trick. ',
        'But you\'ll need something reasonably hefty to hit it with. ',
        'Is there anything you\'ve come across recently that might do the job? ',
        'What did you have to use to get to this tunnel in the first place? ',
        'What about that ' + windlass.name + '? ',
        'HIT CRYSTAL WITH ' + windlass.name.toUpper(),
        'Then hit it again. '
    ]
    openWhenRevealed = 'crystal-stuck'
    closeWhenSeen = agrathCave
    closeWhenTrue = !crystal.isInInitState
;

+ Goal 'How do I get out of the Burial Cave?'
    [
        'How thoroughly have you studied your environment? ',
        'Is there anything you haven\'t searched or examined yet? ',
        'What about the walls?',
        'Or, more specifically, what\'s in the walls. ',
        'Or, even more specifically, what\'s in the west wall. ',
        'Namely, the loculus or niche. ',
        'Inside the loculus you\'ll find an ossuary. Take it. '
    ]
    openWhenSeen = agrathCave
    closedWhenTrue = agrathOssuary.discovered
;

+ Goal 'How do I get out of the Burial Cave?'
    [
        'Presumably you have taken the ossuary from the loculus?',
        'And of course you\'ve opened it?',
        'And examined what\'s inside?'
    ]
    openWhenTrue = agrathOssuary.discovered
    closedWhenRevealed = 'force-stone'
;


+ Goal 'How do I move the stone?'
    [
        'You could try asking Agrath. ',
        
        'She\'s not very informative, but her answers may nudge you in the right
        direction eventually. ',
        
        'Her way of appearing in the tomb, her <q>conjuring trick with bones</q>,
        didn\'t exactly employ natural means. ',
        
        'And she\'s trying to get you to recreate Mark\'s story of the Empty
        Tomb: how might the principal character in Mark\'s story have moved
        the stone, if not by brute force?',     
        
        'How might you go about trying to perform a miracle here?',
        
        'Do you remember seeing someone depicted in this situation recently? ',
        
        'Someone depicted in a cave-painting? ',
        
        'Although not strictly relevant to this scene, the first temptation
        offered by the devil in Matthew\'s Gospel (Matt. 4:3) could give you a
        clue of sorts. ',
        
        'Try telling the stone to move.',
        
        'STONE, OPEN or STONE, MOVE or STONE, ROLL AWAY or TELL THE STONE TO
        ROLL ASIDE should all work (as well as the obvious variants thereon). '  
        
    ]
    openWhenRevealed = 'force-stone'
    closeWhenTrue = caveExit.isOpen
;