#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>

ElfPart template 'vocabWords' 'partName'? "desc"?;

class ElfPart: Decoration
    name = (location.name + '\'s ' + partName)
    partName = ''
    vocabWords = 'his its -'
    notImportantMsg = &leaveAloneMsg    
;

elf: TourGuide, Person 'small little odd wrinkled brownish green brownish-green 
    (garden) elf/turlix/person/man' 
    'odd little person' @pot
    "{The elf/he} is brownish-green, with a wrinkled skin from which sparse
    white hairs sprout, seemingly at random. He (it? possibly <<name == 'elf' ?
      'elves have' : 'such an odd little person has'>> no gender) is about
    three feet tall, or perhaps a little more --- as his legs are buried up to
    the ankles in the soil in the pot, measuring his exact height wouldn\'t be
    easy.<.p>
    
    His face is astonishingly ugly, dominated by a long tapering nose as
    gnarled as a tree-root. His fingers are just as long, and end not in
    fingernails but in little fans or tufts of the same white hair. "
    globalParamName = 'elf'
    isHim = true
    isIt = true
    postureDesc {}
    actorHereDesc {}
    isWatered = nil
    knownAsElf = nil
    identifyAsElf {
        name = 'elf';
        knownAsElf = true;
    }
    dobjFor(Water) remapTo (Water, pot)
    
    iobjFor(PourOnto) 
    {
        verify() {}
        check() {}
    }
    
    dobjFor(Take) 
    {
        verify() {}
        check() 
        {
            if (location == pot) 
                failCheck ('His legs seem to be firmly rooted in the soil in
                    the pot. ');
            else 
                failCheck ('Now that you\'ve set him free, you\'re trying to
                    capture him again? Even if you knew how to do that, it
                    would be extremely cruel. ');
        }
    }
    dobjFor(Drop) maybeRemapTo ((pot.location == me && elf.location == pot), 
                                Drop, pot)
    dobjFor(PutOn) maybeRemapTo ((pot.location == me && elf.location == pot),
                                 PutOn, pot, IndirectObject)
    
    iobjFor(PutOn) 
    {
        verify() {}
        check() 
        {
            if ((gDobj != chippedGlass) || (chippedGlass.getState == glassEmpty))
                failCheck(playerActionMessages.notASurfaceMsg);
        }
        action() {   replaceAction (Water, pot);  }
    }
    
    dobjFor(PushTravel)
    {
        verify()
        {
            if(isIn(skateboard))
                skateboard.verifyDobjPushTravel();
            else
                illogicalNow('{The elf/he} probably wouldn\'t much appreciate
                    being pushed around. ');
        }
        
        action()
        {
            if(isIn(skateboard))
                skateboard.actionDobjPushTravel();
            else
                inherited;
        }
    }
    
    /* 
     *   The addWater routine will be called by the chippedGlass in response 
     *   to 'pour water on elf' or 'pour water into pot', but only if the 
     *   water is rainwater. If the elf is now in the front yard or the back 
     *   yard, we need to end the game!
     */
    addWater 
    {
        if (isWatered) 
        {
            "<.q>Oh, I don\'t need any more water,<./q> {the elf/he}
            assures you. <.q>I\'m fine now, thanks to your very kind
            help!<./q> ";
            exit;
        }
        
        isWatered = true;
        setCurState(elfAlert);
        elfAlert.previousState = elfWatered;
        /* 
         *   Named thus because there'll probably be another achievement 
         *   associated with the elf. Moved to before the quote (JA 07-Dec)
         *   so as to score the point even if we're now at the end.
         */
        waterAchievement.awardPointsOnce();
        "As the fresh rainwater trickles into the soil of the pot, {the elf/he}
        begins to uncurl and stretch. No longer a shriveled ball cowering in
        the pot, he stands up straight, his eyes bright. <.q>Ahh ... ahh! You
        don\'t know how wonderful that feels! I think maybe I won\'t die today
        after all."; // No space and no close-quote here.
        
        local r = getOutermostRoom;
        if ((r == frontYard) || (r == backYard))
        {
            "<./q><.p>";
            happyEnding;
            return;
        }
        
        /* 
         *   In this branch, he has been watered, but isn't in the correct 
         *   location:
         */
        " I\'d hug you if I could, but ---<./q> He bends his knees as if
        trying to lift his feet free of the soil in the pot. <.q>--- I\'ve been
        rather planted, you see. I\'m an elf, by the way, in case you hadn\'t
        guessed.<./q><<identifyAsElf>> ";
    }
    
    waterAchievement: Achievement { +4 "watering {the elf/him}" }
    endGameAchievement: Achievement { +6 "freeing the elf from the pot" }
    
    captureExplained = nil
    explainCapture {
        if (captureExplained) return;
        captureExplained = true;
        
        /* 
         *   There is no open-quote at the beginning of this speech, but 
         *   there is a space. This is because it will be a segue from what 
         *   he's saying already. Nor is there a close-quote or space at the 
         *   end.
         */
        " It was my own fault,<./q> he says, looking chagrined. <.q>Her garden
        is such a disaster, so dreadful and dismal and abysmal. Day after day I
        would see her out there raking, and nothing to rake but rocks! Finally,
        one day it was too much for me. I popped up and told her in no
        uncertain terms what a shameful mess she\'d made of it.\b
        <.q>She asked for my help. Demanded it, truth be told. I told her,
        there\'s not much I can do with a garden so decrepit. I can encourage a
        seed to sprout, or perhaps coax a tree to bring forth a few extra
        blossoms, but fill a garden of gravel with flowers and vegetables? It
        would take a hundred elves a hundred days to do it.\b
        <.q>She listened to me, nodding all the while. I thought she
        understood. But then she did --- something, I\'m not sure what, except
        that I think it was a magic spell that came from the absurd thing she
        was wearing on her head. I felt myself getting sleepy, and when I awoke
        I was ";
        if (getOutermostRoom == frontBedroom)
            "up here in this room, in this pot";
        else
        {
            // If we've just stepped out of the pot:
            if (location != pot)
                "up there in that room, in that pot";
            // else we're in the pot, but no longer in the bedroom:
            else
                "in that lonely room, in this pot";
        }
        // continuing the speech:
        ", completely cut off from the soil of the Earth.\b
        <.q>And then she told me if I wouldn\'t promise to make her garden
        grow, she would never let me go! I told her it was beyond my poor
        powers, but she didn\'t want to believe me. Lately she\'s begun
        tormenting me by not watering me. As if that would convince me to
        promise something I can\'t possibly achieve. We elves know better than
        to make promises we can\'t keep. If you hadn\'t come along, I\'m sure I
        would have dried up and blown away before another day had gone by.";
    }
    
    /* 
     *   The happyEnding method ends the game. It can be reached in only one 
     *   way: the elf is freshly watered and is in the front yard or the 
     *   back yard. However, this set of conditions can be met in various 
     *   ways. First, the elf can have received water while NOT in either of 
     *   these locations, and can then be pushed into a correct location. 
     *   Second, the elf can already be in one of the correct locations when 
     *   water is added. In addition, the water can be added in one of two 
     *   ways --- by generating rain in the back yard (when the elf is not 
     *   there) and filling the glass with rain water from the birdbath, or 
     *   by generating rain in an outdoor location when the elf is in that 
     *   location.
     */
    happyEnding 
    {
        happyEndingPlayed = true;
        "Moving rather carefully, {the elf/he} lifts one foot out of the soil
        of the pot and extends his leg until the foot (it doesn\'t really look
        much like a foot, but you don\'t get a very good glimpse) touches the
        soil. In the blink of an eye, his leg takes root. He repeats the
        procedure with the other foot, and then stands before you quite proudly
        in the rocky soil of the yard.<.p>
        
        <.q>You\'ve saved me!<./q> he cries. <.q>I\'m free from that horrible
        woman\'s schemes!<<explainCapture>> I\'d like to give you a
        reward --- but sad to say,
        I\'m not a leprechaun. I haven\'t any gold. I\'m just a common garden
        elf, with only a tiny bit of vegetable magic at my disposal.<.p>
        
        <.q>Oh, I know what I could do. ";
        
        elf.moveIntoForTravel(getOutermostRoom);
        elf.posture = standing;
        // Because you might still try to do something with the pot, even at the
        // end of the game:
        pot.noElfName;
        
        if (getOutermostRoom != frontYard) 
        {
            "Let's go to the front yard.<./q><.p>"; 
            setCurState(elfLeading);
        }
        else
            happyEnding2();
    }
        
    happyEnding2()
    {
        "Do you see that poor bedraggled orange tree there? It hasn\'t borne
        fruit in years, and may never again, unless someone else buys this
        house and nurtures it back to health. But it\'s not quite dead, no
        indeed. Watch closely now.<./q><.p>
        
        He gestures at the nearest branch with his long, slim, gnarled fingers.
        As you watch, a single bud bursts forth at the end of the branch. At
        first no more than a tiny green nub, it swells rapidly. In a few
        seconds a plump, ripe orange is hanging from the branch.<.p>
        
        <.q>Go ahead,<./q> says the elf. <.q>Pick the orange and enjoy it.
        It\'s yours.<<skateCheck()>><./q> Before you can stammer your thanks ---
        before you can blurt out the dozen questions jostling in your head
        about what it\'s like being an elf, and where he came from, and whether
        you\'ll ever see him again --- the elf has somehow folded himself
        inward, like a fast-motion film of a growing plant when the film is run
        backwards. He shrinks and runs downward into the soil, and he\'s
        gone. ";

        orange.moveInto(orangeTree);
        orangeTree.grewAnOrange = true;
        elf.moveIntoForTravel(nil);
        // Superseded by the call to pot.noElfName in happyEnding:
        // pot.name = 'heavy pot';
        endGameAchievement.awardPointsOnce();
    }
    
    skateCheck()
    {
        if(!skateboard.isIn(frontYard))
        {
            pot.moveIntoForTravel(pot.getOutermostRoom);
            skateboard.moveIntoForTravel(me);
            " Oh,<./q> he adds, handing you your skateboard, <.q>you nearly
            forgot this.";
        }
    }
    
    /* 
     *   Each turn, the Daemon checks to see whether the conditions have yet 
     *   been met for triggering the happyEnding.
     */
    startDaemon 
    {
        if (endGameDaemonID) return;
        endGameDaemonID = new Daemon(elf, &endGameDaemon, 1);
    }
    endGameDaemonID = nil
    endGameDaemon 
    {
        if (!isWatered) return;
        
        local r = getOutermostRoom;
        if ((r != frontYard) && (r != backYard)) return;
        
        if (!happyEndingPlayed)
            happyEnding;
        
        if (endGameDaemonID) 
        {
            endGameDaemonID.removeEvent;
            endGameDaemonID = nil;
        }
    }
    /* This flag insures that the happy ending will be played only once: */
    happyEndingPlayed = nil
    uselessToAttackMsg = 'There\'s no need to do Mrs. Pepper\'s nefarious work
        for her. '
    beforeAction()
    {
        if(gActionIs(Yell) && isWatered)
            failCheck('There\'s no need to shout --- {the elf/he} can hear you
                perfectly well. ');
        
        inherited;
    }
    
    sightSize = medium
    
    remoteSpecialDesc(pov)
    {
        if(isIn(skateboard))
            "{The elf/he} is standing in the heavy pot which is resting on your
            skateboard, which in turn is lying on
            <<getOutermostRoom.roomFloor.theName>>
            <<getOutermostRoom.inRoomName(pov)>>. ";
        else
            inherited(pov);
    }
    
    specialDesc()
    {
        if(isIn(skateboard))
            "{The elf/he} is standing in the pot that's on your skateboard. ";
        else
            inherited;
    }
;

+ ElfPart 'wrinkled skin' 'skin'
    "{The elf/he}\'s skin is wrinked, and sprouts white hairs seemingly at
    random"
    isMassNoun = true
;

+ ElfPart 'sparse white hairs/hair' 'sparse white hairs'
    "TSparse white hairs seem to sprout at random from all over his skin, and
    from the ends of his fingers. "
    isPlural = true
    notImportantMsg = &leaveAloneMsg    
;

+ ElfPart '(ends)/fingers' 'fingers'    
    "His fingers are as long as his nose, and end not in fingernails but
        in little fans or tufts of white hair."
    isPlural = true 
;

+ ElfPart 'legs/knees' 'legs'
    "His legs are buried up to the ankles in the soil in the pot. "  
    isPlural = true    
;

+ ElfPart 'face' 'face'
    "His face is astonishingly ugly, dominated by a long tapering nose as
    gnarled as a tree-root. "
;

+ ElfPart 'long tapering gnarled nose' ' nose'
    desc = "{The elf/he}'s long tapering nose is as gnarled as a tree-root. "    
;

//------------------------------------------------------------------------------
// The elfThirsty state:

+elfThirsty: InConversationState
    stateDesc = "He\'s curled up in a foetal position in the pot, and gazes up
        at you beseechingly. "
    attentionSpan = 5
    beforeAction()
    {
        if(gActionIs(Yell))
        {
            "You shout at {the elf/him} in the hope of making yourself better
            understood to the poor creature. In response the unfortunate
            creature huddles in on itself and croaks, <.q>Water! Water!<./q> ";
            exit;
        }
    }
;

++elfWilted: ConversationReadyState
    stateDesc = "He\'s curled up in a foetal position in the pot, moaning
        faintly. "
    isInitState = true
    beforeAction()
    {
        if(gActionIs(Yell))
        {
            "You\'re not sure if {the elf/he} will be able to hear you, so you
            decide to talk very loud. ";
            replaceAction(TalkTo, elf);
        }            
    }
;

+++ HelloTopic
    "<.q>Hi there!<./q> you say.\b
    <<elfThirstyTopic.topicResponse()>> "
;

+++ ImpHelloTopic
    "<.q>Hi there!<./q> you say. "
;

+++ ByeTopic
    "{The elf/he} looks at you regretfully. "
;

++ GiveShowTopic @chippedGlass
    topicResponse() { replaceAction(PourOnto, chippedGlass, elf); }
;

+++ AltTopic
    "{The elf/he} eyes the empty glass despairingly and croaks <.q>Water!
    Water!<./s>. "
    isActive = (chippedGlass.getState == glassEmpty)
;

++ elfThirstyTopic: DefaultAnyTopic
    "In reply, {the elf/he} makes soft croaking, choking noises. With an
    effort, he finally manages to force out a few intelligible words: <.q>Water
    --- thirsty. Need water....<./q><.reveal need-water> "
;

//------------------------------------------------------------------------------
// The much more interesting elfWatered state:

+elfAlert: InConversationState
    stateDesc = "He\'s standing up proudly in the pot, his back straight,
        smiling at you in a friendly way. "    
;

++elfWatered: ConversationReadyState
    stateDesc = "He\'s swaying back and forth in the pot, his leafy fingers
        waving gently. "
    
;

++ AskTopic, SuggestedAskTopic, StopEventList [elf, pamphlet]
    [
        {: "<.q>I don\'t know very much about ... little people,<./q> you
            venture. <.q>Are you by any chance an
            elf?<./q>\b<<elf.identifyAsElf>> <.q>Why, that I am. A good guess.
            Not a very important elf, though, just a common garden elf. My name
            is Turlix.<./q> He bows. "},
        
        {: "<.q>Do all garden elves live in pots in houses?<./q> you ask. <.q>I
            mean, I wouldn\'t have guessed.<./q>\b
        <.q>Oh, no,<./q> he says, shaking his head sadly. <.q>I\'m being held
            captive by that awful woman.<<elf.explainCapture>><./q> " },
        
        {: "<.q>I need to be returned to the soil of the Earth,<./q> he says.
            <.reveal transportation-need><.q>If you can do that for me, I
            suppose I might be able to reward you in some small way. Can you
            possibly figure out a way to get me outdoors? I can\'t walk more
            than a step or two, as I always have to be in contact with the
            soil. If you pull me up, it would kill me.<./q> "},
        
        '<.q>Garden elves aren\'t honestly very interesting. Maybe a little
        more interesting than rutabagas and parsnips, but not a great deal.
        Isn\'t there some way you can help me get back out to the yard?<./q> '
    ]
    name = 'himself'
;

++ DefaultAskForTopic
    "<.q>Could you give me...?<./q> you begin.\b
    <.q>I doubt it,<./q> {the elf/he} replies, before you can even complete
    your request. <.q>My powers are very limited, you see.<./q> "
;

++TellTopic, SuggestedTellTopic, StopEventList [mrsPepper, skateboard]
    [
        {: "You tell the elf the sad tale of how Mrs.\ Pepper grabbed your
        skateboard and ran off with it<<skateboard.seen ? ', and how you
            found it hidden under the back porch' : ''>>. <.q>I can\'t
            say I\'m surprised,<./q>
            he says. <.q>Wicked mischief seems to be in her nature.<./q> "},
        '<.q>Yes, you\'ve told me about that already,<./q> he replies. '
    ]
    name = 'your skateboard'
;
    
++ AskTopic, SuggestedAskTopic, StopEventList @mrsPepper
    [
        {: "<.q>What can you tell me about Mrs.\ Pepper?<./q> you inquire.\b
        <.q>Not very much,<./q> he replies. <.q>She\'s nasty and cruel, and
        she\'s a dreadful gardener, one of the worst it\'s ever been my
            misfortune to encounter.<<elf.explainCapture>><./q> "},
        '<.q>I really don\'t know what to tell you,<./q> he replies. <.q>But
        I do hope we can both be out of here before she returns!<./q> '
    ]
    name = 'Mrs. Pepper'
;

// Another topic, because he does mention his native soil at one point:
++ AskTopic, StopEventList @tNativeSoil
    [
        '<.q>Where do you usually live?<./q> you ask the elf. <.q>Or grow,
        or whatever it is you do?<./q>\b
        <.q>Almost anywhere there\'s a bit of soil,<./q> he replies. <.q>Even
        if it\'s gravelly or parched, I don\'t mind too much.<./q> ',
        'Your attempts to quiz the elf further about his preferred habitat lead
        to a long and boring discussion of types of clay, in which most of the
        information is supplied by the elf while you nod and say, <.q>Oh, I
        see,<./q> over and over. '
    ]
;

// The skateboard asktopic has alttopics:
++ AskTellTopic, StopEventList @skateboard
    [
        '<.q>Mrs.\ Pepper stole my skateboard,<./q> you explain. <.q>I\'m
        really hoping to get it back, but I don\'t know where she might have
        put it. Can you help?<./q>\b
        The elf shakes his head sadly. <.q>I\'ve been imprisoned here for six
        days now. If she put it anywhere in the yard, I might have noticed, if
        I had been outdoors. But if it\'s in the house I wouldn\'t know
        anything. She doesn\'t confide in me, you may be sure of that!<./q> ',
        '<.q>I don\'t know what else I can possibly tell you,<./q> he says. '
    ]
    isActive = (!skateboard.seen)
;
+++ AltTopic, SuggestedAskTopic, StopEventList
    [
        '<.q>Can you tell me how I might be able to get my skateboard out from
        under the porch?<./q> you ask. <.q>I think the space under there is
        just too small for me to crawl in.<./q>\b
        <.q>If you could get me downstairs and outdoors, I could certainly
        retrieve it for you,<./q> the elf replies. <.q>I did notice that
        beneath the porch is only bare soil, not pavement, so I could go there.
        But how you\'ll be able to get me downstairs I don\'t know. This pot
        looks awfully heavy!<./q> ',
        'You decide to try one more time. <.q>Are you sure you don\'t know how
        I can get my skateboard back?<./q>\b
        The elf shrugs. <.q>Maybe you could grow longer arms. That\'s what I\'d
        do.<./q> '
    ]
    isActive = (skateboard.seen)
    name = 'your skateboard'
;
// This AltTopic isn't really an answer to a question, because there's no reason
// to 'ask elf about skateboard' after you've recovered it. However, including it
// will switch off the earlier AltTopic, which is useful -- and it contains a
// veiled in-game hint, which is also useful.
+++ AltTopic
    "With some pride, you tell the elf how you got your skateboard out from
    under the porch using the rake. <.q>I\'m very happy for you,<./q> he says,
    not sounding particularly happy. <.q>I\'ve seen young humans racing down
    the walk on skateboards, and it does look like fun. But I\'ve never been on
    one myself, nor am ever likely to be, since I have roots in place of
    feet.<./q> "
    isActive = (skateboard.moved)
;

++ AskTellTopic @neighbour
    "You mention the neighbor you saw on the other side of the back fence, and
    the elf nods. <.q>Now, <i>her</i> garden is a wonder to behold!<./q> he says
    admiringly. <.q>I
    was especially impressed with her luxuriant stand of bamboo.<./q> "
;

++ AskTellTopic [bamboo, bambooStick]
    "<.q>Have you noticed the beautiful bamboo plant growing in the neighbor\'s
    yard?<./q> you ask.\b
    <.q>Oh, yes,<./q> the elf replies. <.q>From time to time I\'ve seen humans
    using bamboo sticks for magical purposes, but I really don\'t know anything
    about how that might work. Perhaps you could look it up in the
    <i>Encyclopedia Enchantica</i>, if you can find a copy.<./q> "
;

++ AskTellTopic [nextDoorGarden, tGardening]
    topicResponse {
        countResponses++;
        if (countResponses == 1)
        {
            "<.q>You\'re a garden elf, right?<./q>\b
            <.q>That I am,<./q> he says, bowing proudly.\b
            <.q>So you must have seen Mrs.\ Pepper\'s, uhh, garden,<./q> you
            continue. <.q>And the one next door.<./q>\b
            <.q>Oh, yes,<./q> he says. <.q>The difference is quite striking.
            Mrs.\ Pepper is a complete failure as a gardener. ";
            if (!elf.captureExplained) {
                "That was how I came to be in this predicament. ";
                elf.explainCapture;
            }
            else {
                "Whereas her neighbor has a remarkably beautiful garden. I lend
                a hand from time to time, when the neighbor --- that would be
                Mrs.\ Dogwood --- is looking the other way. But really, you
                know, I hardly need to do a thing. She does it all herself.";
            }
            "<./q> ";
            return;
        }
        "<.q>Can you tell me anything else about the garden?<./q> you ask.\b
        <.q>I could tell you volumes about gardens,<./q> the elf replies.
        <.q>Bore you silly for a month! But not much that would be useful at
        the moment.<./q> ";
    }
    countResponses = 0
;

++AskTopic, SuggestedAskTopic @pot
    topicResponse {
        "<.q>Are you comfortable in that pot?<./q> you ask the elf.\b
        <.q>Oh, it\'s not too bad,<./q> he replies. <.q>It will be months
        before I\'m root-bound, and if I can\'t escape from here before then
        I\'m sure I\'ll be dead.<./q>";
        if (!elf.captureExplained) {
            "\b<.q>But what are you doing in a pot?<./q> you persist.\b
            <.q>As to that.... ";
            elf.explainCapture;
            "<./q> ";
        }
        else " ";
    }
    name = 'the pot'
; 

++AskTellTopic, StopEventList @tRoots
    [
        '<.q>I notice your feet seem to be buried in the soil of the pot,<./q>
        you remark.\b
        <.q>Feet? Ah, well, I haven\'t any feet, you know, not like you,<./q>
        he replies. <.q>I hardly know how you\'d draw up enough nourishment
        with those flat things at the ends of your legs, and especially not
        when you encase them in coverings like those --- what do you call them?
        --- shoes. No, what I have are fine sturdy roots. There\'s near as much
        of me below ground as above, when I\'m standing before you.<./q> ',
        
        '<.q>But couldn\'t you just pull up your feet --- I mean, your legs ---
        I mean, your roots --- and walk around?<./q> you ask.\b
        <.q>Oh, the very idea!<./q> The elf shudders. <.q>No, I\'m quite
        content to be part of the soil, you see. Being uprooted would be a
        horrible thing. I\'d surely die.<./q> ',
        
        'The elf has explained that he can\'t survive if his roots are pulled
        out of the soil. You consider asking him more questions about that ---
        but really, it all seems sensible enough (if a bit weird). '
    ]
;

++ AskTellTopic, StopEventList @elevator
    [
        '<.q>Did you know there\'s an elevator in this house?<./q> you ask the
        elf.\b
        <.q>What\'s an elevator?<./q> he replies. <.q>I\'m a creature of the
        Great Outdoors, you\'ll understand. I know very little about what\'s
        inside houses.<./q>\b
        <.q>It\'s ... well, it\'s a little room that goes up and down,<./q> you
        explain.\b
        <.q>You mean, like a bird?<./q>\b
        <.q>Well, no,<./q> you admit. <.q>An elevator isn\'t really very much
        like a bird. It\'s more like ... oh, never mind.<./q> ',
        
        'You contemplate trying to explain the concept of an elevator to the
        elf, but really it doesn\'t seem all that worthwhile. '
    ]
;
+++AltTopic, StopEventList
    [
        '<.q>There\'s an elevator in this house,<./q> you tell the elf, <.q>but
        I think it\'s broken. I\'m not sure how to fix it.<./q>\b
        <.q>I really wouldn\'t know how to tell you how to fix anything,<./q>
        the elf says. <.q>Not things in houses, I mean. Could you water it? Or
        pick the aphids off? Or perhaps convince the gophers not to gnaw at its
        roots? Those are the things I\'d try.<./q> ',
        'It seems pretty clear from what he said before that the elf won\'t be
        able to help you with that problem. '
    ]
    isActive = (!machinery.isFixed && machinery.seen)
;

++ DefaultAskTellTopic, ShuffledEventList
    [
        '<.q>I don\'t know what to tell you about that,<./q> the elf says,
        shaking his head. ',
        '<.q>You humans must lead such interesting lives,<./q> the elf says.
        <.q>You\'re just bursting with questions and comments!<./q> ',
        '<.q>I\'m more concerned about how I might be returned to my native
        soil,<./q> the elf says. ',
        '<.q>That\'s not something I know very much about,<./q> he responds.
        <.q>I\'m very sorry.<./q> ',
        '<.q>I\'m not much of a conversationalist,<./q> he admits. <.q>You\'ve
        stumped me ... if you\'ll forgive the term.<./q> '
    ]
;

++ YesNoTopic
    "<.q>You appear to be answering a question I haven't asked,<./q> {the
    elf/he} observes, <.q>it's strange how humans do that!<./q> "
;

//------------------------------------------------------------------------------
// GiveShowTopics.

// Question: Is this too obvious?
++ GiveShowTopic @skateboard
    "<.q>I wouldn\'t have any use for such a vehicle,<./q> the elf says. <.q>I
    could never ride it, as I don\'t have feet. Unless I were in a pot like
    this one, and the pot were placed on the board. That would work, But then
    someone would have to push me before I could go anywhere.<./q> "
;

++ DefaultGiveShowTopic
    "<.q>I don\'t have any use for that, I\'m afraid,<./q> the elf says.
    <.q>Thank you for showing it to me, though.<./q> "
;

//------------------------------------------------------------------------------
// ECSE 11-Dec-07: Added GuidedTourState etc.

+ elfLeading: ElfGuidedTourState
    escortDest = driveByHouse
    stateAfterEscort = elfLeading2
    commonDesc = "waiting for you to follow him to the southeast. "    
;

++ DefaultElfGuidedTourTopic
;


+ elfLeading2: ElfGuidedTourState
    escortDest = driveway
    stateAfterEscort = elfLeading3
    commonDesc = "beckoning you to follow him south along the driveway. "
    arrivingWithDesc = "{The elf/he} beckons you to follow him south along
        the driveway. "
;

++ DefaultElfGuidedTourTopic
;
    
+ elfLeading3: ElfGuidedTourState
    escortDest = frontYard
    stateAfterEscort = elfArriving
    commonDesc = "clearly anxious for you to follow him west into the front
        yard. "
    arrivingWithDesc = "{The elf/he} nods towards the front yard, indicating
        that you are to follow him westwards. "
;

++ DefaultElfGuidedTourTopic
;

+ elfArriving: ActorState
    
    arrivingTurn()
    {
        "{The elf/he} stops in the middle of the front yard and nods towards
        the tree. <.q>";
        getActor.happyEnding2();
    }
;

class ElfGuidedTourState: GuidedTourState
    escortStateClass = ElfGuidedInTravelState
    beforeTravel(traveler, connector)
    {
        if(connector != escortDest)
        {
            "<.q>No! No! Not that way!<./q> {the elf/he} stops you, his voice
            strangely compelling, <.q>We must go <i>that</i> way!<./q> He nods
            towards <<escortDest.destName>>. ";
            exit;
        }
        inherited(traveler, connector);
    }
    stateDesc = "He's <<commonDesc>>"
    specialDesc = "{The elf/he} is <<commonDesc>>"
    commonDesc = nil
;

class ElfGuidedInTravelState: GuidedInTravelState 
    sayDeparting(conn)
    {
        switch(conn)
        {
            case driveByHouse: "{The elf/he} leads the way to the side of the
                house. "; break;
            case driveway: "{The elf/he} strides ahead of you into the drive. ";
                 break;
            case frontYard: "{The elf/he} accompanies you into the front yard.
                "; break;
            default: inherited(conn);
        }
        
    }    
;

class DefaultElfGuidedTourTopic: DefaultAnyTopic, ShuffledEventList
    [
        '<.q>Never mind that now, just follow me!<./q> he replies. ',
        '<.q>Hurry up!<.q> {the elf/he} urges you, <.q>we must get to the front
        yard before she comes back!<./q> ',
        '<.q>Come on, I want to show you something!<./q> he interrupts you. '
    ]
;
    
