#charset "us-ascii"
#include <advlite.h>

//-----------------------------------------------------------------------------
// secludedLair
//-----------------------------------------------------------------------------

secludedLair: Room 'Secluded Lair of the Marionettes and Gerbils'
    "A very forest of greenery crawls up the walls of this oddly shaped little room.
    There's a stone archway to the northwest, but in every other direction you see
    only a mass of greenery.<.p>
    Dominating the area is a crowd of little wooden people -- marionettes, one would
    be inclined to call them. But nobody is pulling their strings. The marionettes
    seem to be managing quite nicely on their own. They're riding in circles on large rodents
    of some kind, and yipping and yahooing as if they were in a miniature rodeo. "
    
    northwest = secludedArch
    north = PM2
    northeast = PM2
    east = PM5
    southeast = PM3
    south = PM6
    southwest = PM8
    west = PM7
;

+ Decoration 'greenery; vigorous healthy; vegetation plants forest'
    "The vegetation appears to be quite vigorous and healthy. "
;

+ Decoration 'walls'
    "The walls are pretty much hidden by the plants. "
    plural = true
;

+ Decoration 'miniature rodeo'
    "It sure looks like a rodeo, podner. No Brahma bulls, though, and that's
    just as well. ";
;

+ secludedArch: OctagonExteriorPassage '+; (northwest)'
;

+ gerbils: Fixture 'gerbils; large furry; rodent rodents animal animals gerbil; them'
    "The gerbils (if that's what they are) are larger than you would have expected ---
    maybe the size of a cocker spaniel. Clearly they're rodents, though, not
    dogs or cats. The marionettes are riding them in circles. "
    dobjFor (Take) {
        verify() { logical; }
        check() {
            "Trying to catch them would be more trouble than it's worth. ";
        }
    }
    dobjFor(Pull) asDobjFor(Feel)
    dobjFor(Pat) asDobjFor(Feel)
    dobjFor(Feel) {
        verify() {}
        check() {
            "They're scampering aound too actively for you to get your hands on them. ";
        }
    }
;

+ lairMarionettes: Actor
    'marionettes; antic active hyper wood wooden little mahogany; women puppet marionette puppets men; them'
    "The little wooden men, about a dozen of them, are frantically active. They seem to be marionettes,
    though their strings dangle uselessly. Some of them are not men but women, and a couple
    have faces of an attractive mahogany hue. "
    plural = true
    celebrating = nil
;

++ marionettesCircling: ActorState
    specialDesc = "The marionettes are riding their gerbils in a circle around a large green bottle of
        MiraklGro. "
    stateDesc = "They're riding on gerbils. "
    isInitState = true
    beforeAction() {
        if (gActionIs(Take) && (gDobj == miraklGro) && (!marionettes.celebrating)) {
            "The marionettes form up in a solid barrier between you and the bottle, brandish
            their tiny swords and spears, and chant, <q>No, no, no!</q> ";
            exit;
        }
    }
;

+++ AskTopic, StopEventList @lairMarionettes
    [
        '<q>Well, you\'re a pretty bunch,</q> you tell them. <q>What are you, anyway</q><.p>
        <q>The nice lady downstairs made us,</q> one of them explains. <q>But then the wizard
        brought us to life. Or sort of, if you can call this living.</q><.p>
        <q>It\'s all right,</q> another of them adds. <q>But she never finished our costumes.
        We were supposed to be wearing nice colorful capes!</q><.p>
        The others take up the cry: <q>Yes, capes, capes! We need capes!</q> ',
        
        '<q>We told you already, lady,</q> says one of the little men. <q>We like riding around
        in the greenery, but we wish we had nice colorful capes to wear.</q> '
    ]
;
+++ DefaultAskTellTopic
    "The marionettes are too busy riding around and whooping to pay much attention to you. "
;
+++ GiveShowTopic @scrapsOfCloak
    topicResponse() {
        scrapsOfCloak.moveInto(nil);
        lairMarionettes.setState(marionettesCelebrating);
        miraklGro.isFixed = nil;
        "Their little wooden eyes light up when they see the colorful scraps of cloth.
        You hand out the scraps, one to each of the marionettes, and they tie them around
        their necks. In a trice they're riding in circles again, whooping and hollering.
        <q>Thanks, pretty lady!</q> one of them shouts. <q>If you want our big green bottle,
        you can have it now!</q> ";
        
    }
;

+++ GiveShowTopic [scarf, tatteredCloak]
    "<q>Ooh, pretty!</q> they chorus. <q>But too big, too big!</q> "
;

+++ DefaultGiveShowTopic
    "Your generous gesture fails to generate any signs of interest. "
;

++ marionettesCelebrating: ActorState
    specialDesc = "The marionettes are whooping and hollering as they ride hither and yon on
        their gerbils. "
    stateDesc = "They're showing off their new cloaks. "
;

// ----------------------------------------------------------------------
// The Plant Maze
// ----------------------------------------------------------------------

underPlantTunnel: TravelConnector
    destination = greenFriends
    travelDesc = "On your hands and knees you crawl under the mat of foliage.
        Your sense of direction, though faltering, enables you to emerge at last,
        unscathed and only slightly grimy. "
    canTravelerPass(t) { return true; }
;

// First we need a class of decorative plants that can rotate their colors.

class MazeFlowers: Fixture
    // vocab = 'stamens;; blossoms blossom flowers plant flower plants; them'
    desc = "<<rotateColor()>>The <<name>> are blooming enthusiastically. "
    dobjFor(CrawlUnder) {
        verify() {}
        action() { doInstead(Go, downDir); }
    }
    iobjFor(PourOnto) {
        verify() {}
        check() {
            if (gDobj == bioBGone) "Killing the nice flowers would be a
                terrible thing to do! ";
            else "The flowers are not in need of watering. ";
        }
    }
    cannotTakeMsg = 'Hmm, maybe come back later and pick a few flowers for
        a corsage, but not until after you have the prom dress. '
    assignName() {
        if (flowerName == 'lilies') {
            if (tempColor == 'white') name = 'white lilies';
            else if (tempColor == 'yellow') name = 'yellow lilies';
            else if (tempColor == 'orange') name = 'orange lilies';
            else if (tempColor == 'red') name = 'red lilies';
            else if (tempColor == 'pink') name = 'pink lilies';
            else if (tempColor == 'violet') name = 'violet lilies';
            else if (tempColor == 'blue') name = 'blue lilies';
            else "This should never print 1. ";
        }
        else if (flowerName == 'roses') {
            if (tempColor == 'white') name = 'white roses';
            else if (tempColor == 'yellow') name = 'yellow roses';
            else if (tempColor == 'orange') name = 'orange roses';
            else if (tempColor == 'red') name = 'red roses';
            else if (tempColor == 'pink') name = 'pink roses';
            else if (tempColor == 'violet') name = 'violet roses';
            else if (tempColor == 'blue') name = 'blue roses';
            else "This should never print 2. ";
        }
        else if (flowerName == 'tulips') {
            if (tempColor == 'white') name = 'white tulips';
            else if (tempColor == 'yellow') name = 'yellow tulips';
            else if (tempColor == 'orange') name = 'orange tulips';
            else if (tempColor == 'red') name = 'red tulips';
            else if (tempColor == 'pink') name = 'pink tulips';
            else if (tempColor == 'violet') name = 'violet tulips';
            else if (tempColor == 'blue') name = 'blue tulips';
            else "This should never print 3. ";
        }
    }
    colorRotation = 3
    nextColor = 0
    colorList = ['white', 'orange', 'yellow', 'red', 'pink', 'violet', 'blue']
    tempColor = 'white'
    
    rotateColor() {
        nextColor++;
        if (nextColor > colorRotation) nextColor = 1;
        tempColor = colorList[nextColor];
        assignName();
        // If I'm doing it right, this next line should replace the primary
        // vocab entry with the new color.
        addVocab (name);
    }
    flowerName = 'lilies'
    name = 'white lilies'
;

class PlantMazeRoom: Room
    roomTitle = 'Among the Flowering Plants'
    vocab = 'qqqqq'
    desc = "You are surrounded on all sides by masses of flowering plants. The
        <<showPlants()>> are especially beautiful. You
        can travel in almost any direction. "
    plantsHere = flowers1
    showPlants() {
        plantsHere.rotateColor();
        return plantsHere.name;
    }
    roomNumber = 1
    warningGiven = nil
    roomBeforeAction() {
        if (warningGiven) return;
        local roomList = [PM1, PM2, PM3, PM4, PM5, PM6, PM7, PM8, PM9];
        if (gActionIs(Drop) || gActionIs(Throw)) {
            for (local i=1; i<10; i++) {
                roomList[i].warningGiven = true;
            }
            "It occurs to you that dropping things here might not be such a grand
            idea. You might have a wee bit of trouble finding them again. ";
            exit;
        }
    }
    down = underPlantTunnel
    roomAfterAction() {
        if (gActionIs(Drop) || gActionIs(GoTo) || gActionIs(Throw)) {
            "A smallish entity riding some sort of rodent scampers past you. With
            a little <q>Yippee!</q>, the entity scoops up whatever looks interesting and
            rides off into the foliage with it. ";
            local foundOne = nil;
            local len = self.contents.length() + 1;
            local objList = [];
            // First we make an object list of anything portable that's in the room's contents:
            for (local i = 1; i < len; i++) {
                // "Test: Now attempting <<self.contents[i].name>>. ";
                if (self.contents[i].ofKind(PDportable)) {
                    foundOne = self.contents[i];
                    objList = objList.append(foundOne);
                }
            }
            local len2 = objList.length();
            if (len2 == 0) return;
            // Now we'll redistribute whatever is in the object list:
            for (local j = 1; j <= len2; j++)
            {
                relocate (objList[j]);
            }
        }          
    }
    relocate(obj) {
        local roomList = [PM1, PM2, PM3, PM4, PM5, PM6, PM7, PM8, PM9];
        local room = PM1;
        local r = rand(9) + 1;
        room = roomList[r];
        // Do a quick reset if the little guy is about to redistribute
        // what you dropped to the room you're already in:
        while (room == gPlayerChar.getOutermostRoom) {
            r = rand(9) + 1;
            room = roomList[r];
            }
        obj.moveInto(room);
    }
;

PM1: PlantMazeRoom
    roomNumber = 1
    plantsHere = flowers1
    north = PM3
    northwest = PM2
    west = PM7
    southwest = PM3
    south = PM1
    southeast = PM4
    east = PM5
    northeast = greenFriends
;
+ flowers1: MazeFlowers 'white lilies;; foliage lily blossoms blossom flowers plant flower plants; them'
    flowerName = 'lilies'
    tempColor = 'white'
    // using the defaults for colorRotation and colorList
;
    
PM2: PlantMazeRoom
    roomNumber = 2
    plantsHere = flowers2
    north = PM3
    northwest = PM9
    west = PM8
    southwest = PM2
    south = PM2
    southeast = PM6
    east = PM1
    northeast = PM4
;
+ flowers2: MazeFlowers 'orange roses;; foliage rose blossoms blossom flowers plant flower plants; them'
    flowerName = 'roses'
    colorRotation = 4
    tempColor = 'orange'
    colorList = ['orange', 'pink', 'yellow', 'pink']
;
    
PM3: PlantMazeRoom
    roomNumber = 3
    plantsHere = flowers3
    north = PM9
    northwest = PM3
    west = PM9
    southwest = PM1
    south = PM4
    southeast = PM5
    east = PM6
    northeast = PM2
;
+ flowers3: MazeFlowers 'blue tulips;; foliage tulip blossoms blossom flowers plant flower plants; them'
    flowerName = 'tulips'
    colorRotation = 3
    tempColor = 'blue'
    colorList = ['blue', 'pink', 'yellow']
;
PM4: PlantMazeRoom
    roomNumber = 4
    plantsHere = flowers4
    north = PM2
    northwest = PM7
    west = PM4
    southwest = PM8
    south = PM3
    southeast = PM3
    east = PM6
    northeast = PM9
;
+ flowers4: MazeFlowers 'white tulips;; foliage tulip blossoms blossom flowers plant flower plants; them'
    flowerName = 'tulips'
    colorRotation = 4
    tempColor = 'white'
    colorList = ['white', 'blue', 'pink', 'yellow']
;
PM5: PlantMazeRoom
    roomNumber = 5
    plantsHere = flowers5
    north = PM2
    northwest = PM3
    west = PM7
    southwest = PM6
    south = PM9
    southeast = PM1
    east = PM1
    northeast = PM5
;
+ flowers5: MazeFlowers 'pink roses;; foliage rose blossoms blossom flowers plant flower plants; them'
    flowerName = 'roses'
    colorRotation = 3
    tempColor = 'pink'
    colorList = ['pink', 'yellow', 'white']
;
PM6: PlantMazeRoom
    roomNumber = 6
    plantsHere = flowers6
    north = PM3
    northwest = PM6
    west = PM7
    southwest = PM2
    south = PM4
    southeast = PM3
    east = PM1
    northeast = PM8
;
+ flowers6: MazeFlowers 'yellow lilies;; foliage lily blossoms blossom flowers plant flower plants; them'
    flowerName = 'lilies'
    tempColor = 'yellow'
    colorRotation = 4
    colorList = ['yellow', 'blue', 'pink', 'violet']
;
PM7: PlantMazeRoom
    roomNumber = 7
    plantsHere = flowers7
    north = PM1
    northwest = PM3
    west = PM7
    southwest = PM4
    south = PM3
    southeast = PM8
    east = PM2
    northeast = PM9
;
+ flowers7: MazeFlowers 'violet lilies;; foliage lily blossoms blossom flowers plant flower plants; them'
    flowerName = 'lilies'
    tempColor = 'violet'
    colorRotation = 3
    colorList = ['violet', 'white', 'red']
;
PM8: PlantMazeRoom
    roomNumber = 8
    plantsHere = flowers8
    north = PM3
    northwest = PM1
    west = PM1
    southwest = PM1
    south = PM5
    southeast = PM8
    east = PM7
    northeast = PM3
;
+ flowers8: MazeFlowers 'red roses;; foliage rose blossoms blossom flowers plant flower plants; them'
    flowerName = 'roses'
    colorRotation = 3
    tempColor = 'pink'
    colorList = ['red', 'yellow', 'white']
;
PM9: PlantMazeRoom
    roomNumber = 9
    plantsHere = flowers9
    north = PM9
    northwest = PM8
    west = PM7
    southwest = PM1
    south = PM2
    southeast = PM2
    east = secludedLair
    northeast = PM1
;
+ flowers9: MazeFlowers 'white tulips;; foliage tulip blossoms blossom flowers plant flower plants; them'
    flowerName = 'tulips'
    colorRotation = 4
    tempColor = 'white'
    colorList = ['white', 'violet', 'pink', 'orange']
;

