/*
** Arr_adv.t only exists because I am nit-picky. I've gone through and
** changed all the regular single quotes to &rsquo; for HTML TADS.
**
** Copyright (c) 1998, Stephen Granade. All rights reserved.
*/

#pragma C-

replace checkReach: function(loc, actor, v, obj)
{
    if (obj = numObj or obj = strObj)
        return;
    if (not (actor.isCarrying(obj) or obj.isIn(actor.location)))
    {
        if (find(loc.reachable, obj) <> nil)
             return;
        "%You% can&rsquo;t reach "; obj.thedesc; " from "; loc.thedesc; ". ";
        exit;
    }
}

modify numberedObject
    dobjGen(a, v, i, p) = {
        if (self.value = nil) {
            "You&rsquo;ll have to be more specific about which one you
		mean.";
            exit;
        }
    }
;

modify thing
    itisdesc = {
        /* display "it's" if this is singular, "they're" otherwise */
        if (self.isThem)
            "they&rsquo;re";
        else
            "it&rsquo;s";
    }
    readdesc = { "%You% can&rsquo;t read "; self.adesc; ". "; }
    verDoPush(actor) =
    {
        "Pushing "; self.thedesc; " doesn&rsquo;t do anything. ";
    }
    verDoWear(actor) =
    {
        "%You% can&rsquo;t wear "; self.thedesc; ". ";
    }
    cantReach(actor) =
    {
        if (not actor.isactor)
        {
            "\^<<actor.thedesc>> <<actor.doesdesc>> not respond.";
            return;
        }
        if (not isclass(actor, movableActor))
        {
            "There&rsquo;s no point in talking to <<actor.sdesc>>.";
            return;
        }
        
        if (self.location = nil)
        {
            if (actor.location.location)
                "%You% can&rsquo;t reach that from << actor.location.thedesc >>. ";
            else
                "%You% can&rsquo;t reach that.";
            return;
        }
        if (not self.location.isopenable or self.location.isopen)
            self.location.cantReach(actor);
        else
            "%You%&rsquo;ll have to open << self.location.thedesc >> first. ";
    }
    verIoPutIn(actor) =
    {
        "%You% can&rsquo;t put anything into "; self.thedesc; ". ";
    }
    circularMessage(io) =
    {
        local cont, prep;

        /* set prep to 'on' if io.location is a surface, 'in' otherwise */
        prep := (io.location.issurface ? 'on' : 'in');

        /* tell them about the problem */
        "%You% can&rsquo;t put <<thedesc>> <<prep>> <<io.thedesc>>, because <<
            io.thedesc>> <<io.isdesc>> <<
            io.location = self ? "already" : "">> <<prep>> <<
            io.location.thedesc>>";
        for (cont := io.location ; cont <> self ; cont := cont.location)
        {
            ", which <<cont.isdesc>> <<
                cont.location = self ? "already" : "">> <<prep>> <<
                cont.location.thedesc>>";
        }
        ". ";
    }
    verDoPutIn(actor, io) =
    {
        if (io = nil)
            return;

        if (self.location = io)
        {
            caps(); self.thedesc; " is already in "; io.thedesc; "! ";
        }
        else if (io = self)
        {
            "%You% can&rsquo;t put "; self.thedesc; " in itself! ";
        }
        else if (io.isIn(self))
            self.circularMessage(io);
        else
            self.verifyRemove(actor);
    }
    verIoPutOn(actor) =
    {
        "There&rsquo;s no good surface on "; self.thedesc; ". ";
    }
    verDoPutOn(actor, io) =
    {
        if (io = nil)
            return;

        if (self.location = io)
        {
            caps(); self.thedesc; " is already on "; io.thedesc; "! ";
        }
        else if (io = self)
        {
            "%You% can&rsquo;t put "; self.thedesc; " on itself! ";
        }
        else if (io.isIn(self))
            self.circularMessage(io);
        else
            self.verifyRemove(actor);
    }
    verDoTakeOut(actor, io) =
    {
        if (io <> nil and not self.isIn(io))
        {
            caps(); self.thedesc; " isn&rsquo;t in "; io.thedesc; ". ";
        }
        else
            self.verDoTake(actor);     /* ensure object can be taken at all */
    }
    verDoTakeOff(actor, io) =
    {
        if (io <> nil and not self.isIn(io))
        {
            caps(); self.thedesc; " isn&rsquo;t on "; io.thedesc; "! ";
        }
        self.verDoTake(actor);         /* ensure object can be taken at all */
    }
    verIoPlugIn(actor) =
    {
        "%You% can&rsquo;t plug anything into "; self.thedesc; ". ";
    }
    verDoPlugIn(actor, io) =
    {
        "%You% can&rsquo;t plug "; self.thedesc; " into anything. ";
    }
    verIoUnplugFrom(actor) =
    {
        "That is not plugged into "; self.thedesc; ". ";
    }
    verDoUnplugFrom(actor, io) =
    {
        if (io <> nil)
            { "\^<<self.itisdesc>> not plugged into "; io.thedesc; ". "; }
    }
    verDoLookin(actor) =
    {
        "There&rsquo;s nothing in "; self.thedesc; ". ";
    }
    thrudesc = { "%You% can&rsquo;t see much through << thedesc >>.\n"; }
    verDoLookthru(actor) =
    {
        "%You% can&rsquo;t see anything through "; self.thedesc; ". ";
    }
    verDoLookunder(actor) =
    {
        "There&rsquo;s nothing under "; self.thedesc; ". ";
    }
    verDoRead(actor) =
    {
        "I don&rsquo;t know how to read "; self.thedesc; ". ";
    }
    verDoLookbehind(actor) =
    {
        "There&rsquo;s nothing behind "; self.thedesc; ". ";
    }
    verDoTurn(actor) =
    {
        "Turning "; self.thedesc; " doesn&rsquo;t have any effect. ";
    }
    verDoTurnWith(actor, io) =
    {
        "Turning "; self.thedesc; " doesn&rsquo;t have any effect. ";
    }
    verDoTurnTo(actor, io) =
    {
        "Turning "; self.thedesc; " doesn&rsquo;t have any effect. ";
    }
    verIoTurnTo(actor) =
    {
        "I don&rsquo;t know how to do that. ";
    }
    verDoTurnon(actor) =
    {
        "I don&rsquo;t know how to turn "; self.thedesc; " on. ";
    }
    verDoTurnoff(actor) =
    {
        "I don&rsquo;t know how to turn "; self.thedesc; " off. ";
    }
    verDoAskAbout(actor, io) =
    {
        "Surely, %you% can&rsquo;t think "; self.thedesc; " knows anything
        about it! ";
    }
    verDoTellAbout(actor, io) =
    {
        "It doesn&rsquo;t look as though "; self.thedesc; " is interested. ";
    }
    verDoUnboard(actor) =
    {
        if (actor.location <> self)
        {
            "%You're% not <<self.statusPrep>> <<self.thedesc>>! ";
        }
        else if (self.location = nil)
        {
            "%You% can&rsquo;t leave <<self.thedesc>>! ";
        }
    }
    doUnboard(actor) =
    {
        if (self.fastenitem)
        {
            "%You%&rsquo;ll have to unfasten <<actor.location.fastenitem.thedesc
            >> first. ";
        }
        else
        {
            "Okay, %you're% no longer <<self.statusPrep>> <<self.thedesc>>. ";
            self.leaveRoom(actor);
            actor.moveInto(self.location);
        }
    }
    verDoAttackWith(actor, io) =
    {
        "Attacking "; self.thedesc; " doesn&rsquo;t appear productive. ";
    }
    verIoAttackWith(actor) =
    {
        "It&rsquo;s not very effective to attack with "; self.thedesc; ". ";
    }
    verDoEat(actor) =
    {
        caps(); self.thedesc; " doesn&rsquo;t appear appetizing. ";
    }
    verDoDrink(actor) =
    {
        caps(); self.thedesc; " doesn&rsquo;t appear appetizing. ";
    }
    verDoPull(actor) =
    {
        "Pulling "; self.thedesc; " doesn&rsquo;t have any effect. ";
    }
    doShowTo(actor, io) =
    {
        if (io <> nil)
        {
            caps(); io.thedesc; " isn&rsquo;t impressed. ";
        }
    }
    verIoShowTo(actor) =
    {
        caps(); self.thedesc; " isn&rsquo;t impressed. ";
    }
    verDoMove(actor) =
    {
        "Moving "; self.thedesc; " doesn&rsquo;t reveal anything. ";
    }
    verDoMoveTo(actor, io) =
    {
        "Moving "; self.thedesc; " doesn&rsquo;t reveal anything. ";
    }
    verIoMoveTo(actor) =
    {
        "That doesn&rsquo;t get us anywhere. ";
    }
    verDoMoveWith(actor, io) =
    {
        "Moving "; self.thedesc; " doesn&rsquo;t reveal anything. ";
    }
    verIoMoveWith(actor) =
    {
        caps(); self.thedesc; " doesn&rsquo;t seem to help. ";
    }
    verDoTouch(actor) =
    {
        "Touching "; self.thedesc; " doesn&rsquo;t seem to have any effect. ";
    }
    verDoPoke(actor) =
    {
        "Poking "; self.thedesc; " doesn&rsquo;t seem to have any effect. ";
    }
    verDoBreak(actor) = {}
    doBreak(actor) =
    {
        "You&rsquo;ll have to tell me how to do that.";
    }
    genMoveDir = { "%You% can&rsquo;t seem to do that. "; }
;

modify hider
    verDoSearch(actor) =
    {
        "%You%&rsquo;ll have to be more specific about how %you% want%s%
        to search that. ";
    }
;

modify underHider
    doLookunder(actor) =
    {
        if (self.underCont = nil)
            "There&rsquo;s nothing else under <<self.thedesc>>. ";
        else
            self.underCont := self.searchObj(actor, self.underCont);
    }
;

modify behindHider
    doLookbehind(actor) =
    {
        if (self.behindCont = nil)
            "There&rsquo;s nothing else behind <<self.thedesc>>. ";
        else
            self.behindCont := self.searchObj(actor, self.behindCont);
    }
;

modify searchHider
    doSearch(actor) =
    {
        if (self.searchCont = nil)
            "There&rsquo;s nothing else in <<self.thedesc>>. ";
        else
            self.searchCont := self.searchObj(actor, self.searchCont);
    }
;

modify fixeditem
    verDoTake(actor) =
    {
        "%You% can&rsquo;t have "; self.thedesc; ". ";
    }
    verDoDrop(actor) =
    {
        "%You% can&rsquo;t drop "; self.thedesc; ". ";
    }
    verDoPutIn(actor, io) =
    {
        "%You% can&rsquo;t put "; self.thedesc; " anywhere. ";
    }
    verDoPutOn(actor, io) =
    {
        "%You% can&rsquo;t put "; self.thedesc; " anywhere. ";
    }
    verDoMove(actor) =
    {
        "%You% can&rsquo;t move "; self.thedesc; ". ";
    }
    verDoThrowAt(actor, iobj) =
    {
        "%You% can&rsquo;t throw <<self.thedesc>>.";
    }
;

modify dialItem
    ldesc =
    {
        caps(); self.thedesc; " can be turned to settings
        numbered from <<self.minsetting>> to << self.maxsetting >>.
        \^<<self.itisdesc>> currently set to << self.setting >>. ";
    }
    doTurnTo(actor, io) =
    {
        if (io = numObj)
        {
            if (numObj.value < 1 or numObj.value > self.maxsetting)
            {
                "There&rsquo;s no such setting! ";
            }
            else if (numObj.value <> self.setting)
            {
                self.setting := numObj.value;
                "Okay, <<self.itisdesc>> now turned to "; say(self.setting); ". ";
            }
            else
            {
                "\^<<self.itisdesc>> already set to "; say(self.setting); "! ";
            }
        }
        else
        {
            "I don&rsquo;t know how to turn "; self.thedesc;
            " to that. ";
        }
    }
;

modify switchItem
    verDoTurnon(actor) =
    {
        /*
         *   You can't turn on something in the dark unless you're
         *   carrying it.  You also can't turn something on if it's
         *   already on.  
         */
        if (not actor.location.islit and not actor.isCarrying(self))
            "It&rsquo;s pitch black.";
        else if (self.isActive)
            "\^<<self.itisdesc>> already turned on! ";
    }
    doTurnon(actor) =
    {
        self.isActive := true;
        "Okay, <<self.itisdesc>> now turned on. ";
    }
    verDoTurnoff(actor) =
    {
        if (not self.isActive)
            "\^<<self.itisdesc>> already turned off! ";
    }
    doTurnoff(actor) =
    {
        self.isActive := nil;
        "Okay, <<self.itisdesc>> now turned off. ";
    }
;

modify room
    cantReach(actor) = { "I don&rsquo;t see that here."; }
    noexit = { "%You% can&rsquo;t go that way. "; return nil; }
;

modify darkroom
    roomAction(actor, v, dobj, prep, io) =
    {
        if (not self.islit and not v.isDarkVerb)
        {
            "%You% can&rsquo;t see a thing. ";
            exit;
        }
        else
            pass roomAction;
    }
    lookAround(verbosity) =
    {
        if (self.islit)
            pass lookAround;
        else
            "It&rsquo;s pitch black. ";
    }
    roomCheck(v) =
    {
        if (self.islit or v.isDarkVerb)
            return true;
        else
        {
            "It&rsquo;s pitch black.\n";
            return nil;
        }
    }
;

modify movableActor
    actorAction(v, d, p, i) =
    {
        caps(); self.thedesc; " <<self.doesdesc>>n&rsquo;t appear
            interested. ";
        exit;
    }
    verGrab(item) =
    {
        caps(); self.thedesc; " <<self.isdesc>> carrying "; item.thedesc;
        " and won&rsquo;t let %youm% have it. ";
    }
    fmtYoure = "he&rsquo;s"
    fmtYouve = "he&rsquo;s"
    disavow = "\"I don&rsquo;t know much about that.\""
    verIoGiveTo(actor) =
    {
        if (actor = self)
            "That wouldn&rsquo;t accomplish anything!";
    }
;

modify basicMe
    verDoFollow(actor) =
    {
        if (actor = self)
            "You can&rsquo;t follow yourself! ";
    }
    fmtYoure = "you&rsquo;re"
    fmtYouve = "you&rsquo;ve"
;

modify decoration
    ldesc = "That&rsquo;s not important."
    dobjGen(a, v, i, p) =
    {
        if (v <> inspectVerb)
        {
            "\^<<self.thedesc>> <<self.isdesc>>n&rsquo;t important.";
            exit;
        }
    }
    iobjGen(a, v, d, p) =
    {
        "\^<<self.thedesc>> <<self.isdesc>>n&rsquo;t important.";
        exit;
    }
;

modify distantItem
    dobjGen(a, v, i, p) =
    {
        if (v <> askVerb and v <> tellVerb and v <> inspectVerb)
        {
            "\^<<self.itisdesc>> too far away.";
            exit;
        }
    }
;

modify clothingItem
    verDoWear(actor) =
    {
        if (self.isworn)
        {
            "%You're% already wearing "; self.thedesc; "! ";
        }
        else if (not actor.isCarrying(self))
        {
            "%You% %do%n&rsquo;t have "; self.thedesc; ". ";
        }
    }
;

modify doorway
    destination =
    {
        if (self.isopen)
            return self.doordest;
        else if (not self.islocked and not self.noAutoOpen)
        {
            self.isopen := true;
            if (self.otherside)
                self.otherside.isopen := true;
            "(Opening << self.thedesc >>)\n";
            return self.doordest;
        }
        else
        {
            "%You%&rsquo;ll have to open << self.thedesc >> first. ";
            setit(self);
            return nil;
        }
    }
    verDoOpen(actor) =
    {
        if (self.isopen)
            "\^<<self.itisdesc>> already open. ";
        else if (self.islocked)
            "\^<<self.itisdesc>> locked. ";
    }
    verDoClose(actor) =
    {
        if (not self.isopen)
            "\^<<self.itisdesc>> already closed. ";
    }
    verDoLock(actor) =
    {
        if (self.islocked)
            "\^<<self.itisdesc>> already locked! ";
        else if (not self.islockable)
            "\^<<self.itnomdesc>> can&rsquo;t be locked. ";
        else if (self.isopen)
            "%You%&rsquo;ll have to close <<self.itobjdesc>> first. ";
    }
    verDoUnlock(actor) =
    {
        if (not self.islocked)
            "\^<<self.itisdesc>> not locked! ";
    }
    verDoLockWith(actor, io) =
    {
        if (self.islocked)
            "\^<<self.itisdesc>> already locked. ";
        else if (not self.islockable)
            "\^<<self.itnomdesc>> can&rsquo;t be locked. ";
        else if (self.mykey = nil)
            "%You% %do%n&rsquo;t need anything to lock <<self.itobjdesc>>. ";
        else if (self.isopen)
            "%You%&rsquo;ll have to close <<self.itobjdesc>> first. ";
    }
    doLockWith(actor, io) =
    {
        if (io = self.mykey)
        {
            "Locked. ";
            self.islocked := true;
            if (self.otherside)
                self.otherside.islocked := true;
        }
        else
            "\^<<self.itnomdesc>> doesn&rsquo;t fit the lock. ";
    }
    verDoUnlockWith(actor, io) =
    {
        if (not self.islocked)
            "\^<<self.itisdesc>> not locked! ";
        else if (self.mykey = nil)
            "%You% %do%n&rsquo;t need anything to unlock <<self.itobjdesc>>. ";
    }
    doUnlockWith(actor, io) =
    {
        if (io = self.mykey)
        {
            "Unlocked. ";
            self.islocked := nil;
            if (self.otherside)
                self.otherside.islocked := nil;
        }
        else
            "\^<<self.itnomdesc>> doesn&rsquo;t fit the lock. ";
    }
    ldesc =
    {
        if (self.isopen)
            "\^<<self.itisdesc>> open. ";
        else
        {
            if (self.islocked)
                "\^<<self.itisdesc>> closed and locked. ";
            else
                "\^<<self.itisdesc>> closed. ";
        }
    }
;

modify vehicle
    verDoBoard(actor) =
    {
        if (actor.location = self)
        {
            "%You're% already <<self.statusPrep>> <<self.thedesc>>! ";
        }
        else if (actor.isCarrying(self))
        {
            "%You%&rsquo;ll have to drop <<self.thedesc>> first!";
        }
    }
    verDoTake(actor) =
    {
        if (actor.isIn(self))
            "%You%&rsquo;ll have to get <<self.outOfPrep>> <<self.thedesc>> first.";
        else
            pass verDoTake;
    }
    dobjGen(a, v, i, p) =
    {
        if (a.isIn(self) and v <> inspectVerb and v <> getOutVerb
            and v <> outVerb)
        {
            "%You%&rsquo;ll have to get <<self.outOfPrep>> <<
                self.thedesc>> first. ";
            exit;
        }
    }
    iobjGen(a, v, d, p) =
    {
        if (a.isIn(self) and v <> putVerb)
        {
            "%You%&rsquo;ll have to get <<self.outOfPrep>> <<
                self.thedesc>> first. ";
            exit;
        }
    }
;

modify surface
    ldesc =
    {
        if (itemcnt(self.contents))
        {
            "On "; self.thedesc; " %you% see%s% "; listcont(self); ". ";
        }
        else
        {
            "There&rsquo;s nothing on "; self.thedesc; ". ";
        }
    }
    doSearch(actor) =
    {
        if (itemcnt(self.contents) <> 0)
            "On <<self.thedesc>> %you% see%s% <<listcont(self)>>. ";
        else
            "There&rsquo;s nothing in <<self.thedesc>>. ";
    }
;

modify container
    ldesc =
    {
        if (self.contentsVisible and itemcnt(self.contents) <> 0)
        {
            "In "; self.thedesc; " %you% see%s% "; listcont(self); ". ";
        }
        else
        {
            "There&rsquo;s nothing in "; self.thedesc; ". ";
        }
    }
    ioPutIn(actor, dobj) =
    {
        if (addbulk(self.contents) + dobj.bulk > self.maxbulk)
        {
            "%You% can&rsquo;t fit that in "; self.thedesc; ". ";
        }
        else
        {
            dobj.doPutIn(actor, self);
        }
    }
    doSearch(actor) =
    {
        if (self.contentsVisible and itemcnt(self.contents) <> 0)
            "In <<self.thedesc>> %you% see%s% <<listcont(self)>>. ";
        else
            "There&rsquo;s nothing in <<self.thedesc>>. ";
    }
;

modify openable
    verDoLookin(actor) =
    {
        /* we can look in it if either it's open or it's transparent */
        if (not self.isopen and not isclass(self, transparentItem))
           "\^<<self.itisdesc>> closed. ";
    }
;

modify lockable
    verDoOpen(actor) =
    {
        if (self.islocked)
        {
            "\^<<self.itisdesc>> locked. ";
        }
        else
            pass verDoOpen;
    }
    verDoLock(actor) =
    {
        if (self.islocked)
        {
            "\^<<self.itisdesc>> already locked! ";
        }
    }
    doLock(actor) =
    {
        if (self.isopen)
        {
            "%You%&rsquo;ll have to close "; self.thedesc; " first. ";
        }
        else
        {
            "Locked. ";
            self.islocked := true;
        }
    }
    verDoUnlock(actor) =
    {
        if (not self.islocked)
            "\^<<self.itisdesc>> not locked! ";
    }
    verDoLockWith(actor, io) =
    {
        if (self.islocked)
            "\^<<self.itisdesc>> already locked. ";
    }
    verDoUnlockWith(actor, io) =
    {
        if (not self.islocked)
            "\^<<self.itisdesc>> not locked! ";
        else if (self.mykey = nil)
            "%You% %do%n&rsquo;t need anything to unlock << self.itobjdesc >>.";
    }
;

modify keyedLockable
    doLockWith(actor, io) =
    {
        if (self.isopen)
        {
            "%You% can&rsquo;t lock << self.thedesc >> when <<self.itisdesc>> open. ";
        }
        else if (io = self.mykey)
        {
            "Locked. ";
            self.islocked := true;
        }
        else
            "\^<<self.itnomdesc>> doesn&rsquo;t fit the lock. ";
    }
    doUnlockWith(actor, io) =
    {
        if (io = self.mykey)
        {
            "Unlocked. ";
            self.islocked := nil;
        }
        else
            "\^<<self.itnomdesc>> doesn&rsquo;t fit the lock. ";
    }
;

modify transparentItem
    ldesc =
    {
        if (self.contentsVisible and itemcnt(self.contents) <> 0)
        {
            "In "; self.thedesc; " %you% see%s% "; listcont(self); ". ";
        }
        else
        {
            "There&rsquo;s nothing in "; self.thedesc; ". ";
        }
    }
    doSearch(actor) =
    {
        if (self.contentsVisible and itemcnt(self.contents) <> 0)
            "In <<self.thedesc>> %you% see%s% <<listcont(self)>>. ";
        else
            "There&rsquo;s nothing in <<self.thedesc>>. ";
    }
;

modify sleepVerb
    action(actor) =
    {
        if (actor.cantSleep)
            "%You% %are% much too anxious worrying about %your% continued
            survival to fall asleep now. ";
        else if (global.awakeTime+1 < global.sleepTime)
            "%You're% not tired. ";
        else if (not (actor.location.isbed or actor.location.ischair))
            "I don&rsquo;t know about you, but I can never sleep
            standing up. %You% should find a nice comfortable
            bed somewhere. ";
        else
        {
            "%You% quickly drift%s% off into dreamland...\b";
            goToSleep();
        }
    }
;

modify debugVerb
    enterDebugger(actor) =
    {
        if (debugTrace())
            "You can&rsquo;t think this game has any bugs left in it... ";
    }
;

