#charset "us-ascii"

#pragma once

#ifndef ADV3_H
#include <adv3.h>
#endif

// checks for if a variable was NOT defined from file en_us.h
// .. and if so then include the file to define that variable, method, etc.
#ifndef singleDir
#include <en_us.h>
// #error "You can put an error here too if the variable <> something. "
#endif

/* 
 *  Modifications File 
 * 
 *  This is where we override and/or redefine
 *  existing TADS objects and methods.
 *
 *  NOTE: As this file *modifys* objects and routines, you
 *        should #include this file at the very END of your
 *        main file, not at the beginning where normal include's are.
 *
 *  Main game file: 
 *  C:\sw\game_design\tads3\cromGame3.cromfun3.t
 * 
 *  see: D:\sw\game_design\tads3\t3_doc\t3banner.htm
 *  see: msg_neu.t, banner.t
 *  see: status.t  for: removing default banner
 *                i.e.: statuslineBanner.removeBanner(); // note: use at own risk
 */  



// for words that are like "actor/singer"
PreinitObject
    execute()
    {
        cmdTokenizer.insertRule(
            ['slash-word', new RexPattern('<alpha>+/<alpha>+'),
             tokString, nil, nil],
            'word', nil);
    }
;

// for words that are like "/tell"
PreinitObject
    execute()
    {
        cmdTokenizer.insertRule(
            ['chat-word', new RexPattern('/<alpha>+'),
             tokString, nil, nil],
            'word', nil);
    }
;


// for words that are like "7%"
PreinitObject
    execute()
    {
        cmdTokenizer.insertRule(
            ['percentage', new RexPattern('<digit>+<percent>'),
             tokString, nil, nil],
            'word', nil);
    }
;

modify Actor
    inventoryLister: actorInventoryLister
    {
        showInventoryEmpty(parent)
        {
            /* empty inventory */
            "<<buildSynthParam('The/he', parent)>> {is} holding absolutely
            nothing. ";
        }
        showInventoryWearingOnly(parent, wearing)
        {
            /* we're carrying nothing but wearing some items */
            "<<buildSynthParam('The/he', parent)>> {is}n\'t holding anything,
            but {is} sporting <<wearing>>. ";
        }
        showInventoryCarryingOnly(parent, carrying)
        {
            /* we have only carried items to report */
            "<<buildSynthParam('The/he', parent)>> {is} holding <<carrying>>. ";
        }
        showInventoryShortLists(parent, carrying, wearing)
        {
            local nm = gSynthMessageParam(parent);
            
            /* short lists - combine carried and worn in a single sentence */
            "<<buildParam('The/he', nm)>> {is} holding <<carrying>>,
            and <<buildParam('it\'s', nm)>>{subj} sporting <<wearing>>. ";
        }
        showInventoryLongLists(parent, carrying, wearing)
        {
            local nm = gSynthMessageParam(parent);
            
            /* long lists - show carried and worn in separate sentences */
            "<<buildParam('The/he', nm)>> {is} holding <<carrying>>.
            <<buildParam('It\'s', nm)>> sporting <<wearing>>. ";
        }
        /*
         *   For 'tall' listings, we'll use the standard listing style, so we
         *   need to provide the framing messages for the tall-mode 
         *   listing.  
         */
        showListPrefixTall(itemCount, pov, parent)
            { "<<buildSynthParam('The/he', parent)>> {is} holding:"; }
        showListContentsPrefixTall(itemCount, pov, parent)
            { "<<buildSynthParam('A/he', parent)>>, who {is} holding:"; }           
    }    
;



    
// modify input.t
modify InputDef
    beginInputFont(){   "<.inputline><font color=black>"; }
    endInputFont(){ "</font><./inputline>"; }
;
   
modify libMessages
    mainCommandPrompt(which){
       //"<font color=#00FF00>What do you want to do now? \b&gt</font>";// WORKS!!!
       "<font color=\"black\"> \b&gt</font>";// WORKS!!!
    }   
;


// Stops various program crashes on "ct me" commands
DefineIAction(ChatTellTwo)
  execAction(){
        "Talking to yourself? ";
  }
;
VerbRule(ChatTellTwo)
  '/tell' ('me' | 'myself' | 'Quill' | 'player') 
  :ChatTellTwoAction
  verbPhrase = 'chat tell/telling myself'
;

// stops various program crashes on "ct me <something>" commands
DefineIAction(ChatTellThree)
  execAction(){
        "Talking to yourself? ";
  }
;
VerbRule(ChatTellThree)
  '/tell' ('me' | 'myself' | 'Quill' | 'player') singleLiteral
  :ChatTellThreeAction
  verbPhrase = 'chat tell/telling myself (what)'
;

// Player can "chat" to varioius NPCs in the game with the command: /tell <actor> "string of text to send" 
DefineLiteralTAction(ChatTell,DirectObject) // Actor)
  execAction(){
     local myDobj = getDobj();
     if((myDobj==gPlayerChar)|| (gActor==gPlayerChar)){              
        if(gActor==myDobj){
          "<br>Talking you yourself again? ";
          exit;
        }     
        "&nbsp;<font color=#9900FF>[You tell <<myDobj.name>>]: <<gLiteral>></font> ";
        myDobj.chatReply(gLiteral);// ask the NPC for a chat reply to our tell
     }
  }
  // otherwise you can't chat outside of your current room location to other actors 
  objInScope(obj) { return true; } // if(obj.ofKind(Actor)) return true; 
  askDobjResponseProd = singleNoun
  //askLiteralResponseProd = withSingleNoun
;
VerbRule(ChatTell)
  '/tell' singleDobj singleLiteral 
  :ChatTellAction
  verbPhrase = 'chat tell/telling (who) (what)'
;
modify Thing
 chattable = nil 
  dobjFor(ChatTell){ verify(){ if(self.chattable==nil) illogical('There\'s no way to chat tell {that dobj/him}. '); } 
         check(){ }
  }
  // replies to a chat tell command
  chatReply(sentstring){ }
;
modify Actor
  chattable = true 
  dobjFor(ChatTell){ verify(){ if(gActor.chattable==nil) illogical('There\'s no way to chat tell {that dobj/him}. '); } 
         check(){ }
  }
  // replies to a chat tell command
  chatReply(sentstring){ 
        "<br>&nbsp;<font color=red>[<<self.name>> AFK message]: Sorry, I\'m away from the keyboard right now.</font> ";
  } 
  // stop a NIL object crash bug
  setPronounObj(obj){
     if(obj!=nil){
        obj = obj.getIdentityObject();
        if(obj==nil) exit;// abort if still nil
        if (obj.canMatchHim) setHim(obj);
        if (obj.canMatchHer) setHer(obj);
        if (obj.canMatchIt) setIt(obj);
        if (obj.canMatchThem) setThem([obj]);
     }
  }
;
modify me
  dobjFor(ChatTell){ verify(){ logicalRank(90,'likely'); }
                     check(){}
                     action(){ "Talking to yourself or something? "; }
  }
  iobjFor(ChatTell){ verify(){ illogical('Um.... no!'); } }
;





// ********** WARNING POV MODS ****************
// --> our new tracking object ---> gameMain.currCromPlayerChar
//modify FirstCommandProd
//   getTargetActor() {
//        return gameMain.currCromPlayerChar;// ** old was --> libGlobal.playerChar;
//    }
//;

// from file: msg_neu.t 
// This is for answering random yes/no questions from the parser like "Are you crazy?"
//modify playerActionMessages
    /* an internal common handler for sayHelloMsg, sayGoodbyeMsg, etc */
//    addressingNoOneMsg
  //  { 
       // local s0 = '{You/he} {must} be more specific about '
       //       + gLibMessages.whomPronoun
       //       + ' {it actor/he} want{s/ed} to talk to. ';
       // if(gameMain.questionAsked==nil){
       //     return s0;
       // }else{
       //     if(gAction==YesAction){
       //          "Whaaaaaa...? ";
       //     }
            //if(gameMain.Qyes!=nil) && return gameMain.Qyes;
            //if(gameMain.Qno!=nil) return gameMain.Qno;
            //if(gameMain.Qmaybe!=nil) return gameMain.Qmaybe;
       //     return s0;
       // }
//    }
//;

// fixes a null object reference crash that can happen if game ends within a Fuse object

modify BasicLocation
  canFly = nil // by default you can't fly in basic locations unless this is manually set to true
;

// fix a null object reference crash in suggested topics
modify SuggestedTopic
    associatedTopicIsActive() { 
       if(associatedTopic == nil) return nil; // null catcher - C.K. 5 JUN 2010
       return associatedTopic.checkIsActive(); 
    }
;


/*
modify OutdoorRoom
  roomActorPostureDesc(actor) {
            if(actor.posture == beingCarried){
                 " (being carried) "; 
            }else{
                libMessages.actorInRoomPosture(actor, self);
            }
            inherited();
  }
  roomActorStatus(actor) {
            if(actor.posture == beingCarried){
                 " (being carried) "; 
            }else{
                libMessages.actorInRoomPosture(actor, self);
            }
            inherited();
  }  
;
*/

notCrawling: PreCondition
  // temp objects
  actor = nil
  obj = nil
  checkPreCondition(obj, allowImplicit){
        if(gActor.posture!=crawling) return nil; // we're done
        /* try an implicit 'stand' command */
        //if (allowImplicit && tryImplicitAction(StandOn,gActor,gActor.location)){
        //       /*
        //        * We executed the command - make sure it worked, and abort
        //        * if it didn't
        //        */
        //       if(gActor.posture!=crawling) exit; // abort the command
        //        
        //       /* tell the caller we executed an implicit command */
        //       return true;
        //}        
        gMessageParams(actor,obj);// this sets variables for use with msg params
        // note the "\^" below is used to capitalize the next first letter encountered...
        local oWho = (gActor == gPlayerChar) ? 'you' : gActor.name;
        local s0 = '\^' + oWho + '{subj actor} need{s} to be standing, not crawling, to reach {subj obj}{the obj/him}. ';
        //  what action are we?   
        if(gAction!=nil){
           if(gAction.baseActionClass==PutInAction){
               s0 = '\^' + oWho + '{subj actor} can\'t reach {subj obj}{that obj/him} while crawling. ';
               if((gIobj!=nil) && (gDobj!=nil)){
                    s0 = '\^' + '{the dobj/him} is too far out of reach up there to put in {the iobj/him} while crawling. ';
               }
           }
           if(gAction.baseActionClass==LookInAction){
               s0 = '\^' + oWho + '{subj actor} can\'t look in {subj obj}{that obj/him} from this angle while crawling. ';
           }
        }
        //say('gAction.baseActionClass==PutInAction true or false? ' + (gAction.baseActionClass==PutInAction)); 
        //if(gIobj!=nil) say('gIobj.name==' + gIobj.name+'<br>');
        //if(gDobj!=nil) say('gDobj.name==' + gDobj.name+'<br>');
        reportFailure(s0);
        /* make it the pronoun */
        gActor.setPronounObj(obj);
        /* abort the command */
        exit;
  }
;

notKneeling: PreCondition
  // temp objects
  actor = nil
  obj = nil
  checkPreCondition(obj, allowImplicit){
        if(gActor.posture!=kneeling) return nil; // we're done
        /* try an implicit 'stand' command */
        //if (allowImplicit && tryImplicitAction(StandOn,gActor,gActor.location)){
        //       /*
        //        * We executed the command - make sure it worked, and abort
        //        * if it didn't
        //        */
        //       if(gActor.posture!=kneeling) exit; // abort the command
        //        
        //       /* tell the caller we executed an implicit command */
        //       return true;
        //}
        gMessageParams(actor,obj);// this sets variables for use with msg params
           // note the "\^" below is used to capitalize the next first letter encountered...
           local oWho = (gActor == gPlayerChar) ? 'you' : gActor.name;
           reportFailure('\^' + oWho + '{subj actor} need{s} to be standing, not kneeling, to reach {subj obj}{the obj/him}. ');
        /* make it the pronoun */
        gActor.setPronounObj(obj);
        /* abort the command */
        exit;
  }
;

modify playerActionMessages 
 outOfReachMsg(obj) 
     { 
         gMessageParams(obj); 
         return '{The obj/he} {is} out of reach. '; 
     } 
;  

modify OutOfReach 
  cannotReachFromOutsideMsg(dest) { return &outOfReachMsg; } 
  cannotReachFromInsideMsg(dest) { return &outOfReachMsg; } 
;

class CanNotSeeInsideContainerIfCrawling: HighIfCrawling, OutOfReach, Openable, Container // , Occluder
  canObjReachContents(obj) { 
        if(gActor.posture==crawling) return nil;
        return true; 
  }
  contentsListedInExamine {
     if(gActor.posture==crawling) return nil;
     return true;
  }
  // obscuredSpecialDesc = (specialDesc)
//  occludeObj(obj, sense, pov){
//     if(gActor.posture==crawling) return true;
//
//        /* by default, simply ask the object what it thinks */
//        return obj.isOccludedBy(self, sense, pov);
//    }
  canPutIn(obj) { 
     if(gActor.posture==crawling) return nil;

     return validContents.indexOf(obj) != nil; // default
  }
  dobjFor(LookIn){
        verify() { inherited; }
        check(){
             if(gActor.posture==crawling){
                 "You can not see inside that while you are crawling. ";
                 exit;
             }
             inherited;
        }
        action(){ inherited;
        }
    }
  verifyPutInInterior(){
           if(gActor.posture==crawling){
               illogical(&canNotPutInWhileCrawling);
           }
                /* 
         *   if we haven't resolved the direct object yet, we can at least
         *   check to see if all of the potential direct objects are
         *   already in me, and rule out this indirect object as illogical
         *   if so 
         */
        if (gDobj == nil)
        {
            /* 
             *   check the tentative direct objects to see if (1) all of
             *   them are directly inside me already, or (2) all of them
             *   are at least indirectly inside me already 
             */
            if (gTentativeDobj.indexWhich(
                {x: !x.obj_.isDirectlyIn(self)}) == nil)
            {
                /*
                 *   All of the potential direct objects are already
                 *   directly inside me.  This makes this object
                 *   illogical, since there's no need to move any of these
                 *   objects into me.  
                 */
                illogicalAlready(&alreadyPutInMsg);
            }
            else if (gTentativeDobj.indexWhich(
                {x: !x.obj_.isIn(self)}) == nil)
            {
                /* 
                 *   All of the potential direct objects are already in
                 *   me, at least indirectly.  This makes this object
                 *   somewhat less likely, since we're more likely to want
                 *   to put something in here that wasn't already within.
                 *   Note that this isn't actually illogical, though,
                 *   since we could be moving something from deeper inside
                 *   me to directly inside me.  
                 */
                logicalRank(50, 'dobjs already inside');
            }
        }
        else
        {
            /* 
             *   We can't put myself in myself, obviously.  We also can't
             *   put something into any component of itself, so the command
             *   is illogical if we're a component of the direct object. 
             */
            if (gDobj == self || isComponentOf(gDobj))
                illogicalSelf(&cannotPutInSelfMsg);

            /* if it's already directly inside me, this is illogical */
            if (gDobj.isDirectlyIn(self))
                illogicalAlready(&alreadyPutInMsg);
        }

        /* 
         *   if I'm not held by the actor, give myself a slightly lower
         *   ranking than fully logical, so that objects being held are
         *   preferred 
         */
        if (!isIn(gActor))
            logicalRank(60, 'not indirectly held');
        else if (!isHeldBy(gActor))
            logicalRank(70, 'not held');
  }
  

   /* all senses are connected through us, but at a distance */
//    transSensingThru(sense) { return distant; }
//
 //  brightness = 0
// ** Works! but Occluder could be used instead - however we used Thing flag "canSeeInHighContainerIfCrawling" to track this on dobjFor(Examine)
//  transSensingIn(sense){
//        if(gActor!=nil){
//           // ... if sense==sight...
//          if(gActor.posture==crawling){
//             //illogical('fail');
//             return material.senseThru(sense); // local s0 = 'You can not non not non non. ';
//            // return new CheckStatusFailure(s0,dest);
//            //             return material.senseThru(sense);;
//          }
//        }
//        if (isOpen)
//        {
//            /* I'm open, so the sense passes through without interference */
//             return transparent;
//        }
//        else
//        {
//            /* I'm closed, so the sense must pass through my material */
//            return material.senseThru(sense);
//        }       
//  }
    /*
     *   Get my fill medium.  If I'm open, inherit my parent's medium,
     *   assuming that the medium behaves like fog or smoke and naturally
     *   disperses to fill any nested open containers.  If I'm closed, I
     *   am by default filled with no medium.  
     */
  //  fillMedium()
  //  {
  //      if (isOpen && location != nil)
  //      {
  //          if(gActor.posture==crawling) return paper;
  //
  //          /* I'm open, so return my location's medium */
  //          return location.fillMedium();
  //      }
  //      else
  //      {
  //          /* 
  //           *   I'm closed, so we're cut off from the parent - assume
  //           *   we're filled with nothing 
  //           */
  //          return nil;
  //      }
  //  }
  
;



/* The HighIfKneelingOrCrawling object class.  See also: OutOfReach class in file: objects.t
 *   See also: HighIfKneeling, HighIfCrawling in file: sophmod.t
 * 
 *   Use: Use this for object like the top shelf of a book shelf.
 *        or the top surface of a tall dresser. If the gActor is
 *        kneeling or crawling, the various "verify" routines below will fail 
 *        a GET/PUT/TOUCH activity.
 */
class HighIfCrawlingOrKneeling: Thing
 checkTouchViaPath(obj, dest, op){
        if(obj.ofKind(Actor)){
          if(obj.posture==kneeling){
           local myobj = self;
           local myobj2 = gDobj; // obj;
           // you MUST send local TEMPORARY objects or bad things could happen
           gMessageParams(myobj,myobj2);
           // note the "\^" below is used to capitalize the next first letter encountered...
           local s0 = '\^' + 
                      ((obj==gPlayerChar) ? 'you try' : (obj.name + ' tries')) +
                      ' to reach {the myobj2/him} but {that myobj/him} is too high to reach while kneeling. ';
           return new CheckStatusFailure(s0,dest);
          }
         if(obj.posture==crawling){
           local myobj = self;
           local myobj2 = gDobj; // obj;
           // you MUST send local TEMPORARY objects or bad things could happen
           gMessageParams(myobj,myobj2);
           // note the "\^" below is used to capitalize the next first letter encountered...
           local s0 = '\^' + 
                      ((obj==gPlayerChar) ? 'you try' : (obj.name + ' tries')) +
                      ' to reach {the myobj2/him} but {that myobj/him} is too high to reach while crawling. ';
           return new CheckStatusFailure(s0,dest);
          }
         }
       return checkMoveViaPath(obj, dest, op);// default for Thing class - see file: thing.t
 }
 canObjReachContents(obj) { 
     if(obj.ofKind(Actor)){
        if((obj.posture==kneeling) || (obj.posture==crawling)){
           return nil; 
        }
     }
     if(self.isOpen==nil){
        return nil;
     }
     return true;
 }
 tryImplicitRemoveObstructor(sense, obj) { return nil; }
 cannotReachFromOutsideMsg(dest) { return &tooDistantMsg; }
 cannotReachFromInsideMsg(dest) { return  &tooDistantMsg; }
 canObjReachSelf(obj) { 
   return canObjReachContents(obj); 
 }
 verifyRemove(obj){
      if(gActor.posture==kneeling){
           local myobj = self;
           local myobj2 = obj;
           // you MUST send local TEMPORARY objects or bad things could happen
           gMessageParams(actor,self,myobj,myobj2);
           // note the "\^" below is used to capitalize the next first letter encountered...
           local s0 = '\^' + 
                      ((gActor==gPlayerChar) ? 'you try' : (gActor.name + ' tries')) +
                      ' to reach {the myobj2/him} but {the myobj/him} is too high to reach while kneeling. ';
           say(s0);
           // illogicalNow(s0);
           exit;
      }
      if(gActor.posture==crawling){
           local myobj = self;
           local myobj2 = obj;
           // you MUST send local TEMPORARY objects or bad things could happen
           gMessageParams(myobj,myobj2);
           // note the "\^" below is used to capitalize the next first letter encountered...
           local s0 = '\^' + 
                      ((gActor==gPlayerChar) ? 'you try' : (gActor.name + ' tries')) +
                      ' to reach {the myobj2/him} but {the myobj/him} is too high to reach while crawling. ';
           say(s0); // illogicalNow(s0);
           exit;
      }
 }// end verifyRemove(obj)

 verifyInsert(obj, newCont){
        /* 
         *   If I'm inside the other object, don't allow it, since this
         *   would create circular containment. 
         */
        if (isIn(obj))
            illogicalNow(obj.circularlyInMessage, newCont, obj);
        if(gActor.posture==kneeling){
           local myobj = self;
           local myobj2 = obj;
           // you MUST send local TEMPORARY objects or bad things could happen
           gMessageParams(myobj,myobj2);
           // note the "\^" below is used to capitalize the next first letter encountered...
           local s0 = '\^' + 
                      ((gActor==gPlayerChar) ? 'you try' : (gActor.name + ' tries')) +
                      ' to reach {the myobj2/him} but {the myobj/him} is too high to reach while kneeling. ';
           say(s0);// illogicalNow(s0);
           exit;
        }
 }
 dobjFor(LookIn) { 
    preCond=[objVisible,notCrawling,notKneeling]
    verify { inherited() ; } 
    check(){
        if((gActor.posture==crawling) && (self.canSeeInHighContainerIfCrawling==nil)){
             if(self.ofKind(CanNotSeeInsideContainerIfCrawling)){ 
               local myobj = self;
               //local myobj2 = myparent; // obj;
               // you MUST send local TEMPORARY objects or bad things could happen
               gMessageParams(myobj);
               // note the "\^" below is used to capitalize the next first letter encountered...
               local s0 = '\^' + 
                      ((gActor==gPlayerChar) ? 'you' : (gActor.name)) +
                      ' can not see inside {the myobj/him} while crawling. ';
                      say(s0);
                      exit;
             }// end if
        }// end if
        // inherited();
    }// end check
    action(){ inherited; }
  }
;


/* The HighIfKneeling object class.  See also: OutOfReach class in file: objects.t
 * NOTE: if you wish to also include HighIfCrawling, please use HighIfCrawlingOrKneeling class instead.
 * 
 *   Use: Use this for object like the top shelf of a book shelf.
 *        or the top surface of a tall dresser. If the gActor is
 *        kneeling, the various "verify" routines below will fail 
 *        a GET/PUT/TOUCH activity.
 */
class HighIfKneeling: Thing
 checkTouchViaPath(obj, dest, op){
        if(obj.ofKind(Actor)){
          if(obj.posture==kneeling){
           local myobj = self;
           local myobj2 = gDobj; // obj;
           // you MUST send local TEMPORARY objects or bad things could happen
           gMessageParams(myobj,myobj2);
           // note the "\^" below is used to capitalize the next first letter encountered...
           local s0 = '\^' + 
                      ((obj==gPlayerChar) ? 'you try' : (obj.name + ' tries')) +
                      ' to reach {the myobj2/him} but {that myobj/him} is too high to reach while kneeling. ';
           return new CheckStatusFailure(s0,dest);
          }
        }
       return checkMoveViaPath(obj, dest, op);// default for Thing class - see file: thing.t
 }
 canObjReachContents(obj) { 
     if(obj.ofKind(Actor)){
        if(obj.posture==kneeling){
           return nil; 
        }
     }
     return true;
 }
 tryImplicitRemoveObstructor(sense, obj) { return nil; }
 cannotReachFromOutsideMsg(dest) { return &tooDistantMsg; }
 cannotReachFromInsideMsg(dest) { return  &tooDistantMsg; }
 canObjReachSelf(obj) { 
   return canObjReachContents(obj); 
 }
 verifyRemove(obj){
      if(gActor.posture==kneeling){
           local myobj = self;
           local myobj2 = obj;
           // you MUST send local TEMPORARY objects or bad things could happen
           gMessageParams(myobj,myobj2);
           // note the "\^" below is used to capitalize the next first letter encountered...
           local s0 = '\^' + 
                      ((gActor==gPlayerChar) ? 'you try' : (gActor.name + ' tries')) +
                      ' to reach {the myobj2/him} but {the myobj/him} is too high to reach while kneeling. ';
           illogicalNow(s0);
      }
 }// end verifyRemove(obj)

 verifyInsert(obj, newCont){
        /* 
         *   If I'm inside the other object, don't allow it, since this
         *   would create circular containment. 
         */
        if (isIn(obj))
            illogicalNow(obj.circularlyInMessage, newCont, obj);
        if(gActor.posture==kneeling){
           local myobj = self;
           local myobj2 = obj;
           // you MUST send local TEMPORARY objects or bad things could happen
           gMessageParams(myobj,myobj2);
           // note the "\^" below is used to capitalize the next first letter encountered...
           local s0 = '\^' + 
                      ((gActor==gPlayerChar) ? 'you try' : (gActor.name + ' tries')) +
                      ' to reach {the myobj2/him} but {the myobj/him} is too high to reach while kneeling. ';
           illogicalNow(s0);
        }
        if(gActor.posture==crawling){
           local myobj = self;
           local myobj2 = obj;
           // you MUST send local TEMPORARY objects or bad things could happen
           gMessageParams(myobj,myobj2);
           // note the "\^" below is used to capitalize the next first letter encountered...
           local s0 = '\^' + 
                      ((gActor==gPlayerChar) ? 'you try' : (gActor.name + ' tries')) +
                      ' to reach {the myobj2/him} but {the myobj/him} is too high to reach while crawling. ';
           illogicalNow(s0);
        }
 }
;

/* The HighIfCrawling object class.  See also: OutOfReach class in file: objects.t
 * NOTE: if you wish to also include HighIfKneeling, please use HighIfCrawlingOrKneeling class instead.
 * 
 *   Use: Use this for object like the top shelf of a book shelf.
 *        or the top surface of a tall dresser. If the gActor is
 *        crawling, the various "verify" routines below will fail 
 *        a GET/PUT/TOUCH activity.
 */
class HighIfCrawling: Thing
checkTouchViaPath(obj, dest, op){
        if(obj.ofKind(Actor)){
          if(obj.posture==crawling){
           local myobj = self;
           local myobj2 = gDobj; // obj;
           // you MUST send local TEMPORARY objects or bad things could happen
           gMessageParams(myobj,myobj2);
           // note the "\^" below is used to capitalize the next first letter encountered...
           local s0 = '\^' + 
                      ((obj==gPlayerChar) ? 'you try' : (obj.name + ' tries')) +
                      ' to reach {the myobj2/him} but {that myobj/him} is too high to reach while crawling. ';
           return new CheckStatusFailure(s0,dest);
          }
        }
       return checkMoveViaPath(obj, dest, op);// default for Thing class - see file: thing.t
 }
 canObjReachContents(obj) { 
     if(obj.ofKind(Actor)){
        if(obj.posture==crawling){
           return nil; 
        }
     }
     if(self.ofKind(Openable)){
       if(self.isOpen==nil) return nil;
     }
     return true;
 }
 tryImplicitRemoveObstructor(sense, obj) { return nil; }
 cannotReachFromOutsideMsg(dest) { return &tooDistantMsg; }
 cannotReachFromInsideMsg(dest) { return  &tooDistantMsg; }
 canObjReachSelf(obj) { 
   return canObjReachContents(obj); 
 }
 verifyRemove(obj){
      if(gActor.posture==crawling){
           local myobj = self;
           local myobj2 = obj;
           // you MUST send local TEMPORARY objects or bad things could happen
           gMessageParams(myobj,myobj2);
           // note the "\^" below is used to capitalize the next first letter encountered...
           local s0 = '\^' + 
                      ((gActor==gPlayerChar) ? 'you try' : (gActor.name + ' tries')) +
                      ' to reach {the myobj2/him} but {the myobj/him} is too high to reach while crawling. ';
           illogicalNow(s0);
      }
 }// end verifyRemove(obj)

 verifyInsert(obj, newCont){
        /* 
         *   If I'm inside the other object, don't allow it, since this
         *   would create circular containment. 
         */
        if (isIn(obj))
            illogicalNow(obj.circularlyInMessage, newCont, obj);
        if(gActor.posture==crawling){
           local myobj = self;
           local myobj2 = obj;
           // you MUST send local TEMPORARY objects or bad things could happen
           gMessageParams(myobj,myobj2);
           // note the "\^" below is used to capitalize the next first letter encountered...
           local s0 = '\^' + 
                      ((gActor==gPlayerChar) ? 'you try' : (gActor.name + ' tries')) +
                      ' to reach {the myobj2/him} but {the myobj/him} is too high to reach while crawling. ';
           illogicalNow(s0);
        }
 }
;

// catch if pov == nil - avoid crash bug discovered...
modify Thing
    /* get the outermost room that's visible from the given point of view */
    getOutermostVisibleRoom(pov)
    {
        local enc;
        
        if(pov == nil) return nil;// added 5 JUN 2010 C.K. 

        /* 
         *   Get our outermost enclosing visible room - this is the
         *   outermost enclosing room that the POV can see.  If we manage
         *   to find an enclosing visible room, return that, since it's
         *   "more outer" than we are.  
         */
        if (location != nil
            && (enc = location.getOutermostVisibleRoom(pov)) != nil)
            return enc;

        /* 
         *   We either don't have any enclosing rooms, or none of them are
         *   visible.  So, our outermost enclosing room is one of two
         *   things: if we're visible, it's us; if we're not even visible
         *   ourselves, there's no visible room at all, so return nil.  
         */
        return (pov.canSee(self) ? self : nil);
    }
;


modify Thing
   // ** add start point 15NOV2008 - Cleo K. 
   canSeeInHighContainerIfCrawling = nil 
   canTouchIfCrawling = true // by default we allow touching this object if crawling
   canTouchIfKneeling = true
   /*
    *  We could keep adding code like below all day but if you
    *  instead just use an occluder, the object won't be found
    *  in any "Examine" (or whatever other dobjFor command) anyway.
    */
   dobjFor(Examine) { 
    verify { inherited() ; } 
    check(){
        if((gActor.posture==crawling) && (self.canSeeInHighContainerIfCrawling==nil)){
           local myparent = self.location;
           if(myparent!=nil){
             if(myparent.ofKind(CanNotSeeInsideContainerIfCrawling)){ 
               local myobj = self;
               local myobj2 = myparent; // obj;
               // you MUST send local TEMPORARY objects or bad things could happen
               gMessageParams(myobj,myobj2);
               // note the "\^" below is used to capitalize the next first letter encountered...
               local s0 = '\^' + 
                      ((gActor==gPlayerChar) ? 'you' : (gActor.name)) +
                      ' can not see {the myobj/him} in {the myobj2/him} while crawling. ';
                      say(s0);
                      exit;
             }
           }
        }
        // inherited();
    }
    action(){ inherited; }
  }
  dobjFor(Feel){
   preCond = [touchObj]
   verify(){ inherited(); }
   check(){
       if((gActor.posture==crawling) && (self.canSeeInHighContainerIfCrawling==nil)){
           local myparent = self.location;
           if(myparent!=nil){
             if(myparent.ofKind(CanNotSeeInsideContainerIfCrawling)){ 
               local myobj = self;
               local myobj2 = myparent; // obj;
               // you MUST send local TEMPORARY objects or bad things could happen
               gMessageParams(myobj,myobj2);
               // note the "\^" below is used to capitalize the next first letter encountered...
               local s0 = '\^' + 
                      ((gActor==gPlayerChar) ? 'you' : (gActor.name)) +
                      ' can not reach {the myobj/him} in {the myobj2/him} while crawling. ';
                      say(s0);
                      exit;
             }
           }
        }
      inherited();      
   }
   action(){ inherited; }
  }
  dobjFor(LookIn) { 
    preCond = [objVisible]
    verify { inherited() ; } 
    check(){
        if((gActor.posture==crawling) && (self.canSeeInHighContainerIfCrawling==nil)){
             if(self.ofKind(CanNotSeeInsideContainerIfCrawling)){ 
               local myobj = self;
               //local myobj2 = myparent; // obj;
               // you MUST send local TEMPORARY objects or bad things could happen
               gMessageParams(myobj);
               // note the "\^" below is used to capitalize the next first letter encountered...
               local s0 = '\^' + 
                      ((gActor==gPlayerChar) ? 'you' : (gActor.name)) +
                      ' can not see inside {the myobj/him} while crawling. ';
                      say(s0);
                      exit;
             }// end if
        }// end if
        // inherited();
    }// end check
    action(){ 
            /* show our LOOK IN description */
            lookInDesc;
    }
  }
  // ** add end point 15NOV2008 - Cleo K. 
  canCrawlOn = nil
  customCanNotCrawlOnMsg = &cannotCrawlOnMsg
  dobjFor(CrawlOn){
     preCond = [touchObj]
        verify() { illogical(customCanNotCrawlOnMsg); }
  }
  canKneelOn = nil
  customCanNotKneelOnMsg = &cannotKneelOnMsg
  dobjFor(KneelOn){
     preCond= [touchObj]
        verify(){ illogical(customCanNotKneelOnMsg); }
  }
  // dobjFor(LookOn) remapTo(LookIn,self) // maybeRemapTo(dobj != nil,LookIn,dobj)
  //dobjFor(LookOn) remapTo(Examine,self)
    dobjFor(LookOn){
        preCond = [objVisible]
        verify()
        {
            /* give slight preference to an object being held */
            if (!isIn(gActor))
                logicalRank(80, 'not held');
        }
        action()
        {
            /* show our LOOK IN description */
            lookOnDesc;
        }
    }
  lookOnDesc { mainReport(&nothingOnMsg); }
;

modify Room
  allowedPostures = [sitting, lying, standing, crawling, kneeling]  
  defaultPosture = (gActor.posture == crawling) ? crawling : standing // changed from gPlayerChar to gActor 23NOV2008 C.K. 
  canCrawlOn = true
  canKneelOn = true
  tryMakingTravelReady(conn) { 
                   if(gActor.posture == crawling) return true;
                   if(gActor.posture == flying) return true;
                   return tryImplicitAction(Stand);
  }
  isActorTravelReady(conn) { 
         local iCon = ((gActor.posture == standing) || 
                      (gActor.posture == crawling) ||
                      (gActor.posture == flying))  ? true: nil;
         return iCon;
  }
  travelerArriving(traveler, origin, connector, backConnector) {
        /* 
         *   Set the self-motive actors into the proper default posture
         *   for the location.  We only do this for actors moving under
         *   their own power, since actors in vehicles will presumably
         *   just stay in the posture that's appropriate for the vehicle. 
         */
        foreach (local actor in traveler.getTravelerMotiveActors)
        {
            /*
             *   If the actor isn't in this posture already, set the actor
             *   to the new posture.  Note that we set the new posture
             *   directly, rather than via a nested command; we don't want
             *   the travel to consist of a NORTH plus a SIT, but simply of
             *   a NORTH.  Note that this could bypass side effects
             *   normally associated with the SIT (or whatever), but we
             *   assume that when a room with a specific posture is linked
             *   directly from a separate location, the travel connector
             *   linking up to the new room will take care of the necessary
             *   side effects.  
             */
            if (actor.posture != defaultPosture){
                if(actor.posture != (crawling||flying)) 
                   actor.makePosture(defaultPosture); // added 19MAR2007 by C.K. - allows crawling from room to room without standing up again
            }
        }        
        /* run the arrival notification */
        enteringRoom(traveler);        
        /* describe the arrival */
        traveler.describeArrival(origin, backConnector);
    }
    /* don't consider myself a default for STAND ON, SIT ON, or LIE ON */
    hideFromDefault(action) {
        /* don't hide from STAND ON, SIT ON, LIE ON - CRAWL ON */
        if (action.ofKind(StandOnAction)
            || action.ofKind(SitOnAction)
            || action.ofKind(LieOnAction)
            || action.ofKind(CrawlOnAction)
            || action.ofKind(KneelOnAction)
           )             
            return nil;
        /* don't hide from defaults for other actions, though */
        return inherited(action);
  }
  dobjFor(CrawlOn) maybeRemapTo(roomFloor != nil, CrawlOn, roomFloor)
  dobjFor(KneelOn) maybeRemapTo(roomFloor != nil, KneelOn, roomFloor)
  //dobjFor(LookOn) maybeRemapTo(roomFloor != nil, Examine, roomFloor)
    /* run the appropriate implied command to achieve our default posture */
    tryMakingDefaultPosture()
    {
        if(gActor.posture == crawling) return true;// crawling is okay
        return defaultPosture.tryMakingPosture(self);
    }
  debugShowActors(){
             "\n";
             foreach(local obj in self.contents){
                  "object: <<obj.name>> \n"; 
                  if(obj.ofKind(Actor) || obj.ofKind(Person)){
                  //"Boo! " + roomActorHereDesc(obj);
                  // gLibMessages (?) .actorInRoomPosture(actor, self); see travel.t
                  "actor-or-person: <<obj.name>> \n"; 
                  "...spec: "; gLibMessages.actorInRoomPosture(obj,self);"\n";
                  "...spec2:"; gLibMessages.actorInRoom(obj,self); "\n";
                  "...spec3:"; obj.location.roomActorStatus(obj); "\n";
                  "...spec4:"; 
                  }
             }
             "icky icky icky! \n";
  }
;

modify Actor
    // from: http://users.ox.ac.uk/~manc0049/TADSGuide/LearningTADS3/LearningT316.html
    // We want transparent DistantConnectors to allow sound to pass through so 
    // the player can talk to an NPC from the other side of a very large room
    // i.e. two rooms 
    // for example:  
    //    DistanceConnector [field, farmyard];
    //    DistanceConnector [field, riverbank];
    // 
    // More importantly this will be possible now:
    //    DistanceConnector [loungeE, loungeW]
    //       transSensingThru(sense) { return sense == sound ? transparent : distant; }
    //    ;
    // 
    canBeTalkedTo(talker, sense, info){
       return (info.trans == transparent);
    }
    dobjFor(CrawlOn) { 
      verify(){ 
         illogical(&crawlOnSelfMsg); // verifyNotSelfInherit(&crawOnSelfMsg);
      }
    } 
    dobjFor(KneelOn) {
      verify(){
         illogical(&kneelOnSelfMsg);
      }
    }
    /*
     *  If flagNoMove is set, then the player can NOT move.
     *  This is for the Adrift code's flag_no_move variable.
     */
    canTravelVia(connector,dest){
         if(flagNoMove.ranIt!=nil){
             if(gActor==gPlayerChar){
                 "You can\'t go in any direction! ";// Exactly how Adrift reports it
                 return nil;
             }
             // other NPC's should be able to move...
         }
         return true;
    }
  // this was taken from Heidi.t  
  makeProper
  {
    if(isProperName == nil && properName != nil) 
    {
      isProperName = true;
      name = properName;
      
      /* Method 1: */
      local tokList = Tokenizer.tokenize(properName);
      for (local i = 1, local cnt = tokList.length() ; i <= cnt ; ++i)
       {
        if(i < cnt)
          cmdDict.addWord(self, getTokVal(tokList[i]), &adjective);
        cmdDict.addWord(self, getTokVal(tokList[i]), &noun);
       }
       
       /* Simpler Alternative: this doesn't add forenames as both nouns and
        * adjectives, but as adjectives only with the final name as a noun: */
//      initializeVocabWith(properName);
    }
  }
    
    // use this to put the player's given name as the me.properName - Cleo Kraft, 6/6/2019
    makeProperTwo(someName){
      me.isProperName = true;
      me.name = someName;
      
      /* Method 1: */
      local tokList = Tokenizer.tokenize(someName);
      for (local i = 1, local cnt = tokList.length() ; i <= cnt ; ++i)
       {
        if(i < cnt)
          cmdDict.addWord(self, getTokVal(tokList[i]), &adjective);
        cmdDict.addWord(self, getTokVal(tokList[i]), &noun);
       }
    }
   // beforeTravel(traveler, connector){
   // *** do nothing by default ***
   // "gActor before travel...<<gActor.posture.participle>> \n";
//  }
//  afterTravel(traveler, connector) { 
   /* do nothing by default */ 
   //"gActor after travel...<<gActor.posture.participle>> \n";
//  }

  stats = [1,1,2,3,4,5,6,7,8,9,10,11]
  statNames = ['str','int','dex','agi','wis','cha','nature','death','fire','cold','magic','poison']
  statBonus = [0,0,0,0,0,0,0,0,0,0,0] // bonus to hit, etc.
  spellEffects = [] // spell objects (both good and bad, buffs and curses) go in this list and stats are modified on the fly based on statbuffs
  weightCapacity = stats[1]+25 // all actors can carry 25 lbs. weight plus their strength number - default was 10000 for Actor class
  hitpoints = 20 // this is current hitpoints
  manapoints = 20 // this is current manapoints
  basemanapoints = 20
  baseHitpoints = 20
  getCurrMana(){
       // 1. get base manapoints
       // local basemana = self.basemanapoints;
       // 2. get current manapoints
       local currMana = self.manapoints;
       // 3. TO DO: loop through all manapoint (addition) spell effects on the gActor 
       local spellEffectMana = 0;
       // 4. TO DO: loop through all *negative* (curse) manapoint spell effects on gActor
       local negativeMana = 0;
       // 5. TO DO: loop through all clothing (addition) spell effects on the gActor (i.e. regen, added manpoints, etc.)
       local wornMana = 0;
       local returnMana = currMana + spellEffectMana + negativeMana + wornMana;
       return returnMana;
  }
  // grab fullest manapoints player can have based on fully rested mana
  getFullyRestedMana(){
       // 1. get base manapoints       
       // local baseMana = self.basemanapoints;
       // 2. TO DO: loop through all mana point (addition) spell effects on the gActor 
       local spellEffectMana = 0;
       // 4. TO DO: loop through all clothing (addition) spell effects on the gActor
       local wornMana = 0;
       local returnMana = self.basemanapoints + spellEffectMana + wornMana;
       return returnMana;
  }
  getCurrHP(){
       // 1. get base hitpoints
       // local baseHP = self.baseHitpoints;
       // 2. get current hitpoints
       local currHP = self.hitpoints;
       // 3. TO DO: loop through all hitpoint (addition) spell effects on the gActor (i.e. regen, temp hitpoints, etc.)
       local spellEffectHP = 0;
       // 4. TO DO: loop through all *negative* (curse) hitpoint spell effects on gActor
       local negativeHP = 0;
       // 5. TO DO: loop through all clothing (addition) spell effects on the gActor (i.e. regen, added hitpoints, etc.)
       local wornHP = 0;
       local returnHP = currHP + spellEffectHP + negativeHP + wornHP;
       return returnHP;
  }
  // grab fullest hitpoints player can have based on fully rested HP
  getFullyRestedHP(){
       // 1. get base hitpoints       
       // local baseHP = self.baseHitpoints;
       // 2. TO DO: loop through all hitpoint (addition) spell effects on the gActor (i.e. regen, temp hitpoints, etc.)
       local spellEffectHP = 0;
       // 4. TO DO: loop through all clothing (addition) spell effects on the gActor (i.e. regen, added hitpoints, etc.)
       local wornHP = 0;
       local returnHP = self.baseHitpoints + spellEffectHP + wornHP;
       return returnHP;
   }
  
  getMana(){
       // 1. get base manapoints
       // local baseMana = self.basemanapoints;
       // 2. get current manapoints
       local currMana = self.manapoints;
       // 3. TO DO: loop through all manapoint (addition) spell effects on gActor
       local manaEffect = 0;
       // 4. TO DO: loop through all *negative* (curse) manapoint spell effects on gActor
       local negativeManaEffect = 0;
       // 5. TO DO: loop through all clothing (addition) mana effects on gActor       
       local wornMana = 0;
       local returnMana = currMana + manaEffect + negativeManaEffect + wornMana;
       return returnMana;
  }
  ac = 0 // base armor class
  getAC(){
       // 1. get base armor class
       local baseAC = self.ac;
       // 2. TO DO: loop through AC spell effects on the gActor
       local spellEffectAC = 0;
       // 3. TO DO: loop through all *negative* AC spell effects on the gActor (i.e. curses)
       local negativeAC = 0; 
       // 4. TO DO: loop through clothing list (armor, rings, etc.) and grab AC
       local wornAC = 0;
       if(gActor.contents != nil){
         foreach(local obj in gActor.contents){
               if((obj.ofKind(CromexxClothing)) && (obj.isWornBy(gActor))) wornAC += obj.ac;
         }
       }
       local returnAC = baseAC + spellEffectAC + negativeAC + wornAC;
       return returnAC;
  }  
  xpReward = 0
  xp = 0 // experience points total - this affects character level
  xpBar = 0 // the xp bar (this is checked vs. gameMain.levelXP table to see if the Actor has leveled up)
  level = 1 // override
  offhand = nil // weapon in offhand
  mainhand = nil // weapon in main hand
   
/*
  applyDamage(damage,attacker){
       // "<font color=yellow>Yeah... take that!</font>";
       if(damage==nil) damage=0;
       // is the attacker who attacked us in our enemy list? if not, add them!
       self.hitpoints-=damage; // =self.hitpoints-damage;
       // ** show report below? - we report only if player is attacking a monster typically
       // if(self == gPlayerChar) exit;
       local oWho = (self == gPlayerChar) ? 'You' : self.name;
       local s0='';
       if(self.hitpoints<=0){
          self.hitpoints=0;
          s0 =  '<font color=white>\^' + oWho + '&nbsp;take';
          if(oWho!='You') s0+='s';
          s0+=toString(damage) + '&nbsp;points of damage and die';
          if(oWho!='You') s0+='s';
          s0+='!</font> ';
          say(s0);
          if(self==gPlayerChar){
              s0 = '<br><font color=white>' + oWho + ' {subj actor} ';
              if(oWho=='You'){
                s0+='have';
              }else{
                s0+='has';
              }
              s0+=' been killed by ' + attacker.name + '!</font> ';
              say(s0);
              finishGameMsg(ftDeath,finishOptionUndo);//  endGame(ftDeath); 
          }
       }else{
          // if(self == gPlayerChar) exit;       
          s0 = '<br><font color=white>' + oWho + ' take';
          if(oWho!='You') s0+='s';
          s0+=' ' + toString(damage) + ' points of damage!</font> ';
          say(s0);
       }
  }
*/
;



modify NestedRoomFloor
  dobjFor(CrawlOn) remapTo(CrawlOn, location) 
  dobjFor(LookOn) asDobjFor(LookIn)
  dobjFor(KneelOn) remapTo(KneelOn, location)
;

modify BasicPlatform
   allowedPostures = [sitting, lying, standing, crawling, kneeling, beingCarried]
   obviousPostures = [sitting, lying, standing, crawling, kneeling, beingCarried]
   dobjFor(LookOn) asDobjFor(LookIn)
;

modify Floor
    allowedPostures = [sitting, lying, standing, crawling, kneeling, beingCarried]
    /* specifically allow me as a default for STAND ON, SIT ON, and LIE ON */
    hideFromDefault(action)
    {
        /* don't hide from STAND ON, SIT ON, LIE ON */
        if (action.ofKind(StandOnAction)
            || action.ofKind(SitOnAction)
            || action.ofKind(LieOnAction)
            || action.ofKind(CrawlOnAction)
            || action.ofKind(KneelOnAction))
            return nil;
        /* for other actions, use the standard handling */
        return inherited(action);
    }
    /* 'crawl on floor' causes the actor to crawl in the containing room */
    dobjFor(CrawlOn)
    {
        preCond = [touchObj,
                   new ObjectPreCondition(gActor.location.getOutermostRoom(),
                                          actorDirectlyInRoom)]
        // see msg_neu.t
        verify() { verifyEntry(crawling, &alreadyCrawlingOnMsg); } 
        action() { performEntry(crawling); }
    }
    dobjFor(KneelOn)
    {
        preCond = [touchObj,
                   new ObjectPreCondition(gActor.location.getOutermostRoom(),
                                          actorDirectlyInRoom)]
        // see msg_neu.t
        verify() { verifyEntry(kneeling, &alreadyKneelingOnMsg); } 
        action() { performEntry(kneeling); }
    }
    dobjFor(LookOn) asDobjFor(LookIn)
;



modify Traveler 
   describeNpcArrival(origin, backConnector){
      // *** THIS line we added... ***
      if(gPlayerChar.isHeldBy(self)) exit; // do nothing if we're carrying the player!
     
      // inherited stuff below...
        /*  
         *   If we know the connector back, use its arrival message;
         *   otherwise, use a generic arrival message.  
         */
        if (backConnector != nil)
        {
            /*
             *   If the PC can see the origin, we're not actually arriving
             *   anew; instead, we're simply moving around within the PC's
             *   field of view.  In these cases, we don't want to use the
             *   normal arrival message, because we're not truly arriving;
             *   we could be moving closer to the player, further away from
             *   the player, or moving laterally from one remote location
             *   to another.  If the PC can't see the origin, we're truly
             *   arriving.  
             */
            if (gPlayerChar.canSee(origin))
            {
                /*
                 *   We're not arriving anew, but just moving around within
                 *   the PC's field of view.
                 *   
                 *   - If we're moving closer to the PC - moving from a
                 *   top-level location that doesn't contain the PC to one
                 *   that does - describe this as a "local arrival."
                 *   
                 *   - If we're moving further away from the PC - from
                 *   within the PC's top-level location to a different
                 *   top-level location - don't say anything.  We will have
                 *   already described this as a "local departure" during
                 *   the departure message phase, and from the PC's point
                 *   of view, that fully covers it.
                 *   
                 *   - If we're moving laterally - from one remote
                 *   top-level location to another ("remote" means "does
                 *   not contain the PC") - it's arbitrary whether this
                 *   should be described at arrival or departure time.  We
                 *   arbitrarily pick arrival, so describe the lateral
                 *   local travel now.  
                 */
                if (gPlayerChar.isIn(getOutermostRoom()))
                {
                    /* 
                     *   We're now in the same top-level location as the
                     *   PC, so we've moved closer to the PC, so describe
                     *   this as a "local arrival."  
                     */
                    backConnector.describeLocalArrival(
                        self, origin, location);
                }
                else if (!gPlayerChar.isIn(origin))
                {
                    /* 
                     *   We're *not* in the same top-level location as the
                     *   PC, and we weren't on departure either, so this is
                     *   a lateral move - a move from one remote location
                     *   to another.  Describe it as such now.  
                     */
                    backConnector.describeRemoteTravel(
                        self, origin, location);
                }
            }
            else
            {
                /* we're arriving anew - let the connector describe it */
                backConnector.describeArrival(self, origin, location);
            }
        }
        else
        {
            /* there's no back-connector, so use a generic arrival message */
            gLibMessages.sayArriving(self);
        }
  }
 
;

modify libMessages
/* acompanying another actor on travel */
    sayDepartingWith(traveler, lead)
    {
       /*
        *  Is the player a Little Girl and is carried by an NPC to another location?
        */
       if((gPlayerChar == traveler) && (gPlayerChar.ofKind(LittleGirl)) && 
          (gPlayerChar.isHeldBy(lead))){
           local oSelf = lead;
           local actor = traveler;// gActor;
           // note the "\^" below is used to capitalize the next first letter encountered...
           local oWho = (traveler == gPlayerChar) ? 'you' : gActor.name;
           gMessageParams(oSelf, actor, oWho);// actor,newCont,oSelf);// this sets variables for use with msg params
           local s0 = '\^{the oSelf/him} carry{ies} {subj actor}' + oWho + ' away. ';
           say(s0);
       }else{
           "\^<<traveler.travelerName(nil)>> <<traveler.verbToCome>>
           with <<lead.theNameObj>>. ";
       }
    }
;


modify Thing
  listLocation_ = nil
  listRemoteContents(otherLocation)
  {
    listLocation_ = otherLocation;
    try
    {
      lookAround(gActor, LookListSpecials | LookListPortables);
    }
    finally
    {
      listLocation_ = nil;
    }
  }
  
  adjustLookAroundTable(tab, pov, actor)
  {
    inherited(tab, pov, actor);
    if(listLocation_ !=  nil)
    {
      local lst = tab.keysToList();
      foreach(local cur in lst)
      {
        if(!cur.isIn(listLocation_))
          tab.removeElement(cur);
      }
    }
  }
; 

DefineTAction(Use);
VerbRule(Use)
   ('use') singleDobj
   : UseAction
   verbPhrase = 'use/using (what)'   
;
modify Thing
   isDriveable = nil
   dobjFor(Use){
      preCond = [touchObj]
      verify(){
               illogical('{You/he} can\'t use {that dobj/him}. ');
            }
   }
;


// a custom function lifted form tads3 tutorial...
function endGame(msg) {
  finishGameMsg(msg, [finishOptionUndo, finishOptionFullScore]); 
}


// #include cromfun3.t
// note: "#pragma once" tells the compiler to include THIS file you're reading here ONCE
//       ...the reason for this is so multiple "include" statements don't duplicate objects
//       ...by mistake, etc.
// note: "#pragma all_once" can be used in the MAIN file header to achieve the same
//       thing as "pragma once" but for all include files.
#pragma once

#ifndef ADV3_H
#include <adv3.h>
#endif

// checks for if a variable was NOT defined from file en_us.h
// .. and if so then include the file to define that variable, method, etc.
#ifndef singleDir
#include <en_us.h>
// #error "You can put an error here too if the variable <> something. Boooo!!"
#endif


// See: en_us.t for original LookAction
// Modified this so the "L" by itself means left, not look
// see file: reldir.t ... we modified "DefineLangRelativeDir(left..." to map "l" to "go left"
//modify VerbRule(Look)
//  ('look' | 'look' 'around' | 'lo' | 'lo' 'around')
//  :
//;


// from "TADS 3 Tour Guide" - handled above already in more complex routine
//modify Actor 
//  makeProper() { 
//    if(properName != nil) { 
//      name = properName; 
//      initializeVocabWith(properName); 
//      isProperName = true; 
//    } 
//    return name; 
//  } 
//; 


//main(args)
//{
//   "Hello from TADS 3 !!!\b";
//}

// see if this works...
//modify hintManager
//    topHintMenuObj = topHintMenu // nil
//;

/* "inOnThe" is used for outside POV looking into a room.
 * The brassLantern code uses this reference. 
 * Tie this in with the room name like so:
 *        "<<self.location.inOnThe>> <<self.location.name>>";
 * For the start room this would print something like "On the front path"
 */ 
modify Room
  inOnThe = nil // 'in the' or 'on the'  
;

// hide a real world object while the player is in the V.R. world
// by default all objects are real world objects and will be hidden while in VR world
modify Thing
  realWorldObject = 1 
  hideRWOwhileInVR = 1
  isHiddenForVR = 0  
  tallyID = nil      // for the longRoad class
  tallyNumber = nil  // for the longRoad class
  //dobjFor(Examine){
  //           verify(){ logicalRank(80,'somewhat logical'); inherited; }
  //           check(){ inherited; }
  //           action(){ inherited; }
  //}
;

// see: msg_neu.t
modify libMessages
  finishVictoryMsg = ('YOU ' + tSel('HAVE ', '') + 'WON')
;

// see: msg_neu.t
// gLibMessages (?) .actorInRoomPosture(actor, self); see travel.t
modify playerActionMessages
  /* 
   * In TADS 3.0.12, trying to use the verb 'set to' to set an object that 
   * isn't settable will cause a crash. Stephen Gorrell suggested this fix:
   */
  cannotSetToMsg = '{You/he} {cannot} set {that dobj/him} to anything. '
  /* custom messages
   */
  alreadyCrawlingOnMsg = '{You\'re} already crawling {on dobj}. '
  alreadyKneelingOnMsg = '{You\'re} already kneeling {on dobj}. '
  alreadyKneelingMsg = '{You\'re} already kneeling. '
  alreadyFlyingMsg = '{You\'re} already flying. '
  /* actor crawling on self */
  crawlOnSelfMsg = '{You/he} {can\'t} crawl on {yourself}. '
  kneelOnSelfMsg = '{You/he} {can\'t} kneel on {yourself}. '
  cannotCrawlOnMsg = '{That dobj/he} {is}n&rsquo;t something {you/he} {can} crawl on. '
  cannotKneelOnMsg = '{That dobj/he} {is}n&rsquo;t something {you/he} {can} kneel on. '
  cannotFlyMsg = '{You/he} {does}n\'t know how to fly. ' // 'Since when do{es} {you/he} know how to fly? '
  cannotFondleMsg = '{You/he} {can\'t} fondle {the dobj/him}. '
  cannotFondleYourselfMsg = '{You/he} {can\'t} fondle {yourself}. '
  cannotFondleActorMsg = 'I don\'t think {the dobj/him} would like that very much. '
  cannotGrabMsg = '{You/he} {can\'t} grab {the dobj/him}. '
  cannotGrabYourselfMsg = '{You/he} {can\'t} grab {yourself}. '
  cannotGrabActorMsg = 'I don\'t think {the dobj/him} woulad like that very much. '
  cannotSpankMsg = '{You/he} {can\'t} spank {the dobj/him}. '
  cannotSpankYourselfMsg = '{You/he} {can\'t} spank {yourself}. '
  cannotSpankActorMsg = 'I don\'t think {the dobj/him} would like that very much. '
  cannotSlapMsg = '{You/he} {can\'t} slap {the dobj/him}. '
  cannotSlapYourselfMsg = '{You/he} slap {yourself} hard across the face. It stings a bit but otherwise accomplishes nothing. '
  cannotSlapActorMsg = 'I don\'t think {the dobj/him} would appreciate that. '
  cannotLickMsg = '{You/he} {can\'t} lick {the dobj/him}. '
  cannotLickYourselfMsg = 'Licking {yourself} seems odd but {you/he} tr{ies} it anyway tasting nothing out of the ordinary. '
  cannotLickActorMsg = 'What an odd thing to do. I don\'t think {the dobj/him} would like that very much. '
  cannotBiteMsg = '{You/he} {can\'t} bite {the dobj/him}. '
  cannotBiteYourselfMsg = 'Unless {you/he} {are} some kind of cannibal {you/he} can\'t bite {yourself}. '
  cannotBiteActorMsg = 'What an odd thing to do. I don\'t think {the dobj/him} would like that very much. '
  cannotDriveMsg = '{The dobj/him} {is}n&rsquo;t for driving. '
  cannotWhipActorMsg = '{That dobj/he} probably {won&rsquo;t|wouldn&rsquo;t} like that. '
  /* default report for standing/sitting/lying in/on something */
  roomOkayPostureChangeMsg(posture, obj) { 
        gMessageParams(obj);
        return 'Okay, {you\'re} now ' + posture.participle + ' {on obj}. ';        
  }
  nothingOnMsg = '{You/he} can not see anything unusual on {the dobj/him}. '
  nilMsg = ' '
;

// usage "<<myMMMFootnote.noteRef>> ";
// myMMMFootnote: Footnote "The start room in this game is your bedroom. ";

modify playerMessages
  /*
   *   tell the user they entered a word we don't know, offering the
   *   chance to correct it with "oops" 
   */
  askUnknownWord(actor, txt) {
        /* start the message */
        //"<.parser>Don\'t you know, the word <q><<txt>></q> is not necessary in this
        //story?<./parser> ";
        if(gameMain.showOopsNote==1){
          // "<.parser>Nice try, <<gameMain.firstname>>! I have no idea what you\'re trying
          // to do.
           "<.parser>The word <q><<txt>></q> is not necessary in this story.<./parser> ";
           /* mention the OOPS command, if appropriate */
           if(gameMain.showOopsNote==1) oopsNote();
           gameMain.showOopsNote=0; 
        }else{
           //"<.parser>Nice try, <<gameMain.firstname>>! I have no idea what you\'re 
           // trying to do.<br><br>
           "<.parser>The word <q><<txt>></q> is not necessary in this story. ";
        }       
  }
  /*
   *   tell the user they entered a word we don't know, but don't offer
   *   an interactive way to fix it (i.e., we can't use OOPS at this
   *   point) 
   */
  wordIsUnknown(actor, txt) {
      "<.parser>The story doesn&rsquo;t understand that
      command.<./parser> ";
      // "<.parser>Nice try, <<gameMain.firstname>>! I have no idea what you\'re trying
      // to do.<./parser> ";//
  }
;



// Lifted from T3 help program under "Overriding the obeyCommand" for NPC's
//modify ActorState 
//  obeyCommand(issuingActor, action) 
//    { 
//         /*  
//          *   By default, we ignore all orders.  We do need to generate a 
//          *   response, though, so for this purpose, treat the order as a 
//          *   conversational action, with the 'action' object as the topic. 
//          */ 
//
//         /*  
//          *  If the action takes a direct object (and so could have a list 
//          *  of direct objects), split it into a series of actions 
//          *  with a single direct object 
//          */ 
//         local dobjLst = action.getResolvedDobjList; 
//
//         if(dobjLst != nil)  
//         { 
//            local singleAction = action; 
//  
//        foreach(local obj in dobjLst) 
//           { 
//              singleAction.dobjCur_ = obj; 
//              handleConversation(issuingActor, singleAction, commandConvType);  
//           } 
//         } 
//         /* Otherwise, just treat it as a single command */ 
//
//         else 
//           handleConversation(issuingActor, action, commandConvType); 
//  
//         /* indicate that the order is refused */ 
//         return nil; 
//     } 
//; 

// Now that the above obeyCommand was overriden... add a new TCommandTopic class
//TCommandTopic : CommandTopic 
//  /*  
//   * The direct object, or a list of direct objects, that will be matched 
//   * by this topic. 
//   */ 
//  matchDobj = nil 
//   
//  /*  
//   * The first direct object of the command that this CommandTopic matches. 
//   * We cache it here so that it can easily be picked up in topicResponse. 
//   */ 
//  currentDobj = nil 
//   
//  /* 
//   * Cache the action that has been matched so that it is readily accessible 
//   * from topicResponse  
//   */ 
//  currentAction = nil 
//   
//  matchTopic(fromActor, action) 
//  { 
//    /* First check whether we match the action of the command */ 
//    if(!inherited(fromActor, action)) 
//      return nil; 
//         
//    /* Then cache the first direct object of the command */ 
//      
//    currentDobj = action.getDobj(); 
//        
//    /* If matchDobj is a list, check if the current direct object is in the list */ 
//    if(matchDobj.ofKind(Collection)) 
//    { 
//      if(matchDobj.indexWhich({x: currentDobj.ofKind(x)}) != nil) 
//          return matchScore; 
//    } 
//    else     
//    { 
//      /* See if the direct object matches that specified in matchDobj  
//       * if it's a single object. 
//       */ 
//      if(currentDobj.ofKind(matchDobj)) 
//        return matchScore; 
//    }    
//     
//     /* We can't match the direct object at all, so return nil */ 
//   return nil;  
//  } 
//   
//  handleTopic(fromActor, action) 
//  { 
//    actionPhrase = action.getInfPhrase; 
//    currentAction = action; 
//     
//    /*  
//     * if the player types a command like X ME, getInfPhrase will 
//     * return 'examine you'. In such a case we want to replace 'you' 
//     * with 'me'. 
//     */ 
//    actionPhrase = actionPhrase.findReplace(' you ', ' me ', ReplaceAll); 
//    if(actionPhrase.endsWith(' you')) 
//      actionPhrase = actionPhrase.findReplace(' you', ' me', ReplaceOnce, 
//        actionPhrase.length-5); 
//    inherited(fromActor, action); 
//  }   
//   
//  /* The action phrase of the command currently directed to this actor; 
//   * for example, if the player types 'X ME' the actionPhrase will be 
//   * 'examine me'. This can be used in topicResponse to construct the 
//   * command given by the player character, e.g.  
//   * 
//   *    "Sarah, please examine me," you ask. 
//   */ 
//  actionPhrase = nil 
//; 


// To finish off the above two mods, we need to fix the preparser...
//StringPreParser 
//  doParsing(str, which) 
//     { 
//         local workStr = str.toLower(); 
//         /* First check that the string starts with 'tell' or 'ask' */ 
//         if(!workStr.startsWith('tell ') || !workStr.startsWith('ask ')) 
//           return str; 
//         /* If the string contains 'about ' assume it's a TELL ABOUT  
//          * or ASK ABOUT command 
//          */ 
//         if(workStr.find(' about ')) 
//           return str; 
//            
//         /* If the string doesn't contain 'to' it can't be a TELL TO  
//            or ASK TO command */ 
//               
//         local locTo = workStr.find(' to '); 
//         if(locTo == nil) 
//           return str;   
//          
//         local locSpace = workStr.find(' ');          
//         str = workStr.substr(locSpace + 1, locTo - locSpace - 1) 
//           + ',' + workStr.substr(locTo + 3); 
//          
//         /* finally, replace 'you' with 'me' in case the player 
//          * typed TELL X TO X YOU or the like 
//          */ 
//         str = str.findReplace(' you ', ' me ', ReplaceAll); 
//         if(str.endsWith(' you')) 
//           str = str.findReplace(' you', ' me', ReplaceOnce, str.length-5); 
//         return str; 
//     } 
//;

// and this fixes the verb stuff for the above...
//DefineLiteralTAction(TellTo, IndirectObject);  
  
//VerbRule(TellTo) 
// ('tell' | 'ask' | 'order') singleDobj 'to' singleLiteral 
// : TellToAction 
// verbPhrase = 'tell/telling (whom) (to what)' 
//; 

//modify Thing 
//  dobjFor(TellTo) 
//  { 
//    verify() { illogical('{The dobj/he} do{es}n\'t accept orders. '); } 
//  } 
//; 


// This helps stop players from debugging the game without the source code
// NOTE: by default the *production* file will NOT have a debug command
// so this only essentially modifies the debug command for the test environment.
//modify DebugAction // Orig. from file: actions.t --> DefineIAction(Debug)
//    execAction()
//    {
//        /* if the debugger is present, break into it */
//        //if (t3DebugTrace(T3DebugCheck))
//        //    t3DebugTrace(T3DebugBreak);
//        //else
//        //    "Debugger not present. ";
//        "Debugs is crawling all over de kitchen floor, icky! Smash de bugs. Smash de bugs I say! But you don't see that here. "; // You\'d like to debug this wouldn\'t you? ";
//    }
//;


modify OutdoorRoom
   isAbleToHaveSunlight = true // used to verify indoor rooms that CAN have sunlight and/or outdoor rooms
   isOutdoors = true
;

modify Thing
   isClimbable = nil // for our climbable object (obj. MagicRope uses this test)
   no_drop = nil // true if no drop item
   no_drop_message = "You can not drop that. "
   // note: CromexxClothing class has also variable: is_not_removable See: crom_obj.t 
   is_not_removable = nil
   is_not_removable_message = "You can not remove that. "
   agent_tick_script = nil // used in CromexxClothing class (usually runs a script on *worn* Things only)
   wasWornBy = nil // used by our CromexxRing class to store/retrieve value (for putting on and removing clothes via magic)
   isAbstract = nil // used to check for "held" abstract objects(s) such as player's gender
   isBodyPart = nil // used to check for class BodyPart object(s)
   colorDesc = nil // used for BodyPart desc. i.e. hair color, eye color, lipstick color, etc. 
   isGactor = nil // used to verify if an object is a gActor (actor) type or not
   isAbleToHaveSunlight = nil // used to verify indoor rooms that CAN have sunlight and/or outdoor rooms
   isOutdoors = nil
   dobjFor(Drop){
        preCond = [objHeld]
        verify(){
               if(self.no_drop != true) logicalRank(80,'somewhat likely if not no drop');                
               // if(self.no_drop == true) logicalRank(5,'a bit unlikely if a no drop item');
               inherited;
        }
        check(){ 
               if(self.no_drop == true){
                  self.no_drop_message;
                  exit;
               }
               inherited; 
        }
        action(){ 
             gActor.getDropDestination(self, nil)
                 .receiveDrop(self, dropTypeDrop); 
        }
   }// end dobjFor(Drop)
   dobjFor(Throw){
       verify() { 
           if(no_drop == true){           
             no_drop_message;
             exit;
           }
        }
        action() { askForIobj(ThrowAt); }
   }// end dobjFor(Throw)
   dobjFor(ThrowAt){
        preCond = [objHeld]
        verify()
        {
           if(no_drop == true){           
             no_drop_message;
             exit;
           }
            /* by default, we can throw something if we can drop it */
            verifyMoveTo(gActor.getDropDestination(self, nil));
          
            /* can't throw something at itself */
            if (gIobj == self)
                illogicalSelf(&cannotThrowAtSelfMsg);

            /* can't throw dobj at iobj if iobj is in dobj */
            if (gIobj != nil && gIobj.isIn(self))
                illogicalNow(&cannotThrowAtContentsMsg);
        }
        action()
        {
            /* 
             *   process a 'throw' operation, finishing with hitting the
             *   target if we get that far 
             */
            processThrow(gIobj, &throwTargetHitWith);
        }
   }
;

/*
 * NOTE: instead of doing a modify me, we
 * have defined class CromexxHuman in file: crom_obj.t
 * which will handle all our modifications.
 * Also note that this means we'll need to
 * have our NPC's be of class CromexxHuman
 * instead of class Actor.
 */ 


//
// Modify quit routine... see file: actions.t
// modify QuitAction
//  terminateGame()
//    {
//        /* acknowledge that we're quitting */
//        libMessages.okayQuitting();
//        
        // ***** ADD OUR CODE HERE *****
        //
        // Kill banner(s)    
//          if(frodop != nil)    
//            frodop.removeBanner(); // bannerDelete(1);
//            //frodop = nil;          
//            
//        /* throw a 'quitting' signal to end the game */
//        throw new QuittingException;
//    }  
// ;
//


//modify RestartAction   // see file: actions.t for: DefineSystemAction(Restart)
//    execSystemAction()
//    {
//        /* confirm that they really want to restart */
//        libMessages.confirmRestart();
//        if (yesOrNo())
//        {
//            /* 
//            *   The confirmation input will have put us into
//             *   start-of-command mode for sequencing purposes; force the
//             *   sequencer back to mid-command mode, so we can show
//             *   inter-command separation before the restart. 
//             */
//
//        // ***** ADD OUR CODE HERE *****
//        //
//        // Kill banner(s)
//        uuu = 0;
//        uuu = inputDialog(InDlgIconInfo,'what up dude?',InDlgYesNoCancel,InDlgLblYes, InDlgLblCancel);// from: tadsio.h
//            if(frodop.id != nil){
//               bannerClear(frodop);
//               bannerSizeToContents(frodop);
//               bannerFlush(frodop); 
//               frodop.removeBanner(); // bannerDelete(1);
//               frodop = nil; 
//               uuu = inputDialog(InDlgIconInfo,'what up dude?',InDlgYesNoCancel,InDlgLblYes, InDlgLblCancel);// from: tadsio.h
//            }
// 
//            /* restart the game */
//            doRestartGame();
//        }
//        else
//        {
//            /* confirm that we're not really restarting */
//            libMessages.notRestarting();
//        }
//    }
//;

// ** NOTE: The following has a crash bug in it.
//          A nil object is returned in a query to obj.location.
//          For example, a RoomPart, such as a wall, may have no
//          real object.location point of reference as it is only
//          really in the RoomParts array of the room and maybe 
//          not actually in the room itself.
 // lifted from Heidi.t
modify BasicLocation
lookAroundWithinRemote(actor, pov, otherRoom)
     {
         local illum;
         local infoTab;
         local info;
         local specialList;
         local specialBefore, specialAfter;
         local plst;
 
         // 
         //   get a table of all of the objects that the viewer can sense
         //   in the location using sight-like senses 
         //
         infoTab = actor.visibleInfoTableFromPov(pov);
 
         // get the ambient illumination at the point of view 
         info = infoTab[pov];
         if (info != nil)
         {
             // get the ambient illumination from the info list item 
             illum = info.ambient;
         }
         else
         {
             // the actor's not in the list, so it must be completely dark //
             illum = 0;
         }
 
 
         // 
         //   drop the point-of-view object from the list, to ensure that we
         //   don't list the point-of-view object doing the looking among
         //   the room's contents 
         //
         infoTab.removeElement(pov);
         
                     
             // 
             //   Display any special description messages for visible
             //   objects in otherRoom.  
             //   
             //   Note that we only want to show objects that are currently
             //   using special descriptions AND which aren't contained in
             //   the actor doing the looking, so subset the list
             //   accordingly.  
             //
             specialList = specialDescList(
                 infoTab,
                 {obj: obj.useSpecialDescInRoom(self) && obj.isIn(otherRoom)});
 
             // 
             //   partition the special list into the parts to be shown
             //   before and after the portable contents list 
             //
             plst = partitionList(specialList,
                                  {obj: obj.specialDescBeforeContents});
             specialBefore = plst[1];
             specialAfter = plst[2];
 
             // 
             //   at this point, describe only the items that are to be
             //   listed specially before the room's portable contents list 
             //
             specialContentsLister.showList(actor, nil, specialBefore,
                                            0, 0, infoTab, nil);        
             
     
             if(illum != nil && illum > 1)
             remoteRoomContentsLister(otherRoom).showList(
               actor, otherRoom, otherRoom.contents, ListRecurse, 0, infoTab, nil);
         
             // show the subset that's listed after the room contents
             specialContentsLister.showList(actor, nil, specialAfter,
                                            0, 0, infoTab, nil);
         
     }
     
     
     
    listRemoteContents(otherLocation)
      { lookAroundWithinRemote(gActor, gActor, otherLocation); }
;

// for when we're short
modify Room
    littleDesc = ''
;



// modification to en_us.t
//   What I changed  :  Added one array element
//   Why I changed it:  To use a {that dobj/herself} or {that/herself} tag in a sentence.
//       Example: 'You can\'t play tea party, especially with {that dobj/herself}'
//        if dobj = "bulldozer" this returns "...especially with that."
//        if dobj = "me" this returns ......."...especially with yourself."
//
//   Closest tag to this was {that dobj/her} but it returns "you" NOT "yourself"...
//   ...if you are talking about the "me" object
// 
//modify langMessageBuilder
//   paramList_ =
//    [
//        /* here is one added by Cleo K. */
//        ['that/yourself', &thatObj, nil, nil, true],   
//        /* parameters that imply the actor as the target object */
//        ['you/he', &theName, 'actor', nil, true],
// ......etc.


// KEEP IT !!! THIS IS how to remove the status line!!!!!
// SEE: D:\Program Files\Tads3summer2004\doc\t3frame.htm under "banners" 
// SEE: status.t
modify statusLine
 showStatusHtml()
    { 
      "<BODY BGCOLOR=#C0C0C0 TEXT=#FFFFFF LINK=#DA39E5 VLINK=#99038F>";
      //"<BODY BGCOLOR=#111111 TEXT=#50EB52 LINK=#DA39E5 VLINK=#99038F>"; //  TOPMARGIN=0 LEFTMARGIN=0>";  // MARGINWIDTH=0 MARGINHEIGHT=0>";  CELLSPACING=0 CELLPADDING=0
      //  "[<a href=http:\\\\cromexx.ateros.com\\tads.html>Homepage</a>]
      //   <a href=inventory>inventory</a> 
      //   <a href=score>score</a>
      //   <a href=meters>meters</a><br>
         "<a plain href='<<libMessages.commandLookAround>>'>";         
         /* show left status line */
         showStatusLeft();
         /* set up for the score part on the right half */
         "</a><tab align=right><a plain
          href='<<libMessages.commandFullScore>>'>";
         /* show the right part of the status line */
         showStatusRight();
         "</a>";
         /* add the status-line exit list, if desired */
         if (gPlayerChar.location != nil)
             gPlayerChar.location.showStatuslineExits();
         "</body> \n ";
         // statuslineBanner.sizeToContents();// see: status.t - does not always work though       
    }
 showStatusText()
    {
       "You need an HTML enabled TADS interface for this game.";
    }
;






// KEEP IT !!! THIS IS how to remove the status line!!!!!
// SEE: D:\Program Files\Tads3summer2004\doc\t3frame.htm under "banners" 
// SEE: status.t
/*
modify statusLine
 showStatusHtml()
    { 
       // Setup local var. for pixel height checking 
       local myBannerPixelHeight = nil;
       if(bannerTracker.activeBanners_ != nil){
            myBannerPixelHeight = bannerGetInfo(1)[5];
            bannerSizeToContents(1);
            flushBanner();
            if(myBannerPixelHeight > 91){
                     me.meters = nil; // shut off meters
                     // NOTE: be VERY careful with this.. the daemon calls us and *could* get stuck in a loop
                     // statusLine.showStatusLineDaemon(); // update our banner... NOW! see: status.t
                     // clearScreen();                                         
                     flushBanner();
            }    
       }
       // ..91 pixels high is our optimal value, 186+ is biggest

       "<BODY BGCOLOR=#111111 TEXT=#50EB52 LINK=#DA39E5 VLINK=#99038F>"; //  TOPMARGIN=0 LEFTMARGIN=0>";  // MARGINWIDTH=0 MARGINHEIGHT=0>";  CELLSPACING=0 CELLPADDING=0
       "<table border=0>";
       "<tr>";                 
       "<td valign=top align=left>";
               //  "&nbsp;<table><tr><td><font color=red><i>where</i></font>";
               "<table width=60>"; //  BGCOLOR=#C0C0C0>";
                  "<tr><td valign=top align=left width=20 height=20>";     
                       // ** northwest check **
                       local showIt = nil;
                       if(gPlayerChar.location.northwest != nil) showIt = true;
                       if(gPlayerChar.location.ofKind(Vehicle)){
                          if(gPlayerChar.location.location.northwest != nil) showIt = true;
                       }
                       showIt ? "<a href=northwest><img src=ar_nw.jpg width=20 height=20 alt=nw></a>" : "<img src=ar_nw_g.jpg width=20 height=20 alt=nw_g>";
                       "</td>";
                       "<td valign=top align=left width=20 height=20>";
                       // ** north check **
                       showIt = nil;
                       if(gPlayerChar.location.north != nil) showIt = true;
                       if(gPlayerChar.location.ofKind(Vehicle)){
                          if(gPlayerChar.location.location.north != nil) showIt = true;
                       }  
                       showIt ? "<a href=north><img src=ar_n.jpg width=20 height=20 alt=n></a>" : "<img src=ar_n_g.jpg width=20 height=20 alt=n_g>";
                       "</td>";
                       "<td valign=top align=left width=20 height=20>";
                       // ** northeast check **
                       showIt = nil;
                       if(gPlayerChar.location.northeast != nil) showIt = true;
                       if(gPlayerChar.location.ofKind(Vehicle)){
                          if(gPlayerChar.location.location.northeast != nil) showIt = true;
                       }
                       showIt ? "<a href=northeast><img src=ar_ne.jpg width=20 height=20 alt=ne></a>" : "<img src=ar_ne_g.jpg width=20 height=20 alt=ne_g>"; 
                       "<td valign=top align=left width=20 height=20>";
                       // ** up check **
                       showIt = nil;
                       if(gPlayerChar.location.up != nil) showIt = true;
                       if(gPlayerChar.location.ofKind(Vehicle)){
                          if(gPlayerChar.location.location.up != nil) showIt = true;
                       }
                       showIt ? "<a href=up><img src=ar_u.jpg width=20 height=20 alt=u></a>" : "<img src=ar_u_g.jpg width=20 height=20 alt=u_g>";      
                  "</td></tr>";
                  "<tr><td valign=top align=left width=20 height=20>";
                       // ** west check **
                       showIt = nil;
                       if(gPlayerChar.location.west != nil) showIt = true;
                       if(gPlayerChar.location.ofKind(Vehicle)){
                          if(gPlayerChar.location.location.west != nil) showIt = true;
                       }
                       showIt ? "<a href=west><img src=ar_w.jpg width=20 height=20 alt=w></a>" : "<img src=ar_w_g.jpg width=20 height=20 alt=w_g>";
                       "</td>";
                       "<td valign=top align=left width=20 height=20>";
                       "<a href=in></a>";
                       "</td>";
                       "<td valign=top align=left width=20 height=20>";                       
                       // ** east check **
                       showIt = nil;
                       if(gPlayerChar.location.east != nil) showIt = true;
                       if(gPlayerChar.location.ofKind(Vehicle)){
                          if(gPlayerChar.location.location.east != nil) showIt = true;
                       }
                       showIt ? "<a href=east><img src=ar_e.jpg width=20 height=20 alt=e></a>" : "<img src=ar_e_g.jpg width=20 height=20 alt=e_g>";
                       "<td valign=top align=left width=20 height=20>";                       
                       // ** down check **
                       showIt = nil;
                       if(gPlayerChar.location.down != nil) showIt = true;
                       if(gPlayerChar.location.ofKind(Vehicle)){
                          if(gPlayerChar.location.location.down != nil) showIt = true;
                       }
                       showIt ? "<a href=down><img src=ar_d.jpg width=20 height=20 alt=d></a>" : "<img src=ar_d_g.jpg width=20 height=20 alt=d_g>";      
                  "</td></tr>";
                  "<tr><td valign=top align=left width=20 height=20>";
                       // ** southwest check **
                       showIt = nil;
                       if(gPlayerChar.location.southwest != nil) showIt = true;
                       if(gPlayerChar.location.ofKind(Vehicle)){
                          if(gPlayerChar.location.location.southwest != nil) showIt = true;
                       }
                       showIt ? "<a href=southwest><img src=ar_sw.jpg width=20 height=20 alt=sw></a>" : "<img src=ar_sw_g.jpg width=20 height=20 alt=sw_g>";
                       "</td>";
                       "<td valign=top align=left width=20 height=20>";
                       // ** south check **
                       showIt = nil;
                       if(gPlayerChar.location.south != nil) showIt = true;
                       if(gPlayerChar.location.ofKind(Vehicle)){
                          if(gPlayerChar.location.location.south != nil) showIt = true;
                       }
                       showIt ? "<a href=south><img src=ar_s.jpg width=20 height=20 alt=s></a>" : "<img src=ar_s_g.jpg width=20 height=20 alt=s_g>";
                       "</td>";
                       "<td valign=top align=left width=20 height=20>";
                       // ** southeast check **
                       showIt = nil;
                       if(gPlayerChar.location.southeast != nil) showIt = true;
                       if(gPlayerChar.location.ofKind(Vehicle)){
                          if(gPlayerChar.location.location.southeast != nil) showIt = true;
                       }
                       showIt ? "<a href=southeast><img src=ar_se.jpg width=20 height=20 alt=se></a>" : "<img src=ar_se_g.jpg width=20 height=20 alt=se_g>";
                       showIt = nil; 
                   "</td></tr>";
               "</table>"; 
       "</td><td width=200 valign=top align=left>";
if(me.meters != nil && myBannerPixelHeight <= 100){
           "[<a href=http:\\\\cromexx.ateros.com\\tads.html>Homepage</a>] ";
           "<a href=inventory>inventory</a> ";
           "<a href=score>score</a> ";
           "<a href=meters>meters</a> ";
           "<br>";
       "<table width=250 align=right>";
          "<tr><td width=125 align=right>";
       "binding strength:"; //  <<me.girl_binding_strength>>";
       "<img src=lock.jpg height=15 width=15 alt=lock>";
       "</td><td width=125>";
         local x = 1;
         do{
           if(me.girl_binding_strength >= x){
             "<img src=pink_1x1.jpg height=15 width=1 alt=pink>";
           }else{
              //"<img src=inv_1x1.jpg height=5 width=1 alt=invis>";
             "<img src=blu_1x1.jpg height=5 width=1 alt=invis>";
           }
           x+=5;// x++ for full scale or x+=5 for mini scale 
         }while(x < 100);
       "&nbsp;&nbsp;<<me.girl_binding_strength>>%<br></td></tr><tr><td width=50 align=right>";
       "likes boys:"; //  <<me.girl_likes_boys_level>>";
       "<img src=cupidh.jpg height=15 width=15 alt=cupidh>";
       "<td width=125>";
         x = 1;
         do{
           if(me.girl_likes_boys_level >= x){
             "<img src=pink_1x1.jpg height=15 width=1 alt=pink>";
           }else{
              //"<img src=inv_1x1.jpg height=5 width=1 alt=invis>";
             "<img src=blu_1x1.jpg height=5 width=1 alt=invis>";
           }
           x+=5; // x++ for full scale or x+=5 for mini scale
         }while(x < 100);
       "&nbsp;&nbsp;<<me.girl_likes_boys_level>>%<br></td></tr><tr><td width=100 align=right>";
       "likes being fem:"; // <<me.girl_likes_being_a_girl_level>>";
       "<img src=likegr2.jpg height=15 width=15 alt=heart>"; // heart.jpg
       "</td><td width=125>";
         x = 1;
         do{
           if(me.girl_likes_being_a_girl_level >= x){
             "<img src=pink_1x1.jpg height=15 width=1 alt=pink>";
           }else{
              //"<img src=inv_1x1.jpg height=5 width=1 alt=invis>";
             "<img src=blu_1x1.jpg height=5 width=1 alt=invis>";
           }
           x+=5;// x++ for full scale or x+=5 for mini scale
         }while(x < 100);
       "&nbsp;&nbsp;<<me.girl_likes_being_a_girl_level>>%<br></td></tr></table>";

// **** SECOND METER TABLE 
 " </td><td width=200 valign=top align=left>";  
 "<a href=sex>sex</a>&nbsp;<a href=look>look</a><br>"; // stuff goes here, links, etc.
  "<table width=200 align=right>";
          "<tr><td width=125 align=right>";
       "happy-meter:"; //  <<me.girl_happiness_level>>";
       "<img src=happygrl.jpg height=15 width=15 alt=happygrl>";
       "</td><td width=100>";
         x = 1;
         do{
           if(me.girl_happiness_level >= x){
             "<img src=pink_1x1.jpg height=15 width=1 alt=pink>";
           }else{
              //"<img src=inv_1x1.jpg height=5 width=1 alt=invis>";
             "<img src=blu_1x1.jpg height=5 width=1 alt=invis>";
           }
           x+=5;// x++ for full scale or x+=5 for mini scale 
         }while(x < 100);
       "&nbsp;&nbsp;<<me.girl_happiness_level>>%<br></td></tr><tr><td width=50 align=right>";
// next line blocks out certain meters that only adult characters should have
// if((!me.is_A_Little_Girl) || (me.pcAge >= 18)){
if(me.is_A_Girl && me.pcAge >= 18){
       "climacto-meter:"; //  <<me.climactoMeter>>";
       "<img src=thermo.jpg height=15 width=15 alt=thermo>";
       "<td width=100>";
         x = 1;
         do{
           if(me.climactoMeter >= x){
             "<img src=pink_1x1.jpg height=15 width=1 alt=pink>";
           }else{
              //"<img src=inv_1x1.jpg height=5 width=1 alt=invis>";
             "<img src=blu_1x1.jpg height=5 width=1 alt=invis>";
           }
           x+=5; // x++ for full scale or x+=5 for mini scale
         }while(x < 100);
       "&nbsp;&nbsp;<<me.climactoMeter>>%<br></td></tr><tr><td width=100 align=right>";
       "horny-meter:"; // <<me.hornyMeter>>";
       "<img src=horn.jpg height=15 width=15 alt=horn>";
       "</td><td width=100>";
         x = 1;
         do{
           if(me.hornyMeter >= x){
             "<img src=pink_1x1.jpg height=15 width=1 alt=pink>";
           }else{
              //"<img src=inv_1x1.jpg height=5 width=1 alt=invis>";
             "<img src=blu_1x1.jpg height=5 width=1 alt=invis>";
           }
           x+=5;// x++ for full scale or x+=5 for mini scale
         }while(x < 100);
       "&nbsp;&nbsp;<<me.hornyMeter>>%<br></td></tr>";//  </table>";   
  }// end of if if((!me.is_A_Little_Girl) || (me.pcAge >= 18)){
 "</table>";   
} // end of "if meters == true" block

 
  // girl_happiness_level = 0
  //     climactoMeter = 0 // measures climax
  //     hornyMeter = 0 // measures sexual energy/horniness

       " </td><td width=250 valign=top align=left>";  
          "<a plain href='<<libMessages.commandLookAround>>'>";
           local actor;
           // *** get the player character actor 
           actor = gPlayerChar;
           "<.statusroom>";
           // *** show the actor's location's status name 
           if (actor != nil && actor.location != nil)
               actor.location.statusName(actor);
           "<./statusroom>"; 
           "</a><br>";
            // gPlayerChar.location.showStatuslineExits();
           "<br>";
         "</td><td width=250 valign=top align=left>";


          // *** set up for the score part on the right half
          // </a>
       "</td><td width=50 valign=top align=right>";
           // "<tab align=right>";
           "<P><a plain href='<<libMessages.commandFullScore>>'>";
           // *** show the right part of the status line
           showStatusRight();            
           "</a></P>";
       "</td>";
       "</tr>";      
       "</table>";
       // location.name; // showExits 
      // "<<gPlayerChar.location.north.name>>"; // prints "tree house";
      
       "</body> \n ";
       //bannerSizeToContents(frodop); //       bannerSizeToContents(1);
       //bannerFlush(frodop);        
    }
 showStatusText()
    {
       "You need an HTML enabled TADS interface for this game.";
    }
;
*/



// end of crom_mod.t
