#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>

modify InputDef

    //inherited();&gt;
    beginInputFont() { "<body bgcolor=black text=silver><font face=\"Eras Light ITC\">"; }
 
     /* 
      *   End the input style.  By default, we'll close the <.inputline>
      *   that we opened in beginInputFont(). 
      */
     endInputFont() { "</font>"; }

;

modify libMessages
{
     //Get rid off annoying default message that is displayed after execution of every map move.
     commandResultsEmpty = '';
         //('Nothing obvious happen' + tSel('s', 'ed') + '.<.p>')
        
}

;

/**************************************************************/
/*
modify TopicEntry 
pic = nil 
text = '<body bgcolor=black>';
show() 
      { 
       if (self.pic != nil) 
         {
          mapWindow.updateContents('<body bgcolor=black>'+pic);
         } 
       textWindow.updateContents(text);
      }
       
       handleTopic(fromActor, topic) 
       { 
        show(); 
        inherited(fromActor, topic); 
       } 
      
; 
*/
/**************************************************************/
gameMain: GameMainDef
/* the initial player character is 'me' */
   initialPlayerChar = me
showIntro() { "<body bgcolor=black>A test of Wasteland style graphical CRPG gaming in a TADS3 environment. You begin this game carrying a leather jacket and a pocket knife. Make sure you wear the leather and wield the knife before you fight the mutant as it is your only edge and will save your hide so you can live to explore the other features of this test. "; 
}
 setAboutBox() 
   { 
     "<ABOUTBOX><CENTER>Wasteland-T3\b 
      v <<versionInfo.version>>\b 
      (c) 2006 Kenneth E. Gay\b 
      </CENTER></ABOUTBOX>"; 
   } 
    
   showGoodBye() 
   { 
     "<.p>Thanks for playing!"; 
   }    

;

modify BasicLocation 
     roomPic = nil 
     roomAction = nil
    roomAfterAction()
  {
   if (gPlayerChar.endurance <= 5) { "<sound src=sound/gauntlet_lifeforce.wav layer=foreground>"; }
  }   
     
  roomDesc() 
     { 
 
	 showRoomPic();
	 if (self.roomAction != nil)
	  textWindow.updateContents(roomAction);
	 inherited;
     }


showRoomPic()
{
if (self.roomPic != nil) {
	           mapWindow.updateContents('<body background=\"art/elements/rock1.jpg\"><IMG SRC=\"art/'+roomPic+'.png\">');
/*
switch(self) //gPlayerChar.getOutermostRoom
        {
           case encounterRoom: 
           me.combating.showPic();
           break;
           default: 
            if (self.roomPic != nil) {
	           mapWindow.updateContents('<body background=\"art/elements/rock1.jpg\"><IMG SRC=\"art/'+roomPic+'.png\">'); }
           exit;
        }*/
}
}
;

class Mapped: Room
roomBeforeAction() 
  { 
     local p1=meTile.Pos[1];
     local p2=meTile.Pos[2]; 
if (gAction.actionOfKind(TravelAction)) 
      {
switch(gAction.getDirection())
    {
      case northDirection: nav(p1-1, p2);
      break;

      case southDirection: nav(p1+1, p2);
      break;
      
      case eastDirection: nav(p1, p2+1);
      break;
      
      case westDirection: nav(p1, p2-1);
      break;
      
      case northeastDirection: nav(p1-1, p2+1);
      break;
      
      case northwestDirection: nav(p1-1, p2-1);
      break;
      
      case southeastDirection: nav(p1+1, p2+1);
      break;
      
      case southwestDirection: nav(p1+1, p2-1);
      break;
      }
   
   exit;}
  }

nav(x, y) 
     {

     if (gPlayerChar.location.ofKind(Encounter)) {return;}
     if (!map1.checkMoveTo(x, y)) {return;}
     else
     {

        "<SOUND SRC=\"sound/step.wav\" layer=foreground>";

        meTile.Pos=[x,y];
     }
     }

enteringRoom(traveler) { npcTurn.reload(); map1.reload(); }
leavingRoom(traveler) { npcTurn.endDmon(); map1.endDmon(); }
;



building1: Room 'Abondoned Building' "The place is empty. The sheet metal roofing has been torn away in one spot revealing a man-sized hole in the ceiling. But unless you brought a rope or ladder with you there is no way to reach it. "
roomPic = 'building1'
south=outside
;


me: Actor
   /* the initial location */ 
    location = outside
      //Pos = [3,3]
      //icon = 'icons/PC'
      //Map = 'map1'
      flee=nil
      fleeCounter=0
      sides=1
      dice=10
   ;

+ leather: Armor '(genuine) leather jacket' 'jacket' "Your favorite jacket is a heavy leather bomber with a silky comfortable lining. Soft on the inside, tough on the outside. It won't stop a bullet but anything with claws or sharp teeth might have a difficult time getting past your defenses and it keeps you warm and dry too. "
AC = 5
;

+ knife: Weapon '(Gerber) (pocket) knife' 'pocket knife' "You were raised the old fashioned way. No man worth his salt goes anywhere without his trusty pocket knife. And in your experience no pocket knife is sharper or more durable than a Gerber. Yours has a very comfortable ergonomically shaped rubber handle for a perfect fit and firm grip making the knife like an extension of your arm. Handy tool as well as an effective means of self-defense. "
    dice = 2
    sides = 6
    ;



outside: Mapped, OutdoorRoom 'Outside' ""
;

Decoration 'building' 'building' @outside
  "This run down old building looks as if it has taken quite a beating over the years. As battered as it is, it still somehow manages to remind you of civilization. " 
; 

loot : Thing 'loot treasure money bag cash' 'bag of loot' 
      "A bag stuffed with wads of cash! " 
;


/******************************************************/

    


versionInfo: GameID
   IFID = 'f31dce62-8027-df56-9829-4b50ea15f249'
   name = 'Wasteland-T3. A test of Wasteland style game design using T3. '
   byline = 'Kenneth Eugene Gay'
   htmlByline = 'by <a href="mailto:contactken@frontiernet.net">
                  Kenneth Eugene Gay</a>'
   version = '1.1'
   authorEmail = 'contactken@frontiernet.net <contactken@frontiernet.net>'
   desc = 'This little sample game combines classic Interactive Fiction with classic top down computer role playing games of yesteryear such as Wasteland or Ultima. It is a little lacking in the IF department right now as it is mainly meant to test and sample the CRPG potential of T3. So please do not judge it too harshly.  '
   htmlDesc = 'This little sample game combines classic Interactive Fiction with classic top down computer role playing games of yesteryear such as Wasteland or Ultima. It is a little lacking in the IF department right now as it is mainly meant to test and sample the CRPG potential of T3. So please do not judge it too harshly.  '

    showCredit() 
    { 
        /* show our credits */ 
        "TADS 3 language and library by Michael J. Roberts ";
        
        "<p>Eric Eve & Steve Breslin for help with too many things to list here";
        "<p>Krister Fundin for help with Vectors";
        "<p>Everyone else who posted anything useful, if only for inspiration, in the RAIF [TADS3] group. My thanks goes out to all of the above. ";
        /*  
         *   The game credits are displayed first, but the library will 
         *   display additional credits for library modules.  It's a good 
         *   idea to show a blank line after the game credits to separate 
         *   them visually from the (usually one-liner) library credits 
         *   that follow.   
         */ 
        "\b"; 
    } 
    showAbout() 
    { 
        "This little sample game combines classic Interactive Fiction with classic top down computer role playing games of yesteryear such as Wasteland or Ultima. It is a little lacking in the IF department right now as it is mainly meant to test and sample the CRPG potential of T3. So please do not judge it too harshly. Please email me with your ideas, questions, comments, criticisms, bug reports, etc. "; 
    } 
; 

;
        


DefineIAction(flee)
    execAction()
    {  
    if (gPlayerChar.location.ofKind(Encounter))
    //if (gPlayerChar.isIn(mutiny))
            {
             combatOff();
           "I'm gettin the heck outta here before I become an <b>appetizer!</b> <SOUND SRC=\"sound/runcoward.wav\" layer=foreground>";
           gPlayerChar.moveIntoForTravel(outside);
           map1.reload();
           exit; 
            }
         else
         "Flee from what?! A little jumpy aren't we? ";
 
    }
         
    
;

VerbRule(flee) 'flee' : fleeAction
    verbPhrase = 'fleeing.'
;

DefineIAction(ignore)
    execAction()
    {  
        //cannibal.ignore=true;
        "Oh, it's just a blood thirsty cannibal uber-mutant. If I don't bother it maybe it won't bother me. ";
    }
;

VerbRule(ignore) 'ignore' : ignoreAction
    verbPhrase = 'ignoring.'
;

combatOff()
{
       "<SOUND CANCEL>";
       gActor.endMelee(); 
}
;

DefineIAction(clear)
    execAction()
    {  
      mapWindow.clearWindow();
      mapWindow.updateContents('');
    }
    ;

VerbRule(clear) 'clear' : clearAction
    verbPhrase = 'clearing.'
;