/*
 * The Legend Lives!
 *
 * Executable and source code are
 *
 *                 Copyright (C) 1995 by David M. Baggett
 *
 * All rights reserved, except as follows:
 * 
 *    Electronic redistribution is permitted, but only if not for profit.
 *    Specifically, you may provide copies in electronic form ONLY if you
 *    do not charge anything beyond the distribution media cost AND if you
 *    do not alter the source code in any way.
 *
 * Note that the author reserves all rights to derivative works and
 * products.  This includes ports and enhanced versions.  The author will
 * typically grant permission for these when asked, but this will be
 * dealt with on a case by case basis only.
 *
 */

//
// Products created by the transmogrifier in the Barfee Research Lab
//

#ifndef	DEMO

repellant: Item
	bulk = 1
	weight = 1
	sdesc = "spray can"
	ldesc = {
		"Tiny lettering on the side of the can reads:  ";
		P(); I();
		"\"Akmi Dam Phowl Snayk Rheepehlant.  Guaranteed results!
		Shake before using.  To use, spray target with
		repellant.  In case of failure, send proof of purchase
		to Akmi Galacticorp, Planet Plast, Akmi System.\"";
	}
	noun = 'can' 'repellent' 'rheepehlant'
	adjective = 'dam' 'phowl' 'foul' 'snake' 'snayk' 'spray'  'acme' 'akmi'
	spraycount = 1
	verDoWave(actor) = {}
	doWave(actor) = {
		"You shake the can vigorously.  Suddenly, the can starts
		to hiss ominously -- and then, without warning, it explodes,
		sending metal shards flying everywhere.  Amazingly, you
		are unharmed -- but the can has disintegrated!";

		self.movein(nil);
	}
	verIoSpraywith(actor) = {}
	ioSpraywith(actor, dobj) = {
		dobj.doSpraywith(actor, self);
	}
	verDoSmell(actor) = {
		"Ack!  Smells like poison, all right.  I'd be careful
		with it if I were you.";
	}
;

#endif	/* DEMO */

seeds: Knowntopic, spf	// class defined in seeds.t
	type = "prune"
	adjective = 'prune' 'hoppian'
	myplant = theprune
	location = nil
;

#ifndef	DEMO

paperclip: Item
	isbent = nil
	sdesc = {
		if (self.isbent)
			"bent ";
		"paper clip";
	}
	noun = 'clip'
	adjective = 'paper'
	verDoBend(actor) = {}
	doBend(actor) = {
		if (self.isbent) {
			"You bend the paper clip back into shape.";
			self.isbent := nil;
		}
		else {
			"You bend the paper clip out of shape.";
			self.isbent := true;
		}
	}
;
oillamp: Lightsource
	weight = 2
	adesc = "an oil lamp"
	sdesc = "oil lamp"
	ldesc = {
		"It's an old-style oil lamp.  How quaint! ";

		if (self.islit) {
			"Currently, the lamp is lit.";

			if (self.isin(Me))
			    " It is pleasingly warm in your hands.";
		}
		else {
			"Currently, the lamp is unlit.
			It's cold to the touch.";
		}
	}
	noun = 'lamp' 'light'
	adjective = 'ancient' 'oil' 'old'
	verDoEat(actor) = {}
	doEat(actor) = {
		"Gulp. Not half bad...";

		self.movein(nil);
	}
	verDoRub(actor) = {
		"A giant genie springs forth!  Ha ha.  Just kidding.";
	}
	verDoTurnon(actor) = {
		if (self.islit)
			"It's already on! ";
	}
	doTurnon(actor) = {
		"The lamp is now lit.  It casts a cheery yellow glow.";
		self.islit := true;
	}
	verDoTurnoff(actor) = {
		if ( not self.islit ) "It's not lit. ";
	}
	doTurnoff(actor) = {
		"Okay, the lamp is now off. ";
		self.islit := nil;
	}
	verDoSmell (actor) = {
		"As you might expect, it smells of oil.";
	}
	verDoOpen(actor) = {
		"You can't seem to get the lamp open, but from the
		sloshing sounds inside, it sounds like it's got a
		healthy supply of oil.";
	}
	verDoLick(actor) ={
		"Bleah.  The lamp tastes kind of greasy.  ";
	}
;
coal: Item
	sdesc = "hunk of coal"
	noun = 'coal' 'hunk'
;
playingcard: Item
	sdesc = "playing card"
	ldesc = {
		"It's an ordinary playing card.  It is
		the King of Akmids.";
	}
	noun = 'card'
	adjective = 'playing'
;
toothpick: Item
	sdesc = "wooden toothpick"
	noun = 'toothpick'
	adjective = 'wooden'
;
actionfigure: Item
	sdesc = "Valley King action figure"
	ldesc = {
		"It's a form-molded plastic rendition of 
		the first Valley King.  You used to have
		one when you were little -- it was one
		of your favorite toys.  Come to think of
		it, the Valley King looks a little bit
		like you.";
	}
	noun = 'king' 'figure'
	adjective = 'valley' 'king' 'action'
;
aknex: Item
	firstmention = true
	sdesc = {
		"AkNex tissue";
		if (self.firstmention) {
			self.firstmention := nil;
			notify(self, &explode, 15);
		}
	}
	adesc = "an <<self.sdesc>>"
	ldesc = {
		"It's just an ordinary tissue.  AkNex's
		aren't known for their sturdiness, but
		this one looks fine.";
	}

	explode = {
		if (self.isin(Me.location)) {
			P(); I(); "The AkNex tissue suddenly vaporizes!";
		}
		self.movein(nil);
	}

	noun = 'aknex' 'tissue' 'kleenex'
	adjective = 'akmi'
;
deadrat: Listablesmell, Item
	sdesc = "dead rat"
	ldesc = {
		"It looks like an ordinary dead rat,
		stiff from rigor mortis.  Ewwww.";
	}
	noun = 'rat'
	adjective = 'dead'

	verDoEat(actor) = {}
	doEat(actor) = {
		"You need serious professional help.
		Do NOT contact ADVENTIONS.";
	}
	
	listsmelldesc = "smells awful!"
	smelldesc = { "\^<<self.subjthedesc>> <<self.listsmelldesc>>"; }
;
bomb: Listablesound, Item
	sdesc = {
		"mysterious black sphere";
	}
	ldesc = {
		"It's just a smooth black sphere.  It's ticking.";
	}
	noun = 'sphere' 'ball'
	adjective = 'mysterious' 'black' 'ticking'
	listlistendesc = { "is ticking."; }
	listendesc = {
		"It seems to be making a ticking sound.";
	}
;
flint: Item
	sdesc = "piece of flint"
	noun = 'flint' 'piece'
;
liquidnitrogen: pourable, Readable
	liquiddesc = "liquid nitrogen"
	sdesc = { "canister of "; self.liquiddesc; }
	ldesc = {
		"It would seem to be a canister of liquid nitrogen.
		I'd be careful with it, if I were you -- remember seeing
		your chemistry professor stick a metal dowel in liquid
		nitrogen and then hit it on the table, shattering it? 
		Bet that would sure smart if it happened to your hand.";
	}
	readdesc = {
		"A label on the cannister says \"N (7)\".";
	}

	noun = 'canister' 'nitrogen' 'can' 'liquid'
	adjective = 'liquid' 'nitrogen'

	weight = 3
	bulk = 3
	
	verDoDrink(actor) = {}
	doDrink(actor) = {
		"Drinking liquid nitrogen would surely kill you.";
	}

	poureffect(actor, o) = {
		if (defined(o, &freeze)) {
			o.freeze;
		}
		else {
			"Pouring liquid nitrogen on "; o.objthedesc(nil);
			" will probably destroy it.  This is very likely
			a bad idea.";
		}
	}
;
marbles: Item
	isplural = true
	sdesc = "marbles"
	noun = 'marbles'
;
glue: Item, pourable
	sdesc = "container of glue"
	noun = 'glue' 'container'
	adjective = 'glue'
	verIoPutin(actor) = {}
	ioPutin(actor, dobj) = {
		"\^<<dobj.subjthedesc>> <<dobj.is>> now
		a bit sticky.";
	}
	poureffect(actor, o) = {
		"You pour some of the glue on <<o.objthedesc(nil)>>.
		\^<<o.subjprodesc>> <<o.is>> now a bit sticky.";
	}
;
valmid: Item
	sdesc = "valmid"
	ldesc = {
		"This bronze coin is a valmid, with an image of the first
		Valley King on one side and the Hall of the Valley
		King on	the other.  This coin would be worth a
		fortune if it weren't a synthesized reproduction.";
	}
	noun = 'valmid' 'coin'
	plural = 'coins'
	adjective = 'bronze'

	verDoSmell(actor) = {
		"It smells metallic.";
	}
;
wugrumphat: Clothing
	sdesc = "wugrump hat"
	ldesc = {
		"It's a hat made of Wugrump fur "; note(self); ".  Very
		warm, but quite politically incorrect in these days of
		galaxy-wide eco-consciousness.";
	}
	noun = 'hat'
	adjective = 'wugrump' 'wug' 'rump'
	footnote = {
		"Wugrumps are cute, furry creatures that live on
		the planet Razor in the Edge system.  Unfortunately
		for the Wugrumps, all the other	fauna on Razor are
		carnivorous, and Wugrums are the only things they like to
		eat.  Tough break.  One	scientist estimated, however, that
		they spend fully 98% of their lives procreating.";
	}
;
clay: Item
	sdesc = "lump of clay"
	noun = 'lump' 'clay'
	adjective = 'clay'
;
idtag: Item, Readable
	sdesc = "id tag"
	adesc = "an <<self.sdesc>>"
	ldesc = {
		"It's a metal ID tag. ";
		self.readdesc;
	}
	readdesc = {
		"Embossed letters on the tag read:\b";
		"\tLeben, Comp Specialist, Akmi Space Ship Cheez Pig";
	}
	noun = 'tag'
	adjective = 'id'
;
wax: Item
	sdesc = "blob of wax"
	noun = 'wax' 'blob'
;
#endif	/* DEMO */
