!------------------------------------------------------------------------------
!
!
!								D E A D L I N E
!
!
!								  Inform Port
!
!
!	This material contains elements based on the game Deadline.
!	It is used with permission as instructive material.
!	Original Deadline material is (c) 1982, 1999 Activision, Inc.
!	Deadline and Activision are registered trademarks of Activision, Inc.
!	All rights reserved.
!
!	Inform Port written by Volker Lanz. Please do not distribute modified
!	versions of these files.
!	You can contact me via e-mail: volker.lanz@gmx.net
!
!	Most parts of this file are copyright (c) Graham Nelson.
!
!	LIBEXT.H
!	========
!	Library extensions
!
!
!-------------------------------------------------------------------------------

Global last_npc;


!------------------------------------------------------------------------------
! First, the modified versions of stuff from VERBLIBM.H
!------------------------------------------------------------------------------

[ SqueezeSub;
	if (ObjectIsUntouchable(noun))
		return;

	if (noun has animate && noun ~= player)
		return L__M(##Squeeze,1,noun);

	L__M(##Squeeze,2,noun);
];

[ WaitSub;
	if (AfterRoutines() == 1)
		rtrue;

	<< WaitMoves 3 >>;
];

!------------------------------------------------------------------------------
[ GoSub i j k df movewith thedir old_loc sa sn ss;
	
	if (second ~= 0 && second notin Compass
       && ObjectIsUntouchable(second)) return;

	old_loc = location;
	movewith=0;
	i=parent(player);
	
	if ((location~=thedark && i~=location) || (location==thedark && i~=real_location))
	{
		j=location;
		if (location==thedark)
			location=real_location;

		k=RunRoutines(i,before);
		if (k~=3)
			location=j;
		if (k==1)
		{
			movewith=i;
			i=parent(i);
		}
		else
		{	if (k==0)
			L__M(##Go,1,i);
			rtrue;
		}
	}

	thedir=noun.door_dir;
	if (ZRegion(thedir)==2)
		thedir=RunRoutines(noun,door_dir);
  
	j=i.thedir;
	k=ZRegion(j);
	
	if (k==3)
	{
		print (string) j;
		new_line;
		rfalse;
	}

	if (k==2)
	{
		j=RunRoutines(i,thedir);
		if (j==1)
			rtrue;
	}

	if (k==0 || j==0)
	{
		if (i.cant_go ~= 0)
			PrintOrRun(i, cant_go);
		rfalse;
	}

	if (j has door)
	{
!		Deadline needs concealed doors to work.
!		if (j has concealed)
!			return L__M(##Go,2);

		if (j hasnt open)
		{
			if (noun==u_obj)
				return L__M(##Go,3,j);

			if (noun==d_obj)
				return L__M(##Go,4,j);
			
			return L__M(##Go,5,j);
		}
		
		k=RunRoutines(j,door_to);
		
		if (k==0)
			return L__M(##Go,6,j);
		
		if (k==1)
			rtrue;
		j = k;
	}

	if (movewith==0)
		move player to j;
	else
		move movewith to j;

	location=j;
	MoveFloatingObjects();
	
	df=OffersLight(j);

	if (df~=0)
	{
		location=j;
		real_location=j;
		lightflag=1;
	}
	else
	{
		if (old_loc == thedark)
		{
			DarkToDark();
			if (deadflag~=0)
				rtrue;
		}
		real_location=j;
		location=thedark;
		lightflag=0;
	}
	
	if (AfterRoutines()==1)
		rtrue;
	
	if (keep_silent==1)
		rtrue;

	sa = action;
	sn = noun;
	ss = second;
	
	LookSub(1);
];

!-------------------------------------------------------------------------------
[ LMode1Sub;	! Brief
	lookmode=1;
	"[Okay, you will get brief descriptions.]";
];

!-------------------------------------------------------------------------------
[ LMode2Sub;	! Verbose
	lookmode=2;
	"[Okay, you will get verbose descriptions.]";
];

!-------------------------------------------------------------------------------
[ LMode3Sub;	! Superbrief
	lookmode=3;
	"[Okay, you will get super-brief descriptions. Remember that objects and people
	are not mentioned; only the name of the place you are in.]";
];

!-------------------------------------------------------------------------------
[ ScriptOnSub;
#ifdef JAVA;
	"Transcription is not possible with this version of the story, sorry.";
#ifnot;
	transcript_mode = ((0-->8) & 1);
	if (transcript_mode)
		return L__M(##ScriptOn,1);
	@output_stream 2;
	if (((0-->8) & 1) == 0)
		return L__M(##ScriptOn,3);
	
	L__M(##ScriptOn,2); VersionSub();

	transcript_mode = true;
#endif;
];

!-------------------------------------------------------------------------------
[ ScriptOffSub;
#ifdef JAVA;
	"Transcription is not possible with this version of the story, sorry.";
#ifnot;
	transcript_mode = ((0-->8) & 1);
	
	if (transcript_mode == false)
		return L__M(##ScriptOff,1);
	
	L__M(##ScriptOff,2);
	@output_stream -2;
	
	if ((0-->8) & 1)
		return L__M(##ScriptOff,3);
	
	transcript_mode = false;
#endif;
];

!-------------------------------------------------------------------------------
[ ScoreSub;
	"There is no score in ", (string) Story, ".";
];

!-------------------------------------------------------------------------------
[ FullScoreSub;
	ScoreSub();
];

!------------------------------------------------------------------------------
[ DrawStatusLine width pos;
	@split_window 1;
	@set_window 1;
	@set_cursor 1 1;
	style reverse;

	width = 0->33;
	pos = width-19;
	spaces width;

	@set_cursor 1 2;
	print (name) location;

	@set_cursor 1 pos;
	print (string) TIME__TX;
	LanguageTimeOfDay(sline1, sline2);
   
	@set_cursor 1 1;
	style roman;
	@set_window 0;
];

!------------------------------------------------------------------------------
[ VersionSub;
	Banner();
	print "Created with PC/Win32 Inform "; inversion;
	print " - Library ", (string) LibRelease, " (", (string) LibSerial, ")^";
	print "Copyright (c) Graham Nelson 1993-98.^";
];


!------------------------------------------------------------------------------
[ Banner i;
	new_line;

	style bold;			print (string) Story;
	style roman;		print (string) Headline;

	print "Release ", (0-->1) & $03ff;

	print " Interpreter ", 0->$1e, " Version ", (char) 0->$1f;

    print " Serial Number ";
	for (i=18:i<24:i++) print (char) 0->i;

	print " ";

#ifdef BETA;
	print "[BETA]";
#endif;

#ifdef DEBUG;
	print "[DB]";
#endif;

#ifdef JAVA;
	print "[J]";
#endif;

	print "^^";
];

!------------------------------------------------------------------------------
[ PushSub;
	if (ObjectIsUntouchable(noun))
		return;

	! This was included for "push button" to work
	if (noun has switchable)
	{
		if (noun has on)
			<< SwitchOff noun >>;
		<< SwitchOn noun >>;
	}
	
	if (noun has static)
		return L__M(##Push,1,noun);

	if (noun has scenery)
		return L__M(##Push,2,noun);

	if (noun has animate)
		return L__M(##Pull,4,noun);

	L__M(##Push,3,noun);
];

!------------------------------------------------------------------------------
[ InsertSub ancestor t;
	receive_action = ##Insert;

	if (second==d_obj || player in second)
		<<Drop noun>>;

	if (parent(noun)~=player)
		return L__M(##Insert,1,noun);

	ancestor = CommonAncestor(noun, second);

	if (ancestor == noun)
		return L__M(##Insert, 5, noun);

	if (ObjectIsUntouchable(second))
		return;

	if (second ~= ancestor)
	{
		action=##Receive;
		if (RunRoutines(second,before)~=0)
		{
			action=##Insert;
			rtrue;
		}
		
		action=##Insert;

		if (second has container && second hasnt open)
			return L__M(##Insert,3,second);
	}

	if (second hasnt container)
		return L__M(##Insert,2,second);

	if (noun has worn)
	{
		L__M(##Insert,6,noun);
		<Disrobe noun>;

		if (noun has worn)
			return;
	}

	! Let's see if the container has room for the object to be inserted:
	! (1) The object's size plus the size of the container's children
	!     must not exceed the container's space property value
	! (2) The object's weight plus the weight of the container's children
	!     must not exceed the container's capacity property value
	
	if (noun provides weight)
		t = ValueOrRun(noun, weight);
	else
		t = 1;
		
	if (ChildrenWeight(second) + t > ValueOrRun(second,capacity))
		"There's no room in ", (the) second, " for ", (the) noun, ".";

	if (noun provides size)
		t = ValueOrRun(noun, size);
	else
		t = 3;
		
	if (ChildrenSize(second) + t > ValueOrRun(second, space))
		"There's no room in ", (the) second, " for ", (the) noun, ".";

	move noun to second;

	if (AfterRoutines()==1)
		rtrue;

	if (second ~= ancestor)
	{
		action=##Receive;

		if (RunRoutines(second,after)~=0)
		{
			action=##Insert;
			rtrue;
		}

		action=##Insert;
	}
  
	if (keep_silent==1)
		rtrue;

	if (multiflag==1)
		return L__M(##Insert,8,noun);

	L__M(##Insert,9,noun);
];

!-------------------------------------------------------------------------------
[ ChildrenSize obj s x;
	x = child(obj);
	
	while (x)
	{
		if (x provides size)
			s = s + ValueOrRun(x, size);
		else
			s = s + 1;
		
		x = sibling(x);
	}
	
	return s;
];

!-------------------------------------------------------------------------------
[ ChildrenWeight obj s x;
	x = child(obj);
	
	while (x)
	{
		if (x provides weight)
			s = s + ValueOrRun(x, weight);
		else
			s = s + 1;
		
		x = sibling(x);
	}
	
	return s;
];

!-------------------------------------------------------------------------------
[ TakeSub;
	if (onotheld_mode==0 || noun notin player)
		if (AttemptToTakeObject(noun))
			rtrue;

	if (AfterRoutines()==1)
		rtrue;

	notheld_mode=onotheld_mode;

	if (notheld_mode==1 || keep_silent==1)
		rtrue;

	L__M(##Take,1, noun);
];

!-------------------------------------------------------------------------------
[ AttemptToTakeObject item     ancestor after_recipient i j k;
	! Try to transfer the given item to the player: return false
	! if successful, true if unsuccessful, printing a suitable message
	! in the latter case.

	! People cannot ordinarily be taken.
	if (item == player)
		return L__M(##Take,2);

	if (item has animate)
		return L__M(##Take,3,item);

	ancestor = CommonAncestor(player, item);

	if (ancestor == 0)
	{
		i = ObjectScopedBySomething(item);
		if (i ~= 0)
			ancestor = CommonAncestor(player, i);
	}

	! Are player and item in totally different places?

	if (ancestor == 0)
		return L__M(##Take,8,item);

	! Is the player indirectly inside the item?
	if (ancestor == item)
		return L__M(##Take,4,item);

	! Does the player already directly contain the item?
	if (item in player)
		return L__M(##Take,5,item);

	! Can the player touch the item, or is there (e.g.) a closed container
	! in the way?
	if (ObjectIsUntouchable(item,false,true))
		return;

	! The item is now known to be accessible.

	! Consult the immediate possessor of the item, if it's in a container
	! which the player is not in.

	i=parent(item);
	if (i ~= ancestor && (i has container || i has supporter))
	{
		after_recipient=i;
		k=action;
		action=##LetGo;
		
		if (RunRoutines(i,before)~=0)
		{
			action=k;
			rtrue;
		}
		
		action=k;
	}

	if (item has scenery)
		return L__M(##Take,10,item);

	if (item has static)
		return L__M(##Take,11,item);


	! The item is now known to be available for taking.
	! The question is now: Does the player carry TOO MANY things?
	! And, second: Does he carry things that are TOO HEAVY?
	! Note that support for a SACK_OBJECT has been removed!
	
	! First checking for number of objects and space of player
	! We don't use the size of the objects because this would
	! cause too much confusion in the end.
	
	.RetryToMoveObject;
	k=0;
	objectloop (j in player)
		if (j hasnt worn)
			k = k + 1;

	if (k >= ValueOrRun(player, space))
	{
		if (ToSackObject())			! Something could be moved to the 
			jump RetryToMoveObject;	! SACK_OBJECT, thus we retry the whole thing
		
		! Ok, the player is carrying too many things, so we say he drops something
		! accidentally
		objectloop (j in player)
			if (j hasnt worn)
			{
				move j to location;
				give j moved;			! Shouldn't be necessary, but indeed it is...
				move item to location;	! In case the item was in a container or on a supporter
				give item moved;
				"Oh no, ", (the) j, " slips from your arms while you are trying to take ", (the) item,
				" and both tumble to the ground.";
			}
		
		! If we couldn't remove anything from the player with the above method (shouldn't happen),
		! the player gets the standard message that he's carrying too many things.	
		return L__M(##Take,12);
	}

	! Now checking weight and capacity of player
	k = 0;
	objectloop (j in player)
		if (j hasnt worn)
			k = k + ValueOrRun(j, weight);
			
	if (k + ValueOrRun(item, weight) > ValueOrRun(player, capacity) &&
		~~IndirectlyContains(player, item))
	{
		if (ToSackObject())
			jump RetryToMoveObject;
		"Your load is too heavy.";
	}	

	! Transfer the item.
	move item to player;

	! Send "after" message to the object letting go of the item, if any.

	if (after_recipient~=0)
	{
		k=action;
		action=##LetGo;
		if (RunRoutines(after_recipient,after)~=0)
		{
			action=k;
			rtrue;
		}
		action=k;
	}

	rfalse;
];

!-------------------------------------------------------------------------------
[ ToSackObject j k;
	if (SACK_OBJECT ~= 0)
	{
		if (parent(SACK_OBJECT)~=player)
		{
			L__M(##Take,12);
			rfalse;
		}

		j = 0;
		objectloop (k in player) 
			if (k ~= SACK_OBJECT && k hasnt worn && k hasnt light)
				j=k;

		if (j ~= 0)
		{
			L__M(##Take,13,j);
			keep_silent = 1;
			<Insert j SACK_OBJECT>;
			keep_silent = 0;
			if (j notin SACK_OBJECT)
				rfalse;
			rtrue;
		}
		else
		{
			L__M(##Take,12);
			rfalse;
		}
	}
	
	rfalse;
];

!-------------------------------------------------------------------------------
[ YesOrNo i;
	for (::)
	{
		parse-->1 = " ";
		
		if (location == nothing || parent(player) == nothing) read buffer parse;
        else read buffer parse DrawStatusLine;
		
		i = parse-->1;

		if (i==YES1__WD or YES2__WD or YES3__WD)
			rtrue;

		if (i==NO1__WD or NO2__WD or NO3__WD)
			rfalse;

		L__M(##Quit,1); print "> ";
	}
];

!------------------------------------------------------------------------------
[ RestoreSub;
#ifdef JAVA;
	"You cannot use SAVE or RESTORE in this version of the story, sorry.";
#ifnot;
	restore Rmaybe;

	return L__M(##Restore,1);

	.RMaybe;
	L__M(##Restore,2);
#endif;
];

!------------------------------------------------------------------------------
[ SaveSub s;
#ifdef JAVA;
	"You cannot use SAVE or RESTORE in this version of the story, sorry.";
#ifnot;
	@save -> s;

	switch(s)
	{
		0:
			return L__M(##Save,1);
		1:
			L__M(##Save,2);
		2:
			L__M(##Restore, 2);
			print "^";
			<< Look >>;
	}
#endif;
];

!------------------------------------------------------------------------------
[ VerifySub;
	print "Verifying game...^";

	@verify ?Vmaybe;
	jump Vwrong;

	.Vmaybe;
	return L__M(##Verify,1);

	.Vwrong;
	L__M(##Verify,2);
];

!------------------------------------------------------------------------------
[ InvWideSub;
	<Inv>;
];

!------------------------------------------------------------------------------
[ InvTallSub;
	<Inv>;
];

!------------------------------------------------------------------------------
[ InvSub x c;
	if (child(player) == 0)
		return L__M(##Inv, 1);

	objectloop (x in player)
		if (x hasnt worn)
		{
			give x workflag;
			c++;
		}
		else
			give x ~workflag;	

	if (c == 0)
		return L__M(##Inv, 1);

	L__M(##Inv, 2);
	print ":^";

	WriteListFrom(child(player), WORKFLAG_BIT + RECURSE_BIT + INDENT_BIT + NEWLINE_BIT);

	AfterRoutines();
];

!------------------------------------------------------------------------------
[ LookSub allow_abbrev  visibility_levels i j k;
	if (parent(player)==0)
		return RunTimeError(10);

	.MovedByInitial;
	
 	if (location == thedark) 
 		{ visibility_ceiling = thedark; NoteArrival(); }
 	else
 		{ visibility_levels = FindVisibilityLevels();	
		if (visibility_ceiling == location)
			{
				NoteArrival();
				if (visibility_ceiling ~= location)
					jump MovedByInitial;
			}
		}

	!   Printing the top line
	
	style bold;

	if (visibility_levels == 0)
		print (name) thedark;
	else
	{
		if (visibility_ceiling ~= location)
			print (The) visibility_ceiling;
		else
			print (name) visibility_ceiling;
	}

	for (j=1, i=parent(player):j<visibility_levels:j++, i=parent(i))
		if (i has supporter)
			L__M(##Look,1,i);
		else
			L__M(##Look,2,i);

	if (print_player_flag==1)
		L__M(##Look,3,player);


	new_line;
	
	style roman;

	!   The room description (if visible)

	if (lookmode<3 && visibility_ceiling==location)
	{
		if ((allow_abbrev~=1) || (lookmode==2) || (location hasnt visited))
		{
			if (location.describe~=NULL)
				RunRoutines(location,describe);
			else
			{
				if (location.description==0)
					RunTimeError(11,location);
				else
					PrintOrRun(location,description);
			}
		}
	}

	if (visibility_levels == 0)
		Locale(thedark);
	else
	{
		for (i=player, j=visibility_levels: j>0: j--, i=parent(i))
			give i workflag;
      
		for (j=visibility_levels: j>0: j--)
		{
			for (i=player, k=0: k<j: k++) i=parent(i);
				if (i.inside_description~=0)
				{
					new_line;
					PrintOrRun(i,inside_description);
				}
			Locale(i);
		}
	}

	LookRoutine();
	ScoreArrival();

	action=##Look;
	
	if (AfterRoutines()==1)
		rtrue;
];

!------------------------------------------------------------------------------
[ Locale descin text1 text2 o k p j f2 flag;

	objectloop (o in descin)
		give o ~workflag;

	k=0;

	objectloop (o in descin)
		if (o hasnt concealed && NotSupportingThePlayer(o))
		{
			#IFNDEF MANUAL_PRONOUNS;
			PronounNotice(o);
			#ENDIF;

			if (o hasnt scenery)
			{
				give o workflag;
				k++;
				p=initial;
				f2=0;
				
				if ((o has door || o has container)
						&& o has open && o provides when_open)
				{
					p = when_open;
					f2 = 1;
					jump Prop_Chosen;
				}
				
				if ((o has door || o has container)
						&& o hasnt open && o provides when_closed)
				{
					p = when_closed;
					f2 = 1;
					jump Prop_Chosen;
				}
             
				if (o has switchable && o has on && o provides when_on)
				{
					p = when_on;
					f2 = 1;
					jump Prop_Chosen;
				}
				
				if (o has switchable && o hasnt on && o provides when_off)
				{
					p = when_off;
					f2 = 1;
				}

				.Prop_Chosen;

				if (o hasnt moved || o.describe~=NULL || f2==1)
				{
					if (o.describe~=NULL && RunRoutines(o,describe)~=0)
					{
						flag=1;
						give o ~workflag;
						k--;
					}    
					else
					{
						j=o.p;
						if (j~=0)
						{   
							PrintOrRun(o,p);
							flag=1;
							give o ~workflag;
							k--;
							if (o has supporter && child(o)~=0)
								SayWhatsOn(o);
						}
					}
				}
			}
			else
				if (o has supporter && child(o)~=0)
					SayWhatsOn(o);
		}

	if (k==0)
		return 0;

	if (text1~=0)
	{
		if (flag==1)
			text1=text2;

		print (string) text1, " ";
		WriteListFrom(child(descin),
			ENGLISH_BIT + WORKFLAG_BIT + RECURSE_BIT
			+ PARTINV_BIT + TERSE_BIT + CONCEAL_BIT);
		return k;
	}
           
	if (flag==1)
		L__M(##Look,5,descin);
	else
		L__M(##Look,6,descin);
];

!------------------------------------------------------------------------------
[ SayWhatsOn descon j f;
	if (descon == parent(player))
		rfalse;

	objectloop (j in descon)
	{
		if (j provides initial && j hasnt moved)
		{
			PrintOrRun(j, initial);
			give j ~workflag;
		}
		else if (j hasnt concealed && j hasnt scenery)
		{
			f = 1;
			give j workflag;
		}
		else
			give j ~workflag;
	}
	
	if (f)
	{
		print "On ", (the) descon;
		WriteListFrom(child(descon), ENGLISH_BIT + WORKFLAG_BIT
			+ RECURSE_BIT + PARTINV_BIT + TERSE_BIT + ISARE_BIT);
		".";
	}

	rfalse;	
];

!------------------------------------------------------------------------------
[ WriteListFrom o style depth;
	if (o == child(parent(o)))
	{
		SortOutList(o);
		o=child(parent(o));
	}
	
	c_style = style;

	wlf_indent = 1;		! setting top level indentation (hopefully... *g*)
	
	WriteListR(o,depth);

	rtrue;
];



!------------------------------------------------------------------------------
!	These are modified routines from PARSERM.H
!------------------------------------------------------------------------------

!------------------------------------------------------------------------------
[ TryGivenObject obj threshold k w j;

#ifdef DEBUG;
   if (parser_trace>=5)
       print "    Trying ", (the) obj, " (", obj, ") at word ", wn, "^";
#endif;

   dict_flags_of_noun = 0;

!  If input has run out then always match, with only quality 0 (this saves
!  time).

   if (wn > num_words)
   {   if (indef_mode ~= 0)
           dict_flags_of_noun = $$01110000;  ! Reject "plural" bit
       MakeMatch(obj,0);
       #ifdef DEBUG;
       if (parser_trace>=5)
       print "    Matched (0)^";
       #endif;
       return 1;
   }

!  Ask the object to parse itself if necessary, sitting up and taking notice
!  if it says the plural was used:

   if (obj.parse_name~=0)
   {   parser_action = NULL; j=wn;
       k=RunRoutines(obj,parse_name);
       if (k>0)
       {   wn=j+k;
           .MMbyPN;

           if (parser_action == ##PluralFound)
               dict_flags_of_noun = dict_flags_of_noun | 4;

           if (dict_flags_of_noun & 4)
           {   if (~~allow_plurals) k=0;
               else
               {   if (indef_mode==0)
                   {   indef_mode=1; indef_type=0; indef_wanted=0; }
                   indef_type = indef_type | PLURAL_BIT;
                   if (indef_wanted==0) indef_wanted=100;
               }
           }

           #ifdef DEBUG;
               if (parser_trace>=5)
               {   print "    Matched (", k, ")^";
               }
           #endif;
           MakeMatch(obj,k);
   		   take_all_rule = 3;
           return k;
       }
       if (k==0) jump NoWordsMatch;
   }

!  The default algorithm is simply to count up how many words pass the
!  Refers test:

   parser_action = NULL;

   w = NounWord();

   if (w==1 && player==obj) { k=1; jump MMbyPN; }

   if (w>=2 && w<128 && (LanguagePronouns-->w == obj))
   {   k=1; jump MMbyPN; }

   j=--wn;
   threshold = ParseNoun(obj);
#ifdef DEBUG;
   if (threshold>=0 && parser_trace>=5)
       print "    ParseNoun returned ", threshold, "^";
#endif;
   if (threshold<0) wn++;
   if (threshold>0) { k=threshold; jump MMbyPN; }

   if (threshold==0 || Refers(obj,wn-1)==0)
   {   .NoWordsMatch;
       if (indef_mode~=0)
       {   k=0; parser_action=NULL; jump MMbyPN;
       }
       rfalse;
   }

   if (threshold<0)
   {   threshold=1;
       dict_flags_of_noun = (w->#dict_par1) & $$01110100;
       w = NextWord();
       while (Refers(obj, wn-1))
       {   threshold++;
           if (w)
               dict_flags_of_noun = dict_flags_of_noun
                                    | ((w->#dict_par1) & $$01110100);
           w = NextWord();
       }
   }

   k = threshold; jump MMbyPN;
];

! ----------------------------------------------------------------------------
!  ParseToken(type, data):
!      Parses the given token, from the current word number wn, with exactly
!      the specification of a general parsing routine.
!      (Except that for "topic" tokens and prepositions, you need to supply
!      a position in a valid grammar line as third argument.)
!
!  Returns:
!    GPR_REPARSE  for "reconstructed input, please re-parse from scratch"
!    GPR_PREPOSITION  for "token accepted with no result"
!    $ff00 + x    for "please parse ParseToken(ELEMENTARY_TT, x) instead"
!    0            for "token accepted, result is the multiple object list"
!    1            for "token accepted, result is the number in parsed_number"
!    object num   for "token accepted with this object as result"
!    -1           for "token rejected"
!
!  (A)            Analyse the token; handle all tokens not involving
!                 object lists and break down others into elementary tokens
!  (B)            Begin parsing an object list
!  (C)            Parse descriptors (articles, pronouns, etc.) in the list
!  (D)            Parse an object name
!  (E)            Parse connectives ("and", "but", etc.) and go back to (C)
!  (F)            Return the conclusion of parsing an object list
! ----------------------------------------------------------------------------

[ ParseToken given_ttype given_tdata token_n x y;
  x = lookahead; lookahead = NOUN_TOKEN;
  y = ParseToken__(given_ttype,given_tdata,token_n);
  if (y == GPR_REPARSE) Tokenise__(buffer,parse);
  lookahead = x; return y;
];

[ ParseToken__ given_ttype given_tdata token_n
             token l o i j k and_parity single_object desc_wn many_flag
             token_allows_multiple;

!  **** (A) ****

   token_filter = 0;

   switch(given_ttype)
   {   ELEMENTARY_TT:
           switch(given_tdata)
           {   SPECIAL_TOKEN:
                   l=TryNumber(wn);
                   special_word=NextWord();
                   #ifdef DEBUG;
                   if (l~=-1000)
                       if (parser_trace>=3)
                           print "  [Read special as the number ", l, "]^";
                   #endif;
                   if (l==-1000)
                   {   #ifdef DEBUG;
                       if (parser_trace>=3)
                         print "  [Read special word at word number ", wn, "]^";
                       #endif;
                       l = special_word;
                   }
                   parsed_number = l; return GPR_NUMBER;

               NUMBER_TOKEN:
                   l=TryNumber(wn++);
                   if (l==-1000) { etype=NUMBER_PE; return GPR_FAIL; }
                   #ifdef DEBUG;
                   if (parser_trace>=3) print "  [Read number as ", l, "]^";
                   #endif;
                   parsed_number = l; return GPR_NUMBER;

               CREATURE_TOKEN:
                   if (action_to_be==##Answer or ##Ask or ##AskFor or ##Tell)
                       scope_reason = TALKING_REASON;

               TOPIC_TOKEN:
                   consult_from = wn;
                   if ((line_ttype-->(token_n+1) ~= PREPOSITION_TT)
                       && (line_token-->(token_n+1) ~= ENDIT_TOKEN))
                       RunTimeError(13);
                   do o=NextWordStopped();
                   until (o==-1 || PrepositionChain(o, token_n+1) ~= -1);
                   wn--;
                   consult_words = wn-consult_from;
                   if (consult_words==0) return GPR_FAIL;
               ! DEADLINE - ##Analyse is added here.
                   if (action_to_be==##Ask or ##Answer or ##Tell or ##Analyse)
                   {   o=wn; wn=consult_from; parsed_number=NextWord();
                       #IFDEF EnglishNaturalLanguage;
                       if (parsed_number=='the' && consult_words>1)
                           parsed_number=NextWord();
                       #ENDIF;
                       wn=o; return 1;
                   }
                   return GPR_PREPOSITION;
           }

       PREPOSITION_TT:
           #Iffalse Grammar__Version==1;
!  Is it an unnecessary alternative preposition, when a previous choice
!  has already been matched?
           if ((token->0) & $10) return GPR_PREPOSITION;
           #Endif;

!  If we've run out of the player's input, but still have parameters to
!  specify, we go into "infer" mode, remembering where we are and the
!  preposition we are inferring...

           if (wn > num_words)
           {   if (inferfrom==0 && parameters<params_wanted)
               {   inferfrom = pcount; inferword = token;
                   pattern-->pcount = REPARSE_CODE + Dword__No(given_tdata);
               }

!  If we are not inferring, then the line is wrong...

               if (inferfrom==0) return -1;

!  If not, then the line is right but we mark in the preposition...

               pattern-->pcount = REPARSE_CODE + Dword__No(given_tdata);
               return GPR_PREPOSITION;
           }

           o = NextWord();

           pattern-->pcount = REPARSE_CODE + Dword__No(o);

!  Whereas, if the player has typed something here, see if it is the
!  required preposition... if it's wrong, the line must be wrong,
!  but if it's right, the token is passed (jump to finish this token).

           if (o == given_tdata) return GPR_PREPOSITION;
           #Iffalse Grammar__Version==1;
           if (PrepositionChain(o, token_n) ~= -1)
               return GPR_PREPOSITION;
           #Endif;
           return -1;

       GPR_TT:
           l=indirect(given_tdata);
           #ifdef DEBUG;
           if (parser_trace>=3)
               print "  [Outside parsing routine returned ", l, "]^";
           #endif;
           return l;

       SCOPE_TT:
           scope_token = given_tdata;
           scope_stage = 1;
           l = indirect(scope_token);
           #ifdef DEBUG;
           if (parser_trace>=3)
               print "  [Scope routine returned multiple-flag of ", l, "]^";
           #endif;
           if (l==1) given_tdata = MULTI_TOKEN; else given_tdata = NOUN_TOKEN;

       ATTR_FILTER_TT:
           token_filter = 1 + given_tdata;
           given_tdata = NOUN_TOKEN;

       ROUTINE_FILTER_TT:
           token_filter = given_tdata;
           given_tdata = NOUN_TOKEN;
   }

   token = given_tdata;

!  **** (B) ****

!  There are now three possible ways we can be here:
!      parsing an elementary token other than "special" or "number";
!      parsing a scope token;
!      parsing a noun-filter token (either by routine or attribute).
!
!  In each case, token holds the type of elementary parse to
!  perform in matching one or more objects, and
!  token_filter is 0 (default), an attribute + 1 for an attribute filter
!  or a routine address for a routine filter.

   token_allows_multiple = false;
   if (token == MULTI_TOKEN or MULTIHELD_TOKEN or MULTIEXCEPT_TOKEN
                or MULTIINSIDE_TOKEN) token_allows_multiple = true;

   many_flag = false; and_parity = true; dont_infer = false;

!  **** (C) ****
!  We expect to find a list of objects next in what the player's typed.

  .ObjectList;

   #ifdef DEBUG;
   if (parser_trace>=3) print "  [Object list from word ", wn, "]^";
   #endif;

!  Take an advance look at the next word: if it's "it" or "them", and these
!  are unset, set the appropriate error number and give up on the line
!  (if not, these are still parsed in the usual way - it is not assumed
!  that they still refer to something in scope)

    o=NextWord(); wn--;

    pronoun_word = NULL; pronoun_obj = NULL;
    l = PronounValue(o);
    if (l ~= 0)
    {   pronoun_word = o; pronoun_obj = l;
        if (l == NULL)
        {   !   Don't assume this is a use of an unset pronoun until the
            !   descriptors have been checked, because it might be an
            !   article (or some such) instead

            for (l=1:l<=LanguageDescriptors-->0:l=l+4)
                if (o == LanguageDescriptors-->l) jump AssumeDescriptor;
            pronoun__word=pronoun_word; pronoun__obj=pronoun_obj;
            etype=VAGUE_PE; return GPR_FAIL;
        }
    }

    .AssumeDescriptor;

    if (o==ME1__WD or ME2__WD or ME3__WD)
    {   pronoun_word = o; pronoun_obj = player;
    }

    allow_plurals = true; desc_wn = wn;

    .TryAgain;
!   First, we parse any descriptive words (like "the", "five" or "every"):
    l = Descriptors(token_allows_multiple);
    if (l~=0) { etype=l; return GPR_FAIL; }

    .TryAgain2;

!  **** (D) ****

!  This is an actual specified object, and is therefore where a typing error
!  is most likely to occur, so we set:

    oops_from = wn;

!  So, two cases.  Case 1: token not equal to "held" (so, no implicit takes)
!  but we may well be dealing with multiple objects

!  In either case below we use NounDomain, giving it the token number as
!  context, and two places to look: among the actor's possessions, and in the
!  present location.  (Note that the order depends on which is likeliest.)

    if (token ~= HELD_TOKEN)
    {   i=multiple_object-->0;
        #ifdef DEBUG;
        if (parser_trace>=3)
            print "  [Calling NounDomain on location and actor]^";
        #endif;
        l=NounDomain(actors_location, actor, token);
        if (l==REPARSE_CODE) return l;                  ! Reparse after Q&A
        if (l==0) {   if (indef_possambig)
                      {   ResetDescriptors(); wn = desc_wn; jump TryAgain2; }
                      etype=CantSee(); jump FailToken; } ! Choose best error

        #ifdef DEBUG;
        if (parser_trace>=3)
        {   if (l>1)
                print "  [ND returned ", (the) l, "]^";
            else
            {   print "  [ND appended to the multiple object list:^";
                k=multiple_object-->0;
                for (j=i+1:j<=k:j++)
                    print "  Entry ", j, ": ", (The) multiple_object-->j,
                          " (", multiple_object-->j, ")^";
                print "  List now has size ", k, "]^";
            }
        }
        #endif;

        if (l==1)
        {   if (~~many_flag)
            {   many_flag = true;
            }
            else                                  ! Merge with earlier ones
            {   k=multiple_object-->0;            ! (with either parity)
                multiple_object-->0 = i;
                for (j=i+1:j<=k:j++)
                {   if (and_parity) MultiAdd(multiple_object-->j);
                    else MultiSub(multiple_object-->j);
                }
                #ifdef DEBUG;
                if (parser_trace>=3)
                    print "  [Merging ", k-i, " new objects to the ",
                        i, " old ones]^";
                #endif;
            }
        }
        else
        {   ! A single object was indeed found

            if (match_length == 0 && indef_possambig)
            {   !   So the answer had to be inferred from no textual data,
                !   and we know that there was an ambiguity in the descriptor
                !   stage (such as a word which could be a pronoun being
                !   parsed as an article or possessive).  It's worth having
                !   another go.

                ResetDescriptors(); wn = desc_wn; jump TryAgain2;
            }
        
            if (token==CREATURE_TOKEN && CreatureTest(l)==0)
            {   etype=ANIMA_PE; jump FailToken; } !  Animation is required

            if (~~many_flag)
                single_object = l;
            else
            {   if (and_parity) MultiAdd(l); else MultiSub(l);
                #ifdef DEBUG;
                if (parser_trace>=3)
                    print "  [Combining ", (the) l, " with list]^";
                #endif;
            }
        }
    }

!  Case 2: token is "held" (which fortunately can't take multiple objects)
!  and may generate an implicit take

    else

    {   l=NounDomain(actor,actors_location,token);       ! Same as above...
        if (l==REPARSE_CODE) return GPR_REPARSE;
        if (l==0)
        {   if (indef_possambig)
            {   ResetDescriptors(); wn = desc_wn; jump TryAgain2; }
            etype=CantSee(); return GPR_FAIL;            ! Choose best error
        }

!  ...until it produces something not held by the actor.  Then an implicit
!  take must be tried.  If this is already happening anyway, things are too
!  confused and we have to give up (but saving the oops marker so as to get
!  it on the right word afterwards).
!  The point of this last rule is that a sequence like
!
!      > read newspaper
!      (taking the newspaper first)
!      The dwarf unexpectedly prevents you from taking the newspaper!
!
!  should not be allowed to go into an infinite repeat - read becomes
!  take then read, but take has no effect, so read becomes take then read...
!  Anyway for now all we do is record the number of the object to take.

        o=parent(l);
        if (o~=actor)
        {   if (notheld_mode==1)
            {   saved_oops=oops_from; etype=NOTHELD_PE; jump FailToken;
            }
            not_holding = l;
            #ifdef DEBUG;
            if (parser_trace>=3)
                print "  [Allowing object ", (the) l, " for now]^";
            #endif;
        }
        single_object = l;
    }

!  The following moves the word marker to just past the named object...

    wn = oops_from + match_length;

!  **** (E) ****

!  Object(s) specified now: is that the end of the list, or have we reached
!  "and", "but" and so on?  If so, create a multiple-object list if we
!  haven't already (and are allowed to).

    .NextInList;

    o=NextWord();

    if (o==AND1__WD or AND2__WD or AND3__WD or BUT1__WD or BUT2__WD or BUT3__WD
           or comma_word)
    {
        #ifdef DEBUG;
        if (parser_trace>=3) print "  [Read connective '", (address) o, "']^";
        #endif;

        if (~~token_allows_multiple)
        {   etype=MULTI_PE; jump FailToken;
        }

        if (o==BUT1__WD or BUT2__WD or BUT3__WD) and_parity = 1-and_parity;

        if (~~many_flag)
        {   multiple_object-->0 = 1;
            multiple_object-->1 = single_object;
            many_flag = true;
            #ifdef DEBUG;
            if (parser_trace>=3)
                print "  [Making new list from ", (the) single_object, "]^";
            #endif;
        }
        dont_infer = true; inferfrom=0;           ! Don't print (inferences)
        jump ObjectList;                          ! And back around
    }

    wn--;   ! Word marker back to first not-understood word

!  **** (F) ****

!  Happy or unhappy endings:

    .PassToken;

    if (many_flag)
    {   single_object = GPR_MULTIPLE;
        multi_context = token;
    }
    else
    {   if (indef_mode==1 && indef_type & PLURAL_BIT ~= 0)
        {   if (indef_wanted<100 && indef_wanted>1)
            {   multi_had=1; multi_wanted=indef_wanted;
                etype=TOOFEW_PE;
                jump FailToken;
            }
        }
    }
    return single_object;

    .FailToken;

!  If we were only guessing about it being a plural, try again but only
!  allowing singulars (so that words like "six" are not swallowed up as
!  Descriptors)

    if (allow_plurals && indef_guess_p==1)
    {   allow_plurals=false; wn=desc_wn; jump TryAgain;
    }
    return -1;
];

!------------------------------------------------------------------------------
!	This is a modified InformLibrary object. The original InformLibrary
!	object in parserm.h must be excluded (e.g. by an #ifdef statement that's
!	just never true) to be able to successfully	compile the gamefile.
!------------------------------------------------------------------------------

Object InformLibrary "(Inform Library)"
  with play
       [ i j k l x;
       standard_interpreter = $32-->0;
       transcript_mode = ((0-->8) & 1);
       ChangeDefault(cant_go, CANTGO__TX);
       
       buffer->0 = 120;
       buffer2->0 = 120;
       buffer3->0 = 120;
       parse->0 = 64;
       parse2->0 = 64;
       
       real_location = thedark;
       player = selfobj;
       actor = player;
    
       top_object = #largest_object-255;
       selfobj.capacity = MAX_CARRIED;
       #ifdef LanguageInitialise;
       LanguageInitialise();
       #endif;
       new_line;
       j=Initialise();
       last_score = score;
       move player to location;
       while (parent(location)~=0) location=parent(location);

       ! This loop must not give anything ~concealed that's worn!
       real_location = location;
       objectloop (i in player)
			if (i has worn)
				give i moved;
			else
				give i moved ~concealed;
    
       if (j~=2) Banner();

       MoveFloatingObjects();
       lightflag=OffersLight(parent(player));
       if (lightflag==0) { real_location=location; location=thedark; }

       < Look >;
    
       for (i=1:i<=100:i++) j=random(i);

       #ifdef EnglishNaturalLanguage;
       old_itobj = itobj; old_himobj = himobj; old_herobj = herobj;
       #endif;
    
       while (~~deadflag)
       {   
           #ifdef EnglishNaturalLanguage;
               PronounOldEnglish();
               old_itobj = PronounValue('it');
               old_himobj = PronounValue('him');
               old_herobj = PronounValue('her');
           #endif;

           .very__late__error;

           if (score ~= last_score)
           {   if (notify_mode==1) NotifyTheScore(); last_score=score; }

           .late__error;

           inputobjs-->0 = 0; inputobjs-->1 = 0;
           inputobjs-->2 = 0; inputobjs-->3 = 0; meta=false;
    
           !  The Parser writes its results into inputobjs and meta,
           !  a flag indicating a "meta-verb".  This can only be set for
           !  commands by the player, not for orders to others.
    
           InformParser.parse_input(inputobjs);
    
           action=inputobjs-->0;

           !  --------------------------------------------------------------

           !  Reverse "give fred biscuit" into "give biscuit to fred"
    
           if (action==##GiveR or ##ShowR)
           {   i=inputobjs-->2; inputobjs-->2=inputobjs-->3; inputobjs-->3=i;
               if (action==##GiveR) action=##Give; else action=##Show;
           }
    
           !  Convert "P, tell me about X" to "ask P about X"
    
           if (action==##Tell && inputobjs-->2==player && actor~=player)
           {   inputobjs-->2=actor; actor=player; action=##Ask;
           }
    
           !  Convert "ask P for X" to "P, give X to me"
    
           if (action==##AskFor && inputobjs-->2~=player && actor==player)
           {   actor=inputobjs-->2; inputobjs-->2=inputobjs-->3;
               inputobjs-->3=player; action=##Give;
           }
    
           !  For old, obsolete code: special_word contains the topic word
           !  in conversation
    
           if (action==##Ask or ##Tell or ##Answer)
               special_word = special_number1;

           !  --------------------------------------------------------------
    
           multiflag=false; onotheld_mode=notheld_mode; notheld_mode=false;
           !  For implicit taking and multiple object detection
    
          .begin__action;
           inp1 = 0; inp2 = 0; i=inputobjs-->1;
           if (i>=1) inp1=inputobjs-->2;
           if (i>=2) inp2=inputobjs-->3;
    
           !  inp1 and inp2 hold: object numbers, or 0 for "multiple object",
           !  or 1 for "a number or dictionary address"
    
           if (inp1 == 1) noun = special_number1; else noun = inp1;
           if (inp2 == 1)
           {   if (inp1 == 1) second = special_number2;
               else second = special_number1;
           } else second = inp2;

           !  --------------------------------------------------------------
           !  DEADLINE / NPC_ENGINE:

           if (actor == player && action == ##Tell)
           {
               if (last_npc && TestScope (last_npc))
                   actor = last_npc;
               else
                   objectloop (x in location)
                       if (x ofclass NPC_Engine)
                           actor = x;
               
               if (actor ~= player)
               {
                   print "(said to ", (the) actor, ")^";
                   last_npc = actor;
                   inputobjs-->2=actor; actor=player; action=##Ask;
                   jump begin__action;
               }
           }
          
           if (actor ~= player)
               last_npc = actor;
           else
           {
               if (noun ofclass NPC_Engine)
                   last_npc = noun;
               else if (second ofclass NPC_Engine)
                   last_npc = second;
           }
           
			if (actor ~= player && actor ofclass NPC_Engine && actor.npc_move_type ~= 2)
			{
				if (action == ##Hey || actor in location)
					actor.npc_stopped = 3;
			}

			if (noun ofclass NPC_Engine && noun.npc_move_type ~= 2)
			{
           		if ((action == ##Ask or ##Hello or ##Accuse && noun in location)
           				|| (action == ##Hey))
           			noun.npc_stopped = 3;
			}

			if (second ofclass NPC_Engine && second.npc_move_type ~= 2
					&& action == ##Show or ##Give && second in location)
				second.npc_stopped = 3;

                   
           !  END OF DEADLINE / NPC_ENGINE
           !  --------------------------------------------------------------    
           if (actor~=player)
           {   
           !  The player's "orders" property can refuse to allow conversation
           !  here, by returning true.  If not, the order is sent to the
           !  other person's "orders" property.  If that also returns false,
           !  then: if it was a misunderstood command anyway, it is converted
           !  to an Answer action (thus "floyd, grrr" ends up as
           !  "say grrr to floyd").  If it was a good command, it is finally
           !  offered to the Order: part of the other person's "life"
           !  property, the old-fashioned way of dealing with conversation.
    
               j=RunRoutines(player,orders);
               if (j==0)
               {   j=RunRoutines(actor,orders);
                   if (j==0)
                   {   if (action==##NotUnderstood)
                       {   inputobjs-->3=actor; actor=player; action=##Answer;
                           jump begin__action;
                       }
                       if (RunLife(actor,##Order)==0) L__M(##Order,1,actor);
                   }
               }
               jump turn__end;
           }

           !  --------------------------------------------------------------
           !  Generate the action...

           if ((i==0)
               || (i==1 && inp1 ~= 0)
               || (i==2 && inp1 ~= 0 && inp2 ~= 0))
           {   self.begin_action(action, noun, second, 0);
               jump turn__end;
           }

           !  ...unless a multiple object must be substituted.  First:
           !  (a) check the multiple list isn't empty;
           !  (b) warn the player if it has been cut short because too long;
           !  (c) generate a sequence of actions from the list
           !      (stopping in the event of death or movement away).

           multiflag = true;
           j=multiple_object-->0;
           if (j==0) { L__M(##Miscellany,2); jump late__error; }
           if (toomany_flag)
           {   toomany_flag = false; L__M(##Miscellany,1); }
           i=location;

           for (k=1:k<=j:k++)
           {   if (deadflag) break;
               if (location ~= i)
               {   L__M(##Miscellany, 51);
                   break;
               }
               l = multiple_object-->k;
               PronounNotice(l);

				! DEADLINE -- Here, if the verb is arrest, the list of objects mustn't be printed
               if (action ~= ##Arrest)
	               print (name) l, ": ";

               if (inp1 == 0)
               {   inp1 = l; self.begin_action(action, l, second, 0); inp1 = 0;
               }
               else
               {   inp2 = l; self.begin_action(action, noun, l, 0); inp2 = 0;
               }

				! DEADLINE -- Again, if it was Arrest, the action ends here.
               if(action == ##Arrest)
                 break;

           }

           !  --------------------------------------------------------------
    
           .turn__end;
    
           !  No time passes if either (i) the verb was meta, or
           !  (ii) we've only had the implicit take before the "real"
           !  action to follow.
    
           if (notheld_mode==1) { NoteObjectAcquisitions(); continue; }
           if (meta) continue;
           
           ! NPC_ENGINE - in case of a waiting action, no time passes either
           if (action == ##Wait or ##WaitMoves or ##WaitUntil or ##WaitHours or ##NPC_WaitFor)
             continue;
           
           if (~~deadflag) self.end_turn_sequence();
       }

           if (deadflag~=2) AfterLife();
           if (deadflag==0) jump very__late__error;
    
           print "^^    ";
           #IFV5; style bold; #ENDIF;
           print "***";
           if (deadflag==1) L__M(##Miscellany,3);
           if (deadflag==2) L__M(##Miscellany,4);
           if (deadflag>2)  { print " "; DeathMessage(); print " "; }
           print "***";
           #IFV5; style roman; #ENDIF;
           print "^^^";
           ScoreSub();
           DisplayStatus();
    	   AfterGameOver();
       ],

       end_turn_sequence
       [ i j;

           turns++;
           if (the_time~=NULL)
           {   if (time_rate>=0) the_time=the_time+time_rate;
               else
               {   time_step--;
                   if (time_step==0)
                   {   the_time++;
                       time_step = -time_rate;
                   }
               }
               the_time=the_time % 1440;
           }

           #IFDEF DEBUG;
           if (debug_flag & 4 ~= 0)
           {   for (i=0: i<active_timers: i++)
               {   j=the_timers-->i;
                   if (j~=0)
                   {   print (name) (j&$7fff), ": ";
                       if (j & $8000) print "daemon";
                       else
                       {   print "timer with ",
                                 j.time_left, " turns to go"; }
                       new_line;
                   }
               }
           }
           #ENDIF;

			! DEADLINE / NPC_ENGINE
			! This one I changed so that it sets tw_waiting on whenever
			! a daemon or a timer returns true. This means, that if a
			! daemon/timer wants the game to ask the player if he likes
			! to keep waiting, it should return true; if not, it must
			! return false
			for (i=0: i<active_timers: i++)
			{
				if (deadflag) return;
				j=the_timers-->i;
				if (j~=0)
				{
					#ifdef DEBUG;
						if (parser_trace >= 3)
							print "[Running ", (name) (j&$7fff), ".]^";
					#endif;
					
					if (j & $8000)
					{
						if(RunRoutines(j&$7fff,daemon))
							give tw_waiting on;
					}
					else
					{
						if (j.time_left==0)
						{
							StopTimer(j);
						   
							if (RunRoutines(j,time_out))
								give tw_waiting on;
						}
						else
							j.time_left=j.time_left-1;
					}
				}
			}
           
           if (deadflag) return;

           scope_reason=EACH_TURN_REASON; verb_word=0;
           DoScopeAction(location);
           SearchScope(ScopeCeiling(player), player, 0);
           scope_reason=PARSING_REASON;

           if (deadflag) return;

           TimePasses();

           if (deadflag) return;

           AdjustLight();

           if (deadflag) return;

           NoteObjectAcquisitions();
       ],

       begin_action
       [ a n s source   sa sn ss;
           sa = action; sn = noun; ss = second;
           action = a; noun = n; second = s;
           #IFDEF DEBUG;
           if (debug_flag & 2 ~= 0) TraceAction(source);
           #IFNOT;
           source = 0;
           #ENDIF;
           #IFTRUE Grammar__Version == 1;
           if ((meta || BeforeRoutines()==false) && action<256)
		   ActionPrimitive();
           #IFNOT;
           if ((meta || BeforeRoutines()==false) && action<4096)
           ActionPrimitive();
           #ENDIF;
           action = sa; noun = sn; second = ss;
       ],
  has  proper;
  
!------------------------------------------------------------------------------

!------------------------------------------------------------------------------
!	And now the library messages and stuff from ENGLISH.h
!------------------------------------------------------------------------------

!------------------------------------------------------------------------------
[ LanguageLM n x1 i;
	Prompt:
		print "^>";
		rtrue;

	Miscellany:
		switch(n)
		{
			1:	"(considering the first sixteen objects only)^";
			2:	"Nothing to do!";
			3:	print " You have died ";
			4:	print " You have won ";
			5:	print "^Would you like to RESTART, RESTORE a saved game";
				#IFDEF DEATH_MENTION_UNDO;
				print ", UNDO your last move";
				#ENDIF;
				if (TASKS_PROVIDED==0)
					print ", give the FULL score for that game";
				if (deadflag==2 && AMUSING_PROVIDED==0)
					print ", see some suggestions for AMUSING things to do";
				" or QUIT?";
			6:	"[Your interpreter does not provide ~undo~.  Sorry!]";
			7:	"~Undo~ failed.  [Not all interpreters provide it.]";
			8:	"Please give one of the answers above.";
			9:	"^It is now pitch dark in here!";
			10:	"What?";
			11:	"[You can't ~undo~ what hasn't been done!]";
			12:	"[Sorry, can't ~undo~ twice in a row.]";
			13:	"[Previous turn undone.]";
			14:	"[Sorry, that can't be corrected.]";
			15:	"Think nothing of it.";
			16:	"[~Oops~ can only correct a single word.]";
			17:	"It is pitch dark, and you can't see a thing.";
			18:	print "yourself";
			19:	"There's nothing special about yourself.";           
			20:	"[To repeat a command like ~frog, jump~, just say
				~again~, not ~frog, again~.]";
			21:	"[You can hardly repeat that.]";
			22:	"[You can't begin with a comma.]";
			23:	"[You seem to want to talk to someone, but I can't see whom.]";
			24:	"[You can't talk to ", (the) x1, "!]";
			25:	"[To talk to someone, try ~someone, hello~ or some such.]";
			26:	"(first taking ", (the) not_holding, ")";
			27:	"[That last sentence didn't make sense.]";
			28:	print "I only understood you as far as wanting to ";
			29:	"[I didn't understand that number.]";
			30:	if (action_to_be == ##Find)
					"You're the detective.";

				wn = 1;
				i = NextWordStopped();
				while (i)
				{ 
					if (i == -1)
						"You can't see that here."; 
					i = NextWordStopped();
				} 

				DontKnowWord(wn-1);
				rtrue;
			31:	"[You seem to have said too little.]";
			32:	"You aren't holding that!";
			33:	"[You can't use multiple objects with that verb.]";
			34:	"[You can only use multiple objects once on a line.]";
			35:	"[I'm not sure what ~", (address) pronoun_word,
				"~ refers to.]";
			36:	"[You excepted something not included anyway!]";
			37:	"What a (ahem!) strange idea!";
			38:	DontKnowWord(1);
				rtrue;
			39:	"[You don't need to refer to this to complete the story.]";
			40:	"[You can't see ~", (address) pronoun_word,
				"~ (", (the) pronoun_obj, ") at the moment.]";
			41:	"[I didn't understand the way that finished.]";
			42:	if (x1==0)
					print "[None";
				else
					print "[Only ", (number) x1;
				print " of those ";
				if (x1==1)
					print "is";
				else
					print "are";
				" available.]";
			43:	"[Nothing to do.]";
			44:	"[There are none at all available.]";
			45:	print "Who do you mean, ";
			46:	print "Which do you mean, ";
			47:	"Sorry, you can only have one item here. Which exactly?";
			48:	print "Whom do you want";
				if (actor~=player)
					print " ", (the) actor;
				print " to ";
				PrintCommand();
				print "?^";
			49:	print "What do you want";
				if (actor~=player)
					print " ", (the) actor;
				print " to ";
				PrintCommand();
				print "?^";
			50:	print "Your score has just gone ";
				if (x1 > 0)
					print "up";
				else
				{
					x1 = -x1;
					print "down";
				}
				print " by ", (number) x1, " point";
				if (x1 > 1)
					print "s";
			51:	"[Since something dramatic has happened,
				your list of commands has been cut short.]";
			52:	"^Type a number from 1 to ", x1,
				", 0 to redisplay or press ENTER.";
			53:	"^[Please press SPACE.]";
		}

	ListMiscellany:
		switch(n)
		{
			1:	print " (providing light)";
			2:	rtrue;
			3:	print " (providing light)";
			4:	rtrue;
			5:	print " (providing light)";
			6:	rtrue;
			7:	print " (providing light)";
			8:	print " (providing light and being worn";
			9:	print " (providing light";
			10:	print " (being worn";
			11:	print " (which ", (isorare) x1, " ";
			12:	print "open";
			13:	print "open but empty";
			14:	print "closed";
			15:	print "closed and locked";
			16:	print " and empty";
			17:	print " (which ", (isorare) x1, " empty)";
			18:	print " containing ";
			19:	print " (on ";
			20:	print ", on top of ";
			21:	print " (in ";
			22:	print ", inside ";
		}

	Pronouns:
		switch(n)
		{
			1:	print "At the moment, ";
			2:	print "means ";
			3:	print "is unset";
			4:	"no pronouns are known to the game.";
		}
		
	Order:
		DoYourself();
		rtrue;
		
	Quit:
		switch(n)
		{
			1: print "Please answer yes or no.";
			2: print "Do you wish to stop your investigation (Y/N) >";
		}
		rtrue;

	Restart:
		switch(n)
		{
			1: print "Do you wish to restart your investigation (Y/N) >";
			2: "[Failed.]";
		}
		rtrue;
		
	Restore:
		switch(n)
		{
			1:	"[Failed.]";
			2:	"[Game successfully restored.]";
		}
		
	Save:
		switch(n)
		{
			1:	"[Failed.]";
			2:	"[Game successfully saved.]";
		}
		
	Verify:
		switch(n)
		{
			1:	"[Game correct.]";
			2:	"[Error!]";
		}

	ScriptOn:
		switch(n)
		{	
			1:	"[A transcript is already being written.]";
			2:	"[Here begins a transcript of interaction with ",
				(string) Story, ".]";
			3:	"[Attempt to begin transcript failed.]";
		}

	ScriptOff:
		switch(n)
		{
			1:	"[Transcripting is already off.]";
			2:	"[Here ends a transcript of interaction with ",
				(string) Story, ".]";
			3:	"[Attempt to end transcript failed.]";
		}
		
	NotifyOn:
		"[Score notification on.]";

	NotifyOff:
		"[Score notification off.]";

	Places:
		print "You have visited: ";

	Objects:
		switch(n)
		{
			1:	"Objects you have handled:^";
			2:	"None.";
			3:	print "   (worn)";
			4:	print "   (held)";
			5:	print "   (given away)";
			6:	print "   (in ", (name) x1, ")";
			7:	print "   (in ", (the) x1, ")";
			8:	print "   (inside ", (the) x1, ")";
			9:	print "   (on ", (the) x1, ")";
			10:	print "   (lost)";
		}
  
	Score:
		if (deadflag)
			print "In that game you scored ";
		else
			print "You have so far scored ";
		print score, " out of a possible ", MAX_SCORE,
			", in ", turns, " turn";
		if (turns~=1)
			print "s";
		return;

	FullScore:
		switch(n)
		{
			1:	if (deadflag)
					print "The score was ";
				else
					print "The score is ";
				"made up as follows:^";
			2:	"finding sundry items";
			3:	"visiting various places";
			4:	print "total (out of ", MAX_SCORE; ")";
		}

	Inv:
		switch(n)
		{
			1:	"You are empty-handed.";
			2:	print "You are carrying";
		}
		
	Take:
		switch(n)
		{
			1:	"You are now carrying ", (the) x1, ".";
			2:	"You probably know that you cannot take yourself already.";
			3:	"I don't suppose ", (the) x1, " would care for that.";
			4:	print "You'll have to get ";
				if (x1 has supporter)
					print "off ";
				else
					print "out of ";
				print_ret (the) x1, " first.";
			5:	"You already have ", (thatorthose) x1, ".";
			6:	if (noun has pluralname)
					print "Those seem ";
				else
					print "That seems ";
				"to belong to ", (the) x1, ".";
			7:	if (noun has pluralname)
					print "Those seem ";
				else
					print "That seems ";
				"to be a part of ", (the) x1, ".";
			8:	print_ret (Cthatorthose) x1, " ", (isorare) x1,
					"n't available.";
			9:	print_ret "Sorry, but ", (the) x1, " ", (isorare) x1, "n't open.";
			10, 11:	
				SurelyYouJest();
				rtrue;
			12:	"You're carrying too many things already.";
			13:	"(putting ", (the) x1, " into ", (the) SACK_OBJECT,
				" to make room)";
		}
		
	Drop:
		switch(n)
		{
			1:	"But ", (the) x1, " ", (isorare) x1, " already here.";
			2:	"You haven't got ", (thatorthose) x1, ".";
			3:	"(first taking ", (the) x1, " off)";
			4:	print "Ok, ", (the) x1, " ", (IsOrAre) x1, " now ";
				if (location == thedark)
					"somewhere in the darkness around you.";
				if (parent(x1) has supporter)
					"on ", (the) parent(x1), ".";
				if (parent(x1) has container)
					"in ", (the) parent(x1), ".";
				"on the floor.";
		}
  
	Remove:
		switch(n)
		{
			1:	if (x1 has pluralname)
					print "They are";
				else
					print "It is";
				" unfortunately closed.";
			2:	if (x1 has pluralname)
					print "But they aren't";
				else
					print "But it isn't";
				" there now.";
			3:	"Removed.";
		}

	PutOn:
		switch(n)
		{
			1:	"You need to be holding ", (the) x1,
				" before you can put ", (itorthem) x1,
				" on top of something else.";
			2:	"You can't put something on top of itself.";
			3:	"Putting things on ", (the) x1, " would achieve nothing.";
			4:	"You lack the dexterity.";
			5:	"(first taking ", (itorthem) x1, " off)^";
			6:	"There is no more room on ", (the) x1, ".";
			7:	"Done.";
			8:	"You put ", (the) x1, " on ", (the) second, ".";
		}

	Insert:
		switch(n)
		{
			1:	"You need to be holding ", (the) x1,
				" before you can put ", (itorthem) x1,
				" into something else.";
			2:	print_ret (Cthatorthose) x1, " can't contain things.";
			3:	print_ret (The) x1, " ", (isorare) x1, " closed.";
			4:	"You'll need to take ", (itorthem) x1, " off first.";
			5:	"You can't put something inside itself.";
			6:	"(first taking ", (itorthem) x1, " off)^";
			7:	"There is no more room in ", (the) x1, ".";
			8:	"Done.";
			9:	"You put ", (the) x1, " into ", (the) second, ".";
		}
	
	EmptyT:
		switch(n)
		{
			1:	print_ret (The) x1, " can't contain things.";
			2:	print_ret (The) x1, " ", (isorare) x1, " closed.";
			3:	print_ret (The) x1, " ", (isorare) x1, " empty already.";
			4: "That would scarcely empty anything.";
		}

	Give:
		switch(n)
		{
			1:	"You aren't holding ", (the) x1, ".";
			2:	"You juggle ", (the) x1, " for a while, but don't achieve much.";
			3:	print (The) x1;
				if (x1 has pluralname)
					print " refuse";
				else
					print " refuses";
				" your offer.";
		}

	Show:
		switch(n)
		{
			1:	"You aren't holding ", (the) x1, ".";
			2:	print_ret (The) x1, " ", (isorare) x1, " unimpressed.";
		}

	Enter:
		switch(n)
		{
			1:	print "But you're already ";
				if (x1 has supporter)
					print "on ";
				else
					print "in ";
				print_ret (the) x1, ".";

			2:	if (x1 has pluralname)
					print "They're";
				else
					print "That's";
				print " not something you can ";

				if (verb_word == 'stand')
					"stand on.";
				else if (verb_word == 'sit')
					"sit on.";
				else if (verb_word == 'lie')
					"lie on.";
				else "enter.";

			3:	"You can't get into the closed ", (name) x1, ".";
			4:	"You can only get into something freestanding.";
			5:	print "You get ";
				if (x1 has supporter)
					print "onto ";
				else
					print "into ";
				print_ret (the) x1, ".";
			6:	print "(getting ";
				if (x1 has supporter)
					print "off ";
				else
					print "out of ";
				print (the) x1; ")";
			7:	if (x1 has supporter)
					"(getting onto ", (the) x1, ")^";
				if (x1 has container)
					"(getting into ", (the) x1, ")^";
				"(entering ", (the) x1, ")^";
		}

	GetOff:
		"But you aren't on ", (the) x1, " right now.";
  
	Exit:
		switch(n)
		{
			1:	"But you aren't in anything at the moment.";
			2:	"You can't get out of the closed ", (name) x1, ".";
			3:	print "You get ";
				if (x1 has supporter)
					print "off ";
				else
					print "out of ";
				print_ret (the) x1, ".^";
		}
		
	VagueGo:
		"You'll have to say which compass direction to go in.";

	Go:
		switch(n)
		{
			1:	print "You'll have to get ";
				if (x1 has supporter)
					print "off ";
				else
					print "out of ";
				print_ret (the) x1, " first.";
			2:	"You can't go that way.";
			3:	"You are unable to climb ", (the) x1, ".";
			4:	"You are unable to descend by ", (the) x1, ".";
			5:	if (location == thedark)
					"You bump into something.";
				print_ret "You can't, since ", (the) x1, " ", (isorare) x1, " closed.";
			6:	print "You can't, since ", (the) x1;
				if (x1 has pluralname)
					" lead nowhere.";
				" leads nowhere.";
		}

	LMode1:
		" is now in its normal ~brief~ printing mode, which gives
		detailed descriptions of places never before visited and short
		descriptions otherwise.";

	LMode2:
		" is now in its ~verbose~ mode, which always gives detailed
		descriptions of locations (even if you've been there before).";
  
	LMode3:
		" is now in its ~superbrief~ mode, which always gives short
		descriptions of locations (even if you haven't been there before).";

	Look:
		switch(n)
		{
			1:	print " (on ", (the) x1, ")";
				rtrue;

			2:	print " (in ", (the) x1, ")";
				rtrue;

			3:	print " (as ";
				@print_obj x1;
				print ")";
				rtrue;

			4:	print "On ", (the) x1;
				WriteListFrom(child(x1),
					ENGLISH_BIT + RECURSE_BIT + PARTINV_BIT
					+ TERSE_BIT + ISARE_BIT + CONCEAL_BIT);
				".";

			default:
				if (x1 ~= location)
				{
					if (x1 has supporter)
						print "On ";
					else
						print "In ";
					print (the) x1, " you";
				}
				else
					print "You";

				print " can ";
				if (n == 5)
					print "also ";
				print "see ";

				WriteListFrom(child(x1),
					ENGLISH_BIT + WORKFLAG_BIT + RECURSE_BIT
					+ PARTINV_BIT + TERSE_BIT + CONCEAL_BIT);

				if (x1 ~= location)
					".";
				" here.";
		}

	Examine:
		switch(n)
		{
			1:	"You can't see anything while it is dark.";
			2:
				switch(random(2))
				{
					1:
						print "You ";
						print (string) random ("don't see anything", 
							"see nothing");

					2:
						print (string) random ("There isn't anything", 
							"There's nothing");
				}

				print " ";
				print (string) random ("special", "extraordinary", "unusual", 
					"interesting");
				print " about ", (the) x1, ".^";
				rtrue;

			3:
				print (The) x1, " ", (isorare) x1, " currently switched ";
				if (x1 has on)
					"on.";
				else
					"off.";
		}
  
	LookUnder:
		switch(n)
		{
			1:	"But it's dark.";
			2:	print "You find nothing but ";
				if (location ofclass Groundfloor or Firstfloor)
					print "dust";
				else
					print "dirt";
				" there.";
		}

	Search:
		switch(n)
		{
			1:	"But it's dark.";
			2:	"There is nothing on ", (the) x1, ".";
			3:	print "On ", (the) x1;
				WriteListFrom(child(x1),
					TERSE_BIT + ENGLISH_BIT + ISARE_BIT + CONCEAL_BIT);
				".";
			4:	"You find nothing unusual.";
			5:	"You can't see inside, since ", (the) x1, " ",
				(isorare) x1, " closed.";
			6:	print_ret (The) x1, " ", (isorare) x1, " empty.";
			7:	print "In ", (the) x1;
				WriteListFrom(child(x1),
					TERSE_BIT + ENGLISH_BIT + ISARE_BIT + CONCEAL_BIT);
				".";
		}

	Unlock:
		switch(n)
		{
			1:	if (x1 has pluralname)
					print "They don't ";
				else
					print "That doesn't ";
				"seem to be something you can unlock.";
			2:	print_ret (ctheyreorthats) x1, " unlocked at the moment.";
			3:	if (x1 has pluralname)
					print "Those don't ";
				else
					print "That doesn't ";
				"seem to fit the lock.";
			4:	"You unlock ", (the) x1, ".";
		}

	Lock:
  		switch(n)
		{
			1:	if (x1 has pluralname)
					print "They don't ";
				else
					print "That doesn't ";
				"seem to be something you can lock.";
			2:	print_ret (ctheyreorthats) x1, " locked at the moment.";
			3:	"First you'll have to close ", (the) x1, ".";
			4:	if (x1 has pluralname)
					print "Those don't ";
				else
					print "That doesn't ";
				"seem to fit the lock.";
			5:	"You lock ", (the) x1, ".";
		}

	SwitchOn:
		switch(n)
		{
			1:	print_ret (ctheyreorthats) x1, " not something you can switch.";
			2:	print_ret (ctheyreorthats) x1, " already on.";
			3:	"You switch ", (the) x1, " on.";
		}
  
	SwitchOff:
		switch(n)
		{
			1:	print_ret (ctheyreorthats) x1, " not something you can switch.";
			2:	print_ret (ctheyreorthats) x1, " already off.";
			3:	"You switch ", (the) x1, " off.";
		}

	Open:
		switch(n)
		{
			1:	"You must be very clever to do that to ", (the) x1, ".";
			2:	if (x1 has pluralname)
					print "They seem";
				else
					print "It seems";
				" to be locked.";
			3:	if(x1 has pluralname)
					print "They are";
				else
					print "It is";
				" already open.";
			4:	print "Opening ", (the) x1, " reveals ";
				if (WriteListFrom(child(x1), ENGLISH_BIT + TERSE_BIT + CONCEAL_BIT)==0)
					"nothing.";
				".";
			5:	if (x1 has door)
					print_ret "Ok, ", (the) x1, " ", (IsOrAre) x1, " now open.";
				"Opened.";
		}

	Close:
  		switch(n)
		{
			1:	"You must be very clever to do that to ", (the) x1, ".";
			2:	if(x1 has pluralname)
					print "They are";
				else
					print "It is";
				" already closed.";
			3:	if (x1 has door)
					print_ret "Ok, ", (the) x1, " ", (IsOrAre) x1, " now closed.";
				"Closed.";
		}
		
	Disrobe:
		switch(n)
		{
			1:	"You're not wearing ", (thatorthose) x1, ".";
			2:	"You take off ", (the) x1, ".";
		}

	Wear:
		switch(n)
		{
			1:	"You can't wear ", (thatorthose) x1, "!";
			2:	"You're not holding ", (thatorthose) x1, "!";
			3:	"You're already wearing ", (thatorthose) x1, "!";
			4:	"You put on ", (the) x1, ".";
		}

	Eat:
		switch(n)
		{
			1:
				print_ret (The) x1, " wouldn't agree with you.";
			2:
				"You eat ", (the) x1, ". Not too bad.";
		}

	Yes:
		"Did you say something?";

	No:
		<< Yes >>;

	Burn:
		"This dangerous act would achieve little.";
	
	Pray:
		"Prayers will never save your brother.";
	
	Wake:
		"No way.";

	WakeOther:
		"That seems unnecessary.";
	
	Kiss:
		"Section 204D, Paragraph 7.6 of the Connecticut Police Code of Conduct 
		specifically prohibits kissing suspects.";

	Think:
		"What a good idea.";

	Smell:
		if (x1 == 0)
			"You smell nothing unexpected.";

		if (x1 == player)
			"You smell just like you always did.";

		if (x1 has animate)
			"That seems rather rude, doesn't it?";
			
		if (x1 has pluralname)
			print "They smell";
		else
			print "It smells";
		" just like ", (a) x1, ".";

	Listen:
		"You hear nothing unexpected.";

	Taste:
		if (x1 has animate)
			"What (ahem!) strange idea!";
		"That's ridiculous!";

	Touch:
		switch(n)
		{
			1:	"Keep your hands to yourself!";
			2:	"You feel nothing unexpected.";
			3:	"If you think that'll help.";
		}

	Dig:
		"Digging would achieve nothing here.";

	Cut:
		"Cutting ", (thatorthose) x1, " up would achieve little.";
	
	Jump:
		"Wheeeeee!";
	
	JumpOver, Tie:
		"You would achieve nothing by this.";

	Drink:
		"There's nothing suitable to drink here.";

	Fill:
		"But there's no water here to carry.";
	
	Sorry:	
		"Yes, and you should feel sorry!";
	
	Strong:
		"One must try to avoid locker-room talk while working.";

	Mild:
		"You ought to be ashamed of yourself.";
		
	Attack:
		"Vandalism is not the answer! Think of your position. How would it look for a famous police 
		inspector to be arrested?";

	Swim:
		"Swimming isn't possible on the grounds.";
		
	Swing:
		"There's nothing sensible to swing here.";

	Blow:
		"You can't usefully blow ", (thatorthose) x1, ".";

	Rub:
		"You achieve nothing by this.";

	Set:
		"No, you can't set ", (thatorthose) x1, ".";

	SetTo:
		"No, you can't set ", (thatorthose) x1, " to anything.";

	WaveHands:
		"You wave, feeling foolish.";

	Wave:
		switch(n)
		{
			1:	"But you aren't holding ", (thatorthose) x1, ".";
			2:	"You look ridiculous waving ", (the) x1, ".";
		}

	Pull, Push, Turn:
		switch(n)
		{
			1:	if (x1 has pluralname)
					print "Those are ";
				else
					print "It is ";
				"fixed in place.";
			2:	"You are unable to.";
			3:	"Nothing happens.";
			4:	"That would be less than courteous.";
		}

	PushDir:
		switch(n)
		{
			1:	"Is that the best you can think of?";
			2:	"That's not a direction.";
			3:	"Not that way you can't.";
		}

	Squeeze:
		switch(n)
		{
			1:	"It's unclear how ", (name) x1, " would take this, so you defer until after hours.";
			2:	"How singularly useless.";
		}

	ThrowAt:
		switch(n)
		{
			1:	"Futile.";
			2:	"You lack the nerve when it comes to the crucial moment.";
		}

	Tell:
		switch(n)
		{
			1:	"You talk to yourself a while.";
			2:	"This provokes no reaction.";
		}

	Answer, Ask:
		"There is no reply.";

	Buy:
		"Nothing is on sale.";

	Sing:
		"Your singing is abominable.";

	Climb:
		"You can't go that way.";

	Wait:
		"Time passes.";

	Sleep:
		"You feel like you're asleep already.";

	Consult:
		"You discover nothing of interest in ", (the) x1, ".";
];
!------------------------------------------------------------------------------

