Room Docking_port "Docking Port"
  with description
    "   This is the huge docking port of the space station. Only one ship 
     is here at the moment, a one-man scooter, so the docking port seems
     unusually empty. A tube leads down toward the heart of the station.",
    d_to  Hall_m,
    in_to Hatch,
    enter Hatch;

Object Hatch "hatch"
  with  
    name "door" "hatch" "scooter" "scooter^s" "ship" "metre" "square"
         "steel" "bulkhead" "bulk",
    before
    [;Examine: print "The scooter's metre square steel hatch which governs 
                      life and death (in space, anyway) is currently ";
               if (hatch has open) "open.";
               else "closed.";
      Open: if ((hatch hasnt open) && (Player in Couch))
              "You can't reach the scooter's hatch from here.";
            if (landtime ~= 20000) 
              "You can't open the scooter's hatch in deep space!";
      Close: if ((hatch has open) && (Player in Couch))
              "You can't reach the scooter's hatch from here.";           
      Exit: if (Player in Docking_port) 
              "You're not in ", (the) Scooter, ".";
    ],
    door_to
    [;if (Location==Scooter) return Docking_port; return Scooter; ],
    door_dir
    [;if (Location==Docking_port) return in_to; return out_to; ],
    found_in Scooter Docking_port,
    has scenery door openable open;

Room Scooter "Scooter"
  with
    name "space" "scooter",
    description
    [;if (landtime == 20000)
        print "   You are in the cramped one-man Class Eight Space Scooter, 
               with a couch for the pilot. 
               Through the viewport, you see the docking port of the 
               Space Station BG-12. Below the viewport is a slot. ";
      else
      {
        print "   You are in the cramped one-man Class Eight Space Scooter,
               with a couch for the pilot. 
               Through the viewport, you see a rapidly approaching Space
               Station. Below the viewport is a slot. ";
      }

      print "The scooter's metre square steel hatch which governs life 
             and death (in space, anyway) is currently ";
      if (hatch has open) "open.";
      else "closed.";
    ],
    out_to Hatch,
    cant_go "This is only a small one-man scooter: better go 'out'.",
    has enterable;

Object -> ScooterSlot "slot"
  with
    name "slot" "auto" "pilot" "autopilot",
    description
      "It looks like it can receive a form of some kind, to activate the
       scooter.",
    before
    [; receive: 
       if (noun == SpaceForm) 
       {
         if (Player notin Couch)
           "The form is spit back out. You hear a recorded voice. ~Safety 
            precautions forbid the activation of the vehicle when the pilot's 
            couch is not occupied.~";
         
         remove SpaceForm;
         launchtime = spacetime + 29;

         "The form is swallowed up, followed by a long pause for 
          triple-redundancy processing. You hear a recorded voice 
          ~Spacecraft activated. Course preset. Launch in 30 
          millichrons.~"; 
       }

       if (noun has worn)
         "You'll have to remove ", (the) noun, " first.";

       if ((noun has big) || (noun has huge))
         "Unsurprisingly ", (the) noun, " doesn't fit in ", 
          (the) ScooterSlot, ".";

       "", (The) slot, " swallows up ", (the) noun, " and then spits it
        back.";
    ],
    has scenery;   

Object -> Couch "pilot's couch"
  with
    name "pilot" "pilot^s" "pilots" "couch" "seat" "chair"
         "pilot-couch" "pilot^s-couch" "pilots-couch"
         "pilot-seat" "pilot^s-seat" "pilots-seat",
    description "It protects the pilot against the effects of acceleration.",
    before
    [; Exit: if (Player notin Couch) "You're not in ", (the) Couch, "."; ],
    has scenery supporter enterable open;      

Object Viewport "viewport"
  with
    name "viewport" "observation" "window" 
         "ultra" "toughened" "ultra-toughened" "perspex",
    description 
    [; "", (The) Viewport, " is made of ultra-toughened perspex."; ],
    before
    [;Search: 
      if (Location==Scooter)
      {
        if (landtime == 20000)
          "Through the viewport, you see the docking port of Space Station
           BG-12."; 
        "Through the viewport, you see a rapidly approaching Space Station.
         It consists of a large metallic ring, slowly rotating. In the center
         is what appears to be a docking port. This is not rotating, 
         presumably to allow for easy landing (well in fact it is rotating
         but at exactly the same speed as the space station in the opposite
         direction, thus appearing to be motionless). The docking port is
         connected to the main station by a long metallic tube. You can also
         make out some thrusters on the outer hull that are occasionally 
         needed to maintain the stations rotation or manoeuvre it away from 
         space debris. As there is effectively no air in space there is no 
         resistance to slow the station down, so it can rotate for long 
         periods without using its thrusters.";
      }
      "It appears to be one of those fancy viewports which you can only
       see out of, not in.";
      Break: "Even if you had the strength to do that, that would mean
              opening the scooter up to the vacuum of space. That doesn't
              seem like such a good idea.";    
      BreakWith: "That would mean opening the scooter up to the vacuum of
                  space. That doesn't seem like such a good idea.";    
      ThrownAt:
      if (noun has worn)
        "You will have to remove ", (the) noun, " first.";
      move noun to Scooter;
      if ((noun has big) || (noun has huge)) 
        "Luckily ", (the) Viewport, " is made of ultra-toughened perspex, 
         so ", (the) noun, " has no effect and drops uselessly on the deck.";
      "", (The) noun, " is too small to have any effect, bounces off ",
       (the) Viewport, " and drops uselessly on the deck.";
    ],
    found_in Scooter Docking_Port,
    has scenery; 
