/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import org.zmpp.base.MemoryReadAccess;
import org.zmpp.encoding.ZCharDecoder;
import org.zmpp.encoding.ZsciiString;
import org.zmpp.vm.Dictionary;
import org.zmpp.vm.DictionarySizes;

public abstract class AbstractDictionary
implements Dictionary {
    private MemoryReadAccess memaccess;
    private int address;
    private ZCharDecoder decoder;
    private DictionarySizes sizes;

    public AbstractDictionary(MemoryReadAccess memoryReadAccess, int n, ZCharDecoder zCharDecoder, DictionarySizes dictionarySizes) {
        this.memaccess = memoryReadAccess;
        this.address = n;
        this.decoder = zCharDecoder;
        this.sizes = dictionarySizes;
    }

    public int getNumberOfSeparators() {
        return this.memaccess.readUnsignedByte(this.address);
    }

    public byte getSeparator(int n) {
        return (byte)this.memaccess.readUnsignedByte(this.address + n + 1);
    }

    public int getEntryLength() {
        return this.memaccess.readUnsignedByte(this.address + this.getNumberOfSeparators() + 1);
    }

    public int getNumberOfEntries() {
        return this.memaccess.readShort(this.address + this.getNumberOfSeparators() + 2);
    }

    public int getEntryAddress(int n) {
        int n2 = this.getNumberOfSeparators() + 4;
        return this.address + n2 + n * this.getEntryLength();
    }

    protected ZCharDecoder getDecoder() {
        return this.decoder;
    }

    protected MemoryReadAccess getMemoryAccess() {
        return this.memaccess;
    }

    protected DictionarySizes getSizes() {
        return this.sizes;
    }

    protected ZsciiString truncateToken(ZsciiString zsciiString) {
        if (zsciiString.length() > this.sizes.getMaxEntryChars()) {
            return zsciiString.substring(0, this.sizes.getMaxEntryChars());
        }
        return zsciiString;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = this.getNumberOfEntries();
        do {
            int n3 = this.getEntryAddress(n);
            String string = this.getDecoder().decode2Zscii(this.getMemoryAccess(), n3, this.sizes.getNumEntryBytes()).toString();
            stringBuilder.append(String.format("[%4d] '%-9s' ", n + 1, string));
            if (++n % 4 != 0) continue;
            stringBuilder.append("\n");
        } while (n != n2);
        return stringBuilder.toString();
    }
}

