
Global wastehall = 0; ! Set in end_scene if the player wasted a blip in the hall
Global wasteroom = 0; ! Ditto, in a room. (Both count number of wasted blips.)
Global wasteentry = 0; ! Set 1 at entry if scrambler is active.

Object sc_5
  class Scene,
  with
	number 5,
	init_scene [;
		SetQuestion(q5_1);
	],
	begin_scene [ rock;
		wastehall = 0;
		wasteroom = 0;
		wasteentry = 0;
		give SecurityOffice ~general;
		OfficeSketchStartup();
		move poisonpen to storetable;
		move pennib to poisonpen;
		securityscanners.startup();
		switch (rock) {
			1: ! first time in
				move activeplayer to SecurityAnnex; 
				give SecurityBranch ~visited; ! in case we saw it in scene 3
				if (scrambler has general)
					wasteentry = 1;
				SaveToolPositions();
			2, -1, -2: ! all subsequent times (including boom/splat)
				move activeplayer to SecurityAnnex; 
				RestoreToolPositions();
				if (scrambler has general) {
					print "The scrambler shouldn't be on -- this scene will be
						unsolvable. [BUG]^";
				}
		}
	],
	end_scene [ rock subrock;
		securityscanners.shutdown();
		switch (rock) {
			-1:
				SetAcidQuestions(subrock);
			-2:
				SetBlastQuestions(subrock);
			-3: ! security door open
				"The door opens, only it's ajar. Ha! Ha! Ha! [BUG]";
			-4: ! pen suicide
				if (q5_dp1 hasnt general) {
					give q5_dp1 general;
					SetQuestion(q5_dp1);
				}
				else {
					SetQuestion(q5_dp1r);
				}
			1: ! walked over threshold without horking.
				if (q5_d1 hasnt general) {
					give q5_d1 general;
					SetQuestion(q5_d1, subrock);
				}
				else {
					SetQuestion(q5_d1r, subrock);
				}
			2: ! horker on too long.
				if (q5_d2 hasnt general) {
					give q5_d2 general;
					SetQuestion(q5_d2);
				}
				else {
					SetQuestion(q5_d2r);
				}
			3: ! not exactly 4 blips
				if (q5_d3 hasnt general) {
					give q5_d3 general;
					SetQuestion(q5_d3, subrock);
				}
				else {
					SetQuestion(q5_d3r, subrock);
				}
			4: ! entered zero or one rooms
				SetQuestion(q5_d4, subrock);
			5: ! left with scrambler on
				SetQuestion(q5_d5);
			6: ! seen in interrog room
				if (q5_d6 hasnt general) {
					give q5_d6 general;
					SetQuestion(q5_d6);
				}
				else if (q5_d6r hasnt general) {
					give q5_d6r general;
					SetQuestion(q5_d6r);
				}
				else {
					SetQuestion(q5_d6rr);
				}
			7: ! left pen behind
				if (q5_d7 hasnt general) {
					give q5_d7 general;
					move poisonpen_model to Himself;
					SetQuestion(q5_d7, subrock);
				}
				else {
					SetQuestion(q5_d7r, subrock);
				}
			8: ! left tools behind
				SetQuestion(q5_d8, subrock);
			9: ! diddled reamer controls
				SetQuestion(q5_d9);
			20: ! success
				SetScene(sc_6);
		}
	];

! Emotional status to date: (absolute strained maximums)
! Minimum: 7 helpful, 5 cosmos, nothing else.
! Maximum: 4 blatant lies, 4 sneaky lies, 9 stubborns, 6 angries, 4 stupid,
!   6 jingos, 3 dumb recall.
! (That's not counting acid/blast queries, which are 1 sneaky, 3 blatant,
! 3 stubborn, 1 angry; or 1 helpful.)
! In startup: +3 stupids, +1 cosmos, +1 jingos, +2 stubborns, +1 blatant.

Object q5_1
  class Question,
  with
	query [;
		print "^~";
		if (q4_db1 hasnt general) {
			print "You could have used the blast tab, did you realize? 
				It would have punched through the door, I'm sure. You would
				have been in and out.";
		}
		else {
			print "And you didn't use the blast tab. Just walked away.";
		}
		print " By that much you missed starting a war. Or ending the one
			we've got.~^^The man stops, gives you a measured glance.
			~This is a war, for all that we're not shooting.~^";
		rtrue;
	],
	time_limit 4,
	answer_yes [;
		num_cosmos++;
		if (num_cosmos > num_jingos)
			print "A wry chuckle. ~Truly, you";
		else
			print "~Now you've surprised me. You";
		print " think more like me than my own by-commander does. 
			I think: if this is peace, why are the armies
			getting larger?";
		SetQuestion(q5_2);
	],
	answer_no [;
		num_stupids++;
		if (num_cosmos > num_jingos)
			print "~You don't think?";
		else
			print "~No, you wouldn't think.";
		print " But if this is peace, why are the armies
			getting larger?";
		SetQuestion(q5_2);
	],
	answer_wait [;
		print "~Consider: if this is peace, why are the armies
			getting larger?";
		SetQuestion(q5_2);
	];

Object q5_2
  class Question,
  with
	query " And even more money on secrets than on simple guns.~",
	time_limit 6,
	answer_yes [;
		num_stupids++;
		print "A one-sided smile. ~I'll make a note of that, for
			our estimates of your budget schedules.~^^He passes that
			off with a tense wave.";
		SetQuestion(q5_3);
	],
	answer_no [;
		num_stupids++;
		self.answer_yes();
	],
	answer_wait [;
		num_stubborns++;
		print "After a moment, he grants you an open palm, 
			and a flash of a smile. 
			~Ever on guard -- even with your side's budget schedules.~^^He
			passes that off with a tense wave.";
		SetQuestion(q5_3);
	];

Object q5_3
  class Question,
  with
	query [;
		print " ~It's frustrating.";
		if (q4_3.number2 == 'yes')
			print " You've thought about this technology.";
		else
			print " You say you haven't thought about this technology.";
		print " It could put our footprints on the moons. We could walk
			to other stars as easily as to the bathhouse. Oceans and mountains
			wouldn't be walls...~ Again he is watching you intently.^^~That,
			I think, is what our masters are afraid of. They'll face death
			before living without walls. You, is that why you're here? Why
			you're willing to unchain a war of assassination?~^";
		rtrue;
	],
	time_limit 3,
	answer_yes [;
		num_jingos++;
		print "~But why... no. Business first.";
		SetQuestion(q5_4);
	],
	answer_no [;
		print "~Then why... no. Business first.";
		SetQuestion(q5_4);
	],
	answer_wait [;
		num_stupids++;
		print "~Your hesitation, I think, I fear more than...
			no. Business first.";
		SetQuestion(q5_4);
	];

Object q5_4
  class Question,
  with
	query "~ He takes a breath, and calms.^^
		~You left the lab without using your explosive. You came back
		to Security. To get your precious lockpick, for the lab door?~ 
		The silver rod flashes between his fingers; you had forgotten
		he was holding it.",
	time_limit 3,
	answer_yes [;
		print "~But for other reasons as well, I think. Show me.~^";
		BeginScene(1);
	],
	answer_no [;
		num_blatant_lies++;
		print "~Perhaps other reasons as well, but I think the pick must
			have been first in your mind. Show me.~^";
		BeginScene(1);
	],
	answer_wait [;
		num_stubborns++;
		print "~Perhaps other reasons as well, but I think the pick must
			have been first in your mind. Show me.~^";
		BeginScene(1);
	];

Object q5_d1
  class Question,
  with
	query [;
		if (self.variant == 2)
			print "^~It would take an impressive level of incompetence to
				disable a scan-web when entering a room, and then fail
				to deal with it effectively when walking out.";
		else
			print "^~An amateur, I think, could have walked through a doorway
				without ever seeing the scan-web above it.";
		if (num_stupids + 2*num_dumb_recall >= 4)
			print " You haven't impressed me thus far, but
				I don't truly think you're incompetent.";
		else
			print " And you've demonstrated that you're not an
				amateur.";
		print "~^";
		num_dumb_recall++;
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q5_d1r
  class Question,
  with
	query [;
		if (self.variant == 2)
			print "^~You didn't set off the alarm going in, and you weren't
				found inside, so you must have suppressed the scan-web coming
				out as well. Yes?~ He does not wait for a reply.^";
		else
			print "^He looks irritable. ~No, no scan-web alarms. Not then,
				not at all.~^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q5_d2
  class Question,
  with
	query [;
		print "^~Yes, the wonderful scan-scrambler. But";
		if (q2_d3 has general)
			print ", as I said earlier,";
		print " it cannot be miraculous. The high-sensitivity webs
			around Security could be fooled; but the scrambler's presence
			would leave eddies. Glitches, you understand. More than a few
			of those in a handful of seconds, and the watchdogs get
			suspicious. As you showed me -- the alarms would ring.~
			He raises an eyebrow. ~";
		if (wasteentry == 0)
			print "Please, again, and using the magic less clumsily.";
		else
			print "In fact, you couldn't have made it up the corridor
				with the scrambler active. Let's just take it as read that
				it wasn't.";
		print "~^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q5_d2r
  class Question,
  with
	query [;
		print "^~We went back, you must know, and looked at every stray
			spark in the scan-data. We know how you used the scrambler.
			On and off, briefly enough to never upset our systems. And it
			did ", (emphstring) "not", " get you caught.~^";
		BeginScene(2);
	];

Object q5_d3
  class Question,
  with
	query [;
		! we know numblips isn't zero, because the player got the pen.
		print "^~Mm,~ the man says slowly. ~This grows complex.";
		if (q2_d3 has general || q5_d2 has general)
			print " As I said before,";
		else
			print " You must see,";
		print " your scrambler leaves traces -- submerged in the scan
			noise if you use it briefly, as you have been doing, but
			traces nonetheless. We have since analyzed every sequence of the
			scan-web data. The results are quite precise; you used the
			scrambler four times. Four blips, on and off, you understand.";
		print " So your story, in which you used it";
		if (self.variant < 4)
			print " only ", (EnglishNumber) self.variant;
		else 
			print " ", (EnglishNumber) self.variant;
		print " times, is not possible.";
		if (wastehall || wasteroom) {
			print " Besides, I doubt you would have used the device
				unnecessarily. Standing around flipping it on and off,
				or dashing through a room for a cursory glance, would
				not be worth the risk to you.";
		}
		print "~^^He shrugs. ~We can play guessing-games all afternoon;
			but matters would go faster if you stuck to the facts.~^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q5_d3r
  class Question,
  with
	query [;
		print "^~I described the situation, did I not? The data shows that
			you used your scrambler precisely four times, not ",
			(EnglishNumber) self.variant, ".";
		if (wastehall || wasteroom) {
			print " And I do not think you wasted any of those uses.";
		}
		print "~^";
		BeginScene(2);
	];

[ dullroomname obj;
	switch (obj) {
		SecurityOffice: print "my office";
		SecurityStorage: print "the storage room";
		InterrogRoomReal: print "this one room";
		default: print "Poughkeepsie [BUG]";
	}
];

Object q5_d4
  class Question,
  with
	query [;
		! so, not all of this code really gets used (must be storage room)
		print "^~Ah. We know that you used your scrambler four times.";
		if (self.variant == nothing) {
			print " But that hardly aids your cause if you merely
				stood in the hallway while doing it.";
		}
		else {
			print " But it would be a waste to visit only ",
				(dullroomname) self.variant, " in that process. And
				you do not seem to be the sort who wastes resources.";
		}
		print "~^";
		BeginScene(2);
	];

Object q5_d5
  class Question,
  with
	query [;
		print "^~I'm afraid we would have picked up the glitches from
			extensive scrambler use,
			even down the hall from the Security web.~^";
		BeginScene(2);
	];	

Object q5_d6
  class Question,
  with
	query [;
		print "^~And away you went.~ The man hesitates, and continues. 
			~That was unnerving, you in this room. ";
		if (interrealchair.number >= 6 || interrealchair.number < 0) {
			print " And when you sat down, the... shadows...
				I've not seen that before. ";
			if (interrealchair.number < 0) {
				print "If I hadn't gotten the resonance damped, matters
					might have been very bad.~ He does not say for whom,
					you notice. ~";
			}
		}
		print "Was that a true memory? The readings were odd, but that might
			have been the emotional loading of the chair, the controls -- were
			you truly in here?~^";		
		rtrue;
	],
	time_limit 4,
	answer_general [;
		print " But why?~ The man frowns, distant. 
			~Nothing in here
			you could want; the lockpick was in storage, and my office
			must have been--~ His gaze falls again on you, locked in
			your chair. ~There's nothing in here but... unless you...~
			He is scowling now, and he stares at you.^^And then he
			leaps to his feet, looks more closely. ~You ", 
			(emphstring) "expected", "...!~ For an instant he seems about
			to move towards you, and then he seizes himself, and hurls
			himself back on his controls. Fingers flying in sequence,
			and he pays you no attention at all.^";
		BrainDrain();
	],
	answer_yes [;
		print "~You were, then.";
		self.answer_general();
		rtrue;
	],
	answer_no [;
		num_helpfuls++;
		print "~Mmm.~ He examines his controls again. ~I shall assume that's
			the truth. Interesting. Well, we must try again, then.~^";
		BeginScene(2);
	],
	answer_wait [;
		print "~Stubborn stone";
		if (num_helpfuls >= 4)
			print ".~ But he says it without much rancor.";
		else
			print ",~ he grimaces.";
		print "^^He examines his controls again. ~Well, I'll assume the readings
			were transient. We should try it again.~^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q5_d6r
  class Question,
  with
	query [;
		print "^~The same strange readings, I'm afraid. I don't believe you
			came in this room at all. This is, after all, the one memory you
			could certainly fake; you're here ", (emphstring) "now.", 
			" But the stresses give you away.~ He considers for a moment,
			nods absently, and reaches for his controls.^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q5_d6rr
  class Question,
  with
	query [;
		print "^~I am beginning to think you did enter this room, after
			all.";
		q5_d6.answer_general();
		rtrue;
	],
  has ~general; ! general means it's been asked

Object q5_d7
  class Question,
  with
	query [;
		print "^~Are you saying you left";
		if (self.variant == 1)
			print " without this";
		else
			print " with this damaged";
		print "?~ The man produces a pen";
		if (SecurityStorage has visited)
			print ", the one you saw in the storage room,";
		print " and holds it up for your inspection.^";
		rtrue;
	],
	time_limit 7,
	answer_yes [;
		num_blatant_lies++;
		print "~Ah? There's one guard who can testify otherwise -- or will
			be able to soon, I should say.~^";
		BeginScene(2);
	],
	answer_no [;
		print "~That's better. One of my people is still recovering from
			its effect.~^";
		BeginScene(2);
	],
	answer_wait [;
		print "The man turns the pen reflectively. ~Well, and I hope not. 
			There's one guard who can testify otherwise -- or will
			be able to soon, I should say.~^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q5_d7r
  class Question,
  with
	query [;
		print "^~No, you've forgotten the pen again.";
		if (self.variant == 1)
			print " You had it with you";
		else
			print " The crystal was intact when you left";
		print ", as we discovered shortly thereafter.~^";
		BeginScene(2);
	];

Object q5_d8
  class Question,
  with
	query [;
		print "^~Now, I know you're not that careless.";
		if (self.variant == 1)
			print " We didn't find anything";
		else
			print " We didn't find ", (the) self.variant, " or anything else";
		print " left behind";
		print ". It's a small matter but I can't let it slip.~^";
		BeginScene(2);
	];

Object q5_d9
  class Question,
  with
	query [;
		print "^~You certainly know better to play with controls that
			you could only mishandle. And ", (emphstring) "I", " certainly
			didn't find this board gooflocked when we began this session.~^";
		BeginScene(2);
	];

Object q5_dp1
  class Question,
  with
	query "^~And there we found you, lying helpless, several hours later.~
		He shakes his head. ~Not a very exciting ending to your tale. 
		I found the truth of it much more dramatic.~",
	time_limit 4,
	answer_yes [;
		print "~Then let's have it.~^";
		BeginScene(2);
	],
	answer_no [;
		print "~You disagree? Well, perhaps anticlimatic from your
			perspective. Certainly an escape would have been much more
			satisfying. But anything has to be better than a paralyzed
			coma.~^";
		BeginScene(2);
	],
	answer_wait [;
		num_stubborns++;
		print "~Ah, not responsive even as an art critic? Ah well.~^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q5_dp1r
  class Question,
  with
	query [;
		print "^~Now, you know you kept that clever device, and used it
			much more effectively than that.~^";
		BeginScene(2);
	];

Object q5_da1
  class Question,
  with
	query [;
		print "^~Impressive, but hardly realistic. I just came from my office,
			and it's quite as tidy as it should be.~^";
		BeginScene(2);
	];

Object q5_da2
  class Question,
  with
	query [;
		print "^~Nicely put,~ he nods, ~but not exactly factual.~ He nods
			towards the door, across the hall, although neither of you
			can see directly. ~No damage visible.~^";
		BeginScene(2);
	];

Object q5_da3
  class Question,
  with
	query [;
		print "^~You may wish, of course.~ The man smiles appreciatively. 
			~But the walls are sound, the chair is whole, and you are in
			it. Your tale cannot change that.~ He reaches for his
			controls.^";
		BeginScene(2);
	];

! ------------- The scene in security

Object SecurityAnnex "Security Annex"
  with
	description "This is the end of a short hallway, which runs southwest
		back to the main corridor. Three large doorways open to the
		north, east, and south.",
	before [   ptr wt;
		if (wasteentry) {
			wasteentry++;
			if (wasteentry >= 3) {
				! disconnect the damn thing
				ptr = scrambler.&data_cache;
				wt = ptr-->1; ! work_target
				ptr-->1 = 0; ! work_target
				ptr-->2 = 0; ! general set false
				if (wt == nothing) {
					print "Scrambler mysteriously active. [BUG]^";
				}
				else {
					ptr = wt.&data_cache;
					ptr-->1 = 0; ! work_target
					ptr-->0 = toolcase; ! location
				}
				! and end scene
				print "Before you can move, a
					buzzer begins sounding up and down the halls.
					Moments later, you hear guards running in your
					direction.^";
				EndScene(2);
				rtrue;
			}
		}
	],
	sw_to [;
		if (escaping) {
			return SecurityBranch;
		}
		PlayerTo(SecurityBranch, 2);
		TryLeaveSecurity();
		rtrue;
	],
	e_to secdooreast,
	n_to secdoornorth,
	s_to secdoorsouth;

[ ScramblerPos    pos;
	pos = locationof(scrambler);
	if (pos == SecurityAnnex)
		return 1;
	if (pos == SecurityOffice)
		return 2;
	if (pos == SecurityStorage)
		return 2;
	if (pos == InterrogRoomReal)
		return 2;
	return 0;
];

Class SecurityDoorway
  with
	name 'large' 'door' 'doorway' 'doorways' 'room',
	door_try [;
		if (escaping) {
			if (self.door_dir == n_to && HimselfEscape has general)
				rfalse;
			print "As you enter the room, a buzzer sounds briefly once.^";
			SummonEsguardsSecurity();
			rfalse;
		}
		! else scene 5
		if (scrambler has general && scrambler.fried == 0 && ScramblerPos()) {
			rfalse;
		}
		else {
			securityscanners.number = 1;
			print "As you step into the room, a buzzer begins to sound.^";
			rfalse;
		}
	],
	description [;
		self.number2();
		"^You can barely see a band of scan-web over the doorway, just
			inside the room.";
	],
	before [;
		Search: <<Examine self>>;
	],
  has door open scenery;

Class SecurityDoorwayIn
  with
	name 'door' 'doorway' 'hall' 'hallway' 'corridor',
	short_name "doorway",
	description "The white hallway waits outside. You can see a band of
		scan-web running above the doorway.",
	door_to SecurityAnnex, ! well, they all do
	door_try [;
		if (escaping) {
			if (self.door_dir == s_to) {
				if (HimselfEscape has general) {
					if (self hasnt general)
						print "You step gingerly under the scan-web band. Silence.
							You recall, with some relief, that the man failed to
							turn it back on after the guard left.^";
					give self general;
				}
				else {
					print "You roll past the man's reach and dive towards the
						door. Over your shoulder you see him start after you,
						and then swerve and reach for his desk.^^A buzzer sounds
						sharply as you dash into the hall.^"; 
					SummonEsguardsSecurity();
				}
				rfalse;
			}
			else {
				print "As you leave the room, a buzzer sounds briefly once.^";
				SummonEsguardsSecurity();
				rfalse;
			}
		}
		! else scene 5
		if (scrambler has general && scrambler.fried == 0 && ScramblerPos() == 1) {
			rfalse;
		}
		else {
			securityscanners.number = 2;
			print "As you leave the room, a buzzer begins to sound.^";
			rfalse;
		}
	],
	before [;
		Search: <<Examine self>>;
	],
  has door open scenery;

Class SecurityRoomsJunk
  with
	number2 "whatever [BUG]",
	short_name [;
		print "things in the room to the ", (string) self.number2;
		rtrue;
	],
	before [;
		default: 
			print_ret "That's inside the room to the ", (string) self.number2, ".";
	],
  has scenery pluralname;

Object -> secnodoor "southwest passage"
  with
	name 'sw' 'southwest' 'passage' 'hall' 'hallway' 'corridor',
	description "The hall just runs southwest to the intersection.",
	before [;
		Examine:
			rfalse;
		Search:
			<<Examine self>>;
		Enter:
			<<Go sw_obj>>;
		default:
			"That's off to the southwest.";
	],
  has scenery;

Object -> secdooreast "east doorway"
  class SecurityDoorway,
  with
	name 'e//' 'east' 'eastern',
	number2 "The room to the east is unexpectedly luxurious, with a
		dark wooden desk and rich panelling. It seems to be occupied mostly
		by cabinets.",
	door_to SecurityOffice,
	door_dir e_to;

Object -> eastroomjunk
  class SecurityRoomsJunk,
  with
	name 'desk' 'cabinet' 'cabinets',
	number2 "east";

Object -> secdoornorth "north doorway"
  class SecurityDoorway,
  with
	name 'n//' 'north' 'northern',
	number2 [;
		print "The room to the north is walled in bare metal.";
		if (interrealchair in InterrogRoomReal)
			" A squat metal chair and a control-covered console face
				each other; there is nothing beside.";
		else
			" A control-covered console faces the spot where your chair
				squatted.";
	],
	door_to InterrogRoomReal,
	door_dir n_to;

Object -> northroomjunk
  class SecurityRoomsJunk,
  with
	name 'metal' 'chair' 'control' 'controls' 'console',
	number2 "north";

Object -> secdoorsouth "south doorway"
  class SecurityDoorway,
  with
	name 's//' 'south' 'southern',
	number2 "The room to the south is filled with lockers; there
		is a table at the far end.",
	door_to SecurityStorage,
	door_dir s_to;

Object -> southroomjunk
  class SecurityRoomsJunk,
  with
	name 'locker' 'lockers' 'table',
	number2 "south";

Object -> secdoorbands "bands of body-scan web"
  with
	name 'band' 'bands' 'body' 'glitter' 'body-scan' 'scan' 'web' 'scan-web' 'webbing',
	description "Just inside each of the three doorways, on the ceilings
		of the three rooms, 
		you see a glittering band of scan-web. The web's
		narrow spacing indicates a tight scan -- capable of picking up
		resonance signals off even a naked human body.",
	before [;
		Examine:
			rfalse;
		default:
			"The bands are inside the rooms.";
	],
  has scenery pluralname;

! remember this can be seen (briefly) from scene 3 and 5. But you can 
! only *be* here when escaping.
Object SecurityBranch "Angle Branch"
  with
	description [;
		print "The corridor runs north and south, like every other
			hallway in this place. A short hallway branches off to the
			northeast. To the west is a blank metal door, with attendant
			black plate beside it.";
		new_line;
		if (powercut) {
			print "^You can see brighter lights shining in the security annex
				to the northeast; there is a murmur of voices as well.^";
		}
		rtrue;
	],
	w_to secbranchdoor,
	ne_to SecurityAnnex,
	n_to NortheastCorner, 
	s_to TossJunction;

Object -> secbranchdoor "metal door"
  class InteriorDoor,
  with
	name 'w//' 'west' 'western' 'blank',
	door_dir w_to,
	before [;
		ActivateTool:
			if (location == SecurityBranch) {
				deadflag = 3;
				"^The door snaps open, and you find yourself staring at an
					armed guard. He seems to recognize you; at least, he
					loses no time into bringing up his pulse gun.";
			}
			if (location == NortheastCorner or TossJunction or SecurityAnnex) {
				deadflag = 3;
				print "^The door in the middle of the corridor, to the";
				switch (location) {
					NortheastCorner: print " south";
					TossJunction: print " north";
					SecurityAnnex: print " southwest";
				}
				", snaps open. A startled-looking guard leans out. He's
					not startled enough to hesitate before he begins firing
					at you.";
			}
			remove lockpick; ! a guard grabs it
			SummonEsguardsSecurity(1);
			rtrue;
	];

Object -> secbranchdoorplate
  class InteriorPlate,
  with
	work_target secbranchdoor;

Object securityceiling "ceiling"
  with
	name 'ceiling' 'roof' 'acoustic' 'acoustical' 'insulation',
	found_in SecurityOffice InterrogRoomReal SecurityStorage,
	description "The ceiling is a solid sheet of acoustical insulation. Light
			comes from glowing discs, deeply inset behind wire grilles.
			A band of scan-web runs along the ceiling in front of the
			doorway.",
	react_before [;
		Examine: 
			rfalse;
		Jump:
			if (player in officedesk)
				"You bend and leap, and your head thumps solidly into the
					ceiling.";
			if (player in interrealchair)
				"You can't do that sitting down.";
			"You bend and leap. Your fingers brush the ceiling, but
				not strongly enough to do anything.";
		default:
			if (noun == securitylights or securitylightgrilles) {
				if (player notin officedesk)
					"The ceiling is a foot out of your reach.";
			}
	],
	before [;
		if (action == ##Examine)
			rfalse;
		if (player notin officedesk)
			"The ceiling is a foot out of your reach.";
		switch (action) {
			##Push:
				"The ceiling insulation is layered over something unyielding.";
			##Touch, ##Rub:
				"The ceiling is rough and slightly soft.";
			##Attack, ##KnockOn:
				"The ceiling absorbs your blow in silence.";
		}
	],
  has scenery transparent;

Object -> securityweb "body-scan web"
  with
	name 'band' 'body' 'glitter' 'body-scan' 'scan' 'web' 'scan-web' 'webbing',
	description "A band of scan-web runs along the ceiling in front of the
		doorway. The web's
		narrow spacing indicates a tight scan, capable of picking up
		resonance signals off even a naked human body.",
	before [;
		Examine:
			rfalse;
		default:
			if (player in officedesk)
				"The scan-web only covers the area just inside the door.
					You can't reach it from the desk.";
			"The ceiling is a foot out of your reach.";
	],
  has scenery;

Object -> securitylights "glowing discs"
  with
	name 'illuminated' 'glowing' 'discs' 'disc' 'disks' 'disk' 
		'lights' 'plastic',
	description "The room is illuminated by discs of glowing plastic,
		recessed in the ceiling and covered by wire grilles.",
	before [;
		Examine:
			rfalse;
		default:
			"The glowing discs are shielded behind wire grilles.";
	],
  has scenery pluralname;

Object -> securitylightgrilles "wire grilles"
  with
	name 'wire' 'grille' 'grilles' 'grills' 'mesh' 'meshes',
	description "Heavy wire meshes protect the lights.",
	before [;
		Take, Push, Pull, Turn, Open, Attack:
			"The wire resists your efforts.";
	],
  has scenery pluralname;

Object SecurityOffice "Security Office"
  with
	description [ ix;
		print "Dark wood panelling surrounds you, a refuge from
			the harsh white visible to the west.
			A massive mahogany desk sits in one
			corner. The rest of the room is mostly metal cabinets, but";
		ix = OfficeSketchNumHanging();
		if (ix) {
			switch (ix) {
				1: print " a sketch takes its";
				2: print " two sketches take their";
				default: print " a few sketches take their";
			}
			print " share of wall, and";
		}
		print " a bookcase stands by the desk.";
		new_line;
		ix = OfficeSketchNumLying();
		if (ix) {
			switch (ix) {
				1: print "^A ", (name) (sketchlist-->0), " is lying on the
					floor.^";
				2: print "^Two sketches, a ", (name) (sketchlist-->0),
					" and a ", (name) (sketchlist-->1), ", are lying on the
					floor.^";
				3: print "^Three sketches -- a ", (name) (sketchlist-->0),
					", a ", (name) (sketchlist-->1),
					", and a ", (name) (sketchlist-->2), " -- are lying on the
					floor.^";
			}
		}
		rtrue;
	],
	out_to secofficedoorway,
	w_to secofficedoorway,
	before [;
		Look, Go, Enter, Exit, VagueGo, Wait, Inv:
			rfalse;
		Tango, Waltz, VagueSay, Answer:
			rfalse;
		ActivateTool, DeactivateTool:
			! fake actions
			rfalse;
		Examine, Search:
			if (noun && anywherein(noun, player)) {
				rfalse;
			}
			give self general;
			rfalse;
		default:
			give self general;
			rfalse;
	],
  has ~general; ! general means you actually did something

Object -> secofficedoorway
  class SecurityDoorwayIn,
  with
	name 'w//' 'west' 'western',
	door_dir w_to;

Object -> secofficewalls "panelled walls"
  with
	name 'dark' 'wood' 'wooden' 'panel' 'panelling' 'wall' 'walls',
	description "Some rich wood, in pleasingly irregular spans, polished
		but naturally dark.",
	before [;
		Touch, Rub:
			"Your fingers glide over the wood.";
		Attack, KnockOn:
			"You pound the wood. The sound is muffled almost to silence;
				insulation must lie under the beautiful grain.";
		Listen:
			"A heavy silence lies behind the wood -- high quality soundproofing,
				at least.";
		Take, Push, Pull:
			"No span of the panelling seems likely to move.";
		Search:
			"You can't see any unusual cracks or spaces in the panelling.
				But then, it would be unusual if you could.";
		Smell, Taste:
			"The faint herbal flavor of some polishing compound drifts from
				the wood.";
	],
  has scenery pluralname;

Object -> officecabinets "cabinets"
  with
	name 'metal' 'cabinet' 'cabinets' 'drawer' 'drawers',
	description [;
		print "Three-drawer metal cabinets stand in rows along each wall.
			The drawers are the normal size for file folders; there is a tiny
			black plate on the front of each one.";
		if (self has open)
			" One drawer stands open.";
		else
			" The cabinets are all closed.";
	],
	before [;
		Open:
			"You pull on a few of the handles, but all the drawers seem to
				be locked.";
		Close:
			if (self hasnt open)
				"All the drawers are already closed.";
		Push, Pull, Turn:
			"The cabinets are too heavy to move.";
		Receive, Empty, EmptyT, Search:
			if (self hasnt open)
				"All the drawers are closed.";
	],
  has scenery pluralname ~open;

Object -> officecabinetplates "tiny black plate"
  class InteriorPlate,
  with
	name 'tiny' 'black' 'rectangle' 'plate' 'plates',
	short_name "tiny black plate",
	work_target officecabinets,
	description "Each cabinet drawer has a tiny, rectangular black plate
		embedded in its front.",
	before [;
		Take: 
			"The plates are fixed in the drawers.";
	],
  has ~pluralname;

Object -> officedesk "desk"
  with
	name 'massive' 'mahogany' 'desk',
	description [;
		print "The desk is an imposing mass, plain of line but precisely
			crafted. ";
		<<Search self>>;
	],
	vehicle_name " (standing on the desk)",
	react_before [;
		Exit:
			if (player in self) {
				move player to parent(self);
				if (keep_silent == 0)
					print "You get down off ", (the) self, ".^";
				rtrue;
			}
		Go:
			if (player in self && noun == d_obj)
				<<Exit>>;
	],
	before [;
		Push, Pull, Turn:
			print_ret "The desk is ", (emphstring) "much", " too heavy
				to move.";
		LookUnder:
			"You peer hopefully under the desk, but even there the floor
				is relentlessly tidy.";
		Climb:
			<<Enter self>>;
	],
  has scenery supporter enterable;

Object -> officebookcase "bookcase"
  with
	name 'bookcase' 'case' 'bookshelf' 'bookshelves' 'shelf' 'shelves',
	description "The bookcase is hand-carved, hung with wooden ivy vines and
		tiny berries. Volumes of technology journals fill some shelves;
		but others display antique folios, leather-bound collections of
		plays, and a small array of dawn-tales and fireside stories.",
	before [;
		Search:
			if (children(self) <= 1)
				"You find nothing but books on the shelves.";
			print "Amid the books, you see ";
			WriteListFrom(child(self),
				TERSE_BIT + ENGLISH_BIT + PARTINV_BIT + CONCEAL_BIT);
			".";
		Receive:
			if (receive_action == ##Insert)
				<<PutOn noun self>>;
		Touch, Rub:
			"You feel intricately carved wood.";
		Push, Pull, Turn:
			"The bookcase is too heavy to move.";
	],
  has scenery supporter;

Object officebooks "books" officebookcase
  with
	name 'book' 'books' 'volume' 'volumes' 'tales' 'stories' 'tale' 'story'
		'dawn-tale' 'dawn' 'fireside' 'antique' 'folio' 'folios'
		'journal' 'journals' 'tech' 'technology',
	description "You see the complete works of Gahtmahan, ~Nightclumps and
		Wind-Whispers,~ a volume of Connaeus woodcuts... if you had time,
		the shelves would be worth a closer look. You don't.",
	before [;
		Examine:
			if (verb_word == 'read')
				"You don't have time to browse.";
		Take:
			"The books are unlikely to help with what you need to do.";
		Push, Pull:
			"No, none of the books is a trigger for a secret door. You're just a
				little disappointed.";
		Search:
			<<Search officebookcase>>;
	],
  has pluralname scenery;

Object officeplays "plays" SecurityOffice
  with
	name 'leather-bound' 'collection' 'play' 'plays',
	description [;
		<Examine officebooks>;
		if (self hasnt general) {
			give self general;
			"^(I hope you weren't expecting some kind of ~Rito and Imita~
				in-joke.)";
		}
		rtrue;
	],
	before [;
		Take, Search, Push, Pull:
			<<(action) officebooks>>;
	],
  has pluralname scenery; ! general for the in-joke in-joke

Class OfficeSketch
  with
	name 'sketch' 'sketches' 'drawing' 'drawings' 'picture' 'pictures',
	describe [;
		if (self has static)
			rtrue;
		if (self in SecurityOffice)
			rtrue;
	],
	list_together "sketches",
	description [;
		self.number2();
		if (self hasnt static) {
			print "^The drawing has been removed from the wall, revealing
				a magnetic mounting pad on the back.^";
		}
		rtrue;
	],
	add_to_scope [;
		if (self hasnt static) {
			AddToScope(sketchpad);
		}
	],
	number2 "The sketch reads, ~This space intentionally left Zarf.~ [BUG]",
	before [;
		Take:
			if (self has static) {
				give self ~static;
				give self general;	
			}
			else {
				give self ~general;
			}
			rfalse;
		PutOn:
			if (second == secofficewalls) {
				if (self has static)
					print_ret (The) self, " is already on the wall.";
				if (self notin player)
					rfalse;
				move self to SecurityOffice;
				give self static;
				print_ret "You press ", (the) self, " against the wall, 
					where it clings.";
			}
		TouchTo:
			if (second == secofficewalls) {
				<<PutOn self second>>;
			}
	],
	after [;
		Take:
			if (self has general) {
				give self ~general;
				print_ret "You pull ", (the) self, " from the wall.";
			}
	],
  has static; ! general is used for the take message.

[ OfficeSketchStartup    ix;
	objectloop (ix ofclass OfficeSketch) {
		give ix static;
		move ix to SecurityOffice;
	}
];

[ OfficeSketchNumHanging    res;
	res = (sketch1 has static) + (sketch2 has static) + (sketch3 has static);
	return res;
];

Array sketchlist --> 5;

[ OfficeSketchNumLying   res;
	res = 0;
	if (sketch1 hasnt static && sketch1 in SecurityOffice) 
		sketchlist-->(res++) = sketch1;
	if (sketch2 hasnt static && sketch2 in SecurityOffice) 
		sketchlist-->(res++) = sketch2;
	if (sketch3 hasnt static && sketch3 in SecurityOffice) 
		sketchlist-->(res++) = sketch3;
	return res;
];

Object sketch1 "seascape"
  class OfficeSketch,
  with
	name 'sea' 'ocean' 'seascape' 'scape' 'escape' 'raft' 'sail',
	number2 "Grey waves beat below an indeterminate, cloudy sky. Nearly lost
		in the distance is a raft -- a tiny shape bearing away beneath a
		wind-torn white sail.";

Object sketch2 "drawing of a night sky"
  class OfficeSketch,
  with
	name 'night' 'sky' 'moon' 'moons' 'star' 'stars',
	number2 "The sketch is in soft talc-pencil, but nonetheless the stars
		shine out, hard distant facets in a jewel-black expanse. One moon is
		high and one is rising; they too are in bright focus, every crater
		and mare. The cool burning moons'-light tints the sky silver
		from behind.";

Object sketch3 "portrait of a young man"
  class OfficeSketch,
  with
	name 'portrait' 'young' 'man' 'eyes' 'face',
	number2 [;
		print "A young man looks out from precise ink stippling. His
			expression is serious, and dark eyes meet yours with near-visible
			force.";
		if (escaping == 0)
			print " You have never seen his face before.";
		else
			print " You recognize his face now; you have seen it, older
				but no less serious, across his desk this long day. His eyes
				have not changed at all.";
		new_line;
		rtrue;
	];

Object sketchpad "magnetic pad"
  with
	name 'magnetic' 'mounting' 'pad',
	description "A magnetic pad is visible on the back of the
		sketch. It's nothing unusual; it just keeps the thing on the
		wall where it belongs.",
	before [;
		Take, Pull:
			"That's part of the sketch.";
		TouchTo:
			if (second == secofficewalls) {
				<<PutOn self second>>;
			}
	],
  has scenery;

Object InterrogRoomReal "Interrogation Chamber",
  with
	description [;
		print "You are in a dim room, bounded by metal walls.";
		if (interrealchair in self)
			print " A steel chair squats on a low pedestal;";
		else
			print " A scarred pedestal stands empty where the chair was;";
		print " facing it is an instrument-covered desk.
			Otherwise the room is sterile. The bright hallway waits to the
			south.";
		new_line;
		rtrue;
	],
	out_to introomdoorway,
	s_to introomdoorway,
	each_turn [;
		if ((~~escaping) && self hasnt general) {
			give self general;
			print_ret "^", (emphstring) "You feel a chill of memory in your
				bones.";
		}
	],
  has ~general; ! general for each_turn message

Object -> introomdoorway
  class SecurityDoorwayIn,
  with
	name 's//' 'south' 'southern',
	door_dir s_to;

Object -> interrealwalls "walls"
  with
	name 'metal' 'wall' 'walls',
	description "The walls are naked metal, unadorned. They give your eyes nowhere
		to rest.",
	before [;
		Touch, Rub, Push, Attack, KnockOn:
			"The walls are immovable.";
	],
  has scenery pluralname;

Object -> interrealdesk "desk"
  with
	name 'desk',
	description [;
		print "The desk is a standard modular composite design.
			The surface is panelled with ranks of controls and instruments.";
		if (child(self)) {
			print " ";
			<<Search self>>;
		}
		new_line;
		rtrue;
	],
	before [;
		Examine, Search:
			rfalse;
		Climb, Enter:
			"You can't climb on the desk without slamming into dozens of
				controls that you have no idea what they do.";
		LookUnder:
			"Nothing but white tile.";
		default:
			if (player in interrealchair)
				"You can't reach the desk from the chair.";
	],
  has supporter scenery;

Object -> interrealcontrols "instruments"
  with
	name 'control' 'controls' 'instrument' 'readout' 'readouts' 'label'
		'labels' 'screen' 'screens' 'panel' 'panels' 'rank' 'ranks',
	description "The desk is covered with dials, readouts, screen panels,
		sliders, and dozens of other instruments. You can put no form
		nor name to any of them.",
	before [;
		Examine:
			if (verb_word == 'read')
				<<Search self>>;
		Search:
			if (player in interrealchair)
				"You can't see the desk clearly from the chair.";
			print "There are a few labels scattered among the controls, and
				they seem to have a biological bent: ~Neurotrans.~, ~Hippocamp.~,
				~EKG~, ~Amygdala~. But the whole leaves you as uncertain as
				the parts.^";
			if ((~~escaping) && self hasnt general) {
				give self general;
				print "^", (emphstring) "You feel another distant chill.", "^";
			}
			rtrue;
		SwitchOn, SwitchOff, Push, Pull, Turn:
			<<Touch self>>;
		Touch:
			if (player in interrealchair)
				"You can't reach the desk from the chair.";
			if (escaping)
				"The controls are dark now, and inert.";
			print "You flip a few controls around. The displays change in
				arbitrary ways -- involving an increasing amount of
				red.^";
			EndScene(9);
			rtrue;
		Take:
			"Those are part of the desk.";
	],
  has pluralname scenery ~general; ! general for Search extra message.

Object -> interrealpedestal "low pedestal"
  with
	name 'low' 'pedestal' 'base' 'column',
	description "It's just a blank, acid-scarred disk of metal. The
		voice module seems to be embedded in the surface.",
	before [ fn;
		Examine:
			if (~~escaping) {
				if (self hasnt general) {
					give self general;
					fn = emphstring;
				}
				else {
					fn = normstring;
				}
				fn("The pedestal under the chair isn't important.");
				new_line;
				rtrue;
			}
		Search:
			<<Examine self>>;
	],
  has scenery; ! general means italic warning

! the chair will be gone when escaping starts, so we don't need to
! check escaping in here.
Object -> interrealchair "chair"
  with
	name 'metal' 'steel' 'slat' 'slats' 'chair' 'heavy' 'frame',
	description "The chair is ugly. Steel slats are riveted to a heavy
		metal frame, and the whole rests on a steel column rising from
		a pedestal on the floor. Restraints are welded to the arm and
		foot rests; wires hang limply from the head support.",
	vehicle_name " (in the chair)",
	vehicle_status_name ", in the chair",
	react_before [ ix;
		Exit:
			if (player in self) {
				move player to parent(self);
				switch (self.number) {
					0, -1:
						print "You stand up.^";
					1, 2:
						print "You hurriedly stand up.^";
					default:
						print "You jerk out of the chair, stumbling as you
							pull against restraints that are not there.";
						if (self.number >= 6)
							print "^^The half-visible figure is gone.";
						new_line;
				}
				rtrue;
			}
		Listen:
			if (player in self && self.number >= 6) {
				if (second == nothing) {
					return RunRoutines(ghostman, before); ! icky
				}
			}
		Yes, No:
			if (player in self && self.number >= 6) {
				<<Answer self ghostman>>;
			}
		Wait:
			if (player in self && self.number >= 6) {
				"You remain silent.";
			}
		VagueSay:
			if (player in self && self.number >= 6) {
				! allow keywords to fall through so that a device can react_before
				if (consult_words >= 1) {
					wn = consult_from;
					ix = NextWord();
					if (ix == '~//' && consult_words >= 2) {
						ix = NextWord();
					}
					if (ix == 'tango') {
						rfalse;
					}
					if (ix == 'waltz') {
						rfalse;
					}
				}
				<<Answer noun ghostman>>;
			}
		Wake, Sleep:
			if (player in self && self.number > 0) {
				"You are not certain how.";
			}
	],
	before [;
		LookUnder:
			<<Examine interrealpedestal>>;
		Touch, Rub:
			"The metal is cool and clean.";
		Push, Pull, Turn:
			"The chair does not move on its base.";
	],
	after [;
		Enter:
			! reset ghost counter, unless it's over.
			if (self.number > 0)
				self.number = 0; 
			"You sit down in the chair. It is not comfortable.";
	],
	number 0,
	add_to_scope [;
		if (player in self && self.number >= 6)
			AddToScope(ghostman);
	],
	each_turn [;
		if (player in self) {
			if (self.number < 0)
				return;
			self.number++;
			switch (self.number) {
				1: print "^", (emphstring) "You feel another distant chill.", "^";
				3: print "^", (emphstring) "There is a half-remembered cool
					pressure around your wrists, your ankles, your forehead.", "^";
				6: print "^", (emphstring) "For a moment, someone is visible,
					facing you across the desk.", "^";
				8: print "^", (emphstring) "The human outline bends over the desk,
					then regards you again. A sense of wordless sound moves
					across you.", "^";
				10:
					print "^", (emphstring) "The half-visible figure frowns and
						does something to its controls--", "^^The chill is gone.
						You are alone in the room.^";
					self.number = -1;
			}
		}
	],
  has scenery enterable supporter;

Object -> interrealbands "restraints"
  with
	name 'restraint' 'restraints' 'band' 'bands' 'cuff' 'cuffs' 'strap' 'straps'
		'arm' 'foot' 'wrist' 'wrists' 'ankle' 'ankles' 'rest' 'rests',
	description [;
		if (player in interrealchair && interrealchair.number >= 3)
			"You stare at the metal bands, until you are certain they are not
				fastened around your limbs.";
		"The heft of the bands leaves nothing to chance.";
	],
	before [;
		Take:
			"They're fixed in place.";
		Touch, Rub:
			"The metal is cool and clean.";
		Attack:
			"The metal restraints are much stronger than you.";
		Wear, Enter:
			"You don't want to.";
		TouchTo:
			if (second == player)
				<<Wear self>>;
	],
  has scenery pluralname;

Object -> interrealleads "leads"
  with
	name 'lead' 'leads' 'wire' 'wires' 'sensor' 'contact' 'contacts',
	description "Leads hang from the headrest. There is a sensor contact
		on the end of each one.",
	before [;
		Take:
			"They're attached to the chair.";
		Attack, Pull:
			"The wires won't break.";
		Wear:
			"You don't want to.";
		TouchTo:
			if (second == player)
				<<Wear self>>;
		TouchFrom:
			if (noun == player)
				<<Wear self>>;
	],
  has scenery pluralname;

Object ghostman "human figure"
  with
	name 'man' 'interrogator' 'human' 'figure' 'outline' 'half' 'visible'
		'half-visible',
	description [;
		print "The figure is nearly not there -- like
			shadows at the edge of your sight, or a dream of blindness.
			It crawls away from your vision; your eyes feel thick and
			strained.^";
	],
	before [;
		Examine:
			rfalse;
		Listen:
			"You can almost hear words, but they too drift on the edge
				of understanding.";
		Ask, Tell:
			"Your words do not reach the figure.";
		ThrownAt:
			"You feel that would be futile.";
		default:
			"You cannot move to reach the figure.";
	],
	life [;
		Ask, Tell, Answer:
			"Your words do not reach the figure.";
	],
	orders [;
		"Your words do not reach the figure.";
	],
  has scenery animate;

Object SecurityStorage "Security Storage Room",
  with
	description [;
		print "This narrow room is lined with steel lockers. There is a
			plain table at the south end, and the doorway to the north exits
			to the corridor.";
		if (storelockers hasnt open)
			" All the lockers are closed.";
		else
			" One of the lockers is open.";
	],
	out_to secstoredoorway,
	n_to secstoredoorway;

Object -> secstoredoorway
  class SecurityDoorwayIn,
  with
	name 'n//' 'north' 'northern',
	door_dir n_to;

Object -> storelockers "lockers"
  with
	name 'steel' 'locker' 'lockers' 'closet' 'cubby' 'cubbies' 'doors',
	description [;
		print "The locker doors vary in size, from palm-length cubbies to a
			closet apparently large enough to walk into.";
		if (self hasnt open)
			" All the doors are closed. Each locker has
				a four-digit number on it.";
		else 
			print_ret " One medium-sized locker, number ", self.number, 
				" stands open.";
	],
	number 0,
	before [;
		Open:
			"The lockers do not have handles.";
		Close:
			if (self hasnt open)
				"All the lockers are already closed.";
		Receive, Empty, EmptyT, Search, Enter:
			if (self hasnt open)
				"All the lockers are closed.";
		Attack, KnockOn:
			"You thump a locker door. It sounds quite sturdy.";
	],
  has scenery pluralname;

Object -> storelockernumbers "locker numbers"
  with
	name 'number' 'numbers' 'digit' 'digits',
	description [;
		print_ret "You look at a random locker. The number ",
			1000 + random(8999), " is visible on it.";
	],
	before [;
		Take:
			"The numbers are printed on the locker doors.";
	],
  has scenery pluralname;

Object -> storetable "table"
  with
	name 'plain' 'table' 'worktable' 'slab',
	description [;
		print "It's just a plastic worktable, a slab built onto the south wall. ";
		<<Search self>>;
	],
	before [;
		Enter, Climb:
			"The table doesn't look strong enough to support your weight.";
		Push, Pull, Turn:
			"The table is a slab extending from the south wall. It can't
				be moved.";
		LookUnder:
			"Nothing but white tile.";
	],
  has scenery supporter;

Object poisonpen "pen"
  with
	name 'pen',
	description [;
		print "It's an ordinary-looking pen";
		if (pennib in self)
			print ". The nib looks a bit sharp, though";
		else
			print ". The nib is missing";
		if (penstain in self) 
			print "; there is a dark stain on the tip";
		".";
	],
	before [;
		TouchTo:
			if (pennib in self)
				<<ActivateTool pennib second>>;
		WriteWith:
			if (pennib in self)
				<<ActivateTool pennib second>>;
			if (second == labconoval)
				<<BaseTouchTo self second>>;
			"With its nib broken, the pen isn't going to write much.";
	],
  has transparent;

Object pennib "nib"
  with
	name 'nib' 'pen-nib' 'indigo' 'sliver' 'crystal' 'needle',
	description "The pen's nib isn't a normal ball tip. It seems to be a
		sliver of some indigo crystal -- a needle-sharp sliver.",
	react_before [;
		AttackWith:
			if (second == self or poisonpen) {
				<<ActivateTool self noun>>;
			}
	],
	before [;
		ActivateTool:
			if (self notin poisonpen)
				"Mightier than the sword, my butt. [BUG]";
			if (poisonpen notin player)
				"You can't do that if you're not holding the pen.";
			if (second == self or poisonpen)
				"The pen isn't flexible, you understand.";
			if (second == player)
				<<Touch self>>;
			if (second == loneguard) {
				remove self;
				move penstain to poisonpen;
				<<ActivateTool loneguard>>;
			}
			remove self;
			print_ret "The sliver of crystal breaks off against ",
				(the) second, " and is lost.";
		TouchTo:
			<<ActivateTool self second>>;
		Attack, Push, Pull:
			remove self;
			"You press your fingernail against the sliver of crystal, which
				snaps away instantly and is lost.";
		Touch:
			print "The indigo needle slices through your skin as if
				through water. The prick is trivial; but then icy cold
				races up your nerves, followed by numbness, and
				the world folds away into chill dark.^";
			remove self;
			EndScene(-4);
			rtrue;
		Taste:
			print "The sliver of crystal dissolves instantly on your tongue,
				without flavor. Then a wash of icy numbness runs down your throat,
				and up over your eyes, and
				the world folds away into chill dark.^";
			remove self;
			EndScene(-4);
			rtrue;
	],
  has scenery;

Object penstain "bloodstain"
  with
	name 'blood' 'stain' 'bloodstain',
	description "There is a small dark stain of blood on the pen's tip.",
	before [;
		Take, Rub:
			remove self;
			"You scrub at the stain until it's gone.";
	],
  has scenery;

Constant MAX_BLIPS 8;
Array blipfrom --> 9; ! MAX_BLIPS+1
Array blipto   --> 9; ! MAX_BLIPS+1

#ifdef ZDEBUG;

[ DebugBlip    ix;
	print "There are ", securityscanners.blips, " blips.^";
	for (ix = 0 : ix < securityscanners.blips && ix < MAX_BLIPS : ix++) {
		print ix, ": ", (name) blipfrom-->ix, " to ", 
			(name) blipto-->ix, "^";
	}
	if (blipfrom-->MAX_BLIPS ~= -7 || blipto-->MAX_BLIPS ~= -7)
		print "Array bounds damaged! (", (blipfrom-->MAX_BLIPS), ", ",
			(blipto-->MAX_BLIPS), ")^";
];

#endif;

Object securityscanners
  with
	startup [;
		self.number = 0;
		self.scramble_counter = 0;
		self.blips = 0;
		blipfrom-->MAX_BLIPS = -7;
		blipto-->MAX_BLIPS = -7;
		StartDaemon(self);
		StartDaemon(securityfriers);
	],
	shutdown [;
		StopDaemon(self);
		StopDaemon(securityfriers);
	],
	daemon_priority -20, ! very low; occurs after tools.
	number 0, ! set to nonzero to trigger a threshold alarm.
	scramble_counter 0,
	blips 0,
	daemon [;
		if (player == passiveplayer) {
			self.shutdown();
			"All the alarms go off at once, including the grandfather
				clock. [BUG]";
		}
		! the scrambler has just fried, then the timer has ticked, now this.
		switch (self.number) {
			1:
				print "^The harsh buzz continues. Within
					moments you also hear footsteps hurrying towards you.^";
				EndScene(1, 1);
				return;
			2:
				print "^The harsh buzz continues. Within
					moments you also hear footsteps hurrying towards you.^";
				EndScene(1, 2);
				return;
		}
		if (scrambler has general && scrambler.fried == 0) {
			if (self.scramble_counter == 0) {
				! just switched on
				if (self.blips < MAX_BLIPS) {
					blipfrom-->(self.blips) = location;
				}
			}
			else {
				! continuing on
			}
			
			self.scramble_counter++;
			if (self.scramble_counter == 1
				&& scrambler.work_target == timerswitch) {
				! no advantage if the thing turns itself off!
				self.scramble_counter++; 
			}
			if (self.scramble_counter >= 3) {
				print "^A buzzer begins sounding up and down the halls.
					Moments later, you hear guards running in your
					direction.^";
				EndScene(2);
				return;
			}
		}
		else {
			! the scrambler is off.
			if (self.scramble_counter) {
				self.scramble_counter = 0;
				if (self.blips < MAX_BLIPS) {
					blipto-->(self.blips) = location;
				}
				self.blips++;
			}
		}
	];

Object securityfriers
  with
	daemon_priority -2, ! before tools
	daemon [;
		if (scrambler has general && scrambler.fried == 0) {
			if (ScramblerPos() == 2) {
				scrambler.fried = true;
				print "^A moment after you step into the room, the
					scrambler emits a sharp squeal. Then a sharper
					crackling noise -- and then a thread of smoke,
					as its quiet vibration ceases.^";
			}
		}
	];
	
[ TryLeaveSecurity    num ix didoffice didstore didinter;
	
	wastehall = 0;
	wasteroom = 0;
	
	if (scrambler.fried)
		print "Fried equipment on the loose! [BUG]^";

	if (scrambler has general) {
		EndScene(5);
		return;
	}
	
	if (anywherein(poisonpen, player) == 0) {
		EndScene(7, 1);
		return;
	}
	if (pennib notin poisonpen) {
		EndScene(7, 2);
		return;
	}
	
	num = securityscanners.blips;
	
	didoffice = 0;
	didstore = 0;
	didinter = 0;
	
	for (ix=0 : ix<num && ix<MAX_BLIPS : ix++) {

		switch (blipfrom-->ix) {
			SecurityOffice: didoffice = 1;
			SecurityStorage: didstore = 1;
			InterrogRoomReal: didinter = 1;
		}
		switch (blipto-->ix) {
			SecurityOffice: didoffice = 1;
			SecurityStorage: didstore = 1;
			InterrogRoomReal: didinter = 1;
		}
		
		if (blipto-->ix == blipfrom-->ix) {
			if (blipto-->ix == SecurityAnnex)
				wastehall++;
			else
				wasteroom++;
		}
		else {
			if (blipto-->ix ~= SecurityAnnex && blipfrom-->ix ~= SecurityAnnex)
				"Wow, you can run fast. [BUG]";
		}
	}
	
	if (num ~= 4) {
		EndScene(3, num);
		return;
	}
	
	if (didoffice + didstore + didinter >= 3) {
		"How did you get into all three? [BUG]";
	}
	
	if (didoffice + didstore + didinter <= 1) {
		ix = 0;
		if (didoffice) ix = SecurityOffice;
		if (didstore) ix = SecurityStorage;
		if (didinter) ix = InterrogRoomReal;
		EndScene(4, ix);
		return;
	}
	
	if (didinter) {
		EndScene(6);
		return;
	}
	
	ix = LeftToolsBehind(5);
	if (ix) {
		EndScene(8, ix);
		rtrue;
	}

	! So now we know there were 4 blips, two rooms entered, and not the interrog
	! room. That's all we need, right?
	
	EndScene(20);
	rtrue;
];

