#! perl -w

use strict;
my @scores = ();
my @abbrev = ();

while (<>) {
    chomp;
    if (/^Selection\s*(\d+):.*scoring\s*(\d+)/) {
	push @scores, [$1-1, $2+0];
    }
    elsif (/^Abbreviate/) {
	push @abbrev, $_;
    }
}

for my $ix (sort { $b->[1] <=> $a->[1] } @scores) {
    last if ($ix->[1] < 250);
    print $abbrev[$ix->[0]] . "! @{$ix}\n";
}
