!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.04.05 ORKeyboardPrimitive	[Z, GLULX]
! A modified keyboard primitive that allows other modules to specify routines to replace
! the normal keyboard input routines.  Additionally, in Z-Code, modules can respond
! to the timer or terminating Zcharacter events.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
!
! To add this module to your library, add the line:
!
!		#include "ORKeyboardPrimitive";					!Constant USE_ORKeyboardPrimitive; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORKeyboardPrimitive; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.02.10	Initial Creation
! 2002.02.26	Fit to new framework
! 2002.02.28	Modified for GLULX compiling.
! 2002.04.03	Added ability to usurp the normal keyboard input routines. This ability
!				is available for both GLULX and Z-Code.
!--------------------------------------------------------------------------------------
#ifdef USE_ORKeyboardPrimitive;
		message "          Processing library extension ORKeyboardPrimitive...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORKeyboardPrimitive_DONEREPLACE; constant ORKeyboardPrimitive_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------
	replace KeyboardPrimitive;
!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORKeyboardPrimitive_DONEMESSAGE; constant ORKeyboardPrimitive_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORKeyboardPrimitive requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORKeyboardPrimitive_DONECODE;constant ORKeyboardPrimitive_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
		ORRoutinesList ORKBInstead;
		[__insteadfunc a_buffer a_table rv;
			rv=ORKBInstead.run_until(true,a_buffer, a_table);
			return rv;
		];

#ifndef TARGET_GLULX;
		ORRoutinesList ORKBTimer;
		[__timerfunc;
			ORKBTimer.run_accumulate();
			return false;
		];
		ORRoutinesList ORKBFilter;
		[__filterfunc t rv;
			rv=ORKBFilter.run_accumulate(t);
			if(rv>0) rtrue; rfalse;
		];

		[KeyboardPrimitive a_buffer a_table t;
			a_buffer->1=0;
			a_table->1=0;
			if(__insteadfunc(a_buffer, a_table)==true) {
				if(a_buffer->1==0) 
					rfalse; !--rfalse: no text in the buffer to process
				else
					rtrue; !--rtrue
			}
		.orkbprim_input;
			@aread a_buffer a_table 1 __timerfunc -> t;
			if(__filterfunc(t)==true){ !--redraw what is in input buffer
				print "^";
				L__M(##Prompt);
				for(t=2:t<(a_buffer->1)+2:t++) print (char)a_buffer->t;
				jump orkbprim_input;
			}
		];
	#ifnot;
		[ KeyboardPrimitive  a_buffer a_table done ix;
			a_buffer->1=0;
			a_table->1=0;
			if(__insteadfunc(a_buffer, a_table)==true) {
				if(a_buffer->1==0) 
					rfalse; !--rfalse: no text in the buffer to process
				else
					rtrue; !--rtrue
			}
		#IFDEF DEBUG;
			if (gg_commandstr ~= 0 && gg_command_reading ~= false) {
			! get_line_stream
			done = glk($0091, gg_commandstr, a_buffer+WORDSIZE,
			(INPUT_BUFFER_LEN-WORDSIZE)-1);
			if (done == 0) {
			glk($0044, gg_commandstr, 0); ! stream_close
			gg_commandstr = 0;
			gg_command_reading = false;
			print "[Command replay complete.]^";
			! fall through to normal user input.
			}
			else {
			! Trim the trailing newline
			if ((a_buffer+WORDSIZE)->(done-1) == 10)
				done = done-1;
			a_buffer-->0 = done;
			glk($0086, 8); ! set input style
			glk($0084, a_buffer+WORDSIZE, done); ! put_buffer
			glk($0086, 0); ! set normal style
			print "^";
			jump KPContinue;
			}
		}
		#ENDIF;
		done = false;
		glk($00D0, gg_mainwin, a_buffer+WORDSIZE, INPUT_BUFFER_LEN-WORDSIZE, 
			0); ! request_line_event
		while (~~done) {
			glk($00C0, gg_event); ! select
			switch (gg_event-->0) {
			5: ! evtype_Arrange
				DrawStatusLine();
			3: ! evtype_LineInput
				if (gg_event-->1 == gg_mainwin) {
				a_buffer-->0 = gg_event-->2;
				done = true;
				}
			}
			ix = HandleGlkEvent(gg_event, 0, a_buffer);
			if (ix == 2) {
			done = true;
			}
			else if (ix == -1) {
			done = false;
			}
		}
		#IFDEF DEBUG;
		if (gg_commandstr ~= 0 && gg_command_reading == false) {
			! put_buffer_stream
			glk($0085, gg_commandstr, a_buffer+WORDSIZE, a_buffer-->0); 
			glk($0081, gg_commandstr, 10); ! put_char_stream (newline)
		}
		#ENDIF;
		.KPContinue;
		Tokenise__(a_buffer,a_table);
		! It's time to close any quote window we've got going.
		if (gg_quotewin) {
			glk($0024, gg_quotewin, 0); ! close_window
			gg_quotewin = 0;
		}
		];

	#endif;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORKeyboardPrimitive_DONEGRAMMAR; constant ORKeyboardPrimitive_DONEGRAMMAR; #ifdef ORKeyboardPrimitive_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;