!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.09.15 ORStartingTurn [Z, GLULX]
! In Inform, "moves" on the status line start at one instead of zero.
! This module changes that.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! This module was created after a review of Matthew Auger's submitted bug report for 
! standard library( Issue L61011 : "Move count starts at 1") which can be reviewed at:
!
!	http://www.inform-fiction.org/patches/L61011.html
!
! This module impliments Matthew's solution but also leverages a constant STARTING_TURN
! which is defaulted to 0 if not defined. (Why would you want to make it anything else? 
! Who knows...)
!--------------------------------------------------------------------------------------
! AutoDep:	ORObjectInitialise
!			ORKeyboard
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#ifdef USE_ORStartingTurn; #include "ORStartingTurn"; #endif;
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORStartingTurn; 
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.09.15	Initial Creation
!--------------------------------------------------------------------------------------
#ifdef USE_ORStartingTurn;message "          Processing library extension ORStartingTurn...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 
	#ifndef USE_ORKeyboard; Constant USE_ORKeyboard; message "          ****Forcing inclusion of ORKeyboard****"; #include "ORKeyboard"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORStartingTurn_DONEREPLACE; constant ORStartingTurn_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------
	replace KeyboardDoUndo;
!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORStartingTurn_DONEMESSAGE; constant ORStartingTurn_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORStartingTurn requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORStartingTurn_DONECODE;constant ORStartingTurn_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	[KeyboardDoUndo a_table nw i w;!--return false to get freshinput
	#IFV5;
	!  Undo handling

	!  In Graham's 6/9 code, the following line tests (parse->1==1) instead
	!  of (nw==1). I believe that's wrong. In particular, it prevents "undo"
	!  from working during "Which do you mean...?" disambiguation, because
	!  input at that prompt goes into parse2 instead of parse.
		w=a_table-->1;
		if ((w == UNDO1__WD or UNDO2__WD or UNDO3__WD) && (nw==1))
		{   if (turns==STARTING_TURN){   !--only change...
				L__M(##Miscellany,11); 
				return -1;
			}
			if (undo_flag==0){   
				L__M(##Miscellany,6); 
				return -1;
			}
			if (undo_flag==1) jump UndoFailed;
	#ifndef TARGET_GLULX;
			! The just_undone check shouldn't be done in Glulx, as multiple
			! undo is possible.
			if (just_undone==1){   
				L__M(##Miscellany,12); 
				return -1;
			}
			@restore_undo i;
	#ifnot; ! TARGET_GLULX
			@restoreundo i;
			i = (~~i);
	#endif; ! TARGET_
			if (i==0){   
				.UndoFailed;
				L__M(##Miscellany,7);
			}
			return -1;
		}
	#ifndef TARGET_GLULX;
		@save_undo i;
	#ifnot; ! TARGET_GLULX
		@saveundo i;
		if (i == -1) {
			GGRecoverObjects();
			i = 2;
		}
		else {
			i = (~~i);
		}
	#endif; ! TARGET_
		just_undone=0;
		undo_flag=2;
		if (i==-1) undo_flag=0;
		if (i==0) undo_flag=1;
		if (i==2)
		{
	#ifndef TARGET_GLULX;
			style bold;
	#ifnot; ! TARGET_GLULX
			glk($0086, 4); ! set subheader style
	#endif; ! TARGET_
			print (name) location, "^";
	#ifndef TARGET_GLULX;
			style roman;
	#ifnot; ! TARGET_GLULX
			glk($0086, 0); ! set normal style
	#endif; ! TARGET_
			L__M(##Miscellany,13);
			just_undone=1;
			return -1;
		}
	#ENDIF;
	];
	object with object_initialise[;turns=STARTING_TURN;];

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORStartingTurn_DONEGRAMMAR; constant ORStartingTurn_DONEGRAMMAR; #ifdef ORStartingTurn_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------
	default STARTING_TURN 0;
!--------------------------------------------------------------------------------------
#endif; #endif; #endif;