! mfclass.h
!
! Provides ClassifyName()
!          returns true if the perceptron classified the contents of 
!          name_said as female, false if male.
!
! Perform (Perceptron Classifier in Inform) v1.0
! Nick Montfort  http://nickm.com  2004-06-25

Constant name_max 30;
Array name_said -> 33;
Array mult_letter -> 2 252 1 0 254 253 254 5 3 0 252 0 5 251 254
247 0 5 253 255 2 9 255 0 0 0;
Array initial_bigram -> 250 255 0 255 0 0 4 0 0 0 0 253 5 255 0 2
  0 253 2 0 4 0 0 0 0 0 253 0 0 0 254 0 0 0 245 0 0 3 0 0 5 0 0 1
  0 0 0 0 0 0 255 0 255 0 0 0 248 0 0 251 1 0 0 254 0 0 253 0 0
  253 0 0 254 0 0 0 0 0 251 0 0 0 253 0 0 0 6 0 0 0 0 0 0 0 0 0 0
  0 249 0 249 0 0 0 255 2 0 255 0 0 0 0 0 0 0 255 255 251 0 0 0 6
  6 7 255 254 0 0 0 0 1 0 0 0 247 0 0 0 0 0 0 6 0 0 0 0 0 253 0 0
  0 0 0 0 0 0 0 0 0 0 249 0 0 0 3 0 0 244 0 0 0 0 0 0 0 0 248 0 7
  0 0 0 254 0 0 0 3 0 0 0 1 0 0 0 0 0 254 0 0 0 0 0 252 0 0 0 0 0
  255 0 0 0 0 0 252 0 0 0 0 0 0 1 0 0 0 252 253 0 0 0 0 0 0 0 255
  0 0 0 255 0 0 0 3 0 0 0 0 0 2 0 0 0 0 0 255 0 0 0 0 0 3 0 0 0
  255 0 0 0 6 0 0 0 0 0 0 0 0 253 0 0 0 0 0 0 253 0 3 0 0 0 252 0
  0 0 1 0 0 0 0 0 252 0 0 0 0 0 254 0 0 0 254 0 1 0 0 0 255 0 0 0
  252 0 0 0 0 0 254 0 0 0 0 0 3 0 0 0 2 0 3 0 0 0 1 0 0 0 0 0 0 0
  0 0 252 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 7 0
  253 0 0 0 0 252 0 0 0 5 0 0 0 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 251 0 0 2 246 0 0 0 0 0 1 0 0 0 0 0 252 0 0 0 255 0 1 0
  255 0 250 0 0 0 255 0 0 0 0 0 4 253 0 0 0 249 7 0 0 0 0 0 10 0 0
  0 2 0 0 1 253 0 0 0 0 0 254 0 0 245 0 0 0 0 0 0 251 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 252 0 0 0 254
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 246 0 0 0 255 0 0 3 241 0 0 0
  0 0 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 0
  0 0 0 245 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
Array final_bigram -> 0 0 252 253 2 0 0 1 0 0 0 243 253 0 0 0 0 
 251 250 253 0 0 0 253 0 0 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
 0 0 0 0 5 0 6 0 0 0 253 0 0 0 9 0 238 0 0 0 249 0 0 0 0 0 0 0 0 0
 5 0 10 0 0 0 3 0 0 0 4 0 0 0 0 0 250 0 0 0 0 0 0 0 0 0 0 0 3 249
 0 249 6 0 252 0 0 0 254 252 0 0 255 0 0 247 255 5 0 0 241 251 254
 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0
 253 0 250 7 0 0 0 0 0 0 251 0 0 0 0 0 0 0 0 0 1 0 9 0 0 0 4 0 0 0
 0 0 0 0 0 252 0 0 0 0 0 253 0 0 0 0 6 0 14 0 247 0 5 0 251 0 0 0
 248 255 252 252 245 247 0 0 255 0 0 0 0 0 0 0 2 0 0 0 0 0 0 0 0 0
 0 0 0 0 2 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0
 0 0 0 0 0 0 0 4 0 11 0 0 245 5 0 0 0 6 0 0 248 252 0 245 0 0 0 0
 245 0 0 0 0 4 0 10 0 0 0 4 0 0 0 4 0 0 0 0 0 249 0 0 0 0 0 0 0 0
 0 252 0 8 0 0 250 6 0 255 0 9 0 252 0 0 7 0 0 0 0 0 242 0 0 0 0 4
 0 0 252 0 0 254 0 0 0 0 0 0 3 0 253 0 0 0 245 248 0 0 0 255 0 255
 0 0 0 0 0 9 0 0 242 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 0 251 246 0 0 0 0 8 0
 250 252 0 0 251 0 0 0 0 243 0 0 0 0 0 0 8 0 0 0 1 0 0 253 0 0 0 0
 0 0 255 0 0 0 254 249 0 0 0 0 2 0 11 0 0 0 0 0 0 2 0 0 0 0 0 0
 246 0 0 0 0 250 0 0 0 0 0 0 254 0 0 0 2 0 252 0 0 0 0 254 0 255 0
 0 0 0 250 0 0 0 0 0 0 4 6 0 0 0 0 0 0 0 254 0 0 0 0 0 252 0 0 0 0
 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0 0 0 0 0 0 0
 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 12 0 0 247 1
 0 0 0 0 0 0 255 0 8 0 0 0 0 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
 0 0 0 0 254 0 0 0 0 0 0 0 0 0 0 0;
Array medial_bigram -> 252 6 5 254 5 252 254 0 4 0 252 0 254 2 4 0 
 4 1 254 254 251 0 255 0 3 4 1 251 0 0 0 0 0 0 9 0 0 255 0 0 3 0 0
 250 0 0 0 0 0 0 1 0 0 0 0 0 11 0 0 0 2 0 255 0 0 0 249 0 1 0 0 0
 0 0 0 0 0 0 255 0 0 242 0 255 255 0 2 0 0 251 0 254 245 0 0 252 1
 0 0 0 0 0 10 0 5 9 2 3 6 254 1 0 254 255 0 4 3 3 4 5 0 0 253 2 5
 3 255 254 0 0 255 0 0 0 6 253 0 0 0 0 0 0 0 0 252 0 0 3 0 253 0 0
 0 0 0 0 5 0 0 0 255 0 3 9 253 0 0 0 0 0 244 0 0 0 0 0 1 0 0 0 0 0
 254 0 0 0 3 0 0 0 1 0 0 2 0 254 252 0 0 248 0 0 254 0 0 0 10 0
 252 0 4 0 2 11 2 0 0 254 0 8 246 5 254 247 1 3 7 1 251 2 0 0 0 2
 252 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255
 0 0 0 248 0 0 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 254 253 252 4 7 254
 1 0 2 0 0 253 3 0 2 0 0 0 254 255 3 254 0 0 3 0 242 7 0 0 0 0 0 0
 251 0 0 0 250 0 1 0 0 0 0 0 255 0 0 0 0 0 1 0 255 0 0 0 4 0 1 1
 252 247 0 4 6 0 0 249 9 4 252 0 0 0 1 254 1 253 2 255 255 254 255
 2 7 0 7 3 247 253 251 252 0 0 2 2 1 0 255 3 254 0 7 0 0 0 253 0 0
 0 0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
 0 0 0 0 0 0 6 0 0 0 0 0 0 255 248 253 2 0 255 0 1 0 0 252 2 3 5 0
 0 249 255 251 3 248 0 0 3 0 7 0 249 0 8 0 0 255 7 0 0 0 4 0 3 0 0
 255 2 4 255 0 0 0 0 0 7 0 0 0 0 0 0 255 252 0 0 6 0 3 248 0 0 4 2
 9 255 0 0 0 0 0 253 0 254 3 1 0 247 0 252 0 255 0 0 4 0 3 0 2 252
 4 0 0 0 0 0 0 255 0 0 0 2 0 0 0 254 0 0 0 0 0 4 0 0 0 0 0 0 0 0 0
 0 0 251 0 0 0 2 0 0 0 253 0 0 0 0 1 0 0 0 252 0 0 0 0 0 0 0 0 255
 0 0 0 0 0 0 0 3 0 0 0 0 0 0 0 0 0 0 255 0 0 0 0 0 0 252 0 8 252 0
 0 0 0 0 0 0 251 0 0 0 0 0 252 7 0 0 0 0 0 0 0 2 0 0 0 4 0 0 0 0 0
 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;

[ ClassifyName sum i j k w;
  sum = 0;

  ! The bias is 0 for this trained perceptron, so the term is omitted.

  ! Shift 'A' (and 'a') to 0, and similarly for other letters
  for (i=0:i<name_said->0:i++)
    {
    if(name_said->(i+1) > 96)
      { name_said->(i+1) = name_said->(i+1) - 32; }
    name_said->(i+1) = name_said->(i+1) - 65;
    }

  ! Check for letters occuring multiple times
  for(i=0:i<26:i++)
    {
    for (j=0:j<name_said->0:j++)
      {
      if(name_said->(j+1) == i)
        {
        k=j+1;
        while(k<name_said->0)
          {
          if(name_said->(k+1) == i)
            {
            w = mult_letter->i;
            if (w>128) { w = w - 256; }
            sum = sum + w;
            k = name_said->0;
            }
          k++;
          }
        }
      }
    }

  ! Add weight for initial bigram
  w = initial_bigram->(((name_said->1)*26) + name_said->2);
  if (w>128) { w = w - 256; }
  sum = sum + w;
  
  ! Add weight for final bigram
  w = final_bigram->(((name_said->((name_said->0)-1))*26) + name_said->(name_said->0));
  if (w>128) { w = w - 256; }
  sum = sum + w;
  
  ! Add weight for all bigrams in between
  for(i=2:i<((name_said->0)-1):i++)
    {
    w = medial_bigram->(((name_said->i)*26) + name_said->(i+1));
    if (w>128) { w = w - 256; }
    sum = sum + w;
    }

  if (sum > 0)
    { return true; } ! Female name
  else
    { return false; } ! Male name
];

! END ----------------------------------------------------------------------
