//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Main.h"
#include "glkthread.h"
#include "verbs.h"
#include "preps.h"
#include "margins.h"
#include "nav.h"
#include "assoc.h"
#include "FontDialog.h"
#include "colors.h"
#include "about.h"
#include "story.h"
#include "globals.h"
#include "zclass.h"
#include "gclass.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
GLK *glk;
VM *vm;
ZMACHINE *zmachine;
GMACHINE *gmachine;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
  : TForm(Owner)
{
DoubleBuffered=true;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormShow(TObject *Sender)
{
MainForm->Left=Screen->Width/2-320;
MainForm->Top=Screen->Height/2-240;
VerbForm->Left=Screen->Width/2-75;
VerbForm->Top=Screen->Height/2-200;
PrepForm->Left=Screen->Width/2-75;
PrepForm->Top=Screen->Height/2-200;
CompassForm->Left=Screen->Width/2-121;
CompassForm->Top=Screen->Height/2-93;

prop_font=new TFont();
prop_font->Name="Times New Roman";
prop_font->Color=clBlack;
prop_font->Size=12;
fixed_font=new TFont();
fixed_font->Name="Courier New";
fixed_font->Color=clBlack;
fixed_font->Size=12;
glk=new GLK(true);
glk->moring=true;
       
home_dir=ExtractFilePath(Application->ExeName);

clipboard=Clipboard();

String font_file=home_dir;
font_file+="\\beyzork.fon";
if (!AddFontResource(font_file.c_str())){
  Application->MessageBox("Cannot initialize custom Zork font.  Please make sure the file beyzork.fon is in my directory.","ERROR.",MB_OK);
  Application->Terminate();};
SendMessage(Handle,WM_FONTCHANGE,0,0);

previous_stories=new TStringList();
previous_stories->Add("");
previous_stories->Add("");
previous_stories->Add("");
previous_stories->Add("");

read_reg();
update_prev_menus();
check_associations();
toggle_clock();
FontsForm->populate_fonts();
ColorsDialog->populate_colors();

StoryForm->clear_metadata();

story_loaded=false;
first_story=true;
dialogue_up=false;

if (ParamCount())
  init_story(ParamStr(1));
}
//---------------------------------------------------------------------------
void TMainForm::read_form_reg(String section,TForm *form,TRegIniFile *reg)
{
form->Left=reg->ReadInteger(section,"left",437);
form->Top=reg->ReadInteger(section,"top",184);
form->Width=reg->ReadInteger(section,"width",150);
form->Height=reg->ReadInteger(section,"height",400);
form->Color=(TColor)reg->ReadInteger(section,"color",clWhite);
if (reg->ReadBool(section,"max",false))
  form->WindowState=wsMaximized;
};
//--------------------------------------------------------------------------
void TMainForm::read_font_reg(String section,TFont *font,String def_font,int def_size,TRegIniFile *reg)
{
font->Name=reg->ReadString(section,"name",def_font);
font->Size=reg->ReadInteger(section,"size",def_size);
font->Color=(TColor)reg->ReadInteger(section,"color",clBlack);
};
//--------------------------------------------------------------------------
void TMainForm::read_reg()                   
{
TRegIniFile *reg=new TRegIniFile("Software\\Jimmy Maher\\filfre");

if (reg->KeyExists("MainForm")){

  read_font_reg("TextFont",prop_font,"Times New Roman",12,reg);
  glk->prop_font->Assign(prop_font);
  for (int i=0;i<11;i++)
    glk->textbuffer_style[i].text_color=prop_font->Color;
  read_font_reg("StatusFont",fixed_font,"Courier New",12,reg);
  glk->fixed_font->Assign(fixed_font);
  for (int i=0;i<11;i++)
    glk->textgrid_style[i].text_color=fixed_font->Color;
  read_font_reg("OtherFont",VerbForm->Font,"Arial",10,reg);
  PrepForm->Font->Assign(VerbForm->Font);

  read_form_reg("MainForm",MainForm,reg);
  for (int i=0;i<11;i++){
    glk->textbuffer_style[i].back_color=Color;
    glk->textgrid_style[i].back_color=Color;};
  glk->left_margin=reg->ReadInteger("MainForm","leftmargin",0);
  glk->right_margin=reg->ReadInteger("MainForm","rightmargin",0);
  read_form_reg("VerbForm",VerbForm,reg);
  read_form_reg("PrepForm",PrepForm,reg);
  CompassForm->Left=reg->ReadInteger("CompassForm","left",390);
  CompassForm->Top=reg->ReadInteger("CompassForm","top",262);
  CompassForm->Color=(TColor)reg->ReadInteger("CompassForm","color",clSilver);

  Verbs->Tag=reg->ReadBool("VerbForm","visible",false);
  Prepositions->Tag=reg->ReadBool("PrepForm","visible",false);
  Compass->Tag=reg->ReadBool("CompassForm","visible",false);

  TimerShow->Checked=!reg->ReadBool("Options","Timer",true);
  WarningMenu->Checked=reg->ReadBool("Options","Warnings",true);
  CoverMenu->Checked=reg->ReadBool("Options","Frontispiece",true);
  MoreMenu->Checked=reg->ReadBool("Options","More",true);
  glk->moring=MoreMenu->Checked;
  AssocForm->AskButton->Checked=reg->ReadBool("Options","AssocPrompt",false);

  ChDir(reg->ReadString("Previous","Dir",".\\"));
  previous_stories->Strings[0]=reg->ReadString("Previous","1","");
  previous_stories->Strings[1]=reg->ReadString("Previous","2","");
  previous_stories->Strings[2]=reg->ReadString("Previous","3","");
  previous_stories->Strings[3]=reg->ReadString("Previous","4","");};

delete reg;
};
//----------------------------------------------------------------------------
void TMainForm::update_prev_menus()
{
update_prev_menu(PrevMenu1,previous_stories->Strings[0]);
update_prev_menu(PrevMenu2,previous_stories->Strings[1]);
update_prev_menu(PrevMenu3,previous_stories->Strings[2]);
update_prev_menu(PrevMenu4,previous_stories->Strings[3]);
};
//----------------------------------------------------------------------------
void TMainForm::update_prev_menu(TMenuItem *menu,String filename)
{
if (filename=="")
  menu->Visible=false;
else{
  menu->Caption=ExtractFileName(filename);
  menu->Visible=true;};
};
//----------------------------------------------------------------------------
void TMainForm::check_associations()
{
TRegIniFile *reg=new TRegIniFile("Software\\Classes");
//reg->RootKey=HKEY_CLASSES_ROOT;

if (!AnsiContainsText(reg->ReadString("Filfre.blb\\Shell\\Open\\Command","",""),Application->ExeName)){
  if (!AssocForm->AskButton->Checked){
    AssocForm->ShowModal();
    if (AssocForm->Tag){
      add_association(reg,"z3");
      add_association(reg,"z4");
      add_association(reg,"z5");
      add_association(reg,"z8");
      add_association(reg,"zblorb");
      add_association(reg,"gblorb");
      add_association(reg,"ulx");
      add_association(reg,"blb");};};};

delete reg;            
};
//----------------------------------------------------------------------------
void TMainForm::add_association(TRegIniFile *reg,String type)
{
//reg->OpenKey("\\",false);

String ext=".";
ext+=type;

String key="Filfre";
key+=ext;
reg->WriteString(ext,"",key);

reg->WriteString(key,"","Filfre Story");
//reg->OpenKey(key,false);

String value=home_dir;
value+="Filfre.ico";
reg->WriteString(key+"\\DefaultIcon","",value);

value="\"";
value+=Application->ExeName;
value+="\" \"%1\"";
reg->WriteString(key+"\\Shell\\Open\\Command","",value);
};
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormResize(TObject *Sender)
{
cancel_moring();

StatusBar->Width=ClientWidth;
StatusBar->Top=ClientHeight-20;
StatusBar->Panels->Items[0]->Width=StatusBar->ClientWidth-150;

client_width=ClientWidth;
client_height=ClientHeight-20;

if (story_loaded&&!vm->quitting){
  glk->resize_redraw();
  glk->setup_screen();
  glk->signal_resize();};
}
//---------------------------------------------------------------------------
void TMainForm::write_reg()
{
TRegIniFile *reg=new TRegIniFile("Software\\Jimmy Maher\\filfre");

write_form_reg("MainForm",MainForm,reg);
reg->WriteInteger("MainForm","leftmargin",glk->left_margin);
reg->WriteInteger("MainForm","rightmargin",glk->right_margin);
write_form_reg("VerbForm",VerbForm,reg);
write_form_reg("PrepForm",PrepForm,reg);
write_form_reg("CompassForm",CompassForm,reg);

write_font_reg("TextFont",prop_font,reg);
write_font_reg("StatusFont",fixed_font,reg);
write_font_reg("OtherFont",VerbForm->VerbTree->Font,reg);

reg->WriteBool("VerbForm","visible",Verbs->Tag);
reg->WriteBool("PrepForm","visible",Prepositions->Tag);
reg->WriteBool("CompassForm","visible",Compass->Tag);

reg->WriteBool("Options","Timer",TimerShow->Checked);
reg->WriteBool("Options","Warnings",WarningMenu->Checked);
reg->WriteBool("Options","Frontispiece",CoverMenu->Checked);
reg->WriteBool("Options","More",MoreMenu->Checked);
reg->WriteBool("Options","AssocPrompt",AssocForm->AskButton->Checked);

reg->WriteString("Previous","Dir",GetCurrentDir());
reg->WriteString("Previous","1",previous_stories->Strings[0]);
reg->WriteString("Previous","2",previous_stories->Strings[1]);
reg->WriteString("Previous","3",previous_stories->Strings[2]);
reg->WriteString("Previous","4",previous_stories->Strings[3]);

delete reg;
};
//--------------------------------------------------------------------------
void TMainForm::write_form_reg(String section,TForm *form,TRegIniFile *reg)
{
/*reg->WriteInteger(section,"left",form->Left);
reg->WriteInteger(section,"top",form->Top);
reg->WriteInteger(section,"width",form->Width);
reg->WriteInteger(section,"height",form->Height);
reg->WriteInteger(section,"color",form->Color);
reg->WriteBool(section,"max",(form->WindowState==wsMaximized));*/
WINDOWPLACEMENT placement;
placement.length=sizeof(placement);
GetWindowPlacement(form->Handle,&placement);
reg->WriteInteger(section,"left",placement.rcNormalPosition.left);
reg->WriteInteger(section,"top",placement.rcNormalPosition.top);
reg->WriteInteger(section,"width",placement.rcNormalPosition.right-placement.rcNormalPosition.left);
reg->WriteInteger(section,"height",placement.rcNormalPosition.bottom-placement.rcNormalPosition.top);
reg->WriteInteger(section,"color",form->Color);
reg->WriteBool(section,"max",(form->WindowState==wsMaximized));

};
//--------------------------------------------------------------------------
void TMainForm::write_font_reg(String section,TFont *font,TRegIniFile *reg)
{
reg->WriteString(section,"name",font->Name);
reg->WriteInteger(section,"size",font->Size);
reg->WriteInteger(section,"color",font->Color);
};
//--------------------------------------------------------------------------

void __fastcall TMainForm::FormClose(TObject *Sender, TCloseAction &Action)
{
if (story_loaded){
  if (WarningMenu->Checked&&!glk->saved)
    if (Application->MessageBox("Exiting Filfre will cause you to lose your game in progress.  Are you sure?","WARNING!",MB_YESNO)==IDNO){
      Action=caNone;
      return;};
  cleanup_story();};

write_reg();

RemoveFontResource(".\\beyzork.fon");
SendMessage(Handle,WM_FONTCHANGE,0,0);
delete prop_font;
delete fixed_font;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FontsMenuClick(TObject *Sender)
{
if (!glk->mored){
  dialogue_up=true;
  FontsForm->ShowModal();
  dialogue_up=false;};
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ColorsMenuClick(TObject *Sender)
{
if (!glk->mored){
  dialogue_up=true;
  ColorsDialog->ShowModal();
  dialogue_up=false;};
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::MarginsMenuClick(TObject *Sender)
{
if (!glk->mored){
  dialogue_up=true;
  MarginsForm->ShowModal();
  dialogue_up=false;};
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::WarningMenuClick(TObject *Sender)
{
WarningMenu->Checked=!WarningMenu->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CoverMenuClick(TObject *Sender)
{
CoverMenu->Checked=!CoverMenu->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::TopicsMenuClick(TObject *Sender)
{
String tmp=home_dir;
tmp+="filfre.html";
ShellExecute(Handle,"open",tmp.c_str(),NULL,home_dir.c_str(),SW_SHOW);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::AboutMenuClick(TObject *Sender)
{
dialogue_up=true;
AboutBox->ShowModal();
dialogue_up=false;
}
//---------------------------------------------------------------------------
bool TMainForm::story_warning()
{
if (story_loaded&&WarningMenu->Checked&&!glk->saved)
  if (Application->MessageBox("Opening a new story will cause you to lose your game in progress.  Are you sure?","WARNING!",MB_YESNO)==IDNO)
    return (false);

return (true);
};
//---------------------------------------------------------------------------

void __fastcall TMainForm::OpenMenuClick(TObject *Sender)
{
if (glk->mored||!story_warning())
  return;

if (StoryOpenDialog->Execute()){
  StoryForm->Visible=false;
  init_story(StoryOpenDialog->FileName);};
}
//---------------------------------------------------------------------------
void TMainForm::init_story(String filename)
{
if (!first_story){
  cleanup_story();
  glk->cleanup();};

story_file=new TFileStream(filename,fmOpenRead|fmShareDenyWrite);

int story_size;
read_version();
if (version==70){
  story_size=read_blorb();
  read_version();}
else
  story_size=story_file->Size;
if (!version){
  Application->MessageBox("This does not appear to be a valid version 3, 4, 5, or 8 Z-Machine story file, nor a valid Glulx file.","Invalid File",MB_OK);
  return;};

if (version<71){
  zmachine=new ZMACHINE;
  vm=(VM *)zmachine;}
else{
  gmachine=new GMACHINE;
  vm=(VM*)gmachine;};

vm->version=version;
//vm->story=new unsigned char [story_size];
vm->story=(unsigned char *)malloc(story_size);
story_file->Read(vm->story,story_size);

if (previous_stories->IndexOf(filename)==-1){
  previous_stories->Move(2,3);
  previous_stories->Move(1,2);
  previous_stories->Move(0,1);
  previous_stories->Strings[0]=filename;}
else{
  previous_stories->Move(previous_stories->IndexOf(filename),0);};
update_prev_menus();

toggle_menus(true);

ChDir(ExtractFileDir(filename));

String ini_name=ChangeFileExt(filename,".cfg");
if (FileExists(ini_name)){
  TStringList *ini=new TStringList;
  ini->LoadFromFile(ini_name);
  if (ini->IndexOfName("WindowBorders")!=-1){
    if (AnsiLowerCase(ini->Values["WindowBorders"])=="no"){
      glk->borders=false;
      glk->scrollbar=false;};};
  if (ini->IndexOfName("WindowWidth")!=-1){
    String tmp=ini->Values["WindowWidth"];
    ClientWidth=tmp.ToIntDef(Width);};
  if (ini->IndexOfName("WindowHeight")!=-1){
    String tmp=ini->Values["WindowHeight"];
    ClientHeight=tmp.ToIntDef(Height);};         
  if (ini->IndexOfName("FontName")!=-1){
    if (Screen->Fonts->IndexOf(ini->Values["FontName"])!=-1){
      glk->prop_font->Name=ini->Values["FontName"];};};
  if (ini->IndexOfName("FontSize")!=-1){
    String tmp=ini->Values["FontSize"];
    glk->prop_font->Size=tmp.ToIntDef(glk->prop_font->Size);};
  if (ini->IndexOfName("FixedFontName")!=-1){
    if (Screen->Fonts->IndexOf(ini->Values["FixedFontName"])!=-1){
      glk->fixed_font->Name=ini->Values["FixedFontName"];};};
  if (ini->IndexOfName("FixedFontSize")!=-1){
    String tmp=ini->Values["FixedFontSize"];
    glk->fixed_font->Size=tmp.ToIntDef(glk->fixed_font->Size);};
  delete ini;};

if (CoverMenu->Checked)
  StoryForm->show_form(story_file);

story_loaded=true;
first_story=false;
StatusBar->Panels->Items[0]->Text="";


glk->version=version;
glk->story_size=story_size;
glk->story_file=story_file;
WaitTimer->Enabled=true;
glk->Resume();
};

//---------------------------------------------------------------------------

void __fastcall TMainForm::PrevMenu1Click(TObject *Sender)
{
if (!glk->mored&&story_warning()){
  StoryForm->Visible=false;
  init_story(previous_stories->Strings[0]);};
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::PrevMenu2Click(TObject *Sender)
{
cancel_moring();

if (!glk->mored&&story_warning()){
  StoryForm->Visible=false;
  init_story(previous_stories->Strings[1]);};
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::PrevMenu3Click(TObject *Sender)
{
if (!glk->mored&&story_warning()){
  StoryForm->Visible=false;
  init_story(previous_stories->Strings[2]);};
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::PrevMenu4Click(TObject *Sender)
{
if (!glk->mored&&story_warning()){
  StoryForm->Visible=false;
  init_story(previous_stories->Strings[3]);};
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ExitMenuClick(TObject *Sender)
{
Close();  
}
//---------------------------------------------------------------------------
int TMainForm::read_blorb()
{
story_file->Seek(4,soFromBeginning);
unsigned int file_size=restore_long(story_file)+8;
if (restore_string(4,story_file)!="IFRS")
  return (false);

if (seek_chunk("IFmd",file_size,story_file)){
  _di_IXMLDocument xml=NewXMLDocument();
  int length=restore_long(story_file);
  xml->LoadFromXML(restore_string(length,story_file));
  StoryForm->load_metadata(xml);
  delete xml;};

if (!seek_chunk("ZCOD",file_size,story_file))
  if (!seek_chunk("GLUL",file_size,story_file))
    return (false);

return (restore_long(story_file));
};
//---------------------------------------------------------------------------
void TMainForm::read_version()
{
int start_pos=story_file->Position;
story_file->Read(&version,1);
if (version!=3&&version!=4&&version!=5&&version!=8){
  story_file->Seek(start_pos,soFromBeginning);
  String first_chunk=restore_string(4,story_file);
  if (first_chunk=="FORM"){
    version=70;}
  else{
    if (first_chunk=="Glul"){
      version=71;}
    else{
      version=0;};};};
story_file->Seek(start_pos,soFromBeginning);
};
//---------------------------------------------------------------------------

void TMainForm::cleanup_story()
{
if (!vm->quitting){
  cancel_moring();
  glk->mored=false;
  glk->hard_quit=true;
  vm->quitting=true;
  WaitTimer->Enabled=true;
  glk->Resume();
  glk->done->WaitFor(1000);};
Caption="FILFRE";                          
toggle_menus(false);
reset_clock();
TranscriptMenu->Checked=false;
if (zmachine){
  delete zmachine;
  zmachine=NULL;};
if (gmachine){
  delete gmachine;
  gmachine=NULL;};
delete story_file;
StoryForm->clear_metadata();
SaveGame->FileName="";
RestoreGame->FileName="";
story_loaded=false;
first_story=true;
};
//---------------------------------------------------------------------------

void TMainForm::toggle_menus(bool enable)
{
RestartMenu->Enabled=enable;
OpenGameMenu->Enabled=enable;
SaveGameMenu->Enabled=enable;
TranscriptMenu->Enabled=enable;
if (enable&&((version>4&&vm->story[17]&16)||version>8))
  UndoMenu->Enabled=true;
else
  UndoMenu->Enabled=false;
CopyMenu->Enabled=enable;
PasteMenu->Enabled=enable;
SelectMenu->Enabled=enable;
FindMenu->Enabled=enable;
PopupCopy->Enabled=enable;
PopupPaste->Enabled=enable;
Verbs->Enabled=enable;
Prepositions->Enabled=enable;
Compass->Enabled=enable;


Verbs->Checked=Verbs->Tag;
Prepositions->Checked=Prepositions->Tag;
Compass->Checked=Compass->Tag;
if (Verbs->Checked)
  VerbForm->Visible=true;
if (Prepositions->Checked)
  PrepForm->Visible=true;
if (Compass->Checked)
  CompassForm->Visible=true;
};
//---------------------------------------------------------------------------

void __fastcall TMainForm::StoryMenuClick(TObject *Sender)
{
StoryForm->show_form(story_file);  
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::RestartMenuClick(TObject *Sender)
{
if (!WarningMenu->Checked||glk->saved||Application->MessageBox("Restarting the story will cause you to lose your game in progress.  Are you sure?","WARNING!",MB_YESNO)==IDYES)
  init_story(previous_stories->Strings[0]);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::OpenGameMenuClick(TObject *Sender)
{
glk->do_command("RESTORE",true);  
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SaveGameMenuClick(TObject *Sender)
{
glk->do_command("SAVE",true);
}
//---------------------------------------------------------------------------


void __fastcall TMainForm::TranscriptMenuClick(TObject *Sender)
{
if (TranscriptMenu->Checked)
  glk->do_command("SCRIPT OFF",true);
else
  glk->do_command("SCRIPT ON",true);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CopyMenuClick(TObject *Sender)
{
glk->copy_text();  
}
//---------------------------------------------------------------------------


void __fastcall TMainForm::PasteMenuClick(TObject *Sender)
{
glk->paste_text();  
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SelectMenuClick(TObject *Sender)
{
glk->select_all();  
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FindMenuClick(TObject *Sender)
{
FindDialog->Execute();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FindDialogClose(TObject *Sender)
{
dialogue_up=false;
FindDialog->Tag=0;  
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FindDialogShow(TObject *Sender)
{
dialogue_up=true;
FindDialog->Tag=1;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FindDialogFind(TObject *Sender)
{
glk->find_text();  
}
//---------------------------------------------------------------------------

void TMainForm::toggle_clock()
{
if (!TimerShow->Checked){
  reset_clock();
  ClockTimer->Enabled=true;
  TimerReset->Enabled=true;
  TimerPause->Enabled=true;
  TimerShow->Checked=true;}
else{
  ClockTimer->Enabled=false;
  StatusBar->Panels->Items[2]->Text="";
  TimerReset->Enabled=false;
  TimerPause->Enabled=false;
  TimerShow->Checked=false;};
};
//---------------------------------------------------------------------------

void TMainForm::reset_clock()
{
hours=0;
minutes=0;
seconds=0;
};
//----------------------------------------------------------------------------

void __fastcall TMainForm::TimerShowClick(TObject *Sender)
{
toggle_clock();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ClockTimerTimer(TObject *Sender)
{
if (story_loaded){

  seconds++;
  if (seconds>59){
    seconds=0;
    minutes++;
    if (minutes>59){
      minutes=0;
      hours++;};};

  String tmp=hours;
  tmp+=":";
  if (minutes<10)
    tmp+="0";
  tmp+=minutes;
  tmp+=":";
  if (seconds<10)
    tmp+="0";
  tmp+=seconds;

  StatusBar->Panels->Items[2]->Text=tmp;};
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::TimerResetClick(TObject *Sender)
{
reset_clock();  
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::TimerPauseClick(TObject *Sender)
{
if (!TimerPause->Checked){
  ClockTimer->Enabled=false;
  TimerPause->Checked=true;}
else{
  ClockTimer->Enabled=true;
  TimerPause->Checked=false;};
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::VerbsClick(TObject *Sender)
{
if (Verbs->Checked)
  VerbForm->Visible=false;
else
  VerbForm->Visible=true;
Verbs->Tag=Verbs->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::PrepositionsClick(TObject *Sender)
{
if (Prepositions->Checked)
  PrepForm->Visible=false;
else
  PrepForm->Visible=true;
Prepositions->Tag=Prepositions->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CompassClick(TObject *Sender)
{
if (Compass->Checked)
  CompassForm->Visible=false;
else
  CompassForm->Visible=true;
Compass->Tag=Compass->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::MoreMenuClick(TObject *Sender)
{
MoreMenu->Checked=!MoreMenu->Checked;
glk->moring=MoreMenu->Checked;  
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
if (Key==VK_F10){
  tagMSG msg;
  msg.message=WM_KEYDOWN;
  msg.wParam=VK_F10;
  bool handled;
  glk->AppMessage(msg,handled);
  Key=0;};
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::UndoMenuClick(TObject *Sender)
{
glk->do_command("UNDO",true);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::WaitTimerTimer(TObject *Sender)
{
Screen->Cursor=crHourGlass;
StatusBar->Panels->Items[0]->Text="Please wait...";
WaitTimer->Enabled=false;  
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::toggle_waittimer()
{
Screen->Cursor=crDefault;
StatusBar->Panels->Items[0]->Text="";
WaitTimer->Enabled=false;
};
//---------------------------------------------------------------------------

void TMainForm::cancel_moring()
{
if (glk->mored)
  glk->more_cancel=true;
};
void __fastcall TMainForm::StatusBarMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
if (TimerShow->Checked&&X>=StatusBar->Width-100){
  TimerPauseClick(NULL);
  return;};

if (X>=StatusBar->Width-150)
  glk->set_insert(!glk->insert);
}
//---------------------------------------------------------------------------

