/* functions.c
 *
 *  foblub -- a Z-machine for TI calculators
 *  based on pinfocom by InfoTaskForce and Paul Smith
 *  Ported and extended by Nils Gesbert, 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to the
 *  Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Header: RCS/funcs.c,v 3.0 1992/10/21 16:56:19 pds Stab $
 */

#include    "infocom.h"

inline void
plus A2(word, a, word, b)
{
    store(a + b);
}

inline void
minus A2(word, a, word, b)
{
    store(a - b);
}

inline void
multiply A2(word, a, word, b)
{
    store((signed) a * (signed) b);
}

inline void
divide A2(word, a, word, b)
{
    store((signed) a / (signed) b);
}

inline void
mod A2(word, a, word, b)
{
    store((signed) a % (signed) b);
}

inline void
pi_random A1(word, num)
{
  short n = (signed) num;
  if (n > 0) store (random (n) + 1);
  else {
    if (n == 0) randomize();
    else srand (-n);
    store(0);
  }
}

inline void
LTE A2(word, a, word, b)
{
    ret_value((signed) a < (signed) b);
}

inline void
GTE A2(word, a, word, b)
{
    ret_value((signed) a > (signed) b);
}

inline void
bit A2(word, a, word, b)
{
    ret_value((b & (~a)) == 0);
}

inline void
or A2(word, a, word, b)
{
    store(a | b);
}

inline void
not A1(word, a)
{
    store(~a);
}

inline void
and A2(word, a, word, b)
{
    store(a & b);
}

inline void
compare A2(word, num, const word *, param)
{
    const word *pp;
    Bool equal = 0;

    for (pp = &param[1]; num > 1; ++pp, --num)
        equal |= (*param == *pp);

    ret_value(equal);
}

inline void
cp_zero A1(word, a)
{
    ret_value(a == 0);
}
