/* plus_opcodes.c
 *
 *  foblub -- a Z-machine for TI calculators
 *  based on pinfocom by InfoTaskForce and Paul Smith
 *  Ported and extended by Nils Gesbert, 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to the
 *  Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

static inline void read_char (word num, const word *param) {
  if (upper_win_active) display_cursor (TRUE);
  else if (!stream3_active) flush_text_buffer();
  unsigned short a = ngetchx();
  switch (a) {
  case KEY_BACKSPACE : a = 8; break;
  case KEY_ESC : a = 27; break;
  case KEY_UP : a = 129; break;
  case KEY_DOWN : a = 130; break;
  case KEY_LEFT : a = 131; break;
  case KEY_RIGHT : a = 132; break;
  case KEY_F1 ... KEY_F8 : a += 133 - KEY_F1; break;
  }
  if (a & KEY_DIAMOND) a ^= KEY_DIAMOND;
  if (upper_win_active) display_cursor (FALSE);
  store (a);
  ligne_courante = 1;
}

static inline void scan_table (word num, const word *param) {
  word table = param[1];
  unsigned int i;
  Bool mot;
  int skip;
#ifdef DEBUG2
  if (tracing) {
    char buf[50];
    sprintf (buf, "scan_table : %hu", table);
    scr_putline (buf);
  }
#endif
  if (num == 4) {
    mot = param[3] & 128;
    skip = param[3] & 127;
  }
  else {
    mot = 1;
    skip = 2;
  }
  for (i = 0; i < param[2]; i++) {
    if (param[0] == (mot ? get_word(table) : get_byte(table))) {
      store (table);
      ret_value (1);
      return;
    }
    table += skip;
  }
  store (0);
  ret_value (0);
}
