/* titi.c
 *
 *  foblub -- a Z-machine for TI calculators
 *  based on pinfocom by InfoTaskForce and Paul Smith
 *  Ported and extended by Nils Gesbert, 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to the
 *  Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <kbd.h>
#include <graph.h>
#include <compat.h>
#include <string.h>
#include <system.h>
#include "infocom.h"
#include "smallfixedfont.h"

#define WRAPPING FALSE
/* Bool wrapping; */
#define OCTETS_PAR_LIGNE 30 /* nb. d'octets ds une ligne de pixels */
#define HAUTEUR_STATUT (STANDARD ? 7 : 0)
/* en pixels : petite police + 1 pix. noir au-dessus et en-dessous */
#define hauteur_ligne (fonte_courante == F_4x6 ? 6 : 8)
#define hauteur_trou ((LCD_HEIGHT - (STANDARD ? 7 : 1)) % hauteur_ligne)
#define position_y ((unsigned) (LCD_HEIGHT - HAUTEUR_STATUT - hauteur_trou - hauteur_ligne))
#define largeur_ecran LCD_WIDTH
#define largeur_espace (fonte_courante == F_4x6 ? 2 : 6)
#define nb_lignes_max \
((LCD_HEIGHT - HAUTEUR_STATUT) / hauteur_ligne - nb_lignes_a_garder - nb_lignes_upper_win)
#define nb_lignes_a_garder CONTEXT

#ifdef VERSION_QUATRE
#define REVERSE_VIDEO 1
#define BOLD 2
#define ITALIC 4
#define FIXED 8

static word font_style;
#endif /* VERSION_QUATRE */

/* static int fonte_courante; */
#define fonte_courante F_4x6
static int ligne_courante;
static int position_x;

/* Deuxime fentre (upper window) */

Bool upper_win_active;
static word pos_x_upper_win;
static word pos_y_upper_win;
static word taille_up_win;
#define MAX_X (LCD_WIDTH / 4 - 1)
#define nb_lignes_upper_win ((signed) taille_up_win / (6 * OCTETS_PAR_LIGNE))

/* Attention : pour viter des calculs redondants pos_y_upper_win est en fait 
   l'offset en mmoire vido du premier pixel en haut  gauche de la ligne de texte courante
   (donc le nom de la variable est un peu idiot, mais bon...) */

/* Variables de print.c que j'ai besoin de rinitialiser ici : */

static print_buf_t text, room, stream3;
static Bool stream3_active;
static Bool output_disabled;

void scr_setup () {

  FontSetSys (F_4x6);
/*   fonte_courante = F_4x6; */
  ligne_courante = 1 - nb_lignes_a_garder; /* Pas besoin d'historique au dbut... */
  position_x = -1;
  taille_up_win = 0;
  upper_win_active = FALSE;
/*   wrapping = FALSE; */

    pbf_p = &text;

    stream3.len = 0;
    stream3.max = 0;
    stream3.buf = NULL;
    stream3_active = FALSE;
    output_disabled = FALSE;
}


static void print_char_fixed_font (word car, word pos_x, word pos_y) {
  char *ptr;
  unsigned char mask4;
  unsigned char mask3;
  unsigned long caractere;
  int i;
  Bool reverse_video;

  car -= ' ';
  caractere = fixedfont[car];
  /* Si le caractre n'est PAS entre ' ' et '~' on va afficher n'importe quoi,
     ce qui n'est pas plus grave que a : pas besoin de vrifier... */
  if ((caractere & 0100000) && (car != 'j' - ' ')) caractere <<= 3;

  if (pos_x & 1) {
    mask4 = 0xF0;
    mask3 = 0x07;
  }
  else {
    mask4 = 0x0F;
    mask3 = 0x70;
    caractere <<= 4;
  }

#ifdef VERSION_QUATRE
  reverse_video = font_style & REVERSE_VIDEO;
  if (reverse_video) mask4 = ~mask4;
#endif

  ptr = LCD_MEM + 5 * OCTETS_PAR_LIGNE + pos_y + pos_x / 2;
  
  for (i = 0; i < 6; i++) {
#ifdef VERSION_QUATRE
    if (reverse_video) *ptr |= mask4; else
#endif
    *ptr &= mask4;
    *ptr ^= (caractere & mask3);
    ptr -= OCTETS_PAR_LIGNE;
    caractere >>= 3;
  }
}


void va_a_la_ligne() {
#if 0
  /* Faut-il changer de police ? */
  int decalage = 0;
  int fonte = F2_IS_SET (B_FIXED_FONT) ? F_6x8 : F_4x6;
  if (fonte != fonte_courante) {
    decalage = hauteur_trou;
    FontSetSys (fonte);
    fonte_courante = fonte;
    decalage -= hauteur_trou;
  }
#else
#define decalage 0
#endif

  if (ligne_courante++ >= nb_lignes_max) {
    int lc;
    /* crire "..." en bas de l'cran */
    ((byte*)LCD_MEM)[OCTETS_PAR_LIGNE * (LCD_HEIGHT - HAUTEUR_STATUT - (TI89 ? 2 : 1))] = 42;
    switch (ngetchx()) {
      case KEY_ESC : lc = -32768; break; /* Ne plus s'arrter */
      case KEY_DOWN : lc = 32767; break; /* scroller seulement une ligne */
      case ' ' : lc = 1 - nb_lignes_a_garder; break; /* un cran entier */
#ifdef DEBUG
    case 'x' : tracing = !tracing;
#endif
      default : lc = 1;
    }
    ligne_courante = lc;
  }
  /* scrolling d'une ligne vers le haut */
  if (OCTETS_PAR_LIGNE * position_y > taille_up_win) /* sinon a va dconner */
    memmove (LCD_MEM + taille_up_win,
	     LCD_MEM + taille_up_win + (hauteur_ligne - decalage) * OCTETS_PAR_LIGNE,
	     OCTETS_PAR_LIGNE * position_y - taille_up_win);

  memset (LCD_MEM + OCTETS_PAR_LIGNE * position_y, 0,
	  (hauteur_ligne + hauteur_trou) * OCTETS_PAR_LIGNE);
  position_x = -1; /* Les caractres ont une approche  gauche de 1 pixel */
#undef decalage
}

static void ecrit_texte (const char *ptr) {
  char mot[30];
  int k = 0;
  do {
    mot[k] = *ptr;
    if (*ptr == ' ' || *ptr == '\0' || ++k == 29) {
      if (F2_IS_SET (B_FIXED_FONT)) {
	int i;
	position_x += (unsigned) (-position_x) % 4; /* Alignement sur un multiple de 4 */
	if (position_x + 4 * k > largeur_ecran) {
	  va_a_la_ligne(); position_x++; /* va_a_la_ligne remet la position_x  -1... */
	}
	for (i = 0; i < k; i++) {
	  print_char_fixed_font (mot[i], position_x / 4, position_y * OCTETS_PAR_LIGNE);
	  position_x += 4;
	}
      }
      else { /* variable font */
	int longueur;
	mot[k] = '\0';
	longueur = DrawStrWidth (mot, fonte_courante);
	if (position_x + longueur > largeur_ecran)
	  va_a_la_ligne(); /* on vire les espaces en fin de ligne */
	DrawStr (position_x, position_y, mot, A_NORMAL);
	position_x += longueur;
      }
      k = 0;
      if (*ptr == ' ') position_x += 2;
    }
  } while (*ptr++);
}

void scr_putline (const char *texte) {
  ecrit_texte (texte);
  va_a_la_ligne();
}

static void rafraichit_statut () {
  if (STANDARD) {
    if (TI89)/* crire hors de l'cran pour rafrachir aprs ne marche que sur la TI 89 */
      memcpy (LCD_MEM + (LCD_HEIGHT - 7) * OCTETS_PAR_LIGNE,
	      LCD_MEM + LCD_HEIGHT * OCTETS_PAR_LIGNE,
	      7 * OCTETS_PAR_LIGNE);
  }
  else memset (LCD_MEM + (LCD_HEIGHT - hauteur_trou - 1) * OCTETS_PAR_LIGNE, 0,
	       (hauteur_trou + 1) * OCTETS_PAR_LIGNE);
}

void scr_putscore() {
  int position = TI89 ? LCD_HEIGHT : LCD_HEIGHT - 7;
/*   int fonte = FontSetSys (F_4x6); */
  memset (LCD_MEM + position * OCTETS_PAR_LIGNE, 0xFF, 7 * OCTETS_PAR_LIGNE);

  DrawStr (0, position + 1, ti_location, A_REVERSE);
  DrawStr (LCD_WIDTH - DrawStrWidth (ti_status, F_4x6),
	   position + 1, ti_status, A_REVERSE);
/*   FontSetSys (fonte); */
  rafraichit_statut();
}

inline void scr_putsound (int number,
		   int action,
		   int volume,
		   int argc) {
/*   scr_putline (FRENCH ? "[son]" : "[sound effect]"); */
}

int scr_getline (const char *prompt, int maxlen, char *buffer) {
  unsigned short key;
  int i = 0;
  void *kbq = kbd_queue();
  if (STANDARD) scr_putscore();
  ecrit_texte (prompt);
  buffer[0] = 0;
  do {
    char fill[LCD_WIDTH / 2 + 1];
    int pos_x = position_x + DrawStrWidth (buffer, fonte_courante);
    DrawStr (position_x, position_y, buffer, A_REPLACE);
    if (LCD_WIDTH > pos_x) {
      sprintf (fill, "%-*c", (LCD_WIDTH - pos_x) / 2, '_');
      DrawStr (pos_x, position_y, fill, A_REPLACE);
    }
    OSTimerRestart (APD_TIMER);
    while (OSdequeue (&key, kbq)) {
      idle();
      if (OSTimerExpired (APD_TIMER)) {key = KEY_DIAMOND | KEY_ON; break;}
      rafraichit_statut();
    }
    key &= 0xF7FF; /* Pour la rptition */

    if (key & KEY_DIAMOND) switch (key ^ KEY_DIAMOND) {
      case KEY_ON : off();
#ifdef ALPHALOCK
	{unsigned char c; alphaLockOn (&c);} /* off enlve le alpha-lock */
#endif
	break;
      case KEY_STO : F2_CHANGEB (B_FIXED_FONT); break; /* change de police */
      case KEY_MODE : F1_CHANGEB (B_TANDY); break; /* change le Mystrieux Bit Tandy */
/*       case 'Y' : wrapping = !wrapping; break; */
      case KEY_ESC : quit();
#ifdef INTERPNUM
    case KEY_APPS : data_head.interpreter_number++; data_head.interpreter_number %= 12; break;
#endif
#ifdef GTKTIEMU
    case '^' : key = 'f'; break;
#endif
#ifdef DEBUG
    case 'X' : tracing = !tracing; break;
#endif
      default : key ^= KEY_DIAMOND; /* redonne le code SANS alpha -> pratique pour taper , ou .*/
    }
    if (key >= ' ' && key <= '~' && i < maxlen - 1) buffer[i++] = key;
    else if (key == KEY_BACKSPACE && i) i--;
    else if (key == KEY_CLEAR) i = 0;
    else if (key == KEY_ESC)
      return -1; /* Pour annuler... */
    buffer[i] = 0;
  } while (key != KEY_ENTER);
  ligne_courante = -nb_lignes_a_garder; /* je suppose qu'on se souvient de ce qu'on vient
					   d'crire... */
  va_a_la_ligne();
  return i;
}

/******************************************************/
/*             deuxime fentre                       */
/******************************************************/


inline void scr_window (int size) {
#ifdef DEBUG1
  if (tracing) {
    char buf[50];
    sprintf (buf, "split_screen : %hd", size);
    ecrit_texte (buf);
    ngetchx();
    va_a_la_ligne();
  }
#endif
  if (size >= LCD_HEIGHT / 6) {
    taille_up_win = LCD_SIZE - (LCD_SIZE % (6 * OCTETS_PAR_LIGNE));
    position_x = LCD_WIDTH; /* force l'effacement de la dernire ligne avant toute criture
			       dans la fentre principale */
  }
  else
    taille_up_win = size * 6 * OCTETS_PAR_LIGNE;
  if (STANDARD) memset (LCD_MEM, 0, taille_up_win);
}

inline void scr_set_win (int win) {
#ifdef DEBUG1
  if (tracing) {
    char buf[50];
    sprintf (buf, "set_win : %hd", win);
    ecrit_texte (buf);
    ngetchx();
    va_a_la_ligne();
  }
#endif
  if (win) {
    pos_x_upper_win = 0;
    pos_y_upper_win = 0;
    upper_win_active = TRUE;
  }
  else upper_win_active = FALSE;
}

static void scr_newline_upper_win () {
  pos_y_upper_win += 6 * OCTETS_PAR_LIGNE;
  if (pos_y_upper_win < taille_up_win)
    pos_x_upper_win = 0;
  else pos_x_upper_win = 0xFFFF;
}

static inline void scr_putchar_upper_win (word car) {

  if (pos_x_upper_win == 0xFFFF) return; /* 0xFFFF = hors fentre -> on clippe */

  print_char_fixed_font (car, pos_x_upper_win, pos_y_upper_win);

  if (pos_x_upper_win < MAX_X) pos_x_upper_win++;
  else if (WRAPPING) scr_newline_upper_win ();
  else pos_x_upper_win = 0xFFFF;
}

#ifdef VERSION_QUATRE

static void display_cursor (Bool on_or_off) {
  word x = pos_x_upper_win; word y = pos_y_upper_win;
  scr_putchar_upper_win (on_or_off ? '_' : ' ');
  pos_x_upper_win = x; pos_y_upper_win = y;
}

static inline void erase_window (word param) {
#ifdef DEBUG1
  if (tracing) {
    char buf[50];
    sprintf (buf, "erase_window : %hd", param);
    ecrit_texte (buf);
    ngetchx();
    va_a_la_ligne();
  }
#endif
  switch ((signed) param)
    {
    case -1 : taille_up_win = 0;
      upper_win_active = FALSE;
    case -2 : ClrScr();
      pos_x_upper_win = 0;
      pos_y_upper_win = 0;
reinitialise_main_win :
      ligne_courante = 1 - nb_lignes_a_garder;
      position_x = -1;
      break;
    case 0 : if (OCTETS_PAR_LIGNE * LCD_HEIGHT > taille_up_win) /* sinon a va dconner */
      memset (LCD_MEM + taille_up_win, 0,
	      LCD_HEIGHT * OCTETS_PAR_LIGNE - taille_up_win);
      goto reinitialise_main_win;
    case 1 : memset (LCD_MEM, 0, taille_up_win);
      pos_x_upper_win = 0;
      pos_y_upper_win = 0;
    }
}
static inline void erase_line (word param) {}
static inline void set_cursor(word posy, word posx) {
#ifdef DEBUG1
  if (tracing) {
    char buf[50];
    sprintf (buf, "Position curseur : %hu, %hu", posy, posx);
    ecrit_texte (buf);
    ngetchx();
    va_a_la_ligne();
  }
#endif
  if (upper_win_active) {
    pos_x_upper_win = posx - 1;
    pos_y_upper_win = (posy - 1) * 6 * OCTETS_PAR_LIGNE;
    if (story == AMFV) switch (pos_x_upper_win)
      {
      case 66 :  /* date / heure */
	pos_x_upper_win = MAX_X - 9; break;
      case 26 :
      case 27 : /* colonne de droite en library mode */
	if (TI89) pos_x_upper_win -= 7; break;
      case 29 ... 40 :
	pos_x_upper_win -= 40 - (MAX_X + 1) / 2;
      }
    else if (story == TRINITY) {
      if (pos_x_upper_win > 10) /* Je suppose qu'il tente de centrer du texte */
	pos_x_upper_win -= 40 - (MAX_X + 1) / 2;
      if ((signed) pos_x_upper_win < 0)
	pos_x_upper_win = 0;
    }
    if (pos_x_upper_win > MAX_X || pos_y_upper_win >= taille_up_win)
      pos_x_upper_win = 0xFFFF; /* 0xFFFF signifie hors fentre */
  }
}
static inline void get_cursor(word adresse) {
  byte *ptr = base_ptr + adresse;
#ifdef DEBUG1
  if (tracing) {
    ecrit_texte ("get_cursor");
    ngetchx();
    va_a_la_ligne();
  }
#endif
  ptr[0] = 0;
  ptr[1] = pos_y_upper_win / (6 * OCTETS_PAR_LIGNE) + 1;
  ptr[2] = 0;
  ptr[3] = pos_x_upper_win + 1;
}


static inline void scr_font_style (word style) {
  flush_text_buffer();
#ifdef DEBUG1
  if (tracing) {
    char buf[50];
    sprintf (buf, "font_style : %hu", style);
    ecrit_texte (buf);
    ngetchx();
    va_a_la_ligne();
  }
#endif
  if (!upper_win_active) {
    if (((style & FIXED) && !F2_IS_SET(B_FIXED_FONT)) ||
	(!style && (F2_IS_SET(B_FIXED_FONT)) && (font_style & FIXED))) {
      F2_CHANGEB(B_FIXED_FONT);
      va_a_la_ligne();
    }
#ifndef NO_STAR_ITALIC
    else if (((style & ITALIC) && !(font_style & ITALIC)) || (!style && (font_style & ITALIC)))
      print_char ('*');
#endif
  }
  if (style) font_style |= style;
  else font_style = 0;
}
#endif /* VERSION_QUATRE */
