#include <stdio.h>
#include <string.h>
#include <unistd.h>
#ifdef DOS
#define DIRSEP '\\'
#else
#define DIRSEP '/'
#endif

#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <ttversion.h>
#include <revtools.h>
#include <tt.h>
#include <strhead.h>
#include <ttarchive.h>
#include <bin2oth.c>
#include <packhead.h>
#define EMBEDDED_USE
#include <ttarchive.c>

void efface_fichiers_temp () {
  int i;
  char fichier[] = "tmp__cfgfile";
  remove (fichier);
  for (i = 0; i < 64; i++) {
    sprintf (fichier, "tmp__%02d", i);
    remove (fichier);
  }
}

int reconnait_amfv (char *ptr) {
  return ((ptr[2] == 0) && (ptr[3] == 77) && !strncmp (ptr + 18, "850814", 6));
}

int process_file (int calctype, const char *nom_du_fichier) {
  int i;
  int est_amfv;
  int fini = 0;
  long position;
  char *ptr;
  char nom_fic[8];
  char extension[] = "ZC0";
  char nomfic_ti[9];
  char *ttarchive_args[] =
    {"ttarchive", calctype ? "-92" : "-89", "-e", extension, "tmp__cfgfile", nomfic_ti, "zcode"};
  char buffer[4096];
  FILE *fichier_depart = fopen (nom_du_fichier, "rb");
  FILE *fichier_arrivee;
  FILE *fichier_liste;
  if (!fichier_depart)
    return 1;
  
  fread (buffer, 24, 1, fichier_depart);
  rewind (fichier_depart);
  est_amfv = reconnait_amfv (buffer);
  
  fichier_liste = fopen("tmp__cfgfile", "wt");
  if (!fichier_liste) {
    fprintf (stderr, "Error opening temporary file tmp__cfgfile\n");
    efface_fichiers_temp ();
    return 1;
  }
  sprintf (nomfic_ti, "%.7s", nom_du_fichier);
  /* Remove extension if there is one... */
  ptr = strchr (nomfic_ti, '.');
  if (!ptr) ptr = strchr (nomfic_ti, 0);
  *ptr = '0';
  ptr[1] = 0;

  for (i = 0; i < 64;) {

    sprintf(nom_fic, "tmp__%02d", i);
    fichier_arrivee = fopen (nom_fic, "wb");
    if (!fichier_arrivee) {
      fprintf (stderr, "Error opening temporary file %s\n", nom_fic);
      efface_fichiers_temp ();
      return 1;
    }
    position = ftell (fichier_depart);
    
    if (!fread (buffer, 4096, 1, fichier_depart)) {
      int c;
      fseek (fichier_depart, position, SEEK_SET);
      while ((c = fgetc (fichier_depart)) != EOF)
	fputc (c, fichier_arrivee);
      fclose (fichier_depart);
      fclose (fichier_arrivee);
      fprintf (fichier_liste, "%s fin 0 1 compress\n", nom_fic);
      fini = 1;
    }
    else {
      if (est_amfv && (i == 0x33)) {
	buffer[0x450] = 0;
	buffer[0x451] = 0xB0;
      }

      fwrite (buffer, 4096, 1, fichier_arrivee);
      fclose (fichier_arrivee);
      
      fprintf (fichier_liste, "%s %2d 0 0 compress\n", nom_fic, i);
    }

    if (++i % 16 == 0 || fini) {
      fclose (fichier_liste);
      (*ptr)++;
      extension[2]++;
      if (TTArchive (7, ttarchive_args)) {
	fprintf (stderr, "\nttarchive error\n");
	efface_fichiers_temp();
	return 1;
      }
	
      if (fini) break;
      else fichier_liste = fopen("tmp__cfgfile", "wt");
      if (!fichier_liste) {
	fprintf (stderr, "Error opening temporary file tmp__cfgfile\n");
	efface_fichiers_temp ();
	return 1;
      }
    }
  }
  efface_fichiers_temp ();
  return 0;
}

int main (int argc, char **argv) {
  int calctype = -1;
  int i;
  int ret = 0;
  char cwd[1024];
  if (argc >= 3) {
    if (!strcmp ("-89", argv[1])) calctype = 0;
    else if (!strcmp ("-92", argv[1])) calctype = 1;
  }
  else if (argc < 2 || argv[1][0] == '-') {
    printf ("Usage : %s [-89|-92] <Z-code story files>\n", argv[0]);
    return 1;
  }
  if (calctype < 0) {
    printf ("Generate files for which calculator ? 0 : TI-89 -- 1 : TI-92+\n> ");
    while (!scanf ("%d", &calctype) || (calctype && calctype != 1))
      printf ("Please type 0 for TI-89 or 1 for TI-92+ ; Ctrl-C to cancel.\n> ");
    i = 1;
  }
  else i = 2;
  if (!getcwd (cwd, 1024)) {
    fprintf (stderr, "Warning : CWD name too long. Expect problems if you used several"
	     " relative filenames.\n");
    cwd[0] = 0;
  }
  for ( ; i < argc; i++) {
    char *ptr;
    if (ptr = strrchr (argv[i], DIRSEP)) {
      char directory[++ptr - argv[i] + 1];
      memcpy (directory, argv[i], ptr - argv[i]);
      directory[ptr - argv[i]] = 0;
      if (chdir (directory)) {
	fprintf (stderr, "Unable to change working directory to %s\n", directory);
	fprintf (stderr, "Skipping file %s\n", argv[i]);
	continue;
      }
    }
    else ptr = argv[i];
    if (process_file (calctype, ptr)) {
      fprintf (stderr, "Error processing file %s\n", argv[i]);
      ret++;
    }
    chdir (cwd);
  }
  return ret;
}
