!! ZSndDefs.h
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!! V6Lib
!! Copyright 1997-2000 Jason C. Penney (jpenney@chelmsford.com)
!! May be freely redistributed, as long as it is unchanged
!! May be used in any non-commercial game as long as V6Lib version
!!  info is displayed in the game.  By default the library does this
!!  itself via the Version function included in V6.h.
!! May be used in any commercial game with my written permission.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
Message "[Including <ZSndDefs>]";
#Ifndef ZSndDefs_h;
Constant ZSndDefs_h;

Constant RP_FOREVER 255;
Constant V_MAX 255;

#ifdef MAXZSNDS;
Message "Including support for dynamic sound objects";
#endif;

Class 	ZSnd_sub
 private sndnum 0,
	volume V_MAX,
	SoundEffect [effect reps routine vol sn;
	    sn = self.sndnum;
	    vol = (reps * 256) + self.volume;
	    @sound_effect sn effect vol routine;
	],
 with	GetVolume [;
	    return self.volume;
	],
	SetVolume[ vol;
	    self.volume = vol;
	],
	Prepare [;
	    self.SoundEffect(1);
	],
	Finish[;
	    self.SoundEffect(4);
	],
	Stop[;
	    self.SoundEffect(3);
	],
	Play[ reps routine;
	    if (reps == 0)
		reps = 1;
	    self.SoundEffect(2,reps,routine);
	],
	Fade[ sv fv steps;
	    if (fv - sv)
	    {
		Fade_tmp.Setup(sv,fv,steps,self.sndnum);
		DoFade();
	    }
	    else
	    {
		self.SetVolume(sv);
		self.Play(steps);
	    }
	];

#ifdef MAXZSNDS;
Class 	ZSnd(MAXZSNDS)
 class	ZSnd_sub,
 with 	create [ num;
	    self.sndnum = num;
	],
	destroy[;
	];

#ifnot;
Class 	ZSnd
 class 	ZSnd_sub;
#endif;


#Endif;

