! Pathmaker for Triform (release 2)
! Based upon copyrighted code created by Jim Fisher
!
! License: 
! This work is licensed under the Creative Commons Attribution-ShareAlike License
! (http://creativecommons.org/licenses/by-sa/1.0/).
!
! In summary: you must credit the original author(s); if you alter, transform, or 
! build upon this software, you may distribute the SOURCE FORM of the resulting 
! work only under a license identical to this one. Note that the ShareAlike clause 
! does not affect the way in which you distribute the COMPILED FORM of works built upon
! this software. Copyright remains with the original author(s), from whom you
! must seek permission if you wish to vary any of the terms of this license.
! The author(s) would also welcome bug reports and enhancement suggestions.
!
!
!
! The PathMaker object will determine a path between two rooms.  Two starting objects 
! are taken by the determine_path routine. These can be rooms or objects.
! Passage through doors is resolved without regard to whether they are locked.
!
! Sample use:
!
!	PathMaker.determine_path(player, bathroom);
!
!	PathMaker.determine_path(bathroom, bedroom);
!
! The return values for this routine are:
!	
!	-1 : There is no connecting path between the two given objects.
!	-2 : Ran out of workspace while trying to calculate path.  Define the constant
!			PATHDEPTH with a larger than default value.
!	-3 : Although there WAS a path correctly determined, there was NOT enough space in 
!			the path property to contain it. 
!	room obj : The first connected room that must be traveled to in order to finally reach
!			the destination.
!
! Additionally, once the path has been correctly determined, the size property contains 
! the size and the path property contains the final path.
!
! It is also possible to compare two paths, by either finding the length difference between
! them, or by finding they point at which they converge (if any).
!
! Sample use:
!
!	PathMaker.compare_paths(A, B, A, C, false);
!		--> returns the size difference between the path from A to
!		B and the path from A to C (path 1 minus path 2).
!
!	PathMaker.compare_paths(A, B, A, C, true);
!		--> returns the room where the paths A->B and A->C converge, or 0 if there is none.
!		(in progress, very simplistic right now)
!
!	PathMaker.compare_paths(A, B, A, C, D);
!		--> returns true if D is found in both paths A->B and A->C
!
!
! There is a limited amount of scratch workspace used to determine a correct path. If 
! there is not enough space, the path will not be findable. The constant PATHDEPTH
! is used to allocate this scratch space. By default it is set to 30, but can be 
! defined at a greater value in your program's source.

message " Processing library extension 3PathMaker...";

	#Ifndef PATHDEPTH;
	Constant PATHDEPTH 30;
	#Endif;

	Array __pathmaker_room-->PATHDEPTH;

	Array __pathmaker_distance->PATHDEPTH;

	Constant USE_PathMaker;

	Object PathMaker
	with
		path 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0,
		path2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0,
		end_ptr	0,
		cur_ptr	0,
		size 0,
		npc	PathMaker, !--self if not defined...strange, but it will work
		find_room_distance
		[ room t;

			for(t=0:t<self.end_ptr:t++) {
				if(__pathmaker_room-->t==room) 
					return __pathmaker_distance->t;
			}
			return -1;
		],
		add
		[ room level;

			if(self.find_room_distance(room)==-1) {
				__pathmaker_room-->self.end_ptr=room;
				__pathmaker_distance->self.end_ptr=level;
				self.end_ptr++;
			}
		],
		compare_paths
		[ room1 room2 room3 room4 flag val1 val2 x;

			self.determine_path(room1, room2, false); val1 = self.size;

			self.determine_path(room3, room4, true); val2 = self.size;

			if (flag == 0) return val1 - val2;

			if (flag == 1) {
				val1--; val2--;

				while (self.&path-->val1 == self.&path2-->val2) {
					val1--; val2--; x++;
				}

				if (x) return self.&path-->++val1;
				rfalse;
			}

			if (flag ofclass Room) {
				val1 = 0; val2 = 0;
				while (x < 18) {
					if (self.&path-->x == flag) val1++;
					if (self.&path2-->x == flag) val2++;
					x++;
				}
				return (val1 && val2);
			}
		],
		determine_path
		[ npc_cntx endroom flag t startroom;

			if (npc_cntx ofclass Thing) npc_cntx = npc_cntx.location;
			startroom = npc_cntx;
			self.npc = npc_cntx;

			if(endroom ofclass Thing) endroom=endroom.location;

			if(startroom==endroom) return 0;

			for(t=0:t<self.end_ptr:t++) { 	!-- first, clear everything out
				__pathmaker_room-->t=0;
				__pathmaker_distance->t=0;
			}

			self.end_ptr=self.cur_ptr=0;
			self.add(startroom,0); 
			t=self.process(endroom);

			if(t<0) return t; !--- Errors? -1: not reachable; -2: out of workspace

!---all was good, let's fill in the path property and return (either an error or the first room in the list...)

			return self.unwind_path(flag); 
		],
		process
		[ endroom r cr cl t;

			while(self.cur_ptr<self.end_ptr) {
				cr=__pathmaker_room-->(self.cur_ptr);
				cl=self.find_room_distance(cr);

				objectloop(t in compass && t provides door_dir) {
					if(cr provides (t.door_dir)) {
						r=cr.(t.door_dir);
						if(r ofclass Room || r ofclass Door) {

								if (r ofclass Door) r = r.door_to(self.npc);

								!--success.  return needed size for path

								self.add(r,cl+1);
								if(r==endroom) return cl+1;

								if(self.end_ptr>PATHDEPTH)
									return -2; !--Out of space
								}
							}
						}
						self.cur_ptr++;
					}
					return -1; !--completed search, with no possible path found
				],
		unwind_path
		[ flag pos d room r t;

!--called once if the search algorithm has completed successfully,
!--to find the shortest path and put it in the property pointed to by self.path

			room=__pathmaker_room-->(self.end_ptr-1); !--locate the endroom
			self.size=pos=self.find_room_distance(room); !--size of path 
					
			if((self.#path/WORDSIZE)<pos) return -3; !--path too small
				while(pos>0) {
					if (flag == 0) self.&path-->(pos-1)=room;
					else self.&path2-->(pos-1)=room;
					objectloop(d in compass && d provides door_dir) {
						if(room provides (d.door_dir)) {
							r=room.(d.door_dir);
							if(r~=0) {
								if (r ofclass Door) r = r.door_to(self.npc);
								t=self.find_room_distance(r);
								if(t>-1 && t<pos) break;
							}
						}
					}
				room=r;
				pos--;
			}
			if (flag == 0) return self.&path-->0;
			else return self.&path2-->0;
		];