! Replacement for "WriteListFrom()".
! Version 0.98 of 14-April-97
! by Andreas Hoppler. Parts (lots) of this code by Graham Nelson.
!
! Andreas Hoppler ("andreas.hoppler@logon.ch")
! Zurich, Switzerland


Property lister_kind 0;
Global   list_many;
Global   list_left;

ifndef NO_ALIASES;
    Property  List__MiscMessage alias out_to;
    Property  List__R alias in_to;
    Property  List__SingleEntry alias s_to;
    Property  List__MultipleEntry alias n_to;
    Property  List__BeforeEntry alias w_to;
    Property  List__AfterEntry alias e_to;
    Property  List__Recurse alias d_to;
    Property  List__NoInv alias nw_to;
    Property  List__PartInv alias ne_to;
    Property  List__FullInv alias se_to;
endif;

[ TogetherClass l  y;
    y=metaclass(l.list_together);
#ifdef TOGETHER_OBJECT;
        if (y==Class || (y==Object && ~~l.list_together ofclass Lister))
                return Nothing;
#ifnot;
        if (y==Class or Object)
                return Nothing;
#endif;
    return y;
];

Class   Lister,
   with capacity 0,

        List__MiscMessage[ id parm;
            ! another chance to override the messages produced
            return L__M( ##ListMiscellany, id, parm );
        ],

        List__R [ o depth stack_pointer   classes_p sizes_p i j k k2 l m n q mr senc;
                        ! The main listing routine
            if (depth>0 && o==child(parent(o)))
            {   SortOutList(o); o=child(parent(o)); }

            for (::)  ! find first listed child
            {   if (o==0) rfalse;
                if (c_style & WORKFLAG_BIT ~= 0 && depth==0 && o hasnt workflag)
                {   o = sibling(o); continue; }
                if (c_style & CONCEAL_BIT ~= 0
                    && (o has concealed || o has scenery))
                {   o=sibling(o); continue; }
                break;
            }

            classes_p = match_classes + stack_pointer;
            sizes_p   = match_list + stack_pointer;

            ! k=number of listable objects that might plural
            ! j=number of listable objects
            ! also, init classes
            for (i=o,j=0:i~=0 && (j+stack_pointer)<128:i=NextEntry(i,depth),j++)
            {   classes_p->j=0;
                if (i.plural~=0) k++;
            }

            if (c_style & ISARE_BIT ~= 0)
            {
                ! print 'is' / 'are'
                if (c_style & NEWLINE_BIT ~= 0) {
                    if (j==1) m=1001; else m=1003;
                } else {
                    if (j==1) m=1002; else m=1004;
                }
                self.List__MiscMessage( m, o );
                c_style = c_style - ISARE_BIT;
            }

            stack_pointer = stack_pointer+j+1;

            if (k<2) jump EconomyVersion;   ! It takes two to plural

            ! gather identical objects together
            n=1;
            for (i=o,k=0:k<j:i=NextEntry(i,depth),k++)
                if (classes_p->k==0)
                {   classes_p->k=n; sizes_p->n=1;
                    for (l=NextEntry(i,depth), m=k+1:l~=0 && m<j:
                         l=NextEntry(l,depth), m++)
                        if (classes_p->m==0 && i.plural~=0 && l.plural~=0)
                        {   if (ListEqual(i,l)==1)
                            {   sizes_p->n = sizes_p->n + 1;
                                classes_p->m = n;
                            }
                        }
                    n++;
                }
            n--;

!!          print "^";
            for (i=1, j=o, k=0, senc=0: i<=n: i++, senc++)
            {   while (((classes_p->k) ~= i)
                       && ((classes_p->k) ~= -i)) { k++; j=NextEntry(j,depth); }
                m=sizes_p->i;
!!              print "[m=", m, ", i=", i, ", j=", j, ", senc=", senc, "] ";
                if (j.list_together~=0 or lt_value
                    && TogetherClass(j) != Nothing
                    && j.list_together==mr) senc--;
!!              print "[m=", m, ", i=", i, ", j=", j, ", senc=", senc, "]^";
                mr=j.list_together;
            }
            senc--;
            for (i=1, j=o, k=0, mr=0: senc>=0: i++, senc--)
            {   while (((classes_p->k) ~= i)
                       && ((classes_p->k) ~= -i)) { k++; j=NextEntry(j,depth); }
                if (j.list_together~=0 or lt_value)
                {   if (j.list_together==mr) { senc++; jump Omit_FL2; }
                    k2=NextEntry(j,depth);
                    if (k2==0 || k2.list_together~=j.list_together) jump Omit_WL2;
                    k2=TogetherClass(j);
                    if (k2 ~= Nothing)   ! nontrivial list_together
                    {   q=j; listing_size=1; l=k; m=i;
                        while (m<n && q.list_together==j.list_together)
                        {   m++;
                            while (((classes_p->l) ~= m)
                                   && ((classes_p->l) ~= -m))
                            {   l++; q=NextEntry(q,depth); }
                            if (q.list_together==j.list_together) listing_size++;
                        }
                        ! print " [", listing_size, "] ";
                        if (listing_size==1) jump Omit_WL2;

                        if (c_style & INDENT_BIT ~= 0)
                            Print__Spaces(2*(depth+wlf_indent));

                        q=0;
                        if (k2==String)
                        {   for (l=0:l<listing_size:l++) q=q+sizes_p->(l+i); }

                    #ifdef TOGETHER_OBJECT;
                        if (k2==Object)
                            l=j.list_together;
                        else
                            l=DefaultTogether__lister;
                    #ifnot;
                        l=DefaultTogether__lister;
                    #endif;
                        l.List__Recurse( q, j, depth, stack_pointer );

                        mr=j.list_together;
                        jump Omit_EL2;
                    }
                }

               .Omit_WL2;
                list_left = senc;
                q = GetListerKind(j);
                if (q.List__BeforeEntry(j,depth)==1) jump Omit_FL2;
                if (sizes_p->i == 1)
                    q.List__SingleEntry(j);
                else
                    q.List__MultipleEntry(j,sizes_p->i);
                q.List__AfterEntry(j,depth,stack_pointer);

               .Omit_EL2;
                if (c_style & ENGLISH_BIT ~= 0) {
                    list_left = senc;
                    self.List__Glue(i);
                }
               .Omit_FL2;
            }
            rtrue;

           .EconomyVersion;
            ! no plurals possible here, but list_toghether still applies

            n=j;

            for (i=1, j=o: i<=n: j=NextEntry(j,depth), i++, senc++)
            {   if (j.list_together~=0 or lt_value
                    && TogetherClass(j) != Nothing
                    && j.list_together==mr) senc--;
                mr=j.list_together;
            }

            for (i=1, j=o, mr=0: i<=senc: j=NextEntry(j,depth), i++)
            {   if (j.list_together~=0 or lt_value)
                {   if (j.list_together==mr) { i--; jump Omit_FL; }
                    k=NextEntry(j,depth);
                    if (k==0 || k.list_together~=j.list_together) jump Omit_WL;

                    k=TogetherClass(j);

                    if (k~=Nothing) ! routine or string or lister
                    {
                        if (c_style & INDENT_BIT ~= 0)
                            Print__Spaces(2*(depth+wlf_indent));

                        q = 0;
                        if (k==String) ! string
                        {   l=j;
                            do
                            {   l=NextEntry(l,depth); q++;
                            } until (l.list_together~=j.list_together);
                        }

                   #ifdef TOGETHER_OBJECT;
                        if (k==Object)
                            l=j.list_together;
                        else
                            l=DefaultTogether__lister;
                    #ifnot;
                        l=DefaultTogether__lister;
                    #endif;
                        l.List__Recurse( q, j, depth, stack_pointer );

                        mr=j.list_together;
                        jump Omit_EL;
                    }
                }
               .Omit_WL;
                list_left = senc-i;
                q = GetListerKind(j);
                if (q.List__BeforeEntry(j,depth)==1) jump Omit_FL;
                q.List__SingleEntry(j);
                q.List__AfterEntry(j,depth,stack_pointer);

               .Omit_EL;
                if (c_style & ENGLISH_BIT ~= 0) {
                    list_left = senc-i;
                    self.List__Glue( i );
                }
               .Omit_FL;
            }
        ],

        ! print text between entries
        List__Glue [ nprinted;
            if (list_left==1) print (string) AND__TX;
            if (list_left>1)  print ", ";
            nprinted=0;        ! avoid compiler warnings
        ],

        List__SingleEntry [ o;
            if (c_style & NOARTICLE_BIT ~= 0) {
                print (name) o;
            } else {
                if (c_style & DEFART_BIT ~= 0) {
                    print (the) o;
                } else {
                    print (a) o;
                }
            }
        ],

        List__MultipleEntry [ o nr;
            if (c_style & DEFART_BIT ~= 0)
                PrefaceByArticle(o, 1, true); ! o acode pluralize
            print (number) nr, " ";
            PrintOrRun(o,plural,1);
        ],

        ! replaces WriteBeforeEntry
        List__BeforeEntry [ o depth  flag;
            if (c_style & INDENT_BIT ~= 0)
                Print__Spaces(2*(depth+wlf_indent));

            flag = 0;
            if (c_style & FULLINV_BIT ~= 0)
            {   if (o.invent~=0)
                {   inventory_stage=1;
                    flag=PrintOrRun(o,invent,1);
                    if (flag==1 && c_style & NEWLINE_BIT ~= 0) new_line;
                }
            }
            return flag;
        ],

        ! used if neither FULLINV_BIT nor PARTINV_BIT is set
        List__NoInv [; ! o
            return 0;
        ],

        ! used if PARTINV_BIT is set
        List__PartInv [ o;
            if (o has light && location hasnt light)
                self.List__MiscMessage(1, o); ! licht
            return 0;
        ],

        ! used if FULLINV_BIT is set
        List__FullInv [ o  msg;
            if (o.invent ~= 0)
            {   inventory_stage=2;
                if (RunRoutines(o,invent)~=0)
                {   if (c_style & NEWLINE_BIT ~= 0) new_line;
                    return 2;
                }
            }
            msg=-1;
            if (o has light) {
                if (o has worn) msg = 8;
                else            msg = 9;
            } else {
                if (o has worn) msg = 10;
            }
            if (msg >= 0) {
                self.List__MiscMessage( msg, o );
                return 1;
            }
            rfalse;
        ],

        ! Replaces WriteAfterEntry
        List__AfterEntry [ o depth stack_p   flag2 flag3 p;

            if (c_style & PARTINV_BIT ~= 0)
                flag2 = self.List__PartInv( o );
            else if (c_style & FULLINV_BIT ~= 0) {
                flag2 = self.List__FullInv( o );
            } else {
                flag2 = self.List__NoInv( o );
            }
            if (flag2==2) rtrue;
            if (flag2==1) print ")";

            ! flag3 = number of children to be listed
            ! flag2 = first child to be listed
            if (c_style & CONCEAL_BIT == 0)
            {   flag3 = children(o);
                flag2 = child(o);
            }
            else
            {   flag3 = 0; flag2 = 0;
                objectloop (p in o)
                    if (p hasnt concealed && p hasnt scenery) {
                        flag3++;
                        if (flag2==0) flag2 = p;
                    }
            }

            p = false;
            if (flag3>0 && c_style & (ALWAYS_BIT+RECURSE_BIT) ~= 0) {
                ! Try recursion
                list_many = flag3;
                if (flag2 has pluralname) list_many++;
                p = self.List__Recurse( o, flag2, depth, stack_p );
            }
            if (c_style & NEWLINE_BIT ~= 0 && p == 0) new_line;
        ],

        ! base message number used for contents
        number 1021,

        ! try to list downwards
        List__Recurse [ obj child depth stack_p  m save_case;

            ! A lister will only recurse if it has the transparent attribure,
            ! or if the ALWAYS_BIT is set
            if (c_style & ALWAYS_BIT == 0 && self hasnt transparent) rfalse;

            #ifdef short_name_case;
                ! case will be restored at end of list
                save_case = short_name_case;
            #endif;

            if (c_style & ENGLISH_BIT ~= 0) {
                m = self.number;
                if (c_style & TERSE_BIT ~= 0)
                    m = m + 2;
                self.List__MiscMessage( m, obj );
            }

            if (c_style & NEWLINE_BIT ~= 0) new_line;

            self.List__R(child, depth+1, stack_p);

            if (c_style & ENGLISH_BIT ~= 0) {
                self.List__MiscMessage( m+1, obj );
            }

            #ifdef short_name_case;
                short_name_case = save_case;
            #ifnot;
                save_case = 0;      ! avoid compiler errors
            #endif;

            rtrue;
        ],


        List__Locale [ descin text1 text2   o p k j flag f2;
                        ! replacement for 'Locale' routine
            k=0;
            objectloop (o in descin) {
                give o ~workflag;
                if (o hasnt concealed && o~=parent(player))
                {
                    if (o hasnt scenery)
                    {   give o workflag; k++;
                        p=initial; f2=0;
                        if ((o has door || o has container)
                            && o has open && o provides when_open)
                        {   p = when_open; f2 = 1; jump Prop_Chosen; }
                        if ((o has door || o has container)
                            && o hasnt open && o provides when_closed)
                        {   p = when_closed; f2 = 1; jump Prop_Chosen; }
                        if (o has switchable
                            && o has on && o provides when_on)
                        {   p = when_on; f2 = 1; jump Prop_Chosen; }
                        if (o has switchable
                            && o hasnt on && o provides when_off)
                        {   p = when_off; f2 = 1; }

                        .Prop_Chosen;

                        if (o hasnt moved || o.describe~=NULL || f2==1)
                        {   j = 0;
                            if (o.describe~=NULL)
                            {
                                j = RunRoutines(o, describe);
                                if (j~=0)
                                {
                                    give o ~workflag; k--;
                                    if (j~=2) {
                                        flag==1;
                                        #ifndef SIMPLE_PRONOUNS;
                                        PronounNotice(o);
                                        #endif;
                                    }
                                }
                            }
                            if (j==0)
                            {
                                #ifndef SIMPLE_PRONOUNS;
                                PronounNotice(o);
                                #endif;

                                j=o.p;
                                if (j~=0)
                                {   new_line;
                                    PrintOrRun(o,p);
                                    flag=1;
                                    give o ~workflag; k--;
                                    if (o has supporter && child(o)~=0) SayWhatsOn(o);
                                }
                            }
                        }
                    }
                    else
                        if (o has supporter && child(o)~=0) SayWhatsOn(o);
                }
            }
            if (k==0) return 0;

            if (text1~=0)
            {   new_line;
                if (flag==1) text1=text2;
                print (string) text1, " ";
                WriteListFrom(child(descin),
                    ENGLISH_BIT + WORKFLAG_BIT + RECURSE_BIT
                    + PARTINV_BIT + TERSE_BIT + CONCEAL_BIT);
                return k;
            }

            if (flag==1) L__M(##Look,5,descin); else L__M(##Look,6,descin);
        ];



Class   Together__Lister class Lister,
                ! used for list_together processing
   with number 1011,
        List__Recurse [ num o depth stack_p  msg k save_case save_style;

            #ifdef short_name_case;
                save_case = short_name_case;
            #endif;

            save_style=c_style;

            k = o.list_together;
            msg = self.number;
            list_many = num;
            if (k ofclass Routine) {
                inventory_stage=1;
                parser_one=o; parser_two=depth+wlf_indent;
                if (RunRoutines(o,list_together)==1) jump Omit__Sublist;
            } else {
                if (c_style & ENGLISH_BIT ~= 0) msg = msg+2;
                else if (c_style & INDENT_BIT ~= 0) msg = msg+4;
                self.List__MiscMessage( msg, k );
            }

            lt_value=o.list_together; listing_together=o;
            ++wlf_indent;

            self.List__R(o,depth,stack_p);

            --wlf_indent;
            lt_value=0; listing_together=0;

            if (k ofclass Routine) {
                inventory_stage=2;
                parser_one=o; parser_two=depth+wlf_indent;
                RunRoutines(o,list_together);
            } else {
                self.List__MiscMessage( msg+1, k );
            }

           .Omit__Sublist;
            if (save_style & NEWLINE_BIT ~= 0 && c_style & NEWLINE_BIT == 0) new_line;
            c_style=save_style;

            #ifdef short_name_case;
                short_name_case = save_case;
            #ifnot;
                save_case = 0; ! avoid compiler errors
            #endif;

        ];

Together__Lister DefaultTogether__Lister "(DefaultTogether__Lister)";

Class   Cnr__Lister
! for containers
  class Lister
   with number 1029,
        List__PartInv [ o comb;
            comb=0;
            if (o has light && location hasnt light) comb=comb+1;
            if (o has openable && o hasnt open)      comb=comb+2;
            if (self has transparent
                && (child(o)==0)) comb=comb+4;
            if (comb>0)
                self.List__MiscMessage(comb, o);
        ],
        List__FullInv [ o  flag msg;
#ifdef DOESNTWORK;
            flag = self.Lister::List__FullInv( o );
#ifnot;
            flag = Default__Lister.List__FullInv( o );
#endif;
            if (flag==2) return 2;

            msg = -1;
            if (o has openable) {
                if (flag==1) print (string) AND__TX;   ! "and"
                else self.List__MiscMessage( 11, o );  ! "("

                if (o has open) {
                    if (child(o)==0) msg = 13; ! open, empty
                    else             msg = 12; ! open
                }
                else {
                    if (o has lockable && o has locked)
                          msg = 15;   ! locked
                    else  msg = 14;   ! closed
                }
                flag=1;
            }
            else {            ! container, not openable
                if (child(o)==0) {
                    if (flag==1) msg = 16; ! and empty
                    else         msg = 17; ! (empty)
                }
            }
            if (msg>=0) self.List__MiscMessage(msg, o);
            return flag;
        ];


Cnr__Lister OpenCnr__Lister "(OpenCnr__Lister)",                ! open container
    has transparent;

Cnr__Lister TransparentCnr__Lister "(TransparentCnr__Lister)",  ! transparent, closed container
    has transparent;

Cnr__Lister SimpleCnr__Lister "(SimpleCnr__Lister)",    ! non-transparent, closed container
    has ~transparent;

Lister  Supporter__Lister "(Supporter__Lister)",                ! supporter
    has transparent,
   with number 1025;

Lister  Default__Lister "(Default__Lister)",                    ! any other object
    has ~transparent;

Lister  Top__Lister "(Top__Lister)",                                    ! top level
    has transparent;

[ GetListerKind obj  lstr;
        ! Try to let the object itself determine its lister
        if (obj provides lister_kind) {
            lstr=obj.lister_kind;
            if (metaclass(lstr)==Routine) {
                lstr=obj.lister_kind();
            }
            if (metaclass(lstr)==Class or Object) {
                return lstr;
            }
        }

        if (obj has supporter)
            return Supporter__Lister;

        if (obj has container) {
            if (obj has open)
                return OpenCnr__Lister;
            if (obj has transparent)
                return TransparentCnr__Lister;
            return SimpleCnr__Lister;
        }

#ifdef EXPERIMENTAL;
        if (obj has transparent)    ! not a container or supporter
            return Transparent__Lister;
#endif;

        return Default__Lister;
];

[ WillRecurs o;
        if (c_style & ALWAYS_BIT ~= 0) rtrue;
        if (c_style & RECURSE_BIT == 0) rfalse;
        o=GetListerKind(o);
        if (o has transparent) rtrue;
        rfalse;
];

