function labels = test(testdata,w,bias,class)

% test.m
%
% Classifies testdata according to perceptron weights w and bias bias.
% Set class = 0 if all negative data, 1 if all positive, 2 otherwise.
%
% This program implements the same algorithm, and should do the same
% thing, as the Perl program "test.pl" that is included with Perform.
%
% Perform (Perceptron Classifier in Inform) v1.0
% Nick Montfort  http://nickm.com  2004-06-24

labels=zeros(size(testdata,1),1);
poscount = 0;

% Label the data with 0 if negative, 1 if positive.
for i=1:size(testdata,1)
 labels(i,1) = (sum(testdata(i,:) * w') + bias > 0);
 poscount += labels(i,1);
end

% Note what was misclassified, if a class is specified.
if class==1
  printf("%i of %i points misclassified.\n", \
  size(testdata,1)-poscount,size(testdata,1));
end
if class==0
  printf("%i of %i points misclassified.\n", poscount,size(testdata,1));
end
