! nameable.h
! Part of Platypus release 4
! Copyright 2001 Anson Turner.
!
! To use, declare RUNTIME_DICTIONARY_MAX_WORDS, set to the maximum
! number of name words that will be given.
!
! Declare objects ofclass Nameables. Each '...' in the name property
! is a space for a given name. (One such is provided by the class; you can
! give objects more if desired, to allow multiword names.) Each 0 in
! the given_name property (6 by default) allows for 2 characters* in the
! name, including spaces (this is entirely separate from how many words
! it can have). given_name is an individual property and therefore not
! additive, so if you override it, you will be setting the total maximum
! length for that object's given name.
!
! The (optional) example_name property can hold a string giving an example
! name. This is shown if the player types something like NAME MINK MINDY
! (which lacks the required quotation marks). N.B.: The player will not be
! allowed to give the example_name to a different Nameables object. Nor
! can the exact same name be given to any two Nameables.
!
! (*) 4 under Glulx.


#IFNDEF RUNTIME_DICTIONARY_MAX_WORDS;
Message "*** Must set RUNTIME_DICTIONARY_MAX_WORDS to use nameables.h ***";
#ENDIF;


		! MatchText(address, # of chars, string[, ignore punc flag])
		! Returns true if the characters starting at address match the
		! contents of the given string (case insensitive). If the # of
		! chars given is zero, checks as many characters as the string
		! contains.

[ MatchText address length string ipf     c c2;

	string.print_to_array(Byte1A);
	if (length == 0) length = Byte1A-->0;
	if (Byte1A-->0 ~= length) rfalse;
	c2 = 2;
	for (c = 0:c < length:c++,c2++)
	{   if (ipf && address->c == '.' or ',' or '"') { c2--; continue; }
		if (GetLowercase(Byte1A->c2) ~= GetLowercase(address->c)) rfalse;
    }
];

[ ClearProperty obj p     c l ad;

    ad = obj.&p; if (ad == 0) rfalse;
    l = obj.#p / WORDSIZE;
    for (c = 0:c < l:c++)
        ad-->c = 0;
];

#IFDEF DEBUG;
ShowobjCogs
  with
    knows_property [ p;
        if (p == given_name or example_name) rtrue;
    ],
    print_property [ p v;
        print "~";
        if (p == example_name) { print (string) v,"~"; rtrue; }
        for (v = 0:v < noun.#given_name:v++)
        {   if (noun.&given_name->v == 0) break;
            print (char) noun.&given_name->v;
        }
        print "~"; rtrue;
     ],
  private example_name;
#IFNOT;
Object with private example_name;
#ENDIF;

Class Nameables
  has ~proper,
  with
    name '...',
    given_name 0 0 0 0 0 0,
    short_name [     c addr ch l;
        
        if (self.&given_name->0 && self has proper)
        {   addr = self.&given_name;
            l = self.#given_name;
            for (c = 0:c < l:c++)
            {
                ch = addr->c;
                if (ch == 0) break;
                print (char) ch;
            }
            if (action == ##Listing or ##WhichOne)
            {   give self ~proper;
                print " (",(a) self,")";
                give self proper;
            }
            rtrue;
        }
    ];

Verb 'name'
            * noun topic    -> Name
            * noun          -> Name;

[ NameSub     w w2 z c char gnidx lastword addr tl wcount exnameflag;

    if (~~(noun ofclass Nameables))
        print_ret (Ctheyreorthats) noun,"not something you can name.";

    if (noun.&given_name->0)
        "You've already named ",(name) noun,".";

    lastword = consult_from + consult_words - 1;

    wn = consult_from; w = NextWord();
    wn = lastword; w2 = NextWord();
    if (w ~= quote_word || w2 ~= quote_word || consult_words == 1)
    {
        print "To name something, type NAME ";
        OpenBuffer(Byte1A);
        print (name) noun;
        CloseBuffer();
        printcap(Byte1A);
        print " ~";
        if (noun provides example_name) print (string) noun.example_name;
        else print "AL";
        "~, for example.";
    }

    if (consult_words == 2)
        "That's a bit terse.";

    wn = consult_from + 1;
    for (z = consult_from + 1:z < lastword:z++)
    {
        if (NextWord() == comma_word or quote_word or THEN1__WD)
            continue;
        tl = tl + WordLength(z);
        wcount++;
    }
    w = 0;  w2 = noun.#name / WORDSIZE;
    for (z = 0:z < w2:z++)
        if (noun.&name-->z == '...') w++;
    if (wcount > w)
        "That's too many words.";
    if (tl + wcount - 1 > noun.#given_name)
        "That's too long.";
    
    w = WordAddress(consult_from + 1);
    if (noun provides example_name && MatchText(w, 0, noun.example_name, 1))
        exnameflag = 1;
    else
        objectloop(z provides example_name && z ~= noun)
        {
            if (MatchText(w, 0, z.example_name, 1))
            {   w2 = 0; if (z has proper) w2 = true;
                give z ~proper;
                print "That's really more of a name for ",(a) z,".";
                if (w2) give z proper;
                new_line; return;
            }
        }

    gnidx = 0;  wn = consult_from + 1;
    for (z = consult_from + 1:z < lastword:z++)
    {
        if (NextWord() == comma_word or quote_word or THEN1__WD) continue;
        w = WordLength(z);
        w2 = WordAddress(z);
        for (c = 0:c < w:c++)
        {
            char = w2->c;
            Byte1A->c = char;
            if (c == 0) char = GetUppercase(char);
            noun.&given_name->gnidx++ = char;
        }
            
        Byte1A->w = 0;
        if (--wcount) noun.&given_name->gnidx++ = ' ';
    }
    
    objectloop(z ofclass Nameables && z ~= noun)
    {
        for (c = 0:c < gnidx:c++)
            if (noun.&given_name->c ~= z.&given_name->c) jump namesublab1;
        ClearProperty(noun, given_name);
        give z ~proper;
        print "You already gave that name to ",(the) z,".";
        give z proper;
        new_line; return;
        .namesublab1;
    }

    z = noun.#given_name;
    w2 = 0;
    for (c = 1:c < z:c++)
    {   w = noun.&given_name ->c;
        if (w == ' ' || c == z - 1 || w == 0)
        {   addr = FindByWord('...', noun.&name, noun.#name / WORDSIZE);
            noun.&name-->addr = AddWord(noun.&given_name + w2, c - w2);
            w2 = c + 1;
        }
        if (w == 0) break;
    }

    print (The) noun, " ";
    give noun proper;
    PrintX("#is-n#");
    print " now named ",(name) noun,".";
    if (exnameflag) print " (Such an exemplary name.)";
    new_line;
];
