// CYOA.T
// A hybrid CYOA library

// Garth Dighton, 2001

// This library allows you to build a regular text adventure with
// choose-your-own-adventure elements - essentially, menus that you can
// attach to a room which give the player additional options beyond GET
// X, TAKE Y, etc. These options may take any form.

// Items of class Menu contain a particular set of choices, with their
// executable code. You need to override the choices property, and add a
// property for each possible choice to be executed when that choice is
// made. The choices property is a list of lists, each choice (inner
// list) consisting of a string, a property pointer (to the code), and
// and optional expression that determines whether that choice is
// currently valid.

// After creating a Menu object, attach it to a room by setting the
// "menu" property of the room. You can do this at any time - many of
// your menu choices will change the menu of a particular room, for
// instance. You may also want to change the menu when certain normal
// commands are executed.

// See the example provided for details.

// Credits: some of the code below - notably preparse(),
// commandPrompt(), and the choiceVerbs, is taken (with modifications)
// from Mark J. Musante's CYOA_lib, which is designed for a more
// standard choose-your-own adventure. 

modify room
	menu = nil
;

commandPrompt: function(type)
{
	if ((type = 0 || type = 1) && Me.location.menu) {
		Me.location.menu.constructChoices;
		if (Me.location.menu.chstr != '') {
			"\bWhat would you like to do?\b";
			Me.location.menu.sayChoices;
		}
	}
	"\b> ";
}

class Menu: object
	chstr = ''
	sayChoices = {say(self.chstr);}
	choices = []
	gotoList = []

	constructChoices = {
		local i, n;
		self.chstr := '';
		self.gotoList := [];
		n := 1;
		if (self.choices && length(self.choices) > 0) {
			// Construct the choice list, testing to see if each choice
			// is valid
			for (i := 1; i<=length(self.choices); i++) {
				if (length(self.choices[i]) < 3
					|| self.choices[i][3] = true) {
					self.gotoList += self.choices[i][2];
					self.chstr := self.chstr + '\n\t(' + cvtstr(n) + ') ' +
						self.choices[i][1];
					n++;
				}
			}
		}
	}

	Execute(num) = {
		if (num > length(self.gotoList)) {
			"Please enter a choice from the menu, or a regular command. ";
			abort;
		} else {
			self.(self.gotoList[num]);
		}
	}
;

preparse: function( str )
{
	local foo;

	if ( str = '' ) {
		"Pardon me? ";
		return nil;
	}

	foo := cvtnum( str );
	switch( foo ) {
	case 1: return 'one';
	case 2: return 'two';
	case 3: return 'three';
	case 4: return 'four';
	case 5: return 'five';
	case 6: return 'six';
	case 7: return 'seven';
	case 8: return 'eight';
	case 9: return 'nine';
	default:
		if ( foo < 0 || foo > 9 || str = '0' ) {
			"Enter a choice from the menu, please. ";
			return nil;
		}
		return true;
	}
}

//
// Basic choices.  Numbered 1 through 9.
//
choiceVerb: object
	num = 0
	action( actor ) = {
		if ( self.num = 0 ) {
			"Parse error: number not set in verb.\n";
			abort;
		}

		if ( self.num < 1 || self.num > 9 ) {
			"Parse error: choice out of range.\b";
			abort;
		}
		Me.location.menu.Execute(self.num);
	}

;

oneVerb: choiceVerb
	verb = 'one'
	num = 1
;

twoVerb: choiceVerb
	verb = 'two'
	num = 2
;

threeVerb: choiceVerb
	verb = 'three'
	num = 3
;

fourVerb: choiceVerb
	verb = 'four'
	num = 4
;

fiveVerb: choiceVerb
	verb = 'five'
	num = 5
;

sixVerb: choiceVerb
	verb = 'six'
	num = 6
;

sevenVerb: choiceVerb
	verb = 'seven'
	num = 7
;

eightVerb: choiceVerb
	verb = 'eight'
	num = 8
;

nineVerb: choiceVerb
	verb = 'nine'
	num = 9
;

