#pragma C+
/* actors for the beach game	*/

/* the kids who mans the gatehouse. */
gatekeeper: Actor
  isListed = true
  sdesc = "gatekeeper"
  ldesc = "Johnson is a scraggly looking kid who looks like he should be
  delivering pizza instead of manning the gate at the beach. He's pale
  and has a face full of pimples. Other than that, and an annoying
  habit of staring at people as if they weren't even there, he's
  reasonably cheerful."
  
  isfixed = true
  adesc = "Johnson"
  thedesc = "Johnson"
  noun = 'keeper' 'him' 'kid' 'johnson'
  adjective = 'cheerful' 'scraggly'
  location = startroom
  isactor = true
  isHim = true
  maxtoldcount = 0
  maxtold = nil
  Dbobdesc =    {if (self.maxtoldcount < (length(self.rndMsg)+1))  
        {say (self.rndMsg[rand(length(self.rndMsg))]);
        self.maxtoldcount = self.maxtoldcount +1;
        }
     else
        {self.maxtold = true;
        pass alreadyTold;}
    }

  rndMsg =[ 'That kid would never make it out on the seas.'
        'He seems a bit strange.' 'That kid needs some sun.'
        'He\'s always reading.']
;

/* Bob is a beach wanderer. */
Dbob : trackActor
    motionList = [[]]

// *TJR* It seems we should be able to make this a function that
// checks a maxtold flag in an object, if not maxtold it passes the
// object's askme which we can make a [list] to allow more than one 
// thing to be said. If maxtold is true pass alreadyTold. To do this
// for multiple actors there would have to be a maxtold for each.
// Randomizing multiple askme descriptions would probably
// make it hard to track, but we can always set the maxtold flag to less
// manually. Maybe set it up for if maxtold = nil, it is never checked
// (you can always ask) The maxtold flag could also be used to allow
// askme to be done X amount of times before getting alreadyTold.
// *TJR*

    askme = &Dbobdesc        
    rndMsg =[ '\"I used to be a sailor.\"' '\"I was a fisherman.\"'
        '\"I used to work in the lighthouse.\"' ]
    maxtoldcount = 0
    maxtold = nil

/* The method below handles the use of the random comments. As it stands
now, you have to add it in to each NPC or object that you want to use
random comments with. *TJR*
*/
    Dbobdesc =
    {if (self.maxtoldcount < (length(self.rndMsg)+1))  
        {say (self.rndMsg[rand(length(self.rndMsg))]);
        self.maxtoldcount = self.maxtoldcount +1;
        }
     else
        {self.maxtold = true;
        pass alreadyTold;}
    }
    noun = 'bob' 'him'
    adjective = 'wanderer'
    sdesc = "Bob"
    thedesc = "Bob"
    adesc = "Bob"
    ldesc = "Bob is a scruffy looking guy of indeterminate age. He 
	     is wearing faded jeans and a windbreaker, both of which 
	     have seen better days. Bob is also wearing a sailor's cap,
	     and you notice a silver whistle hanging around his neck."
    actorDesc = 
    {                          //decribes the actor's current state
	"Bob is here. He seems to be counting grains of sand. ";
    }

    location = startroom
//set up a follower if you want the player to be able to follow actor
//    myfollower = <???>

    actorAction(v, d, p, i) =
    {
        if (v == helloVerb)
        {  "Bob looks up. \"Seashells,\" %you% replies. ";
            exit;
        }
        else pass actorAction;
    }
// disavow is for things the actor doesn't know about
    disavow = "\"I am an old man, you should probably ask somebody else.\" "

// alreadyTold is printed whenever you ask Sam about something twice

// *TJR* it seems that we should be able to tweak this for using random 
// information, we'd just have to add in a count for told or something
// see comments for askme above *TJR*

    alreadyTold = "\"I told you already. You young people never listen!\" "

// arriveDaemon is called every time the actor 'arrives', that is, reaches
//  the end of one of the lists in motionList.  Since Sam only has one
//  list, this is called every time he loops back around to roomthree.
    arriveDaemon = {

// Prepare to loop again by resetting motionListNum, setting up an action,
//  and making Sam move again right after he performs the action.
        self.motionListNum = 1;
        self.actionTurn = global.turnsofar + 5 + rand(5);
        self.moveTurn = self.actionTurn + 1;
        if (uberloc(Me) != uberloc(self))
            self.location = startroom;
        else {
            "\bBob sits down and talks to himself. ";
              self.doSit;
            }
        }

// Prepare Sam for his rounds.  This is called just before he starts
//  wandering again.
    actionDaemon = {
        if (self.location == self.sit.location) {
            if (uberloc(Me) == uberloc(self))
                "\bBob stands up, and glances around.\n
		        \"I really should be getting back.\" ";
            self.location = self.stand.location;
        }
    }

// Called whenever an actor runs into a locked door. Notice that the player
// can keep locking the door again, and Sam will patiently keep unlocking
// it. Also, notice that every time an actor can't get through a locked
// door, they'll try it again next turn.
    doorLocked(dest) = {    }
;

/* an item to test that regular actordesc still works properly */
bhat: item
    location = Dbob
    sdesc = "hat"
    ldesc = "Bob's beat up sailor cap."
    noun = 'cap' 'hat'
    adjective = 'sailor'
    Dbobdesc = "\"My hat? I got this when I was overseas.\""
;

/* item to test that random messages work ok with items */
bwhistle: item
    location = Dbob
    sdesc = "whistle"
    ldesc = "A silver sailor's whistle."
    noun = 'whistle'
    adjective = 'silver' 'sailor\'s'
    maxtold = nil
    maxtoldcount = 0
    Dbobdesc =
    {if (self.maxtoldcount < (length(self.rndMsg)+1))  
        {say (self.rndMsg[rand(length(self.rndMsg))]);
        self.maxtoldcount = self.maxtoldcount +1;
        }
     else
        {self.maxtold = true;
        pass alreadyTold;}
    }
    rndMsg = ['\"It\'s silver!\"' '\"It used to belong to my pappy.\"'
        '\"You can\'t have it!\"']
;

