#ifndef RAC
#define RAC
#pragma C+
#include <actor.t>

/*
* RAC - Random Actor Comment
* Copyright (c) 1998, Tom Raymond
*  You are permitted to distribute this module freely, as long as 
* 	[1] My name is left on it
*  	[2] you keep all files together.
*
* Requirements:
*  This module is based on, and built around Stephen Grenade's
*  actor.t module, which is the only requirement for RAC.
*
*  You may use this module in any game you like in any form you 
*  like, but please give me credit somewhere in your game. An 
*  e-mail if you have time might be nice as well, but isn't a 
*  requirement.
*
*  You may modify the code to fit your standards. If you do, please:
*	[1] Comment the code changes
*	[2] Please e-mail me a copy so I can consider additions.
*
*  I will welcome any comments or suggestions for this module.
*  I can be reached be e-mail at: adk@usa.net
* 
*   Version history:
*   Ver 1	Functioning random comments	11/13/1998, still needs work
*			added extra comments, separated from actor.t released 3/2/1999

RACVersion: versionTag
    id = "$Id: RAC v 1  11/13/1998\n"
    author = 'Tom Raymond'
    func = 'Random Actor Comments'
;

/* *TJR*
Modifications to work with multiple messages for the askme
routine. As it stands, it works with actors, it gets in a loop with
items. I can't figure that one out. Need to clean it up a little.

I did not add the routine for random to everything so that a standard
(single) askme could be easily implemented. The routine from Dbob's
Dbobdesc would have to be added either to each item you want to use
random comments with or added overall and over-ridden to use the
standard mode.

we add three flags to thing: rndMsg, maxtold, and maxtoldcount.

rndMsg: is a [list] of comments the npc can make

maxtoldcount: is checked against the lengnth of rndMsg, if less it
    prints the comment, otherwise it passes alreadytold. This is a
    numerical variable. I'm not sure on the whys of this, but when
    all facts are told it passes alreadyTold and if you ask a few
    more times it'll pass disavow, in this example it works out kinda
    nicely. *L*

maxtold: a flag set once all messages have been used. This is a
    true\nil flag
*TJR*
*/

modify thing
/* *TJR* our three additions. Just below, ioAskAbout is modified
to check maxtold as well as if there is a valid factTold *TJR*
*/
    rndMsg = []
    maxtold = nil
    maxtoldcount = 0

    ioAskAbout(actor, dobj) =
    {if (self.maxtold and find(self.factTold, dobj))
            dobj.alreadyTold;
     else pass ioAskAbout;
    }
;
modify Actor
/* *TJR* doAskAbout modified to check maxtold as above *TJR* */

    doAskAbout(actor, io) = {
        if (!self.noAlreadyTold and self.maxtold)
            io.factTold += self;
        if (datatype(self.askme) == 13)
            switch (proptype(io, self.askme)) {
                case 3:
                    "\^<<self.thedesc>> says, \"<<io.(self.askme)>>\" ";
                    return;
                case 6:
                case 9:
                    io.(self.askme);
                    return;
                default:
                    self.disavow;
                    return;
            }
        pass doAskAbout;
    }
;

#endif
