//
//  XTPrefsItemBool.m
//  XTads
//
//  Created by Rune Berg on 13/04/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTPrefsItemBool.h"
#import "XTPrefsItem_private.h"


@implementation XTPrefsItemBool

+ (instancetype)itemWithDefaultValue:(id)defaultValue
					 userDefaultsKey:(NSString *)userDefaultsKey;
{
	return [XTPrefsItemBool itemWithDefaultValue:defaultValue userDefaultsKey:userDefaultsKey valueTransformer:nil];
}

+ (instancetype)itemWithDefaultValue:(id)defaultValue
					 userDefaultsKey:(NSString *)userDefaultsKey
					valueTransformer:(XTPrefsValueTransformer *)valueTransformer
{
	XTPrefsItemBool *item = [XTPrefsItemBool new];
	item.defaultValue = defaultValue;
	item.userDefaultsKey = userDefaultsKey;
	item.valueTransformer = valueTransformer;
	item.value = [item copyOfDefaultValue];
	item.skipResetToDefault = NO;
	return item;
}

- (void)internalPersist:(id)persistedValue
{
	NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
	[userDefaults setObject:self.value forKey:self.userDefaultsKey];
}

- (id)internalRestoreFromPersisted
{
	NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
	BOOL b = [userDefaults integerForKey:self.userDefaultsKey];
	NSNumber *res = [NSNumber numberWithBool:b];
	return res;
}

@end
