#!usr/bin/python

import t3utils.t3Image

def main():
	import sys
	from optparse import OptionParser
	usage = "usage: %prog [options] path"
	parser = OptionParser(usage=usage)
	parser.add_option("-m", "--methods", action="store_true", dest="funcs",
						help="Include decompiled methods in output.")
	parser.add_option("-d", "--debug", action="store_true", dest="debug",
						help="Include debugging information in output.")
	parser.add_option("-r", "--rip", action="store_true", dest="rip",
						help="Rip multimedia resources.")
	parser.add_option("-v", "--version", action="store_true", dest="version",
						help="Print program information and version, then exit.")
	(options, args) = parser.parse_args()
	s = []
	if len(args) == 0 and not options.version:
		parser.error("Not enough arguments.")
		return
	if len(args) > 1 and not options.version:
		parser.error("Too many arguments.")
		return
	if options.version:
		sys.stdout.write("\nt3read.py, version " + t3utils.t3Image.VERSION + " by James Mitchelhill ")
		sys.stdout.write("<james@disorderfeed.net>\n")
		return
	try:
		try:
			if options.rip:
				img = t3utils.t3Image.T3Image(args[0], {"ALL": True, "RIP": True})
			else:
				img = t3utils.t3Image.T3Image(args[0])
		except IOError:
			sys.stderr.write("Could not open file " + args[0])
		s.append(img.report_header())
		s.append("\n" + ("*" * 79) + "\n\n")
		if not options.debug:
			s.append(img.report_data_blocks_nodebug())
		else:
			s.append(img.report_data_blocks())
		if options.funcs:
			s.append("\n" + ("*" * 79) + "\n\n")
			s.append(img.report_functions())
	except t3utils.t3Image.FutureVersionError:
		sys.stderr.write("This file claims to be a future version of the T3 Image File format. \
						 Run t3read.py with option -f to ignore this warning.")
	except t3utils.t3Image.MalformedFileError:
		sys.stderr.write("This file appears to be corrupt or is not a T3 Image file.")
	sys.stdout.write("".join(s))
	
	

if __name__ == "__main__":
	main()