! ddcombat.inc
! Need to include my stdlib.inc before you include this
! As well as the stddecl.inc
!
! This file is in the public domain
!
! Adds D&D style combat to your text adventure
!
! Basically, follows the 3e rules
! If a die roll of 1-20 + Players Attack Bonus > 
! The monsters Armor Class, then it's a hit, and damage is 
! Rolled.
! Once a monsters hit points reach zero
!
!
!  Consists of basically 2 commands. One that lets the player
!  attack monsters (by typing attack X), and one more complex
!  one that lets monsters attack players
!
!  The monster attack must use a subroutine, because it must
!  called the creature loop subroutine to loop through all the
!  creatures in the game to see if they are in the same room as the 
!  player, and if so, let them attack. 
!
!  The subroutine and calling the creature loop is set in an after
!  command




Verbs
Wield Weild Weald
Status
END_Verbs


! Need to make that a subroutine, since it must be called a lot.

SUBROUTINES
[Hostiles Attack]
END_SUBROUTINES

! Variables Needed

Variable [CurrentWeapon]   !The weapon being current being used
Variable [YourHP]          ! Player's Hit Points
Variable [YourAC]          ! Player's Armor Class
Variable [YourAB]          ! Player's Attack Bonus
Variable [AttackRoll]      ! Used to hold the roll used to attack
Variable [DamageRoll]

! Basic critter stats

PROP CREATURE
[HP] ! A creatures hit or health points
[AB] ! A creatures combat ability
[AC] ! a creatures armor class, or how hard it is to hit
[AttackDamage] ! how much they do
[AttackDescr] ! a description of their attack
[Corpse] ! Their dead body, placed in the room after being killed
END_PROP

! Stats needed for a weapon

PROP NOUN
[Damage] ! How much damage it does when used as a weapon
[Cost] ! How much it costs
[MagicBonus] ! How much it's bonus is, if any
END_PROP

! Melee Weapon Class

NOUN [MeleeWeapon]  
Weapon
Melee
This is a generic melee or hand to hand combat weapon.
END_NOUN

! Default Weapon 

Noun [Fist]
Fist
Your
invisible
LOCATION [Carried]
[Damage] 2
[Cost] 0
[MagicBonus] 0
CLASS [MeleeWeapon]
UNMOVABLE
END_NOUN

NOUN_DESCR [Fist]
It's your trusty fist. Not as good as a sword, but useful to bash
critters with.
END_NOUN_DESCR

! COMMANDS

! Lets player use different weapons

COMMAND WIELD MELEE WEAPON
  IsCarrying NOUN
  PrintMessage "You wield the $noun$."
  SetVariableTo [CurrentWeapon] NOUN
  DoneWithTurn
END_COMMAND  

! Initialize starting stats. Might want to alter for a game, but
! these shall be the default. 

COMMAND ANY
TurnsLT 1
Set [YourHP] 10
Set [YourAC] 15
Set [YourAB] 2
Set [CurrentWeapon] [Fist]  ! Otherwise we get nasty errors
END_COMMAND


! This command lets the player attack a hostile creature

COMMAND ATTACK ANY 
1  NOUNIsCreature 

2  NOUNPresent  	!checks if noun is here 
3  IsHostile NOUN   	!checks if noun is hostile

   RandomVariable [AttackRoll] 20        ! Rolls a d20
   Add [AttackRoll] [YourAB]             ! add players attack bonus
   Add [AttackRoll] [CurrentWeapon].[MagicBonus] ! add weapon bonus

   4 GE  [AttackRoll] NOUN.[AC]               ! Does it hit
     PrintMessage "You attack the $noun$ and hit."
     RandomVariable [DamageRoll] [CurrentWeapon].[Damage]  ! get damage
     Subtract NOUN.[HP] [DamageRoll]   ! subtact damage from nouns hitpoints
     PrintMessage "You do #Var[DamageRoll]# points of damage"

     5 LE NOUN.[HP] 0                  ! Are the hp less than zero
       Destroy NOUN
       PrintMessage "You killed the $noun$"
       6 NOT Equal NOUN.[Corpse] 0 ! Make sure there is a corpse
       PutInCurrentRoom NOUN.[Corpse]


       6 DoneWithTurn

     5 GT NOUN.[HP] 0
       PrintMessage "The $noun$ is staggered, but still alive."
       DoneWithTurn

   4 LE [AttackRoll] NOUN.[AC]
      PrintMessage "You missed the $noun$."
      DoneWithTurn

3  PrintMessage "You wouldn't hurt a friendly critter, would you?"
   DoneWithTurn

2  PrintMessage "$Noun$ isn't here"
   DoneWithTurn

1  PrintMessage "That's not a creature."
   DoneWithTurn

END_COMMAND    


COMMAND SUBROUTINE[Hostiles Attack]
  1 IsHostile [arg] 		! [arg] contains the critter
    2 Present [arg] 		! Is the creature hostile
      Blankline
      3 NOT Equal [arg].[AttackDescr] 0  ! Make sure it has an attack description
      DescribeThing  [arg].[AttackDescr] ! Print Creatures Attack Description

      3 Equal [arg].[AttackDescr] 0      ' If not, print generic message
       PrintMessage "You are attacked!...."   
      
      3 RandomVariable [AttackRoll] 20    ! Attack Roll
      Add [AttackRoll] [arg].[AB]	! Add the critters Attack Bonus to roll
     
     4 GE  [AttackRoll] [YourAC]        ! Check if attack roll is greater than player AC
     PrintMessage "You've been hit!"                  ! Yes      
     RandomVariable [DamageRoll] [arg].[AttackDamage] ! Roll Damage
     PrintMessage "You take #Var[DamageRoll]# damage!" 
     Subtract [YourHP] [DamageRoll] 		      ! Sub from Player HP
     5 LE [YourHP] 0				      ! If HP are less than zero, kill player
       PrintMessage "You've been killed!"
       KillPlayer
       Return

     5 GT [YourHP] 0                                   
       PrintMessage "You're hurt, but still alive."   ! Can probably omit this
       Return

     4 LT  [AttackRoll] [YourAC]
     PrintMessage "The attack misses you!"
     Return

    2 NOT Present [arg] 
      Return
  1 Return
END_COMMAND

COMMAND AFTER
NOT VerbIsDirection                     ! So you don't get attacked moving into room
Set [loop routine] [Hostiles Attack]  	! Set the loop called by creature loop to
				     	! [Hostiles Attacks], which is used to attack
					! the player
DoSubroutine [creature loop]		! Call the creature loop sub, which loops
					! through all the creatures in the game
END_COMMAND



! Command Status
! 
! Used to tell player his stats and such

COMMAND STATUS
PrintMessage "HP: #Var[YourHP]#"
PrintMessage "AC: #Var[YourAC]#"
PrintMessage "AB: #Var[YourAB]#"
PrintMessageNoNL "You are currently wielding: " 
DescribeThing [CurrentWeapon]
DoneWithTurn
END_COMMAND
