!   ****************
!   * HOWTOPLAYRUS *
!   ****************
!
!   Howtoplayrus — расширение для RInform, добавляющее в программу краткое руководство по игре в интерактивную литературу, а также команды СПРАВКА, ПОМОЩЬ, ИНСТРУКЦИ(Я|И). Руководство содержит информацию по перемещению, взаимодействию с игровыми объектами, персонажами, часто используемые команды и прочее.
!
!   За основу howtoplayrus было взято расширение howtoplay (см. ЛИЦЕНЗИИ). Помимо перевода на русский язык данное расширение было модифицировано для использования с библиотекой DMenus (http://mirror.ifarchive.org/if-archive/infocom/compilers/inform6/library/contributions/DMenus.zip). Howtoplayrus может использоваться и с другими аналогичными библиотеками-меню или без них.
!
! ----------------------------------------------------------------------------
!
!   УСТАНОВКА:
!
!   Поместите файл howtoplayrus.h в папку library из каталога rinform и добавьте следующие строки:
!
!       Include "dmenus"; ! если вы используете библиотеку DMenus (библиотека также должна быть в папке library)
!       Include "howtoplayrus";
!
!   в любое место в коде вашей игры ПОСЛЕ директивы 
!       Include "VerbLib";
!
! ----------------------------------------------------------------------------
!
!   ИСПОЛЬЗОВАНИЕ
!
!   Для вызова руководства необходимо ввести одну из следующих команд: СПРАВКА, ИНСТРУКЦИ(И|Я), ПОМОЩЬ.
!   Если была подключена библиотека DMenus (или аналогичная) появится меню, содержащее список разделов данного руководства. В противном случае на экран будет выведен полный текст руководства.
!
! ----------------------------------------------------------------------------
!
!   ДОПОЛНИТЕЛЬНЫЕ ВОЗМОЖНОСТИ:
!
!   Определите в своем коде константу NO_HOWTO_GRAMMAR, если не хотите, чтобы глаголы "помощь", "справк", "инструкци" были импортированы в вашу игру. В этом случае вам нужно будет создать альтернативный механизм для вывода руководства (через запуск процедуры HowToSub()).
!
!   Если вы хотите включить данное руководство в существующее меню, добавьте в своем коде после определения класса Menu следующий код (для DMenus):
!
!       Object -> "Краткое руководство по игре"
!         with
!           description [;
!             HowToSub();
!           ];
!
! ----------------------------------------------------------------------------
! 
!   ЛИЦЕНЗИИ
!
!   1) Код howtoplayrus.h распространяется на условиях лицензии MIT, автор Алексей Галкин <johnbrown>, 2019 год.
!
!      Текст лицензии MIT доступен по адресу: https://opensource.org/licenses/MIT
!
!   2) Все права на оригинальное руководство "A Beginner's Guide to Playing Interactive Fiction", фрагменты которого были переведены на русский язык и использованны в данном расширении, принадлежат Фредрику Рамсбергу (Fredrik Ramsberg), 2003 год. Полная версия руководства доступна по адресу: http://IFGuide.ramsberg.net
!
!      Автор перевода — Алексей Галкин. Распространяется с разрешения автора оригинала.
!
!      Вы можете использовать данный перевод или его часть в любых целях, не противоречащих действующему законодательству РФ, при соблюдении следующих условий (http://www.microheaven.com/IFGuide/license.html):
!      а) должно быть указано название источника: Beginner's Guide to Playing Interactive Fiction Games;
!      б) должен быть указан адрес источника: http://IFGuide.ramsberg.net;
!      в) должно присутствовать упоминание о том, о том что на веб-сайте, указанном в п.б доступен дополнительный материал.
!
!      Пример: "Выдержка из «Beginner's Guide to Playing Interactive Fiction Games» (http://IFGuide.ramsberg.net)."
!
!   3) howtoplay.h — расширение для Inform 6, автор Майкл Койн (Michael Coyne) (coyne@mts.net). Код передан в общественное достояние ее авторами. См. также:
!      http://mailman.greennet.org.uk/pipermail/inform-maintenance/2014-May/001966.html
!      http://mailman.greennet.org.uk/pipermail/inform-maintenance/2014-May/001968.html
!
!      Howtoplay.h можно скачать по адресу: http://mirror.ifarchive.org/if-archive/infocom/compilers/inform6/library/contributions/howtoplay.h
!
! ---------------------------------------------------------------------------- !

system_file;

! Если класс Menu не определен выводим на экран полный текст руководства
#ifndef Menu;
  [ showMenu item;
    objectloop (item in HowToMenu) {
      new_line;
      style bold;
      item.short_name();
      style roman;
      item.description();
      new_line;
    };
  ];

  Class Menu;
#endif;

! Примечания переводчика
[ t_note text font_off; 
  print "(";
  print (string) text;
  if (~~font_off)
    style underline;
  print ". — Прим. пер.";
  if (~~font_off)
    style roman;
  print ")";
];

! ---------------------------------------------------------------------------- !

Menu howToMenu
  with
    short_name [;
      print "Краткое руководство по игре";
      rtrue;
    ];

Object -> about
  with 
    short_name [;
      "Об этом руководстве";
    ],
    description [;
      print "Это краткое руководство является выдержой из @<<Руководства по игре в интерактивную литературу для начинающих@>> (@<<A Beginner's Guide to Playing Interactive Fiction@>>). Полный текст доступен по адресу: http://IFGuide.ramsberg.net.
      ^^Автор перевода — Алексей Галкин <johnbrown>, 2019 год. Распространяется с разрешения автора.
      ^^Вы можете оставить сообщение в тематической ветке(https://forum.ifiction.ru/viewtopic.php?id=2489) на форуме iFiction.ru или написать мне личное сообщение.";
    ];

Object -> gameStarts
  with
    short_name [;
      "Начало игры";
    ],
    description [;
      print "Когда вы начинаете игру, первое что вы видите, это вступление, обычно состоящее из одного или нескольких экранов текста, которое дает некоторое представление о том кто вы, и, возможно, о ваших целях в игре. Каждый раз, когда игра выводит на экран текст она ждет пока вы не нажмете ВВОД или какую-то другую клавишу, давая вам возможность прочитать весь текст, перед тем как он уйдет с экрана.";
    ];

Object -> gameCommands
  with 
    short_name [;
      "Игровые команды";
    ],
    description [;
      print "После вступления появляется строка приглашения, обычно представленная символом @<<>@>>, хотя он может различаться в разных играх. Строка приглашения сообщает о том, что игра ждет ваших указаний. Их можно отдавать вводя команды в неопределенной форме глагола. Скажем, во вступлении говорится, что вы находитесь на кухне, и видите закрытую стеклянную банку, стоящую на столе. Вы можете попробовать ввести команды ВЗЯТЬ БАНКУ или ОТКРЫТЬ БАНКУ или, возможно, ИЗУЧИТЬ БАНКУ (в этом руководстве слова, написанные заглавными буквами представляют собой команды, которые можно вводить в игре. Однако, на практике, вводить их заглавными буквами нет необходимости). Если в локации есть несколько банок игра может уточнить какую из них вы имеете в виду. Опишите объект одним или несколькими словами, которые позволят игре однозначно определить то, на что вы ссылаетесь. Например, если игра спрашивает @<<Что имеется в виду: голубая стеклянная банка или зеленая стеклянная банка?@>> вы можете напечатать ГОЛУБАЯ, если вас интересует именно голубая. Вы также можете проигнорировать уточняющий вопрос, просто введя новую команду.";
    ];

Object -> movement
  with 
    short_name [;
      "Перемещение";
    ],
    description [;
      print "В большинстве игр, чтобы перейти в другую локацию вам необходимо ввести направление в котором она расположена. Вы можете напечатать ИДТИ НА ЮГ или ЮГ или просто Ю (сокращение от @<<ЮГ@>>). Обычно, используются следующие направления и сокращения: СЕВЕР (С), ВОСТОК (В), ЗАПАД (З), СЕВЕРО-ВОСТОК (СВ), ЮГО-ВОСТОК (ЮВ), СЕВЕРО-ЗАПАД (СЗ), ЮГО-ЗАПАД (ЮЗ), ВВЕРХ (ВВ), ВНИЗ (ВН), ВОЙТИ и ВЫЙТИ. Если ваш персонаж находится на борту корабля вы можете попробовать использовать команды НОС, КОРМА, ЛЕВЫЙ БОРТ, ПРАВЫЙ БОРТ.
      ^^Для перемещения существуют и другие команды, например СЕСТЬ В МАШИНУ, ИДТИ К МАШИНЕ, СЕСТЬ НА МОТОЦИКЛ, ЗАБРАТЬСЯ НА ВЕЛОСИПЕД, ПОДНЯТЬСЯ НА КОРАБЛЬ, ПРЫГНУТЬ НА ПЛАТФОРМУ, НЫРНУТЬ В ОЗЕРО, ЗАЙТИ НА БОРТ, ВЫЙТИ ИЗ МАШИНЫ, ВЫЙТИ, ПОКИНУТЬ, ВЫЛЕЗТИ. Список доступных команд меняется от игры к игре, и также зависит от игровой ситуации. Когда вы отдаете игре команду всегда старайтесь выразить ее как можно проще. Если вы перепробовали разные варианты, но игра вас все равно не понимает, вероятно, вы на неправильном пути. Самое время попробовать что-нибудь другое.";
    ];

Object -> commonVerbs
  with 
    short_name [;
      "Часто используемые команды";
    ],
    description [;
      print "Как вы теперь знаете, команда ВЗЯТЬ, используется, чтобы подобрать предметы. Также вы можете использовать команду БРОСИТЬ, чтобы убрать их из своего инвентаря. Большинство современных т.н. @<<парсерных игр@>> (т.е. основным средством взаимодействия в которых является ввод команд) понимают больше сотни глаголов. С некоторыми из наиболее используемых вы можете употребить сразу несколько существительных, например: ВЗЯТЬ ЗЕЛЕНЫЙ ШАР И ОТВЕРТКУ или БРОСИТЬ ВСЕ или ПОЛОЖИТЬ ВСЕ КРОМЕ МОЛОТКА В СУМКУ. В процессе игры вы ни раз убедитесь, что слово ВСЕ, часто, бывает очень полезным, хотя оно и работает только с некоторыми командами, самые используемые из которых — ВЗЯТЬ И БРОСИТЬ. Вот список наиболее важных команд с примерами из употребления:^";
       font off;
       print "^СМОТРЕТЬ или СМ СМ или СМОТРЕТЬ НА БОБА или ПОСМОТРЕТЬ В БАНКУ или ПОСМОТРЕТЬ ПОД КРОВАТЬЮ^
       ВЗЯТЬ           ВЗЯТЬ НОЖ^
       БРОСИТЬ         БРОСИТЬ НОЖ^
       ОСМОТРЕТЬ или О СМОТРЕТЬ НОЖ или О НОЖ^
       ИССЛЕДОВАТЬ     ИССЛЕДОВАТЬ ПИСЬМЕННЫЙ СТОЛ^
       ИНВЕНТАРЬ или И И^
       ОТКРЫТЬ         ОТКРЫТЬ ЯЩИК^
       ЗАКРЫТЬ         ЗАКРЫТЬ ЯЩИК^
       ЗАПЕРЕТЬ        ЗАПЕРЕТЬ ДВЕРЬ РЖАВЫМ КЛЮЧОМ^
       ОТПЕРЕТЬ        ОТПЕРЕТЬ ДВЕРЬ РЖАВЫМ КЛЮЧОМ^
       СПРОСИТЬ        СПРОСИТЬ ДЖОНА ОБ ОФИЦЕРЕ ПОЛИЦИИ^
       РАССКАЗАТЬ      РАССКАЗАТЬ ДЖОНУ ОБ УБИЙЦЕ^
       СКАЗАТЬ         СКАЗАТЬ ДЖОНУ ПРИВЕТ^
       ДАТЬ            ДАТЬ КРОЛИКА БОБУ^
       ПОКАЗАТЬ        ПОКАЗАТЬ НОЖ ОФИЦЕРУ ПОЛИЦИИ^^
       ЖДАТЬ или Ж     Ж^
       СНОВА           СНОВА^^";
       font on;
       print "Время от времени, вам придется пользоваться и другими командами: АТАКОВАТЬ, КУПИТЬ, НАКРЫТЬ, ПИТЬ, ЕСТЬ, НАПОЛНИТЬ, ПРЫГАТЬ, ЦЕЛОВАТЬ, СТУЧАТЬ, СЛУШАТЬ, ДВИГАТЬ, ТЯНУТЬ, ТОЛКАТЬ, УБРАТЬ, ЧИТАТЬ, СЕСТЬ, СПАТЬ, ВСТАТЬ, КИНУТЬ, ПРИВЯЗАТЬ, ПРИКОСНУТЬСЯ, ПОВЕРНУТЬ, ПЕЧАТАТЬ, ОТВЯЗАТЬ, НАДЕТЬ. На самом деле, их еще больше. Надеемся, эти глаголы будут вписываться в логику игры и их использование будет выглядеть естественным "; 
       t_note("конечно, это зависит от автора игры");
       print ".";
    ];

Object -> time
  with 
    short_name [;
      "Время в игре";
    ],
    description [;
      print "Почти во всех играх жанра @<<интерактивная литература@>> (ИЛ) счет времени идет в ходах, а не в часах и минутах. Каждый раз, когда вы печатаете что-нибудь и нажимаете ВВОД проходит один ход ";
      t_note("если только это не метакоманда или команда, введенная с ошибкой");
      print ". Кроме того, это означает, что до тех пор пока вы не нажмете ВВОД, время не идет. Можно попытаться представить ход как условную минуту, длительность которой зависит от того что вы делаете в этот ход. Если вы хотите, чтобы время продолжало идти, но не хотите при этом совершать никаких действий нажмите ЖДАТЬ или Ж. Это может быть полезно, когда вы ждете кого-то кто должен прийти или что-то, что должно произойти, например, пирог, который должен испечься (разумеется, в игровом мире, не реальном).
      ^^Есть игры, которые проходят в реальном времени, но их относительно немного, и, обычно, автор сообщает об этом в начале игры.";
    ];

Object -> npc
  with 
    short_name [;
      "Общение с другими персонажами";
    ],
    description [;
      print "Наиболее полезные команды для общения с другими игровыми персонажами — СПРОСИТЬ и РАССКАЗАТЬ. Если вы их используете постарайтесь подобрать наиболее емкое ключевое слово в качестве темы; старайтесь избегать сложных языковых конструкций. Например, команда РАССКАЗАТЬ БОБУ О ТОМ ЧТО Я ВИДЕЛ КАК ШЕЙЛА ПОДАРИЛА СТРАННЫЙ АМУЛЕТ ДРУГОЙ ЖЕНЩИНЕ вряд ли даст результат, но РАССКАЗАТЬ БОБУ ОБ АМУЛЕТЕ или РАССКАЗАТЬ БОБУ О ШЕЙЛЕ, возможно, будет полезным. Другими словами, необходимо дать другому персонажу тему на которую вы хотите поговорить или о которой вы хотите спросить, а не пытаться задавать вопрос буквально. Игра попытается сделать логическое предположение о том что вы хотели сказать по данной теме.
      ^^Отметим, что многие игры довольно примитивны по части моделирования людей. Автор должен проделать огромную работу, чтобы персонажи в его игре вели себя реалистично и могли дать подходящий ответ, когда к ним обращаются. В целом, не стоит ожидать слишком многого от других персонажей, хотя, конечно, есть игры где этому аспекту уделено очень много внимания. Кроме того, некоторые авторы предпочитают, для простоты, создавать диалоги, основанные на меню.
      ^^Чтобы сказать кому-то сделать что-то наберите имя персонажа, запятую и, затем, саму команду. Пример: БОБ, РАЗБЕЙ БАНКУ. Как и в реальной жизни, большинство людей не будет автоматически выполнять ваши приказы только потому, что вы так сказали. Если вы предполагаете, что Боб знает что делать с банкой, можете попробовать ввести команду ДАТЬ БАНКУ БОБУ или ПОКАЗАТЬ БАНКУ БОБУ.";
    ];

Object -> metacommands
  with 
    short_name [;
      "Специальные команды (метакоманды)";
    ],
    description [;
      print "В каждой игре существует набор неигровых команд с помощью которых вы можете управлять ее поведением или выполнять определенные задачи. К таким командам относятся:^";
      font off;
      print "^ОТМЕНА          Отменяет последний сделанный ход.^
      КОНЕЦ           Завершает текущую игру.^
      ЗАНОВО          Начинает игру с начала.^
      СОХРАНИТЬ       Сохраняет текущее состояние игры в файл.^
      ВОССТАНОВИТЬ    Загружает ранее сохраненное игровое состояние.^
      ПОМОЩЬ          Показывает информацию об игре, ее авторе ";
      t_note("или выводит руководство по игре в ИЛ", 1);
      print ". Иногда в ней даже можно найти советы по решению загадок.^
      ОПИС! ДЛ        Сообщает игре, что при посещении каждой локации вы хотите видеть ее полное описание, даже если вы уже в ней были.^
      ОПИС! НОРМ      Сообщает игре, что вы хотите видеть полное описание локации только при первом посещении. В дальнейшем выводит краткое описание. Этот режим установлен по-умолчанию ";
      t_note("если только автор его не изменил", 1);
      print ".^ОПИС! КР        Сообщает игре, что вы хотите всегда видеть краткое описание локации.";
      font on;
    ];

Object -> gameStuck
  with 
    short_name [;
      "Тупики и выходы";
    ],
    description [;
      print "Иногда головоломка в игре может завести в тупик. Это часть процесса: нерешенная загадка, как правило, не даст вам продвинуться дальше, пока вы ее не решите. Если вы основательно застряли попробуйте набрать ПОМОЩЬ ";
      t_note("или ПОДСКАЗКА, СОВЕТ");
      print ". Возможно, автор оставил для вас несколько подсказок. Вы также можете обратиться за советом к другим игрокам. Это можно сделать, например, на форуме iFiction.ru (https://forum.ifiction.ru). Кроме советов по прохождению там можно обсудить сыгранные игры, узнать о новинках, поучаствовать в конкурсах, и многое другое.
      ^^Ну, и последнее об игре в интерактивную литературу. Рисуйте карту ";
      t_note("или используйте специальные программы");
      print ". Очень вероятно, что она вам понадобится.";
    ];

! ---------------------------------------------------------------------------- !        
        
[ HowToSub;  
  showMenu(HowToMenu);
];

#ifndef NO_HOWTO_GRAMMAR;
  Verb meta 'помощь' 'справка' 'инструкци'
  * -> HowTo;
#endif;

! ---------------------------------------------------------------------------- !
