! ============================================================================
! Infit (Italian Inform Library)
! ============================================================================
!        Author: Giovanni Riccardi (giovanni@composizioni.com)
!       Version: 2.0
!      Released: 9 October 2002
! Serial Number: 021009
!   Description: "An Inform library to write Interactive Fiction in Italian."
!          Note: For use with Inform 6. (Tested with Inform compiler
!                version 6.21 and Inform library 6/10).
! ============================================================================
!
! FILES IN THE INFIT DISTRIBUTION:
!
!     Italian.h - The Inform Language Definition File for Italian.
!    ItalianG.h - The Italian Grammar File.
!     Replace.h - Some functions in the standard library are replaced
!                 here.
!   leggimi.txt - Informations in Italian.
! copyright.txt - Copyright informations (also in Italian). 
!    guida.html - An INFIT guide in Italian
!
! ============================================================================
!
! COPYRIGHT INFORMATIONS:
!
! Infit copyright (c) 1997 - 2002 by Giovanni Riccardi.
! Some part of the code in these files are copyright 
! (c) 1996 - 1999 by Graham Nelson
!
! Infit is free software. You can freely distribute it with these
! restrictions:
! (a) distributed copies are not substantially different from the
!     original copy archived in the Infit Web Site (see below).
! (b) distributed copies contain this copyright message.
! (c) no profit is involved in the distribution.
!
! Infit is distributed WITHOUT ANY WARRANTY.
!
! ============================================================================
!
! MORE INFO:
!
!   Inform Web Site: http://www.inform-fiction.org
!    Infit Web Site: http://inform.composizioni.com
!       Infit Email: inform@composizioni.com
! My personal Email: giovanni@composizioni.com
!
! ===========================================================================

! LANGUAGE NOTE:
! Since Infit is intended for use of Italian IF Designers, code comments are
! written in Italian.

! Replace.h 
! Numero di Serie: 021009
! -----------------------
! Il file replace.h contiene le versioni "tradotte e adattate" di alcune 
! funzioni della libreria inglese. Per utilizzarlo (necessario al funzionamento
! della Infit) si deve aggiungere un 
!       Include "replace";
! subito dopo l'inclusione di "verblib".  


! ----------------------------------------------------------------------------
! Routine della libreria standard che sono state sostituite
! ----------------------------------------------------------------------------

[ Banner i;
   if (Story ~= 0)
   {
#IFV5; style bold; #ENDIF;
   print (string) Story;
#IFV5; style roman; #ENDIF;
   }
   if (Headline ~= 0)
       print (string) Headline;
   print "Versione ", (0-->1) & $03ff, " / Numero di Serie ";
   for (i=18:i<24:i++) print (char) 0->i;
   print " / Inform v"; inversion;
   print " Libreria ", (string) LibRelease, " ";
#IFDEF STRICT_MODE;
   print "S";
#ENDIF;
#IFDEF INFIX;
   print "X";
#IFNOT;
    #IFDEF DEBUG;
        print "D";
    #ENDIF;
#ENDIF;
   new_line;
];

[ VersionSub;
  Banner();
  if (standard_interpreter > 0)
      print "Interprete standard ",
          standard_interpreter/256, ".", standard_interpreter%256,
          " (", 0->$1e, (char) 0->$1f, ") / ";
  else print "Interprete ", 0->$1e, " Versione ", (char) 0->$1f, " / ";
  print "Libreria, numero di serie ", (string) LibSerial, "^";
#IFDEF LanguageVersion;
  print (string) LanguageVersion, "^";
#ENDIF;
];

[ Objects1Sub i j f;
  L__M(##Objects,1);
  objectloop(i has moved)
  {   f=1; print (the) i; j=parent(i);

      if (j)
      {   if (j==player)
          {   if (i has worn) L__M(##Objects, 3, i);
              else L__M(##Objects, 4);
              jump obj__ptd;
          }

          if (j has animate)   { L__M(##Objects, 5, i); jump obj__ptd; }
          if (j has visited)   { L__M(##Objects, 6, j); jump obj__ptd; }
          if (j has container) { L__M(##Objects, 8, j); jump obj__ptd; }
          if (j has supporter) { L__M(##Objects, 9, j); jump obj__ptd; }
          if (j has enterable) { L__M(##Objects, 7, j); jump obj__ptd; }
      }

      L__M(##Objects, 10, i);
      .obj__ptd; new_line;
  }
  if (f==0) L__M(##Objects,2);
];


[ GenericVerbSub; L__M(##GenericVerb,1); ];